	TITLE	'MEX Clock overlay for TurboDOS'
;
; written 04/30/85 by Ron Fowler
;
; Note: this clock overlay may also be used with MP/M,
; CPM3, or any other operating system that provides the
; function 105 get-time-date system call.
;
no	equ	0	
yes	equ	0ffh
i8080	equ	yes		;for xlat- do not change
i8086	equ	no
cpm	equ	yes
pcdos	equ	no
;
system	equ	5		;system entry point
timef	equ	105		;time-of-day function code
;
;
	org	100h		;processor type flag is here
;
if i8080
	db	0c3h		;show which processor we are for
endif
if i8086
	db	0E9h
endif
;
	org	0e00h		;start of clock overlay 
;
	jmp	gettim		;get time
	jmp	getdat		;get date
	ret			;cset processor
	nop
	nop
	ret			;clock overlay init
	nop
	nop
	ret			;clock overlay de-init
	nop
	nop
;
; subroutine GETTIM returns the time as follows:
;
; B - Hours (0-23)
; C - Minutes (0-59)
; D - Seconds (0-59)
; E - Hundreths of seconds (0-99) 
;
gettim:	call	cread		;do it
	lxi	h,rtcbuf+2	;point to time
	mvi	a,3		;get a loop counter
tloop:	push	psw		;save loop count
	mov	a,m		;fetch next digit
	inx	h
;
; convert digit from BCD to binary
;
	push	psw		;save it
	ani	0F0H		;isolate 10's digit
	rrc			;shift digit to lo nybble
	rrc
	rrc
	rrc			;then multiply by 10
	add	a		;*2
	mov	e,a		;partial product
	add	a		;*4
	add	a		;*8
	add	e		;*10
	mov 	e,a		;save it
	pop	psw		;get digit back
	ani	0FH		;need units digit
	add	e		;add tens
;
; 24-bit rotate through D-C-B (see, nothing
; up my sleeve).
;
	mov	b,c		;shuffle registers to get proper result
	mov	c,d
	mov	d,a
	pop	psw		;recall counter
	dcr	a		;count it down
	jnz	tloop		;\loop till all digits collected
	mvi	e,0		;clear hundreths of second count
	ret			;all done
;
;
; subroutine GETDAT returns the date as follows:
; 
; BC - Year (1985-2099)
; D - Month (1=January, 2=February, etc.)
; E - Day of month (1-31)
;
;
baseyr	equ	78		;base year of date system (1978)
;
; we begin...
;
getdat:	call	cread		;ask system for time
	lhld	rtcbuf		;load it
	mvi	b,baseyr 	;base year in b
;
; scan through years starting at baseyr
; subtracting days from our current date
;
julp:	mov	a,b		;fetch current year
	ani	3		;test for leap year
	lxi	d,365		;first get # lp yr # days
	jnz	nleap		;and skip if not lp year
	inx	d		;is leap year, fix up days
nleap:	inr	b		;bump yr for next pass
	call	subde		;subtract days in cur year
	jz	endy		;jump if last day of yr
	jnc	julp		;continue till we overshoot
endy:	dad	d		;overshot, correct days
	dcr	b		;and year
	mov	a,b		;fetch calculated year
	cpi	100		;rewind every century
	jc	pyr		;(now that's accuracy)
	mvi	b,0		;rewind yr 100 to 0
pyr:	push	b		;save year (in b, we'll pop it into d later)
	mov	a,b		;now check for leap again
	ani	3
	mvi	a,28		;28 days for feb
	jnz	feb28		;go store if not lp year
	inr	a		;adjust for leap year
feb28:	sta	mfeb		;fix month table
	lxi	d,mtbl	 	;point to month table
	mvi	b,0		;init month number
;
; scan through months in curnt yr, subtracting days
;
mnthlp: push	d		;save month table pointer
	ldax	d		;get days in curnt month
	mov	e,a		;get in de as 16 bits
	mvi	d,0
	call	subde		;subtract
	jc	mfound		;exit loop when overshoot
	jz	mfound		;last day of month?
	inr	b		;bump to next month
	pop	d		;retrieve month tbl pointer
	inx	d		;bump to next month
	jmp	mnthlp		;and continue
mfound:	pop	psw		;clear stack
	dad	d		;fix overshoot
	inr	b		;make month 1-relative
	mov	d,b		;return month in D
	mov	e,l		;get remainder in e (date)
	pop	h		;recall year to H
	mov	l,h		;extend it to HL
	mvi	h,0
	lxi	b,1900		;offset for the 1900's
	dad	b
	mov	b,h		;return year in BC
	mov	c,l
	ret
;
; utility routine to subtract de from hl and set flags
;
subde:	mov	a,l		;lo byte first
	sub	e		;(carry doesn't count yet)
	mov	l,a
	mov	a,h		;hi byte
	sbb	d		;(carry counts now)
	mov	h,a
	jc	subde1		;keep the carry flag
	ora	l		;no carry, set the z on hl=0
	ret
subde1:	ora	l		;set the z flag on hl=0
	stc			;restore the carry
	ret
;
; table of months for tojul and fmjul
;
mtbl:	db	31			;jan
mfeb:	db	28			;feb
	db	31,30,31,30		;mar-jun
	db	31,31,30,31,30,31	;jul-dec
;
;
; CREAD queries TurboDOS for the date
;
cread:	mvi	c,timef		;load function code
	lxi	d,rtcbuf	;buffer adrs
	call	system		;do it
	sta	rtcbuf+4	;store seconds
	ret
;
rtcbuf:	ds	5		;real-time clock buffer
;
	end	
;
                                                          