	title	'CompuPro overlay for Interfacer 3/4'
;
; MXH-GB16.ASM -- MEX Overlay file for the CompuPro I3/I4 & SS1.  07/23/85
;
; This overlay adapts the MEX modem program to the CompuPro Interfacer 3 or
; Interfacer 4 or System Support 1 serial cards using the 2651 USART chip.
;
; This overlay is capable of setting baud rate and setting port number
; (via the SET command), setting baud rate from the phone library, dis-
; connecting the  modem, and sending a break.
;
REV	EQU	16	;V 1.6
;
; Note: the portions of this overlay that differ from conventional MEX1
; overlays are flagged by a double-pound-sign: ##  (These modifications
; must be made if an overlay is to be supported as a LOADable overlay).
;
; Calling conventions for the various overlay entry points are detailed more
; fully in the PMMI overlay (MXO-PMxx.ASM, where xx=revision number)
;
; History as a MEX overlay
;
; 07/23/85 - Oops!;  I screwed up, and offset the entire overlay by
;	     1 byte; that's fixed now, sorry!;	- Ron Fowler
; 07/23/85 - Fixed problems that prevent overlay from loading using
;	     the MexPlus LOAD command		- Ron Fowler
; 07/16/85 - Upgraded for MexPlus & added changes by Al Jewer & Alex Soya et al
;					 	- Paul Traina
; 08/22/84 - Expanded features			- Paul Traina
; 05/12/84 - SET port (0-7, S -- S=SS1)		- Ron Fowler
; 05/11/84 - MEXified the overlay		- Ron Fowler
; 07/08/83 - Adapted from MDM711GP.ASM		- Paul Traina
;
; MEX service processor stuff
;
MEX	EQU	00D00h		;address of the service processor
INMDM	EQU	255		;get char from port to A, CY=no more in 100 ms
TIMER	EQU	254		;delay 100ms * reg B
TMDINP	EQU	253		;B=# secs to wait for char, cy=no char
CHEKCC	EQU	252		;check for ^C from KBD, Z=present
SNDRDY	EQU	251		;test for modem-send ready
RCVRDY	EQU	250		;test for modem-receive ready
SNDCHR	EQU	249		;send a character to the modem (after sndrdy)
RCVCHR	EQU	248		;recv a char from modem (after rcvrdy)
LOOKUP	EQU	247		;table search: see CMDTBL comments for info
PARSFN	EQU	246		;parse filename from input stream
BDPARS	EQU	245		;parse baud-rate from input stream
SBLANK	EQU	244		;scan input stream to next non-blank
EVALA	EQU	243		;evaluate numeric from input stream
LKAHED	EQU	242		;get nxt char w/o removing from input
GNC	EQU	241		;get char from input, cy=1 if none
ILP	EQU	240		;inline print
DECOUT	EQU	239		;decimal output
PRBAUD	EQU	238		;print baud rate
;
PRINT	EQU	9		;BDOS/MEX print-string function call
;
BELL	EQU	7		;bell
TAB	EQU	9
CR	EQU	13		;carriage return
LF	EQU	10		;linefeed
ESC	EQU	27
NO	EQU	0
YES	EQU	NOT NO
;
; The following three equates define the condition of your system setup.
;
; The IBAUD equate is the initial baud rate (using MSPEED tokens).  That
; means the following numbers correspond to the following baud rates:
;
;	0= 110		1= 300		3= 600
;	5= 1200		6= 2400		7= 4800
;	8= 9600		9= 19200
;
;	NOTE: 450 baud and 710 baud are not available
;
; The IPORT equate specifies the initial port that MEX will use,
; if you have an Interfacer 3 or 4, you should set it between 0
; and 8 to specifiy which port you want MEX to use first.
; If you have your modem on the System Support 1, insert an 'S' where
; the IPORT number was.
;
; The DSRDCD equate solves a problem with the 2651 USART.  If you are
; using an intelligent modem (Smartmodem/Cermetek/Rixon/et al) then
; the modem must often send back result codes when there is no carrier
; present.  However, the 2651 ignores all input when DCD is not present.
; Therefore, I tie DCD high all the time, and using a special cable, bring
; my DCD line (pin 8) from the modem into my DSR line (pin 6 or 20) on the
; serial board.  If you have DCD piped to DSR, set DSRDCD to YES, else,
; set DSRDCD to no (if you have a regular hookup).
;
IBAUD	EQU	5	;initial baud rate (5=1200 baud, 2=300 baud)
IPORT	EQU	6	;initial I4 port (or 'S' for SS1)
DSRDCD	EQU	YES	;yes if DCD signal is piped to DSR line on 2651
;
; Interfacer 3/4 and SS1 port equates
; 
INBASE	EQU	010h		;base port of CompuPro I3 or I4 card(s)
SSBASE	EQU	05Ch		;base of serial section of CompuPro SS1
UPORT	EQU	INBASE+7	;user (chip select) port
;
; Port offsets
;
DPORT	EQU	0		;data port
SPORT	EQU	1		;status port
MPORT	EQU	2		;mode port
CPORT	EQU	3		;control port
;
TBMT	EQU	001h		;transmit buffer empty
DAV	EQU	002h		;data available
;
	 IF	DSRDCD
DCD	EQU	080h		;check for carrier at DSR bit
	 ENDIF
	 IF	NOT DSRDCD
DCD	EQU	040h		;check for carrier at DCD bit
	 ENDIF
;
; Baud rate parameters
;
BD110	EQU	032h		;110 baud
BD300	EQU	035h		;300 baud
BD600	EQU	036h		;600 baud
BD1200	EQU	037h		;1200 baud
BD2400	EQU	03Ah		;2400 baud
BD4800	EQU	03Ch		;4800 baud
BD9600	EQU	03Eh		;9600 baud
BD19200	EQU	03Fh		;19200 baud
;
;
; ## The following JUMP instruction is necessary for MEXPLUS loadable overlays
;
	ORG	100H
	DB	0C3H		;##JMP INSTRUCTION (MEX 1.2)
	DS	2		;rest of the jump instruction
;
;
	DS	2		;MODEM7 booleans unused by MEX
	DB	'T'		;T=touch, P=pulse (Smartmodem-only)	105H
CLOCK:	DB	60		;clock speed in MHz x10, 25.5 MHz max.	106H
				;20=2 MHh, 37=3.68 MHz, 40=4 MHz, etc.
MSPEED:	DB	0		;set automagically			107H
BYTDLY:	DB	1		;0=0 delay  1=10ms  5=50 ms - 9=90 ms	108H
				;default time to send character in ter-
				;minal mode file transfer for slow BBS.
CRDLY:	DB	5		;0=0 delay 1=100 ms 5=500 ms - 9=900 ms 109H
				;default time for extra wait after CRLF
				;in terminal mode file transfer
COLUMS:	DB	5		;number of DIR columns shown		10AH
SETFLG:	DB	YES		;yes=user-added Setup routine		10BH
SCRTST:	DB	YES		;Cursor control routine 		10CH
	DS	1		;unused in MEX
BAKFLG:	DB	NO		;yes=change any file same name to .BAK	10EH
CRCDFL:	DB	YES		;yes=default to CRC checking		10FH
TOGCRC:	DB	YES		;yes=allow toggling of CRC to Checksum	110H
CVTBS:	DB	NO		;yes=convert backspace to rub		111H
TOGLBK:	DB	YES		;yes=allow toggling of bksp to rub	112H
ADDLF:	DB	NO		;no=no LF after CR to send file in	113H
				;terminal mode (added by remote echo)
TOGLF:	DB	YES		;yes=allow toggling of LF after CR	114H
	DB	YES		;yes=allow transmission of logon	115H
				;write logon sequence at location LOGON
SAVCCP:	DB	YES		;yes=do not overwrite CCP		116H
	DB	NO		;yes=local command if EXTCHR precedes	117H
				;no=external command if EXTCHR precedes
	DB	YES		;yes=allow toggling of LOCONEXTCHR	118H
LSTTST:	DB	YES		;yes=printer available on printer port	119H
XOFTST:	DB	NO		;yes=checks for XOFF from remote while	11AH
				;sending a file in terminal mode
XONWT:	DB	NO		;yes=wait for XON after CR while	11BH
				;sending a file in terminal mode
TOGXOF:	DB	YES		;yes=allow toggling of XOFF checking	11CH
IGNCTL:	DB	NO		;yes=CTL-chars above ^M not displayed	11DH
EXTRA1:	DB	0		;for future expansion			11EH
EXITCHR	DB	'E'-40h		;^E = Exit to main menu			11FH
BRKCHR:	DB	'@'-40h		;^@ = Send 300 ms. break tone		120H
NOCONN:	DB	'D'-40h		;^N = Disconnect from the phone line	121H
LOGCHR:	DB	'L'-40h		;^L = Send logon			122H
LSTCHR:	DB	'P'-40h		;^P = Toggle printer			123H
UNSAVE:	DB	'R'-40h		;^R = Close input text buffer		124H
TRNCHR:	DB	'T'-40h		;^T = Transmit file to remote		125H
SAVCHR:	DB	'Y'-40h		;^Y = Open input text buffer		126H
EXTCHR:	DB	'^'-40h		;^^ = Send next character		127H
	DS	2		;unused by MEX				128H
;
INCTL1:	JMP	INSP		;go input status port			12AH
	DS	7
;
OTDATA:	JMP	OUTDP		;go output data port			134H
	DS	7
;
INPORT:	JMP	INDP		;go input data port			13EH
	DS	7
;
MASKR:	ANI	DAV	! RET	;bit to test for receive ready		148H
TESTR:	CPI	DAV	! RET	;value of rcv. bit when ready		14BH
MASKS:	ANI	TBMT	! RET	;bit to test for send ready		14EH
TESTS:	CPI	TBMT	! RET	;value of send bit when ready		151H
;
; ## Following are two new entrie points for MEXPLUS
; DCDTST returns data-carrier detect in A: 0 if no carrier
;  present, 0FFH if carrier is present, and 0FEH if overlay
;  doesn't know (i.e., doesn't support carrier detect)
; RNGDET works similarly for ring-detect.
;
DCDTST:	JMP	DCDVEC		;data carrier detect			154H
RNGDET:	JMP	RNGVEC		;ring-detect				157H
;
; End of MEXPLUS added vectors
;
	DB	0,0,0,0,0	;reserved space, assumed 0
SMDISC:	DS	3		;smartmodem disconect (not here)	15FH
DIALV:	DS	3		;DIALV: not done here (maybe MXO-SM)	162H
DISCV:	JMP	DISCON		;disconnect				165H
GOODBV:	JMP	GOODBY		;reset port				168H
INMODV:	JMP	NITMOD		;initialize port			16BH
NEWBDV:	JMP	NEWBD		;set new baud rate			16EH
	RET ! NOP ! NOP		;NOPARV					171H
	RET ! NOP ! NOP		;PARITV					174H
SETUPV:	JMP	SETCMD		;					177H
	DS	3		;not used by MEX			17AH
VERSNV:	JMP	SYSVER		;					17DH
BREAKV:	JMP	SBREAK		;					180H
;
; Do not change the following line (it takes up space in MEX that is
; only present in MDM7 overlays -- it will likely be gone by MEX v2.0).
;
	DS	18
;
; Routine to clear to end of screen.  If using CLREOS and CLRSCRN, set
; SCRTEST to YES at 010AH (above).
;
CLREOS:	LXI	D,EOSMSG	;					195H
	MVI	C,PRINT
	CALL	MEX
	RET
;
CLS:	LXI	D,CLSMSG	;					19EH
	MVI	C,PRINT
	CALL	MEX
	RET
;
; end of fixed area .. from here to 1FFh is reserved
;
	ORG	200H		;## NEW BOUNDARY FOR MexPlus
;
;
;
SYSVER:	MVI	C,ILP		;in-line print
	CALL	MEX
	DB	CR,LF
	DB	'CompuPro Interfacer 4/System Support 1 (version '
	DB	REV/10+'0'
	DB	'.'
	DB	REV MOD 10+'0'
	DB	')',CR,LF,0
	CALL	TELL
	MVI	C,ILP
	CALL	MEX
	DB	CR,LF,0
	RET
;
; Routine to exit just prior to exit-to-cpm
;
GOODBY:	CALL	INSP		;get status of port
	ANI	DCD		;is carrier active?
	JZ	GOODB1		;no, so shut down modem so it won't answer
	MVI	C,ILP
	CALL	MEX
	DB	CR,LF,'Exit to CP/M with telephone line connected? (Y/N): ',0
	MVI	C,1		;MEX character input
	CALL	MEX
	ANI	05Fh		;make upper case
	CPI	'N'		;was it no?
	RNZ			;no, it wasn't, so don't disconnect
GOODB1:	CALL	STPORT		;select chip
	XRA	A
	CALL	OUTCP		;sent to control port
	RET
;
; ## return data carrier detect status
;      0    = no carrier
;      255  = carrier present
;      254  = we don't know (DCD not supported)
;
DCDVEC:	CALL	INCTL1		;get status
	ANI	DCD
	RZ
	ORI	255		;fixed from MXH-GB13
	RET
;
; ## return ring-detect status:
;
;     0   =  not ringing
;     255 =  ring detected
;     254 =  we don't kno
;
RNGVEC:	MVI	A,0FEH		;return "we don't know"
	RET
;
; Send break to remote
;
SBREAK:	MVI	A,02Fh		;send break for 300ms
	MVI	B,3		;300 ms
	JMP	DISC1
;
; Disconnect the modem
;
DISCON:	XRA	A		;turn off DTR
	MVI	B,15		;1.5 second delay
DISC1:	PUSH	PSW
	CALL	STPORT		;select port
	POP	PSW
	CALL	OUTCP		;send passed byte to CPORT
	MVI	C,TIMER
	CALL	MEX
	MVI	A,027h		;turn DTR back on
	CALL	OUTCP
	RET
;
; Initialize the port; either set an initial baud rate, or (if
; your system is capable of it) query the current rate and set
; MSPEED value.  We can do neither here, so we assume a value
; for MSPEED -- if it's not the current value, the user must
; execute a SET command to bring MSPEED into agreement with the
; current baud rate.
;
NITMOD:	MVI	A,IPORT
	CPI	'S'		;is it 'S' for SS1?
	JNZ	NITMO1
	MVI	A,0FFh		;yes, store 255 for SS1 token
NITMO1:	STA	PORT
	CALL	INSP		;get modem status
	ANI	DCD		;carrier present?
	JNZ	READBD		;yes, so just read baud rate & set MSPEED
	MVI	A,IBAUD		;no carrier, so default to 1200 baud
	CALL	PBAUD		;initialize port and set mspeed
	RET
;
; SET command: select baud rate, port number. Port number may be any of
; 0,1,2,3,4,5,6,7,S  (S=SS1), baud rate any of 300, 600, 1200, 4800
; 9600, 19200.  Special set-port syntax allows baud rate after port
; number.  Examples:
;
;	SET PORT 3
;	SET PORT 5 1200
;	SET PORT S 300
;	SET BAUD 9600
;
SETCMD:	MVI	C,SBLANK	;any arguments?
	CALL	MEX
	JC	TELL		;if not, go display port/baud
	LXI	D,CMDTBL
	MVI	C,LOOKUP
	CALL	MEX		;parse argument
	PUSH	H		;save any parsed argument adrs on stack
	RNC			;if we have one, return to it
	POP	H		;oops, input not found in table
SETERR:	MVI	C,ILP		;inline print
	CALL	MEX
	DB	CR,LF,'SET command error',CR,LF,0
	RET
;
; Argument table
;
CMDTBL:	DB	'?'+80H		;help
	DW	STHELP
	DB	'BAU','D'+80H	;"set baud"
	DW	STBAUD
	DB	'POR','T'+80H	;"set port"
	DW	SETPOR
	DB	'STO','P'+80H	;"set stop"
	DW	STSTOP
	DB	'LENGT','H'+80H	;"set length"
	DW	SETLEN
	DB	'PARIT','Y'+80H	;"set parity"
	DW	SETPAR
	DB	0		;<<=== table terminator
;
; "SET ?" processor
;
STHELP:	MVI	C,ILP		;inline print
	CALL	MEX
	DB	CR,LF,'SET PORT   <port-number>..........0 to 7 or S'
	DB	CR,LF,'SET PARITY <parity>...............even|odd|none'
	DB	CR,LF,'SET LENGTH <word length>..........5|6|7|8'
	DB	CR,LF,'SET STOP   <stop bits>............1|2'
	DB	CR,LF,'SET BAUD   <rate>..................110| 300| 600|1200'
	DB	CR,LF,'                                  2400|4800|9600|19200'
	DB	CR,LF,0
	RET
;
; "SET LENGTH" processor
;
SETLEN:	MVI	C,SBLANK	;scan to arguement
	CALL	MEX
	JC	SETERR		;break if no arguement
	MVI	C,GNC		;get next character
	CALL	MEX
	SUI	'5'		;subtract ascii '5'
	JC	SETERR		;error if was less than '5'
	CPI	3+1		;error if > binary 3
	JNC	SETERR
	RLC			;move left 2 bits
	RLC
	MOV	B,A		;put in 'B' register
	CALL	GETFMT		;get format
	ANI	11110011b	;mask all but word length
	ORA	B		;add in word length
	CALL	SETFMT
	RET
;
; "SET PARITY" processor
;
SETPAR:	MVI	C,SBLANK	;scan to arguement
	CALL	MEX
	JC	SETERR		;break if no arguement
	MVI	C,GNC		;get next character
	CALL	MEX
	ANI	95		;make upper case
	MVI	B,00110000b	;even parity setup
	CPI	'E'
	JZ	SPAR1
	MVI	B,00010000b	;odd parity setup
	CPI	'O'
	JZ	SPAR1
	MVI	B,00000000b	;no parity setup
	CPI	'N'
	JNZ	SETERR		;error
SPAR1:	CALL	GETFMT		;get word format
	ANI	11001111b	;mask off parity
	ORA	B		;add in parity
	CALL	SETFMT		;set word format
	RET
;
; "SET STOP" processor
;
STSTOP:	MVI	C,SBLANK	;scan to arguement
	CALL	MEX
	JC	SETERR		;break if no arguement
	MVI	C,GNC		;get next character
	CALL	MEX
	MVI	B,040h		;1 stop bit value
	CPI	'1'
	JZ	SSTOP1
	MVI	B,0C0h		;2 stop bit value
	CPI	'2'
	JNZ	SETERR		;else error
SSTOP1:	CALL	GETFMT		;get format
	ANI	00111111b	;mask off baud rate
	ORA	B		;add new baud rate
	CALL	SETFMT		;set new format
	RET
;
GETFMT:	CALL	INCP		;reset flip-flop
	CALL	INMP		;get word format
	PUSH	PSW
	CALL	INMP		;dummy load
	POP	PSW
	RET
;
SETFMT:	PUSH	PSW
	CALL	INCP		;reset flip-flop
	POP	PSW
	CALL	OUTMP		;set word format
	CALL	INCP		;reset flip-flop
	RET
;
; "SET BAUD" processor
;
STBAUD:	MVI	C,BDPARS	;function code: parse a baudrate
	CALL	MEX		;let MEX look up code
	JC	SETERR		;jump if invalid code
NEWBD:	CALL	PBAUD		;no, try to set it
	JC	SETERR		;if not one of ours, bomb out
	RET
;
; "SET PORT" processor
;
SETPOR:	MVI	C,SBLANK	;scan to argument
	CALL	MEX
	JC	SETERR		;if no arg, bomb out
	MVI	C,GNC		;else consume it
	CALL	MEX
	CPI	'S'		;SS1?
	JZ	SETSS1		;jump if so
	CPI	's'
	JZ	SETSS1
	SUI	'0'		;convert
	JC	SETERR
	CPI	7+1
	JNC	SETERR
	JMP	SETX		;go put away port #
SETSS1:	MVI	A,0FFH		;SS1 token
SETX:	STA	PORT
	MVI	C,SBLANK	;any thing more?
	CALL	MEX
	JNC	STBAUD		;if so, go parse as baud rate
	CALL	READBD		;read baud rate, store in MSPEED
;
;	Print status on screen
;
TELL:	MVI	C,ILP		;print port:
	CALL	MEX
	DB	'Port: ',0
	LDA	PORT
	CPI	0FFH		;SS1?
	JNZ	TELL1		;jump if not
	MVI	A,'S'-'0'	;set SS1, and compensate for add
TELL1:	ADI	'0'		;get port # in ASCII
	STA	PORTAS
	MVI	C,ILP
	CALL	MEX
PORTAS:	DB	'     Baud: ',0
	LDA	MSPEED		;get current baud rate
	MVI	C,PRBAUD	;let MEX print it
	CALL	MEX
	MVI	C,ILP
	CALL	MEX
	DB	'    Format: ',0
	CALL	GETFMT		;get format
	ANI	00001100b	;mask all but length
	RRC
	RRC			;divide by 4
	ADI	'5'		;add to ascii 5
	MOV	E,A		;put in 'E' register
	MVI	C,2
	CALL	MEX		;print it [5..8]
	CALL	GETFMT
	ANI	00010000b	;mask all but parity enable
	MVI	E,'N'		;no parity if 0
	JZ	TYPPAR		;show parity
	CALL	GETFMT
	ANI	00100000b	;get parity select
	MVI	E,'O'		;odd parity if 0
	JZ	TYPPAR		;show parity
	MVI	E,'E'		;must have been even parity
TYPPAR:	MVI	C,2		;show character
	CALL	MEX
	CALL	GETFMT		;get format
	ANI	10000000b	;mask all but 2 stop bit indicator
	MVI	E,'1'
	JZ	TYPSTP
	MVI	E,'2'
TYPSTP:	MVI	C,2
	CALL	MEX
	RET
;
; This routine sets baud rate passed as MSPEED code in A.
; Returns CY=1 if baud rate not supported (if supported,
; this routine must set the new MSPEED code).
;
PBAUD:	PUSH	H		;don't alter anybody
	PUSH	D
	PUSH	B
	CPI	9+1		;is baud code > 9?
	JNC	PBEXIT		;error, mspeed code very invalid
	MOV	E,A		;MSPEED code to DE
	MVI	D,0
	LXI	H,BAUDTB	;offset into table
	DAD	D
	MOV	A,M		;fetch code
	ORA	A		;0? (means unsupported code)
	JZ	PBEXIT		;exit if bad
	PUSH	PSW		;no, set the rate
	MVI	A,027h		;turn on DTR, etc
	CALL	OUTCP
	MVI	A,04Eh		;set wordlen to 8NO1 (reset on baud change)
	CALL	OUTMP
	POP	PSW
	CALL	OUTMP		;set new baud rate
	MOV	A,E		;get MSPEED code back
	STA	MSPEED		;set it
	ORA	A		;return no-errors
PBEXIT:	POP	B
	POP	D
	POP	H
	RET
;
PBERR:	STC			;error routine
	JMP	PBEXIT
;
;	Read baud rate, store in MSPEED
;
READBD:	CALL	INCP		;reset mode port flip-flop
	CALL	INMP		;get word/parity
	CALL	INMP		;get baud rate
	MOV	C,A		;save a copy
	ANI	15		;strip off all but rate
	RZ			;it was 0 (weird) so don't do anything
	MOV	A,C		;retore it
	MVI	C,10		;length of table
	LXI	H,BAUDTB	;point to baud rate table
FINDBD:	CMP	M		;do they match?
	JZ	FOUNDB		;yes, we found the baud rate
	INX	H		;hl=hl+1
	DCR	C		;b=b-1
	RZ			;couldn't find baud rate (weird)
	JMP	FINDBD
;
FOUNDB:	PUSH	D
	LXI	D,-BAUDTB	;subtract offset of baud rate table
	DAD	D		;add it to HL
	POP	D
	MOV	A,L		;get left-over
	STA	MSPEED		;store in MSPEED
	RET
;
BAUDTB:	DB	BD110		;110
	DB	BD300		;300
	DB	0		;450 (not supported)
	DB	BD600		;600
	DB	0		;710 (not supported)
	DB	BD1200		;1200
	DB	BD2400		;2400
	DB	BD4800		;4800
	DB	BD9600		;9600
	DB	BD19200		;19200
	DB	0		;32k baud (not supported)
	DB	0		;64k baud (no way)
;
;	Port access routines
;
; Input
;
INCP:	MVI	A,CPORT		;in control port
	JMP	INP1
INMP:	MVI	A,MPORT		;in mode port
	JMP	INP1
INSP:	MVI	A,SPORT		;in status-port
	JMP	INP1
INDP:	MVI	A,DPORT		;in data-port
INP1:	PUSH	B		;can't alter BC
	MOV	C,A		;2661-relative port number in C
	CALL	STPORT		;set port #
	ADD	C		;A=absolute port #
	POP	B		;restore BC
	STA	INP2+1		;put port # in the code
INP2:	IN	0		;do the input
	RET
;
; Output
;
OUTDP:	PUSH	B		;out data-port
	MVI	C,DPORT
	JMP	OUT1
OUTMP:	PUSH	B		;out mport
	MVI	C,MPORT
	JMP	OUT1
OUTCP:	PUSH	B		;out control port
	MVI	C,CPORT
OUT1:	MOV	B,A		;B=char to send
	CALL	STPORT		;set port #
	ADD	C		;A=absolute port #
	STA	OUT2+1		;put port # in the code
	MOV	A,B		;A=char to send
OUT2:	OUT	0		;send it
	POP	B
	RET
;
; Set port #, return base adrs
;
STPORT:	LDA	PORT		;get current port #
	CPI	0FFh		;255 implies SS1
	JNZ	STIN		;jump if not SS1
	MVI	A,SSBASE	;it's SS1, return base adrs
	RET
STIN:	OUT	UPORT		;set IN 3/4 user #
	MVI	A,INBASE	;return base port
	RET
;
PORT:	DB	0		;port storeage
;
; Messages
;
EOSMSG:	DB	ESC,'T','$'
CLSMSG:	DB	ESC,'*','$'
;
;
	END
