	title	'Terminal overlay for Wyse 50 V.1.00 6/18/85'
;
; Copyright 1985, NightOwl Software, Inc. and Alcomp, Inc.
; All Rights Reserved
;
; Written by Al Jewer, 4/07/85
; modified: 4/26/85 (rgf) - rev 1.1
;
; 1.1 modifications:
;
;  1) fixed definition of TDFLAG (see ## flag, below)
;  2) minor fix in TERMSG (also marked with ##)
;  3) insert/delete flag is now a bit vector (see ex-
;     planation, marked with ##)
;
; WYSE 50 MODS	 bob connolly  6/18/85
;  This is the Televideo 920 overlay with only minor changes for WYSE 50.
;  1) changed attribute codes to match wyse 50
;  2) added 25th line display
;  3) changed graphic display codes to wyse
;  4) added function key initialization and function key label line
;     display (from wysefk22.asm) to term initialization.  Keys
;     may be loaded directly into wyse memory (if not more than
;     8 char.) or may be mex key strings (KEY F1="READ A0:SEND ")
;
false	equ	0		; define truth and falsity 
true	equ	0ffh
no	equ	false
yes	equ	true
;
;
cr	equ	0dh		;ascii equates
lf	equ	0ah
bs	equ	08h
bell	equ	07h
esc	equ	1bh
del	equ	7fh
ctrla	equ	'A'-40h		;SOH (function key escape character)
scrclr	equ	1ah		;clear screen character
;
;
; This is the terminal function overlay for the TeleVideo 920.
;
; Video overlays can perform various functions.
; First, they supply MEX with special video functions such as
; reverse video, brite & dim, cursor addressing, etc.
; Secondly, they can supply terminal emulation, by taking
; over keyboard service and modem service while in terminal
; mode. This allows the overlay writer to re-map keys, translate
; control sequences, etc. 
; 
; There are two jump tables associated with the overlay.
; The first is located at the beginning of the overlay 
; segment, and consists of a series of entry points to the 
; overlay. The first two entry points (at 1400 and 1403)
; are the init and exit vectors. The init vector is
; called once only, either at power up or when the overlay
; is loaded. The exit vector is called once only, either at
; exit to the operating system, or before another overlay
; is loaded.
;
; The next two entries are the keyboard service and modem service 
; routines. These are the routines used to do terminal emulation.
; When MEX enters terminal mode, it runs a loop and does a number
; of things in sequence. These include printer and queue service,
; as well as sending keyboard characters and keystrings out to the 
; modem and receiving and displaying characters from the host.
; The tasks of sending and receiving are able to be taken over by
; the terminal overlay, through vectors KBDSRV and MDMSRV. 
; 
; The TSET entry point allows the overlay to receive commands from
; the user, such as emulation on/off, etc. 
;
; While emulation mode is off, the overlay should normally
; pass all calls to KBDSRV and MDMSRV along to the default internal
; routines, aKSRV and aMSRV. 
;
; After the user has entered the proper TSET command, 
; the overlay should enter emulation mode,
; which means that it should intercept all calls to KBDSRV and MDMSRV,
; re-mapping keyboard characters and received data as appropriate.
; A number of entry points to MEX are available to allow you to 
; get to the system I/O easier. These include input, output and status
; routines for modem, keyboard, console, and printer. These can be
; found at the end of the overlay.
;
; Entry point PUTCHR prints the character in the A register to the
; screen, and advances the cursor. The function must handle scrolling 
; and line wrap when necessary. In addition, the function must perform
; carriage return, line feed, bell and backspace functions. All 
; registers except the A and F must be preserved. NUL characters
; must be ignored.
;
; One of the MEX entry points is the keystring processor, LOCTST, which 
; may be called from the overlay if you want to use keystrings in emulation
; mode. When called with the CY flag cleared, the keystring processor 
; works by accepting the character in AL and testing it for a valid 
; keystring. If a keystring definition is found, it
; will be sent out the modem port, and the routine will return a CY
; set to indicate that it used the character. A CY clear indicates that
; the character was not a valid keystring, and was not used.
; The routine will 'soak up' the current escape character. 
; In addition, if this routine is called with the CY flag set, it 
; will process the current character as if the previous character
; was an escape character. This allows the implementation of 
; function keys in the overlay.
;
; Another MEX entry point is QB, which will queue the byte passed in the
; al register to the print and cap buffers, if they are active. This
; routine should be called for each displayed character, if you want to 
; use capture and print spooling while in emulation mode.
;
; The next series of entry points, starting with CLREOS, are entry points
; to allow MEX to use special functions of your particular terminal. 
; All functions within the overlay MUST preserve the HL, BC and DE 
; registers, except where values are passed, as indicated.
; In addition, ENTREV, EXREV, ENTBRT, EXBRT, ENBLNK, and EXBLNK 
; MUST preserve the A and F registers.
;
; The entry point LDRAW allows you to supply line-drawing routines for
; MEX, to allow pretty status displays. The function number is passed
; in the AL register (functions 0 thru 12 allowed). The routine will draw
; one of the basic line-drawing characters. All registers except for
; A and F must be preserved.
;
; The entry point at TSET is used to implement an optional "set" 
; processor for the terminal overlay. This is similar to the set 
; processors for the modem and hardware overlays. 
;
; The entry point THELP lets you replace the MEX on-line terminal
; help menu with one of your own. This is useful if you re-define
; your keyboard or use function keys.
; If you don't want to replace this menu, simply jump to the
; default terminal help menu print routine, at exit point DTHELP.
; Similarly, the TRMENU entry point can supply a replacement for
; the usual message printed upon terminal mode entry. If not supplied,
; this vector should jump to location aDTEMSG.
;
; The flag at STATLN should be defined TRUE or FALSE to indicate the
; presence of a status line on your CRT. Future versions of MEX will
; use this line to display status information while on-line.
; If STATLN is set TRUE, you must supply a routine to write the status line.
; This is done through entry point WRSTAT, which passes a pointer in the
; DX register to a string which is printed to the status line.
; 
	ORG	100H		;START OF TPA
;
; HACKERS: Please note that the following byte MUST be defined in
; ALL overlays. MEX checks for correct processor type before loading
; the overlay. This byte must be a E9h for 8086 or C3h for 8080.
;
	DB	0c3H		;SHOW THAT WE'RE AN 8080 OVERLAY
;
	org	105h		;cpu clock speed stored here
clock:
;
	org	10CH		;video function flag is here
;
	db	true		;yes, we have video functions
;
	org	11dh		;control character filter flag here
filter: db	true		;true = filter control characters from crt
;
	org	0D00H		;mex function processor location
mex:
;
	org	0D1FH		;sendout escape character location
escchr:
;
	org	0d54h		;mode byte location
modloc:
				;2 = sendout active
				;3 = keystring send
;
	org	0e0fh		;## rev 1.1 time/date available flag
tdflag:
;
; TO PERFORM A MEX SERVICE PROCESSOR CALL, MOVE ONE OF THE FOLLOWING 
; VALUES INTO THE C REGISTER, AND CALL MEX. 
;
; EXAMPLE: TO PRINT A LINE OF TEXT TO THE CONSOLE,
;
;		MVI	C,ILP		;MEX INLINE PRINT FUNCTION
;		CALL	MEX		;THIS PERFORMS THE FUNCTION.
;		DB	'This is only a test',0
;
; MEX FUNCTION CALLS PRESERVE THE BX REGISTER.
;
INMDM	EQU	255	;GET CHARACTER FROM PORT TO A, CY= MORE THAN 100 MS
TIMER	EQU	254	;DELAY 100MS * REG B
TMDINP	EQU	253	;B=# SECS TO WAIT FOR CHAR, CY=NO CHAR
CHEKCC	EQU	252	;CHECK FOR ^C FROM KBD, Z=PRESENT
SNDRDY	EQU	251	;TEST FOR MODEM-SEND READY
RCVRDY	EQU	250	;TEST FOR MODEM-RECEIVE READY
SNDCHR	EQU	249	;SEND A CHARACTER TO THE MODEM (AFTER SNDRDY)
RCVCHR	EQU	248	;RECV A CHARACTER FROM MODEM (AFTER RCVRDY)
LOOKUP	EQU	247	;TABLE SEARCH: SEE CMDTBL COMMENTS FOR INFO
PARSFN	EQU	246	;PARSE FILENAME FROM INPUT STREAM
BDPARS	EQU	245	;PARSE BAUD-RATE FROM INPUT STREAM, RETURN IN A
SBLANK	EQU	244	;SCAN INPUT STREAM TO NEXT NON-BLANK (CY= END LINE)
EVALA	EQU	243	;EVALUATE NUMERIC FROM INPUT STREAM TO HL
LKAHED	EQU	242	;GET NEXT CHARACTER W/O REMOVING FROM INPUT
GNC	EQU	241	;GET CHARACTER FROM INPUT, CY=NONE
ILP	EQU	240	;INLINE PRINT FUNCTION
DECOUT	EQU	239	;DECIMAL OUTPUT ROUTINE FROM HL
PRBAUD	EQU	238	;PRINT BAUD RATE
PRNTBL	EQU	237	;PRINT TABLE
PRID	EQU	236	;PRINT [MEX] ID
ONOFF	EQU	235	;PARSE ON/OFF FROM INPUT STREAM	 A = 0 OR 1 (CY=ERR)
PRINT	EQU	9	;DOS/MEX PRINT STRING FUNCTION CALL
CONOUT	EQU	2	;DOS/MEX CONSOLE OUTPUT FUNCTION CALL
;
;
	org	1400H		;base of overlay segment
;
;------------------------------------------------------------
;
;	video overlay starts here
;	(extends 1400-1fff)
;
;------------------------------------------------------------
;
	jmp	tinit		;video overlay init
	jmp	tdinit		;video overlay de-init
	jmp	aksrv		;keyboard service during terminal mode
	jmp	amsrv		;modem service during terminal mode
	jmp	clreos		;clear to end of screen
	jmp	cls		;clear screen, home cursor
	jmp	clreol		;clear to end of line
	jmp	entrev		;enter reverse video
	jmp	exrev		;exit reverse video
	jmp	entbrt		;enter brite mode
	jmp	exbrt		;exit brite mode
	jmp	enblnk		;enter blink mode 
	jmp	exblnk		;exit blink mode
	jmp	remcur		;get & remember cursor position, returned in de
	jmp	rescur		;restore last remembered cursor
	jmp	curadd		;move cursor to D=row (vert), E=column (horiz)
				;0,0 = upper left hand corner
	jmp	putchr		;put character to screen from A, increment
				;cursor position, wrap or scroll if necessary.
	jmp	atstat		;raw terminal status returned to a
	jmp	kin		;raw terminal keyboard data input to a
	jmp	wrstat		;write to status line, text pointed to by de,
				;terminated with 0
	jmp	ldraw		;line drawing routine
	jmp	tset		;TSET entry point for optional SET processor
	jmp	thelp		;terminal mode help menu print routine
	jmp	termsg		;terminal mode entry message
	jmp	inslin		;insert line
	jmp	dellin		;delete line
	jmp	inschr		;insert character
	jmp	delchr		;delete character
	jmp	entunl		;enter underline mode
	jmp	exunl		;exit underline mode
	jmp	trmcap		;return termcap pointer
;
; end of fixed area (jump table)
;
; This routine returns a pointer to the termcap block, which is
; a length byte followed by a list of the supported capabilities.
;
; 
trmcap: lxi	h,trmdef	;return pointer
	ret
;
trmdef: db	4		;4 capabilities 
;
;
statln: db	true		;no status line
	db	true		;yes, cursor addressing available
	db	true		;yes, we generate escape sequences
	db	11111111b	;insert/delete ## see new definition, below
;
; ## bit definition for insert/delete flag, above
;
; 80h = 1 if insert line available, 0 if not
; 40h = 1 if delete line available, 0 if not
; 20h = 1 if insert char available, 0 if not
; 10h = 1 if delete char available, 0 if not
; (note: the low four bits are indeterminate, ignore
;  by MEX, so if you have all four capabilities, you
;  define the insert/delete byte "TRUE")
;
justrt: ret			;null routine, for un-implemented functions
;
; following are the characters we use if there are no line-drawing
; characters available.
;
grchar:		;table of characters
;
;	   char. to use		func. #	   description
;	   ------------		-------	   -----------
	db	'6'		; 0	   ;vertical bar
	db	':'		; 1	   ;horizontal bar
	db	'2'		; 2	   ;upper left corner character
	db	'3'		; 3	   ;upper right corner
	db	'1'		; 4	   ;lower left corner
	db	'5'		; 5	   ;lower right corner
	db	'8'		; 6	   ;crossed lines
	db	'4'		; 7	   ;vbar with right hand extension
	db	'9'		; 8	   ;vbar with left extension
	db	'='		; 9	   ;hbar with upper extension
	db	'0'		; 10	   ;hbar with lower extension
	db	';'		; 11	   ;small dot
	db	'7'		; 12	   ;solid white block
	db	'?'		; 13	   ;checkerboard
;
; routine to draw characters based on a register function number
;
ldraw:	push	h		;save registers
	push	b
	lxi	h,grchar	;point to table
	add	l		;add a to hl
	mov	l,a
	jnc	xcy	
	inr	h
xcy:	mov	c,m		;get character from table
	push	b
	mvi	c,esc
	call	rtype
	mvi	c,'H'
	call	rtype
	pop	b
	call	rtype		;put graphics character to screen
	pop	b
	pop	h		;restore affected registers
	ret
;
wrstat: push	h		;save registers
	push	d
	push	b
	xchg			;pointer to hl
	push	h		;save
	mvi	c,esc		;esc F	writes to status line
	call	rtype
	mvi	c,'F'
	call	rtype
wrstl:	pop	h		;get pointer
	mov	a,m		;get character
	ora	a		;end?
	jz	wrstex
	mov	c,a		;char to c for rtype
	inx	h		;increment pointer
	push	h		;save
	call	rtype		;output character
	jmp	wrstl		;back for next
wrstex: mvi	c,0dh		;done . .
	call	rtype		; . . CR ends
	pop	b
	pop	d
	pop	h
	ret
;
; Next is keyboard input function, including
; keyboard code conversion for special function keys
;
;
kin:	call	atkin		;get the character
	cpi	ctrla		;escape character?
	stc			;clear cy (prep non-function key)
	cmc
	rnz			;return if not function key
	push	h		;save all
	push	d
	push	b
	mvi	b,0		;outer loop counter for timer
fktimr: lda	clock		;get cpu speed
	mov	c,a		;loop counter - we wait roughly .25 ms
burn:	jmp	b2		;10 t-cycles
b2:	dcr	c		;4 t-cycles
	jnz	burn		;10 t-cycles (24 total)
	push	b		;save loop count
	call	atstat		;check for character received
	pop	b
	ora	a		;
	jnz	gotfky		;jump if we found one
	dcr	b		;count the loop
	jnz	fktimr		;wait for about 60 ms for 2nd character
	mvi	a,ctrla		;none received - we assume it was a control-a
	ora	a		;reset cy
	jmp	kend		;return non-function key
gotfky: call	atkin		;get the function code
	push	psw		;save it
	call	atkin		;eat the carriage return
	pop	psw		;recover function code
	cpi	40h		;check for 40h-4ah (top row of function keys)
				;remap if so, else pass thru as other function
	jc	xfunc		;jump if too small
	cpi	4bh		
	jnc	xfunc		;jump if too big
funkey: sui	0fh		;remove offset, change to 31h-3bh
	cpi	3ah		;test for f10
	jnz	nf10		;jump if not
	mvi	a,30h		;make ascii 0 - return f10
xfunc:	cpi	'b'		;break request?
	jnz	notbrk		;jump if not
	mvi	a,'@'		;remap it to what mex wants to see
notbrk: stc			;cy set means function key
kend:	pop	b
	pop	d
	pop	h
	ret
nf10:	cpi	3bh		;test for f11
	jnz	xfunc		;return if not
	mvi	a,'E'		;f11 is remapped to terminal mode exit
	jmp	xfunc
;
;
;
; this routine performs the MEX inline print function
;
ilprt:	mvi	c,ilp
	jmp	mex
;
; Next is the THELP help menu print routine.
;
thelp:	call	ilprt			;inline print
 db cr,lf,'Terminal Control Sequences:',cr,lf,cr,lf
 db 'Funct + (lower case)      |  Other keys:',cr,lf
 db 'e: Exit terminal mode     |  F11:    Exit terminal mode',cr,lf
 db 'b: Send BREAK to remote   |  F1-F10: Keystrings',cr,lf
 db 's: Memory save on         |',cr,lf
 db 'u: Memory save off        |  Note: Funct + @, A, B, C etc..',cr,lf
 db 'p: Toggle printer on/off  |        (upper case) same as',cr,lf
 db 'n: Disconnect modem       |        F1, F2, F3, F4, etc.',cr,lf
 db 't: Transmit file',cr,lf
	db	0
	ret
;
; Next routine prints the terminal mode entry message.
; ## minor change in this routine for revision 1.1 (3 lines moved,
;  [call ilprt , db '      ',0] added
;
termsg: lda	msgflg			
	ora	a			;is message turned off?
	rz				;return if so 
	call	ilprt
	db	'=[Term: use Funct + ? for help]',cr,lf
	db	0
	lda	tdflag			;get time/date overlay flag
	ora	a			;test if time/date available
	rz				;return if not
	call	ilprt
	db	'      ',0
	jmp	prtime			;print the time if available
;
;
; This is the TSET command table.
;
cmdtbl: db	'?'+80h			;help request
	dw	sethlp
	db	'BRIGH','T'+80h		;bright on/off
	dw	setbrt
	db	'BRIT','E'+80h		;brite synonym for bright
	dw	setbrt
	db	'MESSAG','E'+80h	;T-mode message on/off
	dw	setmsg
	db	'MS','G'+80h
	dw	setmsg
	db	'BEEPE','R'+80h		;Beeper on/off
	dw	beeper
	db	'BEE','P'+80h
	dw	beeper
	db	0			;table terminator
;
msgflg: db	1			;T-mode message on/off flag
bpflag: db	1			;Beep on/off flag
brtflg: db	0			;always bright if on
;
; Next is the TSET command processor
;
tset:	mvi	c,sblank		;any arguments?
	call	mex
	jc	telall			;tell current status if not
	lxi	d,cmdtbl		;point command table
	mvi	c,lookup		;see if command found
	call	mex
	jc	seterr			;complain if not
	pchl				;else go to service routine
seterr: call	ilprt			;print error message
	db	cr,lf,'TSET command error. '
	db	'Use TSET ? for help',cr,lf,0
	ret
;
; tset HELP function
;
sethlp: call	ilprt			;print the help message
	db	cr,lf
	db	'TSET MESSAGE ON or OFF (T-mode signon)',cr,lf
	db	'TSET BEEPER ON or OFF',cr,lf
	db	'TSET BRIGHT ON or OFF',cr,lf
	db	cr,lf
	db	0
	ret
;
; set message on/off processor
;
setmsg: lxi	h,msgblk		;load pointer
	jmp	boole			;join boolean common code pointer
;
; set bright on/off processor
;
setbrt: lxi	h,brtblk
	jmp	boole
;
; beeper on/off
;
beeper: lxi	h,beepbl
;
; Boolean TSET common code
;
boole:	mov	e,m			;fetch address of boolean
	inx	h
	mov	d,m
	inx	h			;HL addresses text
	push	d			;save it
	push	h			;save that pointer
	mvi	c,sblank		;any arguments?
	call	mex
	jnc	notell			;jump if so
tell:	pop	d			;none, query only
	mvi	c,print			;print message
	call	mex
	call	ilprt 
	db	' is O',0
	pop	h			;boolean location
	mov	a,m
	ora	a			;is it off?
	jz	izoff			;jump if so
	call	ilprt			;else print 'ON'
	db	'N',cr,lf,0
	ret
izoff:	call	ilprt			;print 'OFF'
	db	'FF',cr,lf,0
	ret
notell: mvi	c,onoff			;parse on/off from input stream
	call	mex
	jc	seterr			;complain if not on or off
	pop	d			;recall msg pointer
	pop	h			;boolean's adrs
	push	h			;resave
	push	d
	mov	m,a			;update boolean
	jmp	tell			;show what we did
;
; next is tset status display 
;
telall: call	crlf
	lxi	h,msgblk		;T-mode message on/off
	call	boole
	lxi	h,beepbl		;beeper on/off
	call	boole
	lxi	h,brtblk		;bright
	call	boole
	jmp	crlf
;
msgblk: dw	msgflg
	db	'T-mode signon msg$'
brtblk: dw	brtflg
	db	'BRIGHT mode$'
beepbl: dw	bpflag
	db	'Console beeper$'
;
;
;
; CRLF - print carriage return and line feed
;
crlf:	call	ilprt		
	db	cr,lf,0
	ret
;
; PUTCHR - put character to screen from A.
;		MUST preserve ALL registers.
;
; special note - This overlay has to do a very wierd thing here because
;			of the way the TV920 does its attribute storage.
;			The terminal EATS ONE CHARACTER POSITION on the
;			screen when you shift in and out of reverse video.
;			Therefore, we eat the character following an "enter 
;			reverse video" or "exit reverse video" call. (This
;			character is always blank from MEX). This makes room
;			for space taken up by the stupid video attribute 
;			storage.
;
putchr: push	psw			;save character
	lda	svflag			;stupid video flag set?
	ora	a
	jz	nstupd			;jump if not following video func char.
	xra	a			;get 0
	sta	svflag			;show video character accounted for
	pop	psw			;recover character
	ret				;return without printing it
nstupd: pop	psw			;recover character
	cpi	bell			;bell character?
	jnz	rtype			;print it if not
	lda	bpflag			;get beep enabled flag
	ora	a
	mvi	a,bell			;restore character
	jnz	rtype			;jump if bell on
	push	b			;save affected registers
	push	d			;
	call	ilprt			;print it instead
	db	'{beep} ',0
	pop	d
	pop	b
	ret
;
svflag: db	0			;set if video function character sent
;
; ENTREV - Enter reverse video
;
entrev: call	savall			;save all registers
	mvi	c,'4'			;enter reverse video function
	jmp	vidfnc			;flag next character to be eaten
;
; EXREV - Exit reverse video
;
exrev:	call	savall
	mvi	c,'0'			;exit reverse video
;	(fall thru....)
;
; VIDFNC - set video function flag, send esc, G, attribute (in c)
;
vidfnc: mvi	a,0ffh			;get true
	sta	svflag			;set the stupid video function flag
	push	b
	mvi	c,esc
	call	rtype
	mvi	c,'G'
	call	rtype
	pop	b
	jmp	rtype
;
; VIDCOM - Video function common code - sends ESC followed by character 
;		passed in the A register.
;
vidcom: push	b			;save character
	mvi	c,esc			;send the escape
	call	rtype		
	pop	b			;recover character
	jmp	rtype			;type it & return
;
;
; ENTBRT - Enter brite mode
;
entbrt: call	savall
	mvi	c,'('			;end half intensity
	jmp	vidcom
;
; EXBRT - Exit brite mode
;
exbrt:	lda	brtflg
	ora	a			;bright mode always?
	rnz				;exit if so
	call	savall
	mvi	c,')'			;start half intensity
	jmp	vidcom
;
;
; ENBLNK - Enter blink mode
;
enblnk: call	savall
	mvi	c,'2'			;start blink field
	jmp	vidfnc

;
; EXBLNK - Exit blink mode
;
exblnk: call	savall
	mvi	c,'0'			;end blink field
	jmp	vidfnc
;
;
; REMCUR - Get and remember cursor position
;
remcur: push	h			;save all affected
	push	b
	mvi	c,'?'			;read cursor
	call	vidcom
	call	atkin			;get row return value
	push	psw			;save it
	call	atkin			;get column return value
	push	psw			;save it too
	call	atkin			;eat the cr
	pop	psw			;pack the bytes to hl
	sui	20h			;remove ascii bias
	mov	l,a
	pop	psw			;recover row
	sui	20h
	mov	h,a
	shld	oldcur			;save it
	xchg				;return in de
	pop	b			;recover affected registers
	pop	h
	ret
;
oldcur: dw	0			;old cursor position stored here
;
; RESCUR - Reset cursor to last remembered position
;
rescur: call	savall			;save registers
	lhld	oldcur			;get old cursor position
	xchg				;to de
acurad: mvi	c,'='			;cursor address function
	push	d
	call	vidcom			;send ESC =
	pop	d
	mov	a,d			;get row
	adi	20h			;add ascii bias
	push	d
	mov	c,a
	call	rtype			;send row address
	pop	d
	mov	a,e			;get column
	adi	20h			;add bias	
	mov	c,a
	call	rtype			;cursor address sequence finished
	ret
;
;
; CURADD - address cursor to dh=row (vert), dl=column (horiz)
;
curadd: call	savall			;save registers
	jmp	acurad			;join common code
;
;
; TINIT - Init overlay, called once only at power up or load time.
;
tinit:	call	cls		;clear screen, home cursor
	mvi	c,ilp
	call	mex
	DB	ESC,'A1p',CR		;SET FUNCTION KEY LINE TO DIM
	DB	ESC,'A2p',CR		;SET LOCAL MESSAGE LINE TO DIM
	DB	ESC,'A3p',CR		;SET HOST MESSAGE LINE TO DIM
;
	DB	ESC,'F'			;ENTERS MESSAGE INTO THE HOST
	db	'MEX with WYSE 50 Terminal Overlay',13
;
	db	ESC,'z01=Send',CR	;label for 1
	db	ESC,'z@',DEL		;code for 1
;			;Must have  KEY F1="READ A0:SEND "  in INI.MEX
;			; so MEX will run your	SEND.MEX  read file.
;			; ESC z @   clears any previous data in F1
;
	db	ESC,'z12=Get',CR	;label for 2
	db	ESC,'zA',DEL		;code for 2

	db	ESC,'z23=Set',CR	;label for 3
	db	ESC,'zBSET ',DEL	;code for 3

	db	ESC,'z34=dir',CR	;label for 4
	db	ESC,'zCDIR',CR,DEL	;code for 4

	db	ESC,'z45=Stat',CR	;label for 5
	db	ESC,'zDSTAT',CR,DEL	;code for 5

	db	ESC,'z56=   ',CR	;label for 6
	db	ESC,'zE',DEL		;code for 6

	db	ESC,'z67=   ',CR	;label for 7
	db	ESC,'zF',DEL		;code for 7

	db	ESC,'z78=Term',CR	;label for 8
	db	ESC,'zGT',CR,DEL	;code for 8
;
	db	ESC,'zH',DEL		;code for 9
	db	ESC,'zI',DEL		;code for 10
	db	ESC,'zJ',DEL		;code for 11
	db	ESC,'zK',DEL		;code for 12
	db	ESC,'zL',DEL		;code for 13
	db	ESC,'zM',DEL		;code for 14
	db	ESC,'zN',DEL		;code for 15
	db	ESC,'zO',DEL		;code for 16
;
; for shift function keys
;
	db	ESC,'zP1=Save',CR	;label for 1
	db	ESC,'z`','J'-40h,'S',DEL	;code for 1

	db	ESC,'zQ2=NoSave',CR	;label for 2
	db	ESC,'za','J'-40h,'U',DEL	;code for 2

	db	ESC,'zR3=Discon',CR	;label for 3
	db	ESC,'zb','J'-40h,'N',DEL	;code for 3

	db	ESC,'zS4=BYE',CR	;label for 4
	db	ESC,'zcBYE',CR,DEL	;code for 4

	db	ESC,'zT5=Printr',CR	;label for 5
	db	ESC,'zd','J'-40h,'P',DEL	;code for 5

	db	ESC,'zU6=DirAll',CR	;label for 6
	db	ESC,'zeDIR $AND',DEL	;code for 6

	db	ESC,'zV7=   ',CR	;label for 7
	db	ESC,'zf',DEL		;code for 7

	db	ESC,'zW8=Command',CR	;label for 8
	db	ESC,'zg','J'-40h,'E',DEL	;code for 8

;	db	esc,'z',del		;to disable shift display
;
	db	0			;terminate ilp
	ret
;
; TDINIT - deinit overlay, called once only at power down 
;
tdinit: call	entbrt		;restore normal briteness
	ret
;
; CLS - Clear screen, home cursor to upper left hand corner.
;
cls:	call	savall		;save all registers
	mvi	c,scrclr	;send screen clear (^Z)
	jmp	rtype		;type it 
;
;
; CLREOS - Clear to end of screen.
;
clreos: call	savall			;save registers
	mvi	c,'Y'			;erase to end of page function
	jmp	vidcom
;
;
; CLREOL - Clear to end of line
;
clreol: call	savall
	mvi	c,'T'			;erase to end of line
	jmp	vidcom
;
;
; INSCHR - Insert character
;
inschr: call	savall
	mvi	c,'Q'			;insert character
	jmp	vidcom
;
;
; DELCHR - Delete character
;
delchr: call	savall
	mvi	c,'W'			;delete character
	jmp	vidcom
;
;
; INSLIN - Insert line
;
inslin: call	savall
	mvi	c,'E'			;insert line
	jmp	vidcom
;
;
; DELLIN - Delete line
;
dellin: call	savall
	mvi	c,'R'			;delete line
	jmp	vidcom
;
;
; ENTUNL - Enter underline mode
;
entunl: call	savall
	mvi	c,'8'			;enter underline mode
	jmp	vidfnc
;
;
; EXUNL - Exit underline mode
;
exunl:	call	savall
	mvi	c,'0'			;exit uderline mode
	jmp	vidfnc
;
;
; 8080 routine to save all registers & flags on stack, and set up
; a return to here (to restore all after subroutine return)
;
savall: shld	hlsave			;save hl in ram
	pop	h			;get subroutine return address to hl
	push	psw			;save all on stack
	push	d
	push	b
	push	h			;subroutine return to stack
	lxi	h,savret		;our return address
	xthl				;put it in stack
	push	h			;followed by calling subroutine address
recurs: lhld	hlsave			;restore hl
	ret				;back to subroutine then back to here..
savret: pop	b			;restore all
	pop	d
	pop	psw
	jmp	recurs			;finish above
;
hlsave: dw	0			;store hl here
;
;
;------------------------------------------------------------
;
;	end of video overlay
;
;------------------------------------------------------------
;
	org	2000h		;video overlay must end before 2000H
;
;------------------------------------------------------------
;
; start of video overlay support vector table
;
;------------------------------------------------------------
;
; DO NOT CHANGE THE FOLLOWING CODE!
; These are entry points to MEX.
;
msrdy:	ds	3		;modem output test, z flag set when ready
otdata: ds	3		;raw modem output from a - status NOT checked
mschr:	ds	3		;wait for output ready, then send char. from b
stat:	ds	3		;kbd ready test, z flag RESET when ready
keyin:	ds	3		;get kbd character to a
mrrdy:	ds	3		;modem input ready test, z flag SET when ready
indata: ds	3		;raw modem input to a
ctype:	ds	3		;console output, filtered, tabs expanded, etc.
				;CAUTION: calls putchr for raw output
rtype:	ds	3		;raw console output from c
atstat: ds	3		;bios status call to rom
atkin:	ds	3		;bios keyboard input call to rom
lsts:	ds	3		;list status, returned in a (nz=ready)
lister: ds	3		;list output from c
aksrv:	ds	3		;default keyboard service routine 
amsrv:	ds	3		;default modem service routine 
loctst: ds	3		;test keyboard character for keystring,
				;process if so. return cy set if character used
qb:	ds	3		;queue byte to print & cap buffers
trmxit: ds	3		;exit terminal mode
dthelp: ds	3		;default terminal help menu print routine
dtemsg: ds	3		;default terminal mode entry message
prtime: ds	3		;print time to console
	ds	12		;spare
;
;
;
	end
