/* console routines for the cpu on board acia */

#include "edtccpu.h"
#include "edtextrn.h"


init_q ()
{
	register unsigned char cc;

	head = tail = input_q;
	cc = *ACIA_DATA;	 /* clear serial chip buffer */
}

con_out (c)
char c;
{
	register unsigned i;

	if(printflag & 0x10) {
		intr_cpu(c); /* 871125mft pass outchar via ICB INT DATA */
	} else {
		i= 0x0fff0000;
		/* wait for transmitter empty */
		while ( ((*ACIA_STAT & 0x02) == 0) && (--i) )
			;
		if ( i==0 )
			return;
		*ACIA_DATA = c;
	}
}

con_in ()
{
	register unsigned char temp;
	if (head != tail) {
		temp = (*head++);
		if (head == &input_q[sizeof input_q])
			head = input_q;  /* wrap around */
		return (temp);
	}
	else
		return (-1);
}


/* this is the interrupt service routine for the on board (cpu) peripheral
   devices....acia (serial i/o chip) */

serint ()
{
	register char cc;

	if (*ACIA_STAT & (char)0x81){  /* did the acia interrupt with a char? */
		cc = *ACIA_DATA;  /* put char in queue */

		if ( cc == 0x1b )
#if DOWN
			return;
#else
			retmon();
#endif

		*tail++ = cc;		/*  put char in queue */
			
		if (tail == &input_q[sizeof input_q])
			tail = &input_q[0];  /* wrap around */
	}
}
