#include "edtdisksect.h"
#include "edt.h"
#include "edtdtc.h"
#include "edtdevdq.h"
#include "edtdevstr.h"
#include "edtextrn.h"


/*
 * format single track  Zt <drive> <c> <h> <scnt> <datapattern>
 */

format (bufptr)
char *bufptr;
{
	register char c2;
	register struct devdq *dev;

	c2 = *(bufptr+1);	/* 2nd char */

	dev = &req;
	initdevq (dev);
	dev->device = DISK;

	if (c2 == 'T')  {
		fmtsect (dev, bufptr);
		return (0);
	}
	return (-1);
	
}


/*
 * format single track
	ZT <drive> <c> <h> <scnt> <datapattern>
 */

fmtsect(dev, bufptr)
register struct devdq *dev;
char *bufptr;
{
	int argu[5];
	register struct dkinf *dkptr;
	register ret, i;

	if ( getarg (bufptr, argu, 5) < 0 )
		return (-1);

	if (argu[0]>3)
		return(-1);
	dev->devnum = argu[0];
	dev->q_devun.pdisk.cyl = argu[1];
	dev->q_devun.pdisk.head = argu[2];

		/* format entire track */
	dev->q_devun.pdisk.sector = 0;		/* starting sector */
	dev->scnt = argu[3];

	/* max have space to format 0x12 sectors */
	if ( dev->scnt > sectsize ) {
		printf ("too many sectors");
		return (-1);
	}

	/* get pointer to physical drive data */
	if ( (dkptr=(struct dkinf *)getphptr(dev))==(struct dkinf *)-1 )
		return(0);

	if ( wridsec (dev,dkptr) ) {
		printf ("can't write id");
		return (-1);
	}

	/* write data to that sector */
	dev->mem = (char *) LOCA;
	i = FORMDATA;
	if ( *(bufptr+1) == 'T' )
		i = argu[4];

	setbuf (dev->mem, (BLKSIZE/2) * dev->scnt, i );
	dev->opr = OPR_WRITE;

	for (i = 0; i<RETRY; i++) {
		if ( (ret = diskio (dev, dkptr) ) == 0 ) 
			break;
		printf ("can't w");
		prchs (dev);
	}

	if ( ret ) 
		return(-1);		/* can't write to sec */
	return (0);
}


