#include "edtccpu.h"
#include "edtdtc.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevdq.h"
#include "edtdevstr.h"
#include "edtdata.h"
#include "edtstruct.h"
#include "edtptm.h"
#include "vreg.h"
#include "edterror.h"
#include "edtextrn.h"
#define NOTLOOP 3

struct errb {
	char err; char errno; char *msgptr;
}errtbl[5] =
{	RDYC_FAULT,	DER_RDYCHG,	"rdychg ",
	HEAD_SEARCH,	DER_HDSR,	"hdersrch ",
	ALT_MODE,	DER_ALT,	"alt ",
	CRC_ERR,	DER_CRC,	"datacrc ",
	DATA_OVR,	DER_OVR,	"dataover ",
};


/*
	interrupt is disable where enter this routine
	if operation has wait for completeion option, then inturrpt will be
		enabled when return

	return:	1 if seek error
		2 if read/write error
		0 if no error
		3 if timeout 
 */
diskrw(dev, dkptr,oldpri)
register struct devdq *dev;
register struct dkinf *dkptr;
register oldpri;
{
	register struct ddcid *id;
	register struct smdwr *wr;
	struct smdrd *rd;
	register unsigned char *ptr;
	register retbyte, timeout;
	register short status;
	register ushort j;
	register int i;

	if ( bddesc.tas1 & STOPDKIO )
		stop();

/* DDDDDDDDDDDDDDDDDDDDDDD */
	if ( dev->flag & 0x8000 )
		errflag(dev);

/* DDDDDDDDDDDDDDDDDDDDDDD */
/* XXXXXXXXXXXXXXX */
	rd = (struct smdrd *)DK_STSR + dev->devnum;
	status = rd->unitstus & 0x0f;
	if ( (status != 0x03) ) {
		printf ("r1");
	}

	dev->forward = 0;
	curwreq = dev;


	/* ************************************ */
	/* program clock to monitor             */
	/* if timeout, need to reset disk drive */
	dkptr->pd_tick =  TICK_1SEC;
	/* ************************************ */
	/* load timing register */
	if ( dkptr->pd_ststat & (DK_INIT+DK_TIMIN) )  {
		/* only load timing register if drive is opened and
			there is value in the table */
		ptr = dkptr->gap;
		timeout = 0;
		for (j=0; j<4; j++)
			timeout |= *ptr++;
		if ( timeout )
			setimid (dkptr->gap);
	}

	/* **************************** */
	/* save operation code in structure */
	/* load timing register 9 and A */
	/* **************************** */
	*DDC_TR2 = 0x80;  
	if ( dev->opr == OPR_READ ) {
		dkptr->pd_opr = DK_READ;
		*DDC_TRA = 0x0; 
	}
	else {
		dkptr->pd_opr = DK_WRITE;
		*DDC_TRA = 0xff; 
	}
	*DDC_TR9 = 0xff;  

	/* clear inturpt word */
	inturpt &= ~(DTB_INT + DDCDMA_INT + DDADMA_INT + CHNDMA_INT + 
		DTBDMA_INT + DDC_INT);

	/* setup DMA & enable DMA */
	setupdma(dev);

	/* setup DDC ID register, DDC sector register */
	id = (struct ddcid *)DDC_IDR;
	id->flag = 0;
	id->cylh = *(char *)&dev->q_devun.pdisk.cyl;
	id->cyll = dev->q_devun.pdisk.cyl;
	id->head = dev->q_devun.pdisk.head;

	*DDC_SCR = dev->q_devun.pdisk.sector << 8 | dev->scnt;
	wr = (struct smdwr *)DK_BUSW + dev->devnum;

	/* 20 u sec, delays after this struction before DK_START */
	wr->head = dev->q_devun.pdisk.head;
	wr->control = 0;

	for (j=0; j<10; j++);	/* delay */


	/* program DDC control register */
	*DDC_CR = dev->opr; 
	*DDC_CR = ENDKDATAC | dev->opr; 
	*DDC_CR = DK_START | ENDKDATAC | dev->opr; 

	i = 1;				/* delay before enable int. */

	dtc_ctl |= DDCINT_EN;
	*DTC_CRL = dtc_ctl;		/* enable ddc done interrupt */
	
	/* only return if send main memory and don't wait */
	if ( (dev->flag & (DEST_L+TNOWAIT)) == TNOWAIT )
		/* disk <->mm  and don't wait */
			return(0);

	/* ********************************* */
	/* fix in V1.6, don't need the clock */
	dkptr->pd_tick =  0;
	/* ********************************* */

	splx (oldpri);

	/* always wait if local memory wait for DDC done (level 6)*/
	/* put timeout in, incase using wrong timing register */
	timeout = TIMEOUT;
	for ( i=0; i<0x00050000/4; i++) {
		if ( inturpt & DDC_INT ) {
			timeout = 0;
			break;
		}
	}


	/* disable inturpt to check error */
	oldpri = spl6();

	/* incase interrupt never happen */
	dtc_ctl &= ~DDCINT_EN;		/* no more ddc interrupt */
	*DTC_CRL = dtc_ctl;

	/* curwreq = 0; dev->flag |= OPRDONE, dkptr->pd_opr = 0; inturpt = 0; */
	/* reset disk channel if error */
	retbyte = checkrw (dev,dkptr);
	splx (oldpri);

	if ( timeout ) {
		/* reset, enable disk data channel */
		dev->rc1 = DER_ILTIM;
		printf ("r2");
		return (timeout);
	}

	return (retbyte);

}


checkrw(dev,dkptr)
register struct devdq *dev;
register struct dkinf *dkptr;
{
	register unsigned char ddcstatus;
	register unsigned short intrptbit; register oldpri;


	curwreq = 0;

	dev->flag |= OPRDONE;
	dkptr->pd_opr = 0;
	/* ********************** */
	/* turn off tick for disk */
	/* ********************** */
	dkptr->pd_tick = 0;

	if ( dev->flag & DEST_L ) {
		intrptbit = DDCDMA_INT; /* disk <-> local memory) */
		dbc_cr &= ~(DDC_EN + DDA_EN);
	}
	else {
		intrptbit = CHNDMA_INT + DTB_INT; /* disk <-> DTB */
		dbc_cr &= ~(CHN_EN + DDA_EN);
	}

	inturpt &= ~( intrptbit + DDADMA_INT + DDC_INT);
	*DBC_CR  = dbc_cr;

	/* may not get ddcdone bit set in DDC_SR */
	ddcstatus = *DDC_SR;

	/* turn off  bits in  DDC control register */
	*DDC_CR = ENDKDATAC;

	/* compute which sector is bad */
	dev->cursdone = (dev->scnt - (unsigned char)(*DDC_SCR) );
	dev->totsdone += dev->cursdone;
	dev->sectleft -=  dev->cursdone;

	/* no error from disk */
	if ( (ddcstatus & ~DONEDDC) == 0 ) {
		return (0);
	}

	dev->badsecn = dev->cursdone + dev->q_devun.pdisk.sector;

	if ( ckddc (dev, ddcstatus) == 0 )
		return;

	/* inturrpt still disable */

	/* some kind of error, reset DDC */
	*DDC_CR = 0;
	*DDC_CR  = ENDKDATAC;
	dkptr->curcyl = -1;

	if ( (dev->flag & DEST_L) == 0 )
		canceldmc();
	return(-1);
}


/*
	DDC timing register is already set 

	read id (E command), format sector, format alt sector,
	read defective media 

	return:	2 if read ID/write ID error
		3 timeout (can't read id)
		0 if no error
 */
rwid(dev, dkptr, indexbit, dmalength, flag)
register struct devdq *dev; register struct dkinf *dkptr;
int indexbit, dmalength;
unsigned short flag;
{

    register struct ddcid *id; register struct smdwr *wr;
    register ushort i; register unsigned char ddcstatus;
    register timeout; register oldpri;
    unsigned char ltbr, *bptr;
    unsigned altsect;

    *(short *)&dev->rc1 = 0;
    if ( dkptr->curcyl != dev->q_devun.pdisk.cyl ) {
        oldpri = spl6();
        /* wait for seek to complete */
        if ( aseek (dev, dkptr,oldpri) ) {
        /* interrupt is enable again, seek problem */
        return (SKERR);
        }
    }
    
    dev->forward = 0;
    curwreq = dev;

    if ( dev->opr == OPR_WRID ) {
        dkptr->pd_opr = DK_WID;
        *DDC_TRA = 0xff;
        }
    else {
        dkptr->pd_opr = DK_RID;
        *DDC_TRA = 0;
    }
    *DDC_TR9 = 0;
    
    
    /* ****************** */
    /* no clock for rwid  */
    dkptr->pd_tick =  0;
    /* ****************** */

    /* inturpt is enabled again */


    /* setup DDC & DDA DMA starting & ending address */
    dmaddr ( dev->mem, dmalength, DDCDMA);
    dmaddr ( dev->mem+dmalength, dmalength, DDADMA);
    
    /* enable DDC  & DDA dma, program data path */
    msdklocm();
    
    /* DDC sector register */
    *DDC_SCR = dev->q_devun.pdisk.sector << 8 | dev->scnt;
    
    /* program DISK BUS REGISTER for specify head */
    wr = (struct smdwr *)DK_BUSW + dev->devnum;

    /* 20 u sec, delays after this struction before DK_START */
    wr->head = dev->q_devun.pdisk.head;
    wr->control = 0;
    
    for (i=0; i<10; i++);		/* delay */
    
    /* allow ddc done interrupt */
    dtc_ctl |= DDCINT_EN;
    
    /* program DDC control register */
    *DDC_CR = dev->opr; 
    *DDC_CR = ENDKDATAC  | dev->opr; 
    *DDC_CR = DK_START | ENDKDATAC | indexbit | dev->opr; 
    
    i = 1;				/* delay before enable int. */
    
    *DTC_CRL = dtc_ctl;
    
    /* wait for DDCdone bit set in DDC STATUS REGISTER */
    /* wait for 80 m sec(80000 usec)  loop = 0x4e20 */
    /* average instruction take 1.25usec */
    
    timeout = TIMEOUT;
    for (i=0; i<80000/4; i++) {
        if ( inturpt & DDC_INT ) {
            timeout = 0;		/* able to read id */
            break;
        }
    }
    
    ddcstatus = *DDC_SR;			/* get status */
    
    i = spl6();
    inturpt &= ~(DDC_INT + DDCDMA_INT+DDADMA_INT);
    dtc_ctl &= ~DDCINT_EN;		/* no more ddc interrupt */
    *DTC_CRL = dtc_ctl;
    
    /* disable DDC & DDA dma (incase interrupt never happen) */
    dbc_cr &= ~(DDC_EN+DDA_EN);
    *DBC_CR = dbc_cr;
    
    dkptr->pd_opr = 0;
    
    
    curwreq = 0;
    splx(i);
        
    /* turn off  bits in  DDC control register */
    *DDC_CR = ENDKDATAC;

    if ( *(short *)&dev->rc1 )
        printrc(dev);
        
    /* timout on reading media defect list */
    if ( timeout == 0 ) {
    /* check any error */
        if (!flag) {
    /* do this if not doing a monitor read id command */
            if ( ckddc (dev, ddcstatus) == 0 )
            return(0);
        } else {  /* come here if doing a monitor read id command */
            if (!(ddcstatus & ~DONEDDC))  { /* any errors? */
		prsecid (dev,dev->scnt,flag,dmalength);
                return (0);               /* return if not */
            }
	    /* if we get here we're doing a monitor read id command
	       and there was at least 1 error         */

            if (ddcstatus & 0xd)  {     /* any errors besides ALT? */
                ckddc (dev, ddcstatus); /* yes, display 'em */
                bptr = (unsigned char *) (dev->mem+3);
            /*  check for skipped track  */
                if ((!*(bptr+4)) && (*bptr & 0x80)) {
                    prchs(dev);
                    printf (" skip track\n");
                    goto REDDC;
                }
            }
            altsect = prsecid(dev,dev->scnt,flag,dmalength);
        }
    }
    /* reset, enable disk data channel */
REDDC: *DDC_CR  = 0;
    *DDC_CR  = ENDKDATAC;
    
    if ( timeout ) {
        dev->rc1 = DER_TIMEOUT;
	printf ("timeout  ");
        return (timeout);
    }
    else if (!(flag && (ddcstatus & 2))) /* if not alt or if not monitor command e then return */
        return (RWERR);
    ltbr = dev->q_devun.pdisk.sector + dev->scnt -1;
	
    if (ltbr > altsect) {
        dev->q_devun.pdisk.sector = altsect + 1;
        dev->scnt = ltbr - altsect;
        return (5);
    }
    return (0);
}

prsecid (dev,cnt,flag,dmalength)
register unsigned char cnt;
register struct devdq *dev;
register unsigned short flag;
register int dmalength;
{
    register int *ptr, i; register temp;
    int *ptralt;
    unsigned char sctr;

    sctr = dev->q_devun.pdisk.sector;
    ptr = (int *)dev->mem;
    for (i=0; i<cnt; i++) {
        temp = *ptr++;
        if (flag == NOTLOOP)
            printf ("\nS(%2x) %8x %8x", sctr++, temp, *ptr);
	ptr++;
        if (temp & 0x40) {
            if (flag != NOTLOOP) 
                printf ("\rC=%3x H=%2x S=%2x ",dev->q_devun.pdisk.cyl,dev->q_devun.pdisk.head,*(unsigned char *)((unsigned char *)ptr-1));
	    ptralt = (int *)(dev->mem+dmalength);
            printf (" ALT, C=%3x H=%2x S=%2x\n",*(unsigned short *)ptralt,
	    *(unsigned char *)((unsigned char *)ptralt+2), *(unsigned char *)((unsigned char *)ptralt+3));
	return (*(ptr-1) & 0xff);
        }
    }
    return (-1);
}

/* return 0: no error in ddcstatus 
   retrun -1 for other error
 */
ckddc (dev, ddcstatus)
register struct devdq *dev;
register unsigned char ddcstatus;
{
	register struct errb *ptr;
	register unsigned short i;

	/* insure other bits not set (check for error) */
	if ( (ddcstatus & ~DONEDDC) == 0 )
		return (0);

	/* check error */
	if ( PRINT1 ) {
		printf (" ds=%x(b=%x)",ddcstatus, dev->badsecn);
		prchs (dev);
	}

	ptr = errtbl;
	for (i=0; i<5; i++) {
		if ( ddcstatus & ptr->err ) {
			dev->rc1 = ptr->errno;
			if ( PRINT1 )
				printf ("%s ", ptr->msgptr);
			break;
		}
		ptr++;
	}

	return (-1);
}

setupdma(dev)
register struct devdq *dev;
{
	register unsigned char *bufptr; register direction;
	register char combo;

	bufptr = (unsigned char *)dtbbuf;

	if ( (dev->flag & DEST_L) == 0 ) {
		if ( dev->opr == OPR_READ )
			direction = WR_DTB;   /* 0xc0 */
		else
			direction = RD_DTB;   /* 0xd0 */
		if (bd_in_system == S90) {
			if (!(dev->flag & ALT))
				FIXDEVMEM(dev);
			combo = (char)bddesc.bd_dtbid | dma_used;
			/* setup chain dma for disk <-> main memory */

			/* setup new dtbbuf info 880219 */
			if(direction & 0x10)
				*bufptr = combo;
			else
				*bufptr = combo | 0x80;
			*(bufptr+1) = (unsigned char)(mem_slot << 4 ); 
			*DTB_IDR = (char)( combo << 4 | dma_used); 
			*(int *)(bufptr+4) = (int)dev->mem;
		}
		else { 		/* default for A1000 system */
			*bufptr = direction | bddesc.bd_dtbid;
			*(bufptr+1) = 0;
			*(int *)(bufptr+4) = (int)dev->mem >> 2;
		}

		*(short *)(bufptr+2) = dev->scnt * (BLKSIZE >> 2);

		/* program CHAIN DMA start & end address with 
			8 bytes buffer containing DTB parameters */
		dmaddr ( bufptr, DTBP_LEN, CHNDMA);
		dmaddr ( altbuf, DDABFSIZ, DDADMA);
		/* ?????also setup DDC ALT for spared sectors */

		/* enable CHAIN DMA, DDA dma program data path */
		mslmdkdtb (direction, DISK);
	}
	else {
		/* setup DDC dma & DDA ALT dma for disk r/w into local memory */
		dmaddr ( dev->mem, dev->scnt * BLKSIZE, DDCDMA);
		dmaddr ( altbuf, DDABFSIZ, DDADMA);

		/* enable DDC & DDC ALT dma, program data path */
		msdklocm ();
	}
}

canceldmc()
{	register unsigned char *bptr;
	register unsigned char status;

	if ( PRINT1 )
		printf ("r3");

	bptr = (unsigned char *)dtbbuf;

	*bptr = DMC_ABT;
	*(bptr+1) = 0;
	*((short *)(bptr+2)) = 0;

	dmaddr ( bptr, 4, DTBDMA );

	dbc_cr = (dbc_cr & CR_MASK) | (LOCMDTBX | WRDTB);
	*DBC_CR = dbc_cr;

	*DTB_CR = 0;
	*DTB_CR = FS_SINT;

	dbc_cr = dbc_cr | DTB_EN;
	*DBC_CR = dbc_cr;

	/* *********************************************** */
	/* wait for DTBDMA to happen, no interrupt turn on */
	/* *********************************************** */
	while ( ((status= *DTB_SR) & DTB_EN) == 0 );

	dbc_cr &= ~DTB_EN;
	*DBC_CR = dbc_cr;
	clean_dbc();

	if ( PRINT1 )
		printf ("r4");
}
	
clean_dbc()
{
	register i;
	register unsigned char status;
	char buf[10];

	/* setup DTB dma to get one long word from main memory */
	dmaddr ( buf, 4, DTBDMA);

	/* DBC control register : local <-> DTB, read from DTB */
	dbc_cr = (dbc_cr & CR_MASK) | LOCMDTBX | RDDTB;
	*DBC_CR = dbc_cr;

	dbc_cr |= DTB_EN;		/* enable DTB dma */
	*DBC_CR = dbc_cr;

	/* enable interrupt and return */
	for (i=0; i<10; i++) {
		if ( ((status= *DBC_SR) & DTB_EN) ) {
			if ( PRINT1 )
				printf ("r6");
			break;
		}
	}

	/* disable dtb dma */
	dbc_cr &= ~DTB_EN;
	*DBC_CR = dbc_cr;
}
