#include "edtdisksect.h"
#include "edt.h"
#include "edtdevdq.h"
#include "edtdevstr.h"
#include "edtdtc.h"
#include "edterror.h"
#include "edtextrn.h"

char *tmoutstr[] = {"d2","d3","d4"};
char *timval[3];

diskopen(dev, dkptr)
struct devdq *dev; register struct dkinf *dkptr;
{
	char buf[0x404]; register ret;
	register unsigned char i;
	register struct sector0 *sec0;
	register struct ld *ldkptr;
	register struct logtype *p;

	sec0 = (struct sector0 *) ((int)(buf+2) & 0xfffffffc);

	timval[0] = (char *)egdata;
	timval[1] = (char *)iddata;
	timval[2] = (char *)esmd;

	/* check if physical drive already opened */

	/* check if drive has been opened */
	if ( dkptr->pd_ststat & DK_INIT )
		return (0);


	ldkptr = &log[(short)(dev->devnum * LOGDR)];

	/* always wait if read system sector */
	dev->flag &= ~TNOWAIT;
	dev->opr = OPR_READ;

	if ( PRINT1 )
		printf ("rD=%x", dev->devnum);

	for (i=0; i<3; i++) {
		setimid(timval[i]); /* try timing values for different disks
								until we get the right ones for the
								disk in use  
							*/
		ret = rsydata (dev, dkptr, SEC0, sec0 );
		if (ret != TIMEOUT) break;
		printf(tmoutstr[i]);
	}
		
	if ( ret )  {
		printf ("d5(%x)\n", dev->rc1);
		return(-1);
	
	}
	/* at least able to read a sector */
	dkptr->pd_ststat |= (DK_ONLINE+DK_READY);

	/* check ID name */
	if ( *((int *)&sec0->id[0]) != ((int)'INIT') ) {
		dev->rc1 = DER_UNFORM;
		return(-1);
	}

	dkptr->formattype = sec0->id[7];

	*(int *)&dkptr->cyldisk = *(int *)&sec0->cyldisk;
	*(int *)&dkptr->seccyl = *(int *)&sec0->seccyl;

	bcopy ( sec0->gap, dkptr->gap, sizeof  iddata);

	/* reprg timing register */
	setimid ( &dkptr->gap[0] );

	dkptr->pd_ldmaxnum = sec0->pd_ldmaxnum;
	dkptr->pd_ldnum = sec0->pd_ldnum;

	/* reserved size */
	dkptr->rv_strt = sec0->rv_strt;
	dkptr->rv_size = sec0->rv_size;
	dkptr->numskiptrack = 0;
	dkptr->skplist = 0;


	if ( dkptr->pd_ldnum > LOGDR ) {
		diskclose (dev, dkptr);
		dev->rc1 = DER_UNFORM;
		return (-1);
	}
	else if ( dkptr->pd_ldnum == 0 ) {
		printf ("d5");
		dkptr->pd_ststat |= DK_INIT;
		return(0);
	}
	
	/* setup log drive table */
	dkptr->pd_ptr = ldkptr;
	p = &sec0->logdrive[0];

	for (i=0; i< dkptr->pd_ldnum; i++) {
		ldkptr->ld_strt = p->ld_strt;
		ldkptr->ld_size = p->ld_size;
		ldkptr->ld_type = p->ld_type;
		ldkptr->ld_mirror = p->ld_mirror; 
		ldkptr->mirtype = p->mirtype;
		ldkptr->ld_bdsnum = 0;

		ldkptr++;
		p++;
	}

	/* read skip track list */
	if ( fillskiptrk ( dev, dkptr, sec0 ) ) {
		diskclose ( dev, dkptr);
		printf ("d1");
		return (-1);
	}

	dkptr->pd_ststat |= DK_INIT;
	return(0);
}

fillskiptrk (dev, dkptr, sk_ptr)
struct devdq *dev;
register struct dkinf *dkptr;
register struct sktrk_list *sk_ptr;
{
	register struct   badtrck  *sk;
	register struct ld *ldkptr;
	register unsigned char i; register ushort numsklist;
	register struct sktrkinf *p;

	ldkptr = dkptr->pd_ptr;

	if(rsydata(dev,dkptr,SKTRKSEC, sk_ptr))
		return(-1);

	if ( sk_ptr->idfield != SKIPSECID ) {
		dev->rc1 = DER_SYBAD;
		return(-1);
	}
	sk = (struct  badtrck  *)sk_ptr;
	numsklist = 0;

	/* each physical drive have own list */
	/* 16 log drives max can have TOTSKLEN skip tracks */
	p = &hsdtsktrk[dev->devnum];

	/* set up skip track pointer for current physical drive */

	/* total skip track list for physical drive */
	p->pd_totsklen = 0;

	/* pointer to the list */
	p->pd_nxtskptr = &p->pd_totsklist[0];

	for (i=0; i<(dkptr->pd_ldmaxnum + 1); i++) {
		if (i == dkptr->pd_ldmaxnum) {
			dkptr->numskiptrack = 0;	/* log drive */
			dkptr->skplist = p->pd_nxtskptr;
		}
		else {
			ldkptr->numskiptrack = 0;	/* log drive */
			ldkptr->skplist = p->pd_nxtskptr;
		}

		while ( sk->cyl || sk->head ) {
			if ( p->pd_totsklen == TOTSKLEN ) {
				dev->rc1 = DER_SKFULL;
				return (-1);
			}
			p->pd_nxtskptr->cyl = sk->cyl;
			p->pd_nxtskptr->head = sk->head;

			p->pd_nxtskptr++;	/* inc pointer */
			p->pd_totsklen++;	/* inc count */

			if (i == dkptr->pd_ldmaxnum)
				dkptr->numskiptrack++;
			else
				ldkptr->numskiptrack++;

			/* check if ran out of data in current sector */
			sk++; numsklist++;
			if ( numsklist == SKTRKSIZ ) {
				if(rsydata(dev,dkptr,sk_ptr->nextsec, sk_ptr))
					return(-1);

				if ( sk_ptr->idfield != SKIPSECID ) {
					dev->rc1 = DER_SYBAD;
					return(-1);
				}
				sk = (struct badtrck *)sk_ptr;

			}
		}

		sk++; numsklist++;
		if ( numsklist == SKTRKSIZ ) {
			if(rsydata(dev,dkptr,sk_ptr->nextsec, sk_ptr))
				return(-1);

			if ( sk_ptr->idfield != SKIPSECID ) {
				dev->rc1 = DER_SYBAD;
				return(-1);
			}
			sk = (struct badtrck *)sk_ptr;
		}

		if (i == dkptr->pd_ldmaxnum) {
			if ( dkptr->numskiptrack == 0 ) 
				dkptr->skplist = 0;
		}
		else {
			if ( ldkptr->numskiptrack == 0 )
				ldkptr->skplist = 0;
		}
		
		ldkptr++;
	}
	return(0);
}

