#include "edtdisksect.h"
#include "edt.h"
#include "edtdevdq.h"
#include "edtdevstr.h"
#include "edtdtc.h"
#include "edterror.h"
#include "edtextrn.h"
#include "edtvern.h"

char s0data[] =
{	'I','N','I','T',0,0,0,0,
	VERNUM,RELEASE,
	'8','5','0','7','3','1',
	0,0,0,0,0,0,0,0,
	CYL84_DRV/0x100, CYL84_DRV, HEAD84_CYL, SEC84_HEAD,
	SEC84_CYL/0x100, SEC84_CYL,
	BLKSIZE/0x100, BLKSIZE,		/* 04, 00, */
};



/* input: secnum is logical sector num 
   output:	0 (no error)
		1 (seek error)
		2 (r/w error)
 */


rwsydata(dev, dkptr, secnum, buf)
register struct devdq *dev; 
struct dkinf *dkptr;
int secnum; char *buf;
{
	register ret;

	if ( secnum >= SEC84_HEAD ) {
		dev->q_devun.block = secnum;
		if ( convl2p (dev, dkptr) )
			return(-1);
	}
	else {
		dev->q_devun.pdisk.cyl = 0;
		dev->q_devun.pdisk.head = 0;
		dev->q_devun.pdisk.sector = secnum;	
	}
	dev->scnt = 1;
	dev->mem = (char *)buf;

	/* always wait for disk to complete */
	dev->flag |= DEST_L;
	

	/* diskio output: 0(no error) 1(seek error) 2(r/w error) */
	if ( (ret = diskio(dev, dkptr)) ) {
		if ( PRINT1 )
			printf ("CAN'T R/W(d=%x s=%x) ", dev->devnum, secnum);
	}

	return (ret);
}

/*
	sector 0,1  
	sector 2,3	spare
	sector 4,5	skip track
	sector 6,7	media defect list
	sector 8,9	boot information
	sector 10,11	disk test result
 */
setsysect (dev, dkptr, dsbuf)
register struct devdq *dev;
struct dkinf *dkptr;
register struct sizedk *dsbuf;
{
	char buf[0x404]; register struct sector0 *bptr;
	register *ptr;
	register i;

	bptr = (struct sector0 *)( (int)(buf+2) & 0xfffffffc);


	/* fill buffer with zero */
	setbuf (bptr, BLKSIZE/2, 0 );

	/* move id, date code */
	bcopy ( s0data, bptr, sizeof s0data );

	if ( dsbuf->cylnum == CYLEAG_DRV )
		ptr = (int *)egdata; 
	else
		ptr = (int *)iddata;

	bcopy ( ptr, bptr->gap, sizeof iddata );

	/* fill the size of disk information */
	if (dsbuf->cylnum != 0) { 

		bptr->trkbytesec = dsbuf->trkbytesec;

		bptr->cyldisk = dsbuf->cylnum;
		bptr->headcyl = dsbuf->headnum;
		bptr->sechead = dsbuf->sectnum;
		bptr->seccyl = dsbuf->seccyl;
		bptr->bytesec = BLKSIZE;
	}


	bptr->pd_ldmaxnum = LOGDR;	/* max num of log drive */
	bptr->pd_ldnum = 0;		/* current num log drive */ 
	bptr->nextsec = NEXTSEC;	/* next available sector */

	bptr->rv_strt = 0;
	bptr->rv_size = 0x7e0;

	
	/* write to sector 0,1 */
	if ( wsydata(dev, dkptr, SEC0, bptr) ) {
		dev->rc2 = DER_SYBAD;
		return (-1);
	}

	/* fill buffer with zero */
	setbuf (bptr, BLKSIZE/2, 0 );

	/* the following sectors  contains all zero data */
	/* setup sector 2,3,(spare) */
	/* setup sector 4,5 (skip track) */
	/* setup sector 6,7(media defect list) */
	/* setup sector 8,9 for BOOT information */
	/* setup sector 0x10,0x11 (bad sectors from disk test) */

	for (i=SPARESEC; i<BADSCSEC+2; i += 2 ) {
		if ( wsydata(dev, dkptr, i, bptr) ) {
			dev->rc2 = DER_SYBAD;
			return (-1);
		}
	}

	return (0);
}

/* write to sector and sector+1 */

wsydata(dev, dkptr, sectnum, buf)
struct devdq *dev; struct dkinf *dkptr;
int sectnum; char *buf;
{
	register ushort i;
	dev->opr = OPR_WRITE;
	for (i=0; i<2; i++) {
		if ( rwsydata(dev, dkptr, sectnum, buf) )
			return;
		sectnum++;
	}
	return(0);
}

/* read sector, if there is error, will read sector+1 */ 

rsydata(dev, dkptr, sectnum, buf)
struct devdq *dev; struct dkinf *dkptr;
int sectnum; char *buf;
{
	register ret;
	dev->opr = OPR_READ;
	if ( ret = rwsydata(dev, dkptr, sectnum, buf) ) {
		if ( ret = rwsydata(dev, dkptr, sectnum+1, buf) )
			return(ret);
	}
	return(0);
}

