
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevdq.h"
#include "edtdtc.h"
#include "edtextrn.h"


#define STARTCYL	0x1
#define DEFPAT		0xf0
#define CYLMASK		0x3ff		/* 10 bits for cyl num */


/* return 0:	if disk is already formatted  & there is no
		media defect list 
   return 1:	if disk is not formatted, and timing register is changed
*/
ckformat(dev, dkptr)
register struct devdq *dev; struct dkinf *dkptr;
{	register i;

	/* try 3 different cylinder */

	/* load timming register for reading media defect */
	setimid (dfiddata);

	/* try cylinder 4,16,64,256 */
	for (i=4; i<500; i=i*4) {
		setbuf (dev->mem, DEFM_LEN/2, 0 );
		dev->q_devun.pdisk.cyl = i;
		dev->q_devun.pdisk.head = 1;
		if ( rwid(dev, dkptr, INDEX, DEFM_LEN, 0) == 0 ) {
			/* able to read off id, but check data */
			if ( ckmdata (dev) == 0 )
				return (1);	/* disk is not formatted */
		}
	}	
	setimid(egdata);
	diskclose (dev, dkptr);
	printf ("f1");
	return (0);		/* return 0 if disk is formatted */
}


/* check media defect list (24 bytes)
 return 0 if cyl, head match and byte 20 =0xf0
 */

ckmdata (dev)
register struct devdq *dev;
{
	register char *ptr;

	ptr = dev->mem;

	/* 1st line below is a check for a defective track */
	if (( *ptr & 0x80)
	|| (    ( (*(short *)ptr & CYLMASK) == dev->q_devun.pdisk.cyl )&&
		( *(char *)(ptr+2) == dev->q_devun.pdisk.head )  &&
		( *(char *)(ptr+3) == 0 ) &&
		( *(char *)(ptr+20) == DEFPAT ) ))  {

		if ( *(long *)(ptr+16) ) {
			if ( *(long *)(ptr+12)  && *(long *)(ptr+8) &&
			*(long *)(ptr+4) )
				return (0);
			else
				goto nolist;
		}
		if ( *(long *)(ptr+12) ) {
			if ( *(long *)(ptr+8) && *(long *)(ptr+4) )
				return (0);
			else
				goto nolist;
		}
		if ( *(long *) (ptr+8) ) {
			if ( *(long *)(ptr+4) )
				return (0);
			else
				goto nolist;
		}
		return (0);
	
	}
nolist:
	printf ("\nf2");
	return (1);
}

recordmed(dev, sptr, countptr)
register int *sptr; register struct devdq *dev; register int *countptr;
{	register int *ptr; register record;
	register ushort i;

	ptr = (int *)dev->mem;
	record = 0;
	ptr++;
	for (i=0; i<4; i++) {
		if ( *ptr++ != 0 ) 
			record++;
	}
	if ( record ) {
		ptr = (int *)dev->mem;
		for (i=0; i<(DEFM_LEN-4)/4; i++) 
			*sptr++ = *ptr++; 	/* record 5 long words */
		(*countptr)+=record;
	}
	return ((int)sptr);
}


incchs(dev, loopptr)
register struct devdq *dev;
int *loopptr;
{
	if ( ++dev->q_devun.pdisk.head >= headsize ) {
		dev->q_devun.pdisk.head = 0;
		dev->q_devun.pdisk.cyl++;

		/* blink lit between green & off */
		if ( dev->q_devun.pdisk.cyl >= cylsize ) {
			dev->q_devun.pdisk.cyl = STARTCYL;
			(*loopptr)++;
		}
	}
	blinkled();
}

