#	@(#)makefile	1.1

SGS = 0
SGSROOT= /src1/a1000/sgs/a1000_1294

CC = $(SGSROOT)/bin/$(SGS)cc
CPP = $(SGSROOT)/lib/$(SGS)cpp
CCOM = $(SGSROOT)/lib/$(SGS)ccom
C2 = $(SGSROOT)/lib/$(SGS)c2
AS = $(SGSROOT)/bin/$(SGS)as
LD = $(SGSROOT)/bin/$(SGS)ld

MPROMVERS=2.0

PROM	= edtprom$(MPROMVERS)
SINC	=	.
#LIB	= -L../../lib -lsc no, it redefines getchar
LIB	=

# special rule for prom code, force .data become .text
NODATA = -Wa,-r 

# force no stack probe
NOSPRB = -W0,-sp

CFLAG = $(NOSPRB) $(NODATA) $(CFLAGS)

.SUFFIXES: .s .o .t .b .p .x

COBJS	=	ckreq.o		cmd.o		console.o \
		disk.o		diskalt.o	diskdfm.o	diskf.o \
		dkio0.o		dkio1.o 	dkio2.o \
		dkparse1.b	dkparse2.o	dkparse3.o \
		dksub1.o	dksub2.o	dksub4.o 	dksub5.o \
		download.o \
		dtbxfer.o	icbparse.o	initdata.o \
		message.o	mmlbuf.o	mmlbuf1.o \
		pgchar.o	printf.o	xfermem.o

# ***********
# PROM files
# ***********
POBJ1	=	vectab.o	mprom.o		math.o		misc.o \
		lmul.o


# ***************************
# 9 track proms files
# ***************************
PTRK9	=	main.b		initbd.b \
		montape.b	taparse.b	tapexio.b	tape9.o \
		inturpt.b 	finrw.b

# ***************************
# Archive prom files
# ***************************
PARCH =	ftaperw.b	tape.b 	tapeio.b 	tapesub.b  tapeinit.b 

TRK9	=	tape9io.o

all: $(PROM)

clean:
	rm -f *.o

clobber: clean
	rm -f $(PROM) *.b *.map *.t *.b tags
	rm -f edtdisksect.h 

edtdisksect.h: edtdsksect.h
	cp edtdsksect.h edtdisksect.h

.c.o:
	$(CC) -c $(CFLAG) $<

.x.s:
	$(CPP) $< -P -I. > $*.s

.s.o:
	$(AS) $(ASFLAGS) -o $@ $*.s

.x.o:
	$(CPP) $< -P -I. > $*.s
	$(AS) $(ASFLAGS) -o $@ $*.s
	rm -f $*.s

#------------------------------
# rule for bssdata.c (bss data)
#------------------------------
.c.t:
	$(CC) -O $(NOSPRB) -c $*.c
	mv $*.o $*.t


#-------------------------------
# comple for 9 track prom code
#-------------------------------
.c.b:
	$(CC) -DTRACK9 -DARCH -DPROM -I$(SINC) -c $(CFLAG) $*.c
	mv $*.o $*.b


$(PROM):	$(POBJ1)  $(COBJS) $(PTRK9) $(PARCH)  $(TRK9)  bssdata.t
	$(LD) -o $(PROM) -m ld.prom \
	$(POBJ1)  $(COBJS) $(PTRK9) $(PARCH) $(TRK9) $(LIB)\
		 bssdata.t > $(PROM).map
	$(SGSROOT)/bin/sapatch -h $(PROM)
	nm -xv $(PROM) >>$(PROM).map
	size -x $(PROM)
	grep bddesc $(PROM).map


bssdata.t: \
		edt.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edttape.h \
		edttape9.h \
		$(SINC)/vreg.h 

ckreq.o: \
		edt.h \
		edtccpu.h \
		edtdata.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdtc.h \
		edtdisksect.h \
		edterror.h \
		edtextrn.h \
		$(SINC)/vreg.h 

console.o:	edtccpu.h \
		edtextrn.h

disk.o: \
		edt.h \
		edtccpu.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edtextrn.h

diskalt.o: \
		edt.h \
		edtccpu.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edtextrn.h

diskdfm.o: \
		edt.h \
		edtccpu.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edtextrn.h


diskf.o: \
		edt.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edtextrn.h

dkio0.o: \
		edt.h \
		edtccpu.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h \
		edttape.h

dkio1.o: \
		edt.h \
		edtccpu.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h \
		edtptm.h \
		edtstruct.h

dkio2.o: \
		edt.h \
		edtccpu.h \
		edtdata.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h \
		edtptm.h \
		edtstruct.h \
		$(SINC)/vreg.h 

dkparse1.o: \
		devcmd.h \
		edt.h \
		edtccpu.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h

dkparse2.o: \
		devcmd.h \
		edt.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edterror.h \
		edtextrn.h

dkparse3.o: \
		edt.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h

dkparse4.o: \
		edt.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edtextrn.h

dkparse5.o: \
		devcmd.h \
		edt.h \
		edtdevdq.h \
		edtdevstr.h  \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h

dksub1.o: \
		edt.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edterror.h \
		edtextrn.h

dksub2.o: \
		edt.h \
		edtvern.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h

dksub4.o: \
		edt.h \
		edtdisksect.h \
		edtdevdq.h \
		edtdtc.h \
		edtextrn.h

dksub5.o: \
		edt.h \
		edtdisksect.h \
		edtccpu.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edtextrn.h

dndownload.o:	$(SINC)/icbcmd.h

dninitbd.o \
dninitbd.f: \
		edtccpu.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdtc.h \
		edtextrn.h \
		edttape.h \
		$(SINC)/icbcmd.h \
		$(SINC)/vreg.h 

dnmain.o: \
		edt.h \
		edtccpu.h \
		edtdata.h \
		edtdisksect.h \
		edtdtc.h \
		edtextrn.h \
		$(SINC)/vreg.h

download.o: \
		edtccpu.h \
		edtdtc.h \
		edtextrn.h \
		$(SINC)/icbcmd.h \
		$(SINC)/vreg.h

dtbxfer.o: \
		edt.h \
		edtccpu.h \
		edtdata.h \
		edtdevdq.h \
		edtdisksect.h \
		edtdtc.h \
		edtextrn.h \
		$(SINC)/vreg.h

finrw.f \
finrw.b: \
		devcmd.h \
		edt.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h \
		edttape.h

ftaperw.b: \
		edt.h \
		edtccpu.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h \
		edttape.h

icbparse.o: \
		edt.h \
		edtccpu.h \
		edtdata.h \
		edtdevdq.h \
		edtdevstr.h  \
		edtdisksect.h \
		edtdtc.h \
		edtextrn.h \
		$(SINC)/icbcmd.h \
		$(SINC)/vreg.h

initbd.b: \
		edt.h \
		edtvern.h \
		edtccpu.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edtextrn.h \
		edttape.h \
		$(SINC)/icbcmd.h \
		$(SINC)/vreg.h

initdata.o:	edt.h 

inturpt.f \
inturpt.b: \
		devcmd.h \
		edt.h \
		edtccpu.h \
		edtdata.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h \
		edtstruct.h \
		edttape.h \
		edttape9.h

main.b: \
		edtvern.h \
		edtccpu.h \
		edtdata.h \
		edtdtc.h \
		edtextrn.h \
		$(SINC)/vreg.h

mmlbuf.o: \
		edt.h \
		edtdisksect.h \
		edtdtc.h \
		edtextrn.h

mmlbuf1.o: \
		edt.h \
		edtdisksect.h \
		edtdtc.h \
		edtextrn.h

montape.b \
montape.f: \
		edtdevstr.h \
		edtextrn.h

taparse.b \
taparse.f: \
		devcmd.h \
		edt.h \
		edtccpu.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h \
		edttape.h \
		edttape9.h

tape.b: \
		edt.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtextrn.h \
		edttape.h

tape9.o: \
		devcmd.h \
		edt.h \
		edtdevdq.h  \
		edtdevstr.h \
		edtdisksect.h \
		edtextrn.h \
		edttape9.h

tape9io.o: \
		devcmd.h \
		edt.h \
		edtccpu.h \
		edtdata.h \
		edtdevdq.h \
		edtdevstr.h  \
		edtdisksect.h \
		edtdtc.h \
		edterror.h  \
		edtextrn.h \
		edtptm.h \
		edttape9.h

tapeinit.b: \
		edt.h \
		edtccpu.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edtextrn.h

tapeio.b: \
		edt.h \
		edtccpu.h \
		edtdata.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h \
		edtptm.h \
		edttape.h

tapesub.b: \
		edt.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edterror.h \
		edtextrn.h \
		edttape.h

tapexio.b \
tapexio.f: \
		devcmd.h \
		edt.h \
		edtdevdq.h \
		edtdevstr.h  \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h \
		edttape.h \
		edttape9.h

timer.o: \
		devcmd.h \
		edt.h \
		edtccpu.h \
		edtdata.h \
		edtdevdq.h \
		edtdevstr.h \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h \
		edtptm.h \
		edttape.h

xfermem.o: \
		devcmd.h \
		edt.h \
		edtccpu.h \
		edtdevdq.h  \
		edtdisksect.h \
		edtdtc.h \
		edterror.h \
		edtextrn.h \
		$(SINC)/vreg.h

#871119downcode.s:	edtcpu.h

mprom.s:	edtcpu.h

vectab.s:	edtcpu.h

dnvectab.s:	edtcpu.h

prom.o: \
		edtcpu.h \
		vectab.a68

