#define ram_start	0x400000
#define ram_size	0x10000		/* 64 k memory */
#define RAMSTACK	0xE000		/* stack pointer */
#define STACKLEN	0x600

#define ICB_SRH	(char   *)0x800000	/* ICB status register high byte(R) */
#define ICB_SR	(short  *)0x800000	/* ICB status register (R) */
#define ICB_IR	(short  *)0x800002	/* ICB inturrpt register (RW)*/

#define DTB_CR	(short  *)0x800004	/* DTB control register (W) */
#define DTB_SR	(char   *)0x800004	/* DTB status register (R) */
#define DTB_IDR	(char   *)0x800006	/* DTB ID register (W) */

#define DBC_CR	(char   *)0x600000	/* DBC control register (W) */
#define DBC_SR	(char   *)0x600000	/* DBC status register (R) */

#define DDC_DMAS (short *)0x600040	/* DDC dma start addr reg(R/W) */
#define DDA_DMAS (short *)0x600042	/* DDC ALT dma start addr reg(R/W) */
#define CHN_DMAS (short *)0x600044	/* CHAIN dma start addr reg (R/W) */
#define DTB_DMAS (short *)0x600046	/* DTB dma start addr register (R/W) */
#define TP_DMAS	(unsigned short *)0x600048/* TAPE dma start addr (R/W) */
#define TP2_DMAS (unsigned short *)0x60004a /* TAPE dma start */

#define DDC_DMAE (short *)0x600060	/* DDC dma end addr register (R/W) */
#define DDA_DMAE (short *)0x600062	/* DDC ALT dma end addr reg(R/W) */
#define CHN_DMAE (short *)0x600064	/* CHAIN dma end addr reg (R/W) */
#define DTB_DMAE (short *)0x600066	/* DTB dma end addr register (R/W) */
#define TP_DMAE  (unsigned short *)0x600068 /* TAPE dma end addr (R/W) */
#define TP2_DMAE  (unsigned short *)0x60006a /* TAPE dma end addr (R/W) */
#define BNK_SEL (unsigned short *)0x6000e0 /* select which 64k to use for dma (W) */

#define DMAOFF	0x20			/* different between start & end */

#define DDC_CR	(char   *)0x8000b0	/* DDC control register (W) */
#define DDC_SR	(char   *)0x8000b0	/* DDC status register (R) */

#define DDC_TR	(char   *)0x800081	/* DDC timing register (R/W) */
#define DDC_TR2 (char   *)0x800085	/* DDC timing register 2 (R/W) */
#define DDC_TR9 (char	*)0x800093	/* DDC timing register 9 (R/W) */
#define DDC_TRA (char	*)0x800095	/* DDC timing register A (R/W) */
#define DDC_TRE	(char   *)0x80009d	/* DDC timing registerE (R/W) */

#define DDC_IDR	(char  *)0x8000a1	/* DDC ID register (R/W) */
#define DDC_ID0	(char  *)0x8000a1	/* DDC ID register 0 (R/W) */
#define DDC_ID5	(char  *)0x8000ab	/* DDC ID register 5 (R/W) */


#define DDC_SCR	(short *)0x800032	/* DISK sector register (R/W) */
#define TP_CR	(short *)0x800038	/* TAPE control register (W) */
#define TP_SR	(short *)0x800038	/* TAPE status register (R) */
#define TP_RSDMA (char *)0x80003a	/* RESET TAPE DMA interrupt (W) */
#define DTC_CRH	(char  *)0x800000	/* DTC control register high byte */
#define DTC_CRL	(char  *)0x800001	/* DTC control register  */
#define SWITCHES (char  *)0x800031	/* dip switches (R) */

/* 6850 serial chip */
#define ACIA_CNTRL (char  *)0x8000c1	/* 6850 control register */
#define ACIA_STAT (char  *)0x8000c1	/* 6850 status register */
#define ACIA_DATA (char  *)0x8000c3	/* 6850 data register */


/* 6840 timer chip  */
#define TM_C13	(char  *)0x8000e1	/* control reg 1 & 3 */
#define TM_C2	(char  *)0x8000e3	/* control reg 2 */
#define TM_S2	(char  *)0x8000e3	/* status register 2 */
#define TM_MSB1	(char  *)0x8000e5	/* count reg 1 (msb) */
#define TM_LSB1	(char  *)0x8000e7	/* count reg 1 (lsb) */
#define TM_MSB2	(char  *)0x8000e9	/* count reg 2 (msb) */
#define TM_LSB2	(char  *)0x8000eb	/* count reg 2 (lsb) */
#define TM_MSB3	(char  *)0x8000ed	/* count reg 3 (msb) */
#define TM_LSB3	(char  *)0x8000ef	/* count reg 3 (lsb) */

/* DISK Bus Register WRITE */
/*                             x		 for drive num */
/*                             |                   */
#define DK_BUSW (short *)0xc00000	/* DISK BUS REGISTER WRITE */
#define DK_WCY	(short *)0xc00000	/* DISK Bus write cylinder */
#define DK_WHD	(short *)0xc00002	/* DISK Bus write head */
#define DK_WCTL	(short *)0xc00004	/* DISK Bus write control */
#define DK_WSI	(short *)0xc00006	/* DISK Bus enable seek,end interrupt */

#define DK_STSR (short *)0xc00000	/* DISK STATUS REGISTER READ */
#define DK_RUS	(short *)0xc00000	/* DISK read unit status */
#define DK_RSCS	(short *)0xc00002	/* DISK read sector status */
#define DK_RRWC	(short *)0xc00004	/* DISK read write/read check */
#define DK_RACS	(short *)0xc00006	/* DISK read access status */


/* bit position or bit value/mask in memory map */

#define ICB_IBUSY	(*ICB_SRH & 0x80)	/* main cpu interrupt DTC */
#define ICB_OBUSY	(*ICB_SRH & 0x40)	/* DTC interrupt main cpu */
#define ICB_TAS		(*ICB_SR & 0x0080)	/* TAS bit */

#define ICBI_MASK	0x0fff		/* ICB interrupt register bit 12-0 */

