/* disk/tape request buffer */
struct devdq {
	struct	devdq *forward;
	struct	devdq *backward;
	uchar	device;			/* z80 device - DISK */
	uchar	devnum;			/* drive #: log/physical */
	uchar	cmd;			/* disk/tape command */
	uchar	q_priority;
	union {
		uint	block;			/* block number on unit */
		uint	lbuf;
		struct {
			ushort cyl;
			uchar head;
			uchar sector;
		} pdisk;
		struct {
			uint file:8;
			uint block:24;
		} ptape;
	} q_devun;
	char *	mem;			/* memory address */
	uint	totcnt;			/* total bytes cnt */
	uint	q_key;
	struct mmu	*q_mmu;
	ushort	flag;			/* flag byte */

	uchar	rc1;			/* return code */
	uchar	rc2;
	uchar	q_extdtb;
	uchar	opr;

	uchar	scnt;			/* sector count */
	uchar	retry;			/* retry for disk */
	uint	orgsect;		/* orginial c,h,s */
	uchar	cursdone;		/* current sector done */
	uchar	badsecn;
	uchar	sectleft;		/* sector left done */
	uchar	totsdone;		/* total sector done */
}; 

#define IOSS
#ifdef IOSS
#define	FIXDEVMEM(x) fixdevmem(x)
#else
#define FIXDEVMEM(x)
#endif
