
#include <stdio.h>

extern int errno;

main(argc, argv)
int	argc;
char	*argv[];
{
	char	*p;

	if (argc != 3) {
		fprintf (stderr, "%s:  Improper argument count, expect:\n",
			argv[0]);
		fprintf (stderr, "\t\t%s chroot_dir local_script\n", argv[0]);
		exit(1);
	}

	/* Change root directory to that specified by argv[1] */
	if (chroot(argv[1])) {
		fprintf (stderr, 
		"%s:  Chroot failed, supplied directory <%s>; errno:  %d.\n",
			argv[0], argv[1], errno);
		exit(2);
	}

	/* Change back to original effective user id */
	setuid(getuid());

	/* Get the SHELL from the user's env, if none available use sh */
	if ((p = getenv("SHELL")) == NULL)
		p = "/bin/sh";

	argv[1] = p;
	execvp(argv[1], &argv[1]);

	fprintf (stderr, 
		"%s:  Execvp failed, exec args:  %s  %s; errno:  %d.\n",
		argv[0], argv[1], argv[2], errno);
	exit(3);

}

