#include "edtccpu.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevstr.h"
#include "edtdevdq.h"
#include "edttape.h"
#include "edtdtc.h"
#include "edterror.h"
#include "edtextrn.h"
#include "vreg.h"

extaper(dev)
register struct devdq  *dev;
{
	int totalcnt, mainmem; 
	register oldpri;

	totalcnt = dev->totcnt;
	mainmem = (int)dev->mem;

	/* wait for operation to be completed */
	dev->flag &= ~TNOWAIT;		/* wait */
	dev->mem = (char *)LOCA;	/* use for local memory addr */
	dev->totcnt = FTAPELEN;		/* # of bytes to read */

	/* if tape r/w having problem, dev->totcnt = how many bytes performed
		dev->rc1 = error code, dev->flag |= OPRDONE */
	if ( tprw(dev) ) 
		return; 		/* error in first read, then retrun */


	/* dev->bcnt = how much more to read from tape */
	totalcnt -= FTAPELEN;


	/* read data into buffer 1 */
	/* return value is total bytes send over to main memory */
	dev->totcnt = rnextbuf(dev, totalcnt, mainmem, 1);
	oldpri = spl6();
	ftaperw = 0;
	splx(oldpri);
	dev->flag |= OPRDONE;

	return;
}


/* readcnt: num of bytes read from tape */

rnextbuf(dev, readcnt, mainmem, tbufadr)
register struct devdq  *dev; int tbufadr;
register readcnt, mainmem;
{
	register int count, address, nrdcnt;
	register int tsize0, tsize1, bytesend;
	int oldpri;

	
	bytesend = 0;		/* total byte send over to master cpu */

	/* wait for dtb bus */
	waitdtb();


	/* don't wait for completion */
	/* dev->flag |=  TNOWAIT; */
	dev->flag |=  (TNOWAIT + FASTAPE);

	tsize0 =  FTAPELEN;
	tsize1 =  FTAPELEN;

	while ( readcnt ) {

		if ( tbufadr ) {
			/* local address & cnt for next tape read */
			dev->mem = (char *)LOCB;
			dev->totcnt = tsize1;
			/* local address & cnt for next sending data to m.m */
			address = LOCA;
			count = tsize0;
		}
		else {
			dev->mem =  (char *)LOCA;
			dev->totcnt = tsize0;
			address = LOCB;
			count = tsize1;
		}

		if ( tprw(dev) )
			return(bytesend);	/* error, no more to do */

		/* send last buffer over to main memory, wait for completion */
		xferbuf ( address, count, mainmem, WR_DTB );

		/* inc main memory address */
		if (bd_in_system == S90)
			mainmem += count;
		else		/* default in A1000 */
			mainmem += (count >> 2);

		/* update how much send over */
		bytesend += count;

		/* check if tape completed or having error */
		if ( waitape(dev) ) {
			/* tape got error */
			if ( (dev->rc1 != TP_FMD)&&(dev->rc2 != TP_FMD) )
				return(bytesend);

			/* hit file mark, determine how much actually read */
			dev->totcnt =dev->totcnt-(*TP_DMAE + 1 - *TP_DMAS);

			xferbuf (dev->mem, dev->totcnt, mainmem, WR_DTB);

			/* update how much send over */
			bytesend += dev->totcnt;
			return(bytesend);
		}
		else {
			/* how much left to read from tape */
			readcnt -=  dev->totcnt;

			/* no more to read from tape, send the last buffer */
			if ( readcnt == 0 ) {
				xferbuf (dev->mem,dev->totcnt,mainmem,WR_DTB);

				/* update how much send over */
				bytesend = bytesend + dev->totcnt;
				return(bytesend);
			}
			else if ( readcnt < FTAPELEN )
				nrdcnt = readcnt;
			else
				nrdcnt = FTAPELEN;
		}

		if ( tbufadr == 0 )
			tsize1 = nrdcnt;
		else
			tsize0 = nrdcnt;

		tbufadr = tbufadr ^ 01;
	}
}


extapew(dev)
register struct devdq *dev;
{
	int totalcnt; register mainmem;
	register oldpri;

	/* wait for dtb to be free */
	waitdtb();

	totalcnt = dev->totcnt;
	mainmem = (int)dev->mem;

	/* get data from main memory into buffer 0 */
	xferbuf ( LOCA, FTAPELEN, mainmem, RD_DTB );

	/* remaining byte left in main memory */
	totalcnt -= FTAPELEN;

	/* inc main memory address */
	if (bd_in_system == S90)
		mainmem += FTAPELEN;
	else
		mainmem += (FTAPELEN>>2);

	/* get data from main memory into buffer 1 */
	xferbuf ( LOCB, FTAPELEN, mainmem, RD_DTB );

	/* remaining byte left in main memory */
	totalcnt -= FTAPELEN;

	/* inc main memory address */
	if (bd_in_system == S90)
		mainmem += FTAPELEN;
	else
		mainmem += (FTAPELEN>>2);

	/* write buffer 0 to tape, don't wait for tape completion */
	dev->flag |= (TNOWAIT + FASTAPE);
	dev->mem = (char *)LOCA;
	dev->totcnt = FTAPELEN;

	if ( tprw(dev) == 0 )
		/* next buffer to write to tape is buffer 1 */
		dev->totcnt = wnextbuf ( dev, totalcnt, mainmem, 1 );

	oldpri = spl6();
	ftaperw = 0;
	splx(oldpri);
	dev->flag |= OPRDONE;
	return;
}


/* tbufadr:	buffer to write to tape */

/* byteget:	num of bytes need to get from main memory */
/* writecnt:	num of bytes write to tape */
wnextbuf (dev, byteget, mainmem, tbufadr)
register struct devdq *dev;
register int byteget, mainmem, tbufadr;
{
	register int address, tsize0, tsize1, nrdcnt, writecnt;

	writecnt = 0;			/* total bytes write to tape */

	tsize0 = FTAPELEN;
	tsize1 = FTAPELEN;

	while ( 1 ) {
		if ( waitape(dev) )
			return(writecnt);		/* error, then return */

		/* no error on write, update how much date written to tape */
		writecnt +=  dev->totcnt;

		if ( tbufadr ) {
			/* next buffer to write to tape */
			dev->mem = (char *)LOCB;
			dev->totcnt = tsize1;
			/* next buffer to fill with data from memory */
			address = LOCA;
		}
		else {
			dev->mem = (char *)LOCA;
			dev->totcnt = tsize0;
			address = LOCB;
		}
		if ( tprw(dev) )
			return(writecnt);		/* error, then return */

		/* check any more data to get from main memory */
		if ( byteget == 0 ) {
			if ( waitape (dev) == 0)
				/* no error on write, update write count */
				writecnt += dev->totcnt;
			return(writecnt);
		}

		/* determine how much to get from main memory */
		if ( byteget < FTAPELEN )
			nrdcnt = byteget;
		else
			nrdcnt = FTAPELEN;

		/* get data from main memory */
		xferbuf ( address, nrdcnt, mainmem, RD_DTB );

		/* remaining byte left in main memory */
		byteget -= nrdcnt;

		if ( tbufadr )
			/* next buffer size write to tape */
			tsize0 = nrdcnt;
		else
			tsize1 = nrdcnt;

		/* inc main memory address */
		if (bd_in_system == S90)
			mainmem += nrdcnt;
		else
			mainmem += (nrdcnt>>2);
			
		/* next buffer */
		tbufadr = tbufadr ^ 01;
	}

}

xferbuf(locaddr, bcnt, main_mem, direction)
register locaddr, bcnt, main_mem, direction;
{
	register unsigned char *bufptr;
	unsigned char cmd=0x11;

	bufptr = (unsigned char *)dtbbuf;
	/* setup 8 bytes parameters for DTB */
	*((short *)(bufptr+2)) = bcnt >> 2;	/* long word cnt */
	*((int *)(bufptr+4)) = main_mem;	/* main memory address */

	/* transfer data between local buffer and main memory */
	xferdata (bufptr, locaddr, direction, DTBWAIT,cmd);
}

waitdtb()
{	register oldpri;

	oldpri = spl6();
	if ( curwreq ) {
		ftaperw = WAIT_DK;
		splx (oldpri);
		while ( ftaperw );
		/* eventually when disk io finished, will set ftaperw=0 */
		oldpri = spl6();
	}
	ftaperw = FT_ACT;
	splx(oldpri);
}
