#include "edtdisksect.h"
#include "edt.h"
#include "edtdevdq.h"
#include "devcmd.h"
#include "edtdevstr.h"
#include "edttape9.h"
#include "edtextrn.h"

extern int t9status(), t9control(), t9rw();
int t9setmode(),t9readwrite();
int tp9status();

struct tt {
	short word; int (*func)(); unsigned short opr;
} ttbl9[] = {
	'S ',	tp9status,	T9STATUS,
	'B ',	t9control,	T9REW,
	'E ',	t9control,	T9ERASE,
	'EF',	t9control,	T9ERAFIX,
	'L ',	t9control,	T9LOAD,
	'U ',	t9control,	T9UNLOAD,
	'RF',	t9control,	T9FMF,		/* space filemark forward */
	'WF',	t9control,	T9FMW,		/* write filemark */
	'VF',	t9control,	T9FMR,		/* space filemark reverse */
	'CF',	t9control,	T9RECF,		/* space record forward */
	'CR',	t9control,	T9RECR,		/* space record reverse */
	'R ',	t9readwrite,	T9READ,
	'W ',	t9readwrite,	T9WRITE,
	'SM',	t9setmode,	T9STR_HI,
	'HI',	t9control,	T9DENHI,	/* high density */
	'LO',	t9control,	T9DENLOW,	/* low density */

	0, 0, 0,
};

/*
	monitor command enter from console
 */
tape9 (bufptr)
unsigned char *bufptr;
{
	register struct tt *p;
	register struct devdq *dev;
	register short c2;
	register struct tp *taptr;
	int argu[2];

	c2 = (*(bufptr+1)<<8) | (*(bufptr+2) );

	dev = &req;
	initdevq (dev);
	dev->device = TAPE;

	for ( p = ttbl9; p->word; p++ ) {
		if ( c2 == p->word ) {
			dev->opr = p->opr;
			
			if ( (p->opr == T9READ)||(p->opr == T9WRITE)) {
				if ( (*p->func) (dev, bufptr) )
					return(-1);
			}
			else {
				/* pick up tape drive number */
				if ( getarg(bufptr, argu, 1) < 0 )
					return (-1);
				if ((argu[0]<0)||(argu[0]>3))
					return(-1);
				dev->devnum = argu[0];

				if (p->opr == T9STR_HI) {
					if ( (*p->func) (dev, bufptr) )
						return(-1);
				}
				else {
					taptr= &tapdr[dev->devnum];
					(*p->func)(dev);
				}
			}

			if ( *(short *)&dev->rc1 )
				printrc (dev);
			return (0);
		}
	}

	return (-1);
}

/*
	tape read/write
 */
t9readwrite( dev, bufptr)
register struct devdq *dev;
char *bufptr;
{
	register struct tp *taptr;
	int argu[3];
	if ( getarg(bufptr, argu, 3) < 0)
		return (-1);

	if ((argu[0]<0x1000) || ((argu[0]+argu[2])>0xc000))
		return(-1);
	dev->mem = (char *)argu[0];		/* local address */
	if ((argu[1]<0)||(argu[1]>3))
		return(-1);
	dev->devnum = argu[1];

	/* check byte count */
	dev->totcnt = argu[2];		/* byte count */
	if ( dev->totcnt > T9MAXCNT )
		return (-1);

	/* special for routine ck9taperw() */
	dev->cmd = TPWRITE;
	if ( dev->opr == T9READ )
		dev->cmd  = TPREAD;

	/* wait for tape inturpt */
	taptr= &tapdr[dev->devnum];
	taptr->next = dev;
	t9rw (dev);
	taptr->next = 0;

	return (0);
}

t9setmode(dev,bufptr)
register struct devdq *dev; char *bufptr;
{
	int argu[3];

	/* argu[1] = 0 stream mode */
	/* argu[1] = 1 start & stop mode */

	/* argu[2] = 0 high speed */
	/* argu[2] = 1 low speed */

	if ( getarg(bufptr, argu, 3) < 0)
		return (-1);

	if (((argu[1]!=0) && (argu[1]!=1)) || ((argu[2]!=0) && (argu[2]!=1))) 
		return(-1);
	/* stream mode or start & stop mode */
	dev->opr |= ((argu[1]<< 4) + (argu[2] <<3 )) ;

	t9control(dev);

	/* also send out SELECT cmd */
	/* if ( selectcmd (IFEN, dev->devnum) ) */
	if ( selectcmd (IFEN, dev) )
		return (-1);

	return (0);
}


