#include "edtccpu.h"
#include "edtdisksect.h"
#include "edt.h"
#include "edtdevstr.h"
#include "edtdevdq.h"
#include "edttape.h"
#include "edtdtc.h"
#include "edtdata.h"
#include "edtptm.h"
#include "edterror.h"
#include "edtextrn.h"
#include "vreg.h"


/* take 0x00515fff to rewind the tape */
#define LOOPCNT2 0x00c0ffff		/* this will give 2 min */
#define LOOPCNT	0x19000

#define SEC5	0x00210000



/* state of online during sending tape command to archieve drive */

/* tape r/w: dev->mem = local address, dev->totcnt = # of bytes */

/* tape rewind, tension, erase, set Q11/Q24 format */
tapepos(dev)
struct devdq *dev;
{
	tapeopr(dev, TP_NONLINE, T_M0, T_M1);

	/* if tape drive hang, OPRDONE will be set */
}

trwfm(dev)
struct devdq *dev;
{
	register b0, b1;
	if ( dev->opr == TRFM ) {
		b0 = TRFM_M0;
		b1 = TRFM_M1;
	}
	else {
		b0 = TWFM_M0;
		b1 = TWFM_M1;
	}
	tapeopr (dev, TP_ONLINE, b0, b1);
	/* if tape drive hang, OPRDONE will be set */
}


tapeopr (dev, state, b0, b1)
struct devdq *dev; int state, b0, b1;
{
	register oldpri; register struct tp *taptr;
	register unsigned short status;

	/* if EXCPT on, read status, and READY must be true,
		and insure correct tape drive is selected */
	/* if tape drive hang, dev->flag |= OPRDONE, dev->rc1 = TP_HANG */
	/* if ( ckexcpt(dev)  == TIMEOUT 		tape drive hang */
	if ( ckexcpt(dev) == -1 ) 
		return;
    
	if ( tcmd (dev, state) )		/* don't care about online */
		return;				/* tape hang, rc1=TP_HANG */

	taptr = tapdr;
	/* DDDDDDDDDDDDDDDDDD */
	/* taptr->next = dev; */
	/* DDDDDDDDDDDDDDDDDD */

	curtapreq = dev;

	/* allow tape interrupt */
	oldpri = spl6();	
	/* don't use tape dma, so setup to be done */

	/* ************************************ */
	/* program clock to monitor             */
	/* if timeout, need to reset tape drive */
	taptr->tp_tick = TICK_3MIN;

	if ( dev->opr == TRFM )		/* longer timeout for read filemark */
		taptr->tp_tick = TICK_20MIN;

	/* ************************************ */

	inturpt = (inturpt & ~TAPE_INT) | TAPEDMA_INT;
	dtc_ctl |= TAPEINT_EN;
	*DTC_CRL = dtc_ctl;
	splx(oldpri);

	if ( dev->flag & TNOWAIT )
		return (0);		/* don't wait for completeion */

	/* wait for READY or EXCPT to be true, always read status */
	while ( (inturpt &  TAPE_INT) == 0 );

	oldpri = spl6();

	/* INTURPT is disable */
	inturpt &= ~(TAPE_INT+TAPEDMA_INT);

	/* DDDDDDDDDDDDDDDDDD */
	/* taptr->next = 0; */
	/* DDDDDDDDDDDDDDDDDD */

	curtapreq = 0;

	/* *********************** */
	/* turn off TICK for tape */
	taptr->tp_tick = 0;
	/* *********************** */

	splx(oldpri);

	/* get tape status */
	status = *TP_SR;
	if ( (status & (TP_EXCPT | TP_READY) ) == 0 ) {
		printf ("no ex/rdy ");
		blkyellow();
	}


	/* if tape hangup, dev->rc1= TP_HANG, dev->flag |= OPRDONE */
	/* if power fail, dev->rc1 = TP_ABORT */
	if ( tstatus (dev) )
		return;

	/* reset dev->rc1 */
	/* mask out status byte and set dev->rc */ 
	setrc (dev, b0, b1);
	return (0);
}


/* **************************************************** */
/* always wait for tape to be completed                 */
/* no tape interrupt involved, just poll the status reg */
/* if tape drive hang, dev->flag |= OPRDONE, dev->rc1 = TP_HANG */

/* return	-1 if tape drive hangup           	*/
/*		   if power fail occur			*/

/* return 	0 if status have been obtained          */
/* **************************************************** */
tstatus(dev)
register struct devdq *dev;
{
	register unsigned short status;
	register count; register i; register oldpri;


	if ( bddesc.tas1 & STOPTPIO ) {
		dev->rc1 = TP_ABORT;
		dev->flag |= OPRDONE;
		return (-1);
	}

	/* send tape status command twice, if no tape error */
	/* archive tape firmware problem */
	for (i=0; i<2; i++) {
		/* send status cmd to tape drive, don't care online */
		oldpri = spl6();
		/* if ( sendcmd (TSTATUS, TP_NONLINE) ) { */
		if ( sendcmd (TSTATUS, TP_ONLINE, dev) ) {
			splx(oldpri);
			return(-1);
		}
		splx(oldpri);
	
		/* check EXECPT for true, may need to resend STATUS cmd	
			(incase it was in the middle of r/w) */
		/* WAIT for ready to be true */
	
		/* while ( ((status = *TP_SR) & (TP_READY|TP_EXCPT)) == 0 ); */
	
		count = LOOPCNT2;
		while( ((*TP_SR & (TP_READY|TP_EXCPT)) == 0) && (--count) );
		if ( count == 0 ) {
			
			if ( (*TP_SR & (TP_READY| TP_EXCPT)) == 0 )  {
				dev->flag |= OPRDONE;
				dev->rc1 = TP_HANG;
				return (-1);
			}
		}

		oldpri = spl6();
		/* if EXCEPT on, need to resend status cmd */
		if ( *TP_SR & TP_EXCPT )  {
			/* if ( sendcmd (TSTATUS, TP_NONLINE) ) { */
			if ( sendcmd (TSTATUS, TP_ONLINE, dev) ) {
				splx(oldpri);
				return(-1);
			}
		}

		if ( getsbyte(dev) ) {	/* get status byte & print */
			splx(oldpri);
			return(-1);		/* return TIMEOUT */
		}

		splx(oldpri);
	
		/* print the tape status */
		if ( PRINT1 )
			ptapstat(dev);

		/* if no tape message show up, send status again */
		if ((tapdr[dev->devnum].tp_stat[0] & T_NOCART) == 0) {
			setrc ( dev, TST_M0, TST_M1 ); 
			dev->flag |= OPRDONE;
			return(0);
		}
	}

	setrc ( dev, TST_M0, TST_M1 ); 
	dev->flag |= OPRDONE;
	return(0);
}
	

tprw(dev)
register struct devdq *dev;
{
	register b0, b1, oldpri;
	register struct tp *taptr;

	/* if EXCPT on, read status, and READY must be true
		and insure correct tape drive is selected */
	/* if tape drive hang, dev->flag |= OPRDONE, dev->rc1 = TP_HANG */
	if ( ckexcpt(dev)  == -1)
		return;

	if ( dev->opr == TREAD ) {
		b0 = TRD_M0_B;
		b1 = TRD_M1_B;
	}
	else {
		b0 = TWR_M0_B;
		b1 = TWR_M1_B;
	}

	/* set appropriate error code before read/write */
	setrc ( dev, b0, b1 );

	if ( *(short *)&dev->rc1 ) {
		dev->totcnt = 0;	/* zero byte performed */
		dev->flag |= OPRDONE;
		printf ("p1");
		return(-1); 
	}

	
	/* program TAPE DMA start & end address */
	dmaddr ( dev->mem, dev->totcnt, TPDMA);

	if ( tcmd (dev, TP_ONLINE) )	/* online set to be true */ 
		return;			/* tape hang, rc1=TP_HANG */

	taptr = tapdr;

	/* DDDDDDDDDDDDDDDDDD */
	/* taptr->next = dev; */
	/* DDDDDDDDDDDDDDDDDD */
	curtapreq = dev;

	/* DBC control register: enable TAPE dma */
	oldpri = spl6();

	/* ************************************ */
	/* program clock to monitor             */
	/* if timeout, need to reset tape drive */
	taptr->tp_tick = TICK_3MIN;
	/* ************************************ */

	inturpt &= ~(TAPEDMA_INT + TAPE_INT);
	dbc_cr = dbc_cr | TP_EN;
	*DBC_CR = dbc_cr;

	splx (oldpri);

	/* return if it is fast tape operation */
	/* do not turn on allow tape inturpt bit */
	if ( (dev->flag & (TNOWAIT+FASTAPE)) == (TNOWAIT+FASTAPE) )
		return (0);		/* don't wait for completion */

	/* allow tape to inturpt  for either wait or no wait */
	oldpri = spl6();
	dtc_ctl |= TAPEINT_EN;
	*DTC_CRL = dtc_ctl;
	splx(oldpri);
	if ( dev->flag & TNOWAIT )
		return(0);

	/* either wait for tape dma done or EXCEPT true */
	while ( (inturpt & TAPE_INT) == 0 );

	oldpri = spl6();

	/* DDDDDDDDDDDDDDDDDD */
	/* taptr->next = 0; */
	/* DDDDDDDDDDDDDDDDDD */

	curtapreq = 0;

	/* *********************** */
	/* turn off TICK for tape */
	taptr->tp_tick = 0;
	/* *********************** */

	inturpt &= ~(TAPEDMA_INT + TAPE_INT);
	splx(oldpri);

	if ( (*TP_SR & TP_EXCPT) && PRINT1 )
		printf ("p2");

	dev->flag |= OPRDONE;
	if ( (b0= cktaperw(dev)) == 0 )
		return(0);
	
	else if ( b0 == TIMEOUT )
		return (TIMEOUT);


	/* compute how many bytes performed */
	dev->totcnt =  dev->totcnt - (*TP_DMAE + 1 - *TP_DMAS);

	/* disable tape dma incase never done */
	oldpri = spl6();
	dbc_cr &= ~TP_EN;
	*DBC_CR = dbc_cr;
	splx (oldpri);
	
	if ( PRINT1 )
		printf ("cnt=%x\n", dev->totcnt);
	return (-1);
}


waitape(dev)
register struct devdq *dev;
{
	register short byte; register oldpri;
	register struct tp *taptr;

	taptr = tapdr;

	/* allow tape interrupt */
	oldpri = spl6();
	dtc_ctl |= TAPEINT_EN;
	*DTC_CRL = dtc_ctl;
	splx(oldpri);

	/* either wait for tape dma done or EXCEPT true */
	while ( (inturpt & TAPE_INT) == 0 );

	oldpri = spl6();
	inturpt &= ~(TAPEDMA_INT + TAPE_INT);

	/* DDDDDDDDDDDDDDDDDD */
	/* taptr->next = 0; */
	/* DDDDDDDDDDDDDDDDDD */

	curtapreq = 0;

	/* *********************** */
	/* turn off TICK for tape */
	taptr->tp_tick = 0;
	/* *********************** */

	splx(oldpri);

	if ( (*TP_SR & TP_EXCPT) && PRINT1 )
		printf ("p3");

	cktaperw(dev);
}

/* ***************************************** */
/* return 	TIMEOUT if tape drive hangup */
/*		dev->flag |= OPRDONE         */
/*		dev->rc1 = TP_HANG	     */
/*		dev->totcnt = 0   	     */
/* return 	0 if READY on                */
/* return	-1 if EXCPT on, read status  */
/* ***************************************** */
cktaperw(dev)
register struct devdq *dev;
{
	register int b0, b1;

	/* if EXCPT on, read status, and READY must be true */
	/* if tape drive hang, dev->flag |= OPRDONE, dev->rc1 = TP_HANG */
	if ( (b0 = ckexcpt (dev)) == 0 )
		return (0);			/* no excpt, every ok */

	if (b0 == -1 ) {
		dev->totcnt = 0;		/* tape hang, power fail */
		return (b0);
	}

	/* except is set */

	/* OPRDONE get clear by tstatus routine, set again */
	dev->flag |= OPRDONE;

	/* problem with r/w, set appropriate error code, and set
		number of bytes performed */
	if ( dev->opr == TREAD ) {
		b0 = TRD_M0;
		b1 = TRD_M1;
	}
	else {
		b0 = TWR_M0;
		b1 = TWR_M1;
	}

	setrc ( dev, b0, b1);
	return (-1);
}


/* 
	Insure correct tape drive is selected
	check tape status, if EXCEPT is true, read status
	and READY must be true when return
	(either EXCEPT or READY must be on)
	if tape drive hang, dev->flag |= OPRDONE, dev->rc1 = TP_HANG

	return 0 if READY TRUE
	return 1 if EXCEPT true and read tape status
	return -1 if tape drive hang or power fail occur
		dev->rc1 = error code
		dev->flag |= OPRDONE
 */
ckexcpt(dev)
register struct devdq *dev;
{
	register unsigned short status; register i;

	for (i=0; i< LOOPCNT; i++) {
		/* if EXCEPT on, send tape status command to clear it */
		if ( (status = *TP_SR) & TP_EXCPT ) {

			/* if tape hangup,rc1= TP_HANG, dev->flag |= OPRDONE */
			if ( tstatus (dev) )
				/* break; */
				return (-1);

			dev->flag &= ~OPRDONE;
			*(short *)&dev->rc1 = 0;
			return (1);
		}
		else if ( status & TP_READY ) {
			*(short *)&tapdr[dev->devnum].tp_stat[0] = 0;
			return (0);
		}

	}

	dev->flag |=OPRDONE;
	dev->rc1 = TP_HANG;
	return (-1);
}

/*
	read in 6 bytes of status from archieve tape drive 
	and print them out
	return -1 if tape drive hang
 */
getsbyte (dev)
register struct devdq *dev;
{
	register i, j; register char *ptr;
	register unsigned short status;

	ptr = (char *)tapdr[dev->devnum].tp_stat;

	for (i=0; i<6; i++) {
		/* wait for ready to be true */
		j = 0;
		while ( ( (status = *TP_SR) & TP_READY ) == 0 ) {
			if ( j++ >= LOOPCNT ) {
				dev->rc1 = TP_HANG;
				dev->flag |= OPRDONE;
				return(-1);
			}
		}

		*ptr++ = status & 0xff;		/* store status byte */

		/* set REQ to inform status byte is read */
		*TP_CR = tp_cr | TP_REQ;

		/* wiat for > 20us before resetting REQ */
		j = 15;
		while (j--);
		*TP_CR = tp_cr & ~TP_REQ;
	}
	return(0);
}


/* ***********************************
	return TIMEOUT if tape drive hangup
	dev->flag |= OPRDONE
	dev->rc1 = TP_HANG
 *********************************** */
tcmd (dev, state)
register struct devdq *dev; int state;
{
	register oldpri, i;

	/* wait for READY to be true */
	i=0;
	while ( (*TP_SR & TP_READY) == 0 ) {
		if ( i++ >= LOOPCNT ) {
			dev->flag |= OPRDONE;
			dev->rc1 = TP_HANG;
			return (TIMEOUT);
		}
	}


	if ( (dev->opr == TWRITE) || (dev->opr == TREAD) ) {
		/* no need to send cmd if it is the same as previous */
		if ( lastpcmd == dev->opr )
			return (0);
	}

	oldpri = spl6();
	if ( sendcmd (dev->opr,state, dev) ) {
		splx(oldpri);
		return (-1);
	}
	splx(oldpri);
	return (0);
}


/* *********************************************** 
interrupt is disabled before enter this rouitne
output:
	return 0 if command accept
	return -1 if tape drive don't communicate 
		or power fail occur
		dev->rc1 = TP_HANG/TP_ABORT
		dev->flag |= OPRDONE
 *********************************************** */
sendcmd(opr, state, dev)
register unsigned char opr;
int state; register struct devdq *dev;
{
	register oldpri; register i,j;

	if ( bddesc.tas1 & STOPTPIO ) {
		dev->rc1 = TP_ABORT;
		dev->flag |= OPRDONE;
		return (-1);
	}

	i = LOOPCNT;
	j = LOOPCNT;
	if ( state & TP_ONLINE )
		tp_cr |= TP_ONLINE; 

	/* send cmd and set/reset online */
	*TP_CR = tp_cr | opr;
	lastpcmd = opr;
	
	/* set REQUEST */
	*TP_CR = tp_cr | TP_REQ | opr;

	/* wait for READY to be true - command accpeted */
	/* ready reset < .25 us - acknowledge strobe */
	/* while ( (*TP_SR & TP_READY) == 0 ); */
	
	while ( ((*TP_SR & TP_READY) == 0) && (--i) );
	if ( i == 0 ) {
		dev->rc1 = TP_HANG;
		dev->flag |= OPRDONE;
		return (-1);
	}

	/* reset REQUEST */
	*TP_CR = tp_cr  & ~TP_REQ;

	/* wait for READY false for command execution */
	/* READY false only last 20u sec */
	while ( (*TP_SR & TP_READY) && (--j) );

	if ( j==0 ) {
		dev->rc1 = TP_HANG;
		dev->flag |= OPRDONE;
		return (-1);
	}

	return(0);
}

/* ????????????????????????????????????????????????? */
setape(drive)
char drive;
{
	struct devdq dkreq; register struct devdq *p; register count;
	register unsigned short status;
	register struct tp *taptr;

	taptr = &tapdr[drive];
	tp_cr = 0;	/* keep track online bit */

	if ( (status = *TP_SR) & TP_READY ) {
		
		/* print out tape status */
		p = &dkreq;
		initdevq (p);
		p->device = TAPE;
		p->devnum = drive;

		/* will wait for it */
		if ( tstatus (p) )
			return (-1);
		taptr->tp_type = TAPEON | TP_ARCH;
		return(0);
	}

	/* no ready, no except, try reset the drive */
	if ( (status & TP_EXCPT) == 0 ) {
		resetape();

		if ( (*TP_SR & (short)TP_EXCPT) == 0 ) {
			/* after reset, still no except, then no drive */
			taptr->tp_type = TP_ARCH;
			printf ("no tape\n");
			return(-1);
		}
	}

	taptr->tp_type = TAPEON | TP_ARCH;

	/* print out tape status */
	p = &dkreq;
	initdevq (p);
	p->device = TAPE;
	p->devnum = drive;

	/* will wait for it , either return 0 or -1 */
	if ( tstatus (p) )
		return(-1);		/* return TIMEOUT */
	return(0);
}
resetape()
{
	register count; register count2;
	*TP_CR = TP_RESET;
	/* wait min 25 us */
	count=40;
	while ( count--);
	*TP_CR = 0;

	/* wait about 5 seconds */
	count = SEC5;
	while ( --count );
}
