
#include "disksect.h"
#include "defectlist.h"
#include "pdf.h"

/* the following should be somewhere else (about the phys stuff) */
#define BAD_TRACK_FLAG 0x8000

struct defect_entry defect_log[MAXLINES];
struct medf medf[MAXLINES];
extern struct sector0 *pd;
extern struct pdstat *statbuf;

static int lino;
static int numentry;

static int input_base = BASE_10;

int cmpdefect();
defectenter(fd) {
    register struct defect_entry *log;
    register struct medf *pmedf;
    register lastcyl,lasthead;
    register int i;
    register int numdefect;
    register struct sectid *bb;
    int numbadblock;
    int defectindex;
    int regularbytesec, lastbytesec;

    /* initialize the array with illegal values */
    for(log=defect_log;log < &defect_log[MAXLINES];log++) {
	/* initialize defect_log to illegal values */
	log->star = -1; log->head = -1;
	log->cyl = -1; log->pos = -1; log->len = -1;
    }
    if( statbuf && statbuf->pd_md_count ) {
	/* read any existing defect info and convert to defect_log */
	if( statbuf->pd_md_count > MAXLINES )
	    errxit("Old list contains too many entries.");
	if(pdfread(fd, PDF_DEFECT, medf)<0) errxit("Defect list read error.");
	numdefect = statbuf->pd_md_count;
	printf("\n%d media defect entries read.\n",numdefect);
	numentry = -1;
	log = defect_log;
	for(i=0,pmedf=medf;i<numdefect;i++,pmedf++) {
	    for(defectindex = 0;defectindex<4;defectindex++) {
		if(pmedf->defpos[defectindex].pos == 0
		  && pmedf->defpos[defectindex].len == 0 ) {
		    if(!defectindex) errxit("Bad list format on disk");
		    else break;
		}
		log->cyl = pmedf->cyl & ~BAD_TRACK_FLAG;
		log->head = pmedf->head;
		log->pos = pmedf->defpos[defectindex].pos;
		log->len = pmedf->defpos[defectindex].len;
		if(pmedf->cyl & BAD_TRACK_FLAG) log->star = '*';
		log++;
		numentry++;
	    }
	}
	printf("%d media defect list items generated\n",numentry+1);
    } else
	numentry = -1;

    while(1) {
	printf("enter 'h' or 'd' to indicate hex or decimal input: ");
	i = pgchar();
	putchar('\n');
	if(i=='h') input_base = BASE_16;
	else if(i=='d')input_base = BASE_10;
	else {
	    beep();printf("illegal input\n");
	    continue;
	}
	break;
    }
    help();
    userentry();
    qsort( defect_log, numentry, sizeof(struct defect_entry), cmpdefect);
#if 0
    for(i=0,log=defect_log;i<numentry;i++,log++) {
        printf("%c%3d        %4x        %2x      %4x     %3x\n",
	log->star == -1 ? ' ' : '*', i,log->cyl,log->head,log->pos,log->len);
    }
#endif
    for(pmedf=medf;pmedf<&medf[MAXLINES];pmedf++) {
	pmedf->cyl = 0; pmedf->head = 0;
	pmedf->defpos[0].pos = 0; pmedf->defpos[0].len = 0;
	pmedf->defpos[1].pos = 0; pmedf->defpos[1].len = 0;
	pmedf->defpos[2].pos = 0; pmedf->defpos[2].len = 0;
	pmedf->defpos[3].pos = 0; pmedf->defpos[3].len = 0;
    }
    /* format for putting it on disk */
    lastcyl = -1; lasthead = -1;
    pmedf = &medf[-1];
    numdefect = 0;
    for(i=0,log=defect_log;i<numentry;i++,log++) {
	if(lastcyl == log->cyl && lasthead == log->head) {
	    if(++defectindex > 3) errxit("more than 4 defects on track");
	    if(log->star == '*') pmedf->cyl |= BAD_TRACK_FLAG;
	} else {
	    pmedf++;numdefect++;
	    defectindex = 0;
	    lastcyl = log->cyl;
	    lasthead = log->head;
	    pmedf->cyl = lastcyl;
	    pmedf->head = lasthead;
	    if(log->star == '*') pmedf->cyl |= BAD_TRACK_FLAG;
	}
	pmedf->defpos[defectindex].pos = log->pos;
	pmedf->defpos[defectindex].len = log->len;
    }
#if 0
    putchar('\n');
    for(i=0,pmedf=medf;i<numdefect;i++,pmedf++)
	printf("%4x   %2x   [ %4x %3x ] [ %4x %3x ] [ %4x %3x ] [ %4x %3x ]\n",
	    pmedf->cyl, pmedf->head,
	    pmedf->defpos[0].pos, pmedf->defpos[0].len,
	    pmedf->defpos[1].pos, pmedf->defpos[1].len,
	    pmedf->defpos[2].pos, pmedf->defpos[2].len,
	    pmedf->defpos[3].pos, pmedf->defpos[3].len);
#endif

    if(pdfwrite(fd,PDF_DEFECT,medf,numdefect) < 0)
	errxit("write error of media defect log, data not stored");
    /*
     * get the actual sect size parameters
     * try for sector 0 values, else make a guess
     */
    if( (lastbytesec=pd->ltrkbpsg) && (regularbytesec = pd->trkbpsg) ) {
	;
    } else { /* make a guess */
	char *guessname;
	if(pd->sechead == 18) { /* smaller fuji */
	    regularbytesec = 0x2390;
	    lastbytesec = 0x2370;
	    guessname = "Fuji 80meg or Fuji 160meg";
	} else if(pd->sechead == 25 ) { /* eagle */
	    regularbytesec = 0x2338;
	    lastbytesec = 0x22c0;
	    guessname = "Fuji eagle";
	} else if(pd->sechead == 26 ) { /* CDC */
	    regularbytesec = 0x245a;
	    lastbytesec = 0x2436;
	    guessname = "CDC 500meg";
	} else if(pd->sechead == 36 ) { /* Fuji 824meg */
	    regularbytesec = 0x2390;	/* added 5/17/89 kc */
	    lastbytesec = 0x2250;
	    guessname = "Fuji 824meg";
	} else errxit("unknown drive type");
	printf("Assuming disk is: %s\n",guessname);
	confirm();
    }
    

    /* generate the bad block list, re-use the user defect_log area */
    numbadblock = conv_defects(pd->sechead, regularbytesec, lastbytesec,
	pd->FORMAT_LEVEL, medf, numdefect, defect_log);
#if 0
    printf("\n%d bad blocks\n",numbadblock);
    for(i=0,bb=(struct sectid *)defect_log;i<numbadblock;i++,bb++)
	printf("%4x   %2x  %2x\n",bb->cyl, bb->head, bb->sector);
#endif
    if(pdfwrite(fd,PDF_BADSECT,defect_log,numbadblock)<0)
	errxit("write error of bad sector list, data not stored");;
}

cmpdefect(a,b)
register struct defect_entry *a,*b;
{
    register temp;
    if(temp = a->cyl - b->cyl) return(temp);
    if(temp = a->head - b->head) return(temp);
    return(a->pos - b->pos);
}

static short maxdgt[] = { 0, 4, 2, 5, 3 };

/*
 *	userentry() and getvalint() work together to get the
 *	user data entry
 *
 *	userentry calls getvalint.  getvalint either returns a
 *	valid integer which is properly delimited or some type of
 *	user control character (cf defectlist.h).
 *	userentry either stuffs the value into the log_entry array,
 *	preforms the requested action or beeps.
 */

userentry()
{
    register struct defect_entry *log;
    register int fldno;
    register int input;
    register int i;
    register int backup;

    lino = -1; /* special for correct entry to while loop */
    log = defect_log;

    while(1) {
	if(lino == -1) input = INITIAL;
	else
	    input = getvalint(fldno==FLD_CYL ? BASE_STAR : input_base,
		maxdgt[fldno],fldno==FLD_LEN ? RET_CHAR : TAB_CHAR,backup);

	if(input == INPUT_TAB) input = LAST_INPUT_VAL - fldno;
	else if(input == INPUT_RETURN) input = LAST_TAB_VAL - fldno;

	switch(input<0? input : fldno) {
	case INPUT_LINE:
	case INPUT_DOLLAR:
	    if(! okline(log)) {
		beep();
		continue;
	    }
	    if( input == INPUT_LINE) {
		putchar('\n');
getlinenumber:
		printf("Enter line number: ");
		i = getvalint(BASE_10,3,RET_CHAR,0);
		if( i < 1 || i > numentry + 1) {
		    beep();
		    goto getlinenumber;
		}
	    } else {/* must be INPUT_DOLLAR */
		if(numentry < 0) {
		    beep();
		    continue;
		}
		i = numentry+1;
	    }
	    lino = i-1;
	    log = &defect_log[lino];
	    putchar('\n');
	    prline(log);
	    fldno = FLD_CYL;
	    backup = FALSE; /* ???????? */
	    continue;
	case INPUT_BACKUP:
	    backup = TRUE;
	    fldno--;
	    continue;
	case INPUT_BACKUP_LINE:
	    /* either all fields set or no fields set */
	    if(! okline(log)) {
		beep();
		continue;
	    }
	    if( lino == 0 ) {
		beep();
		continue;
	    }
	    lino--; log--;
	    putchar('\n');
	    prline(log);
	    fldno = FLD_CYL;
	    backup = FALSE; /* ???????? */
	    continue;
	case INPUT_STAR:
	    log->star = '*';
	    goto do_star;
	case INPUT_DELETE_STAR:
	    log->star = -1;
do_star:
	    putchar('\r');
	    prlino(log->star);
	    continue;
	case INPUT_HELP:
	    help();
	    prlino(log->star);
	    continue;
	case FLD_CYL:
	    log->cyl = input;
	    break;
	case FLD_HD:
	    log->head = input;
	    break;
	case FLD_POS:
	    log->pos = input;
	    break;
	case FLD_LEN:
	    log->len = input;
tablen:
	    log++;
	    /* fall through */
	case INITIAL:
	    fldno = FLD_CYL-1;
	    lino++;
	    if(lino-1 > numentry) numentry = lino-1;
	    if(log->cyl == -1) prlino(log->star);
	    else prline(log);
	    break; /* go for another line */
	case CYL_TAB:
	    i = log->cyl;
	    goto tabpast;
	case HD_TAB:
	    i = log->head;
	    goto tabpast;
	case POS_TAB:
	    i = log->pos;
	    goto tabpast;
	case LEN_TAB:
	    i = log->len;
tabpast:
	    backup = FALSE;
	    if(i < 0) {
		beep();
		continue;
	    }
	    showfield(i);
	    if(input == LEN_TAB) goto tablen;
	    break;
	/*
	 *  the ..._RET cases indicate that a RETURN was typed.  Display
	 *  the entire line and go to the next line, or go to the end
	 *  of the current line if all fields have not been set
	 */
	case CYL_RET:
	    if(log->cyl < 0) goto inputdone;
	    okshowfield(log->cyl);
	    backup = FALSE;
	    fldno++;
	case HD_RET:
	    if( ! okshowfield(log->head)) continue;
	    backup = FALSE;
	    fldno++;
	case POS_RET:
	    if( ! okshowfield(log->pos)) continue;
	    backup = FALSE;
	    fldno++;
	case LEN_RET:
	    if( ! okshowfield(log->len)) continue;
	    putchar('\n');
	    goto tablen;
	default:
	    beep();
	}
	fldno++;
	backup = FALSE;
    }
    
inputdone:

    printf ("done \n");

    numentry++;
    printf("%d entries made\n",numentry);
    
}
static
help() {
    printf("\n");
    printf(" Input/Output mode is %s.\n",
	input_base == BASE_16 ? "hexadecimal" : "decimal");
    printf(" Type ASTERISK ('*') at the cylinder if the line begins with a *.\n");
    printf(" TAB or SPACE BAR advances to the next field.\n");
    printf(" RETURN advances to the next line or exits if at cylinder.\n");
    printf(" BACK SPACE backspaces and erases within the current line. \n");
    printf(" MINUS ('-') moves to the previous line.\n");
    printf(" LESSTHAN ('<') or COMMA (',') backs up to previous field.\n");
    printf(" DOLLAR ('$') makes the last line of the list the current line.\n");
    printf(" L prompts for a line number, this is made the current line.\n");
    printf(" QUESTION ('?') or SLASH ('/') for this message, only at beginning of line.\n");
    printf (" NO            CYLINDER       HEAD        POS/BYTES          LEN/BITS \n");
}
okline(log) /* true if all field vals set or none set */
register struct defect_entry *log; {
    if( (log->len < 0 || log->pos < 0 || log->head < 0 || log->cyl < 0)
	&& log->len + log->pos + log->head + log->cyl != -4 )
	    return(0);
    return(1);
}


static char sval[5];
static char line [100];
static char *lptr;
static int sindex;
getvalint(base, maxdgt, delim,backup)   /*   get a valid integer    */
int base,maxdgt;
char delim;
int backup;

{
    register char c;
    int j,k,n;
    int starflag;

    sindex = 0;
    if( base == BASE_STAR ) {
	starflag = 1;
	base = input_base;
    } else starflag = 0;
    if (backup) {
	while ((lptr >= line) && (vldhexdgt(*lptr--))) 
	; /* bug?, should above be '>=' ? */
	lptr++;
	if (lptr != line)
	    lptr++;
	while (vldhexdgt(*lptr)) 
	    sval[sindex++] = *lptr++;
    }
    else if (starflag)
	lptr = line;
    while(1) {
	c=pgchar();
	if (c >= 'a' && c <= 'f')
	    c = c - 'a' + 'A';
	if (!sindex && starflag) {
	    if (c == '*')
		return (INPUT_STAR);
	    if (c == '\r') 
		return (INPUT_RETURN);
	    if( c == '\b' )
		return( INPUT_DELETE_STAR );
	    if( c == '?' || c =='/' )
		return(INPUT_HELP);
	}
	if (sindex < maxdgt) {
	    if (c >= '0' && c <= '9'
	        || base == BASE_16 && c >= 'A' && c <= 'F') {
		*lptr++ = c;
		sval[sindex++] = c;
		putchar(c);
		backup = FALSE;
		continue;
	    }
	}
	if (c == '\b') {
	    if (sindex > 0) {
		printf ("\b \b");
		*--lptr = SPACE_CHAR;
		--sindex;
		backup = FALSE;
		continue;
	    }
	    if (!starflag) {
		while (*--lptr == ' ') 
		    printf ("\b");
		return(INPUT_BACKUP);
	    }
	} else if(c == ',' || c=='<') {
	    if(sindex && !backup || starflag) {
		beep();
		continue;
	    }
	    while(sindex) {
		putchar('\b');
		--lptr;
		--sindex;
	    }
	    while (*--lptr == ' ') 
		printf ("\b");
	    return(INPUT_BACKUP);
	} else if( c == '-' ) {
	    if( !sindex ) return(INPUT_BACKUP_LINE);
	} else if( c == '$' ) {
	    if( !sindex ) return(INPUT_DOLLAR);
	} else if( delim == TAB_CHAR
	    && (c == TAB_CHAR || c == SPACE_CHAR )) {
	        if(sindex == 0) return(INPUT_TAB);
	        for (k = 1; k < FIELD_SIZE - sindex; k++) {
		    *lptr++ = ' ';
		    printf (" ");
	        }
		sval[sindex] = 0;
	        break;
	} else if( c == RET_CHAR ) {
	    if(c == delim && sindex > 0 && sindex <= maxdgt) {
		sval[sindex] = c;
		if (c == '\r')  {
		    printf ("\n");
		}
		break;
	    }
	    if(!sindex || backup) return(INPUT_RETURN);
	}
	if (c == 'L') 
	    return(INPUT_LINE);
	beep();   /*    BEEP THE TERMINAL    */
    }
    
    return(strtol(sval,0,base));
}

prlino(flag) {
    if(flag == -1) putchar(' ');
    else putchar('*');
    printf ("%03d            ",lino+1); /* 12 blanks after the digits */
}

prline(log)
register struct defect_entry *log;
{
    lptr = line;
    prlino(log->star);
    showfield(log->cyl);
    showfield(log->head);
    showfield(log->pos);
    showfield(log->len);
    putchar('\r');
    prlino(log->star);
}

static int pow_10_16[][2] = {
    { 10000, 0x10000 },
    { 1000, 0x1000 },
    { 100, 0x100 },
    { 10, 0x10 },
    { 1, 0x1 },
};

static
setchar(pval,flag,place)
int *pval;
{
    int c;
    int *ppow;

    ppow = & pow_10_16[place][input_base == BASE_16];
    c = *pval / *ppow;

    if(c || flag) {
	*pval -= c * *ppow;
	if(c<10) c += '0';
	else c += 'A' - 10;
	*lptr++ = c;
	putchar(c);
	return(1);
    }
    return(0);
}

okshowfield(val) {
    if(val < 0) {
	beep();
	return 0;
    }
    while ((lptr > line) && (vldhexdgt(*--lptr))) putchar('\b');
    lptr++;
    showfield(val);
    return 1;
}

showfield(val) { /* the biggest is 5 */
    int size = 0;
    int i;
    for(i=0;i<5;i++) {
	size += setchar(&val,size,i);
    }
    if(size == 0) {
	size = 1;
	putchar('0');
	*lptr++ = '0';
    }
    for (i = 1; i < FIELD_SIZE - size; i++) {
	*lptr++ = ' ';
	printf (" ");
    }
}

vldhexdgt (c)   /*  returns 1 if char is a valid hex digit, otherwise returns 0 */
char c;

{

    return (c >= '0' && c <= '9' || c >= 'A' && c <= 'F');
}

beep() {
    putchar('\007');
}
