/*----------------------------------------------------------------------------
/ convert.c - converts list of media defects from raw format into
/             cyl/head/sector list
/
/ (c) Copyright 1988 ARIX Corp.  San Jose, CA
/---------------------------------------------------------------------------*/

#include "disktest.h"

/*---------------------------------------------------- conv_defects() ------*/
conv_defects(sechead, bytsec, Lbytsec, fmt, def_ptr, def_cnt, dest_ptr)
short bytsec, Lbytsec, fmt;
struct medf *def_ptr;
short def_cnt;
struct sectid *dest_ptr;
{
	short i, ret_cnt, byt_p_trk;
	short strt_def, end_def;
	char last_sec, sec;

	byt_p_trk =  ((sechead -1)) * bytsec + Lbytsec;
	ret_cnt = 0;

	while (def_cnt-- > 0) {
		if ((def_ptr->cyl & 0x8000) != 0) {
                                        /* spare entire track */
			for (sec = 0; sec < sechead; sec++) {
                spare(dest_ptr, def_ptr, sechead, fmt, sec);
				dest_ptr++;
				ret_cnt++;
			}
		}
		else {
                                        /* spare up to four sectors */
			last_sec = -1;
            for (i = 0; i < 4; i++) {
				strt_def = def_ptr->defpos[i].pos - 1;
				if (((end_def = def_ptr->defpos[i].len) == 0) ||
						(strt_def > byt_p_trk)) {
					continue;
				}
                if (strt_def < 0)
                    strt_def = 0;
				end_def = strt_def + ((end_def / 8) + 2);
                if (end_def > byt_p_trk)
                    end_def = byt_p_trk;
				do {
					sec = strt_def/bytsec;
                    if (sec >= sechead)
                        break;
                                        /* NOTE: if wrap around errors can
                                        / happen, change break to sec = 0 */
					if (sec != last_sec) {
                        spare(dest_ptr, def_ptr, sechead ,fmt, sec);
						dest_ptr++;
						ret_cnt++;
						last_sec = sec;
					}
                                        /* mov strt_def to start of next sect */
                    strt_def = (sec + 1) * bytsec;
				} while (strt_def <= end_def);
			}
		}
		def_ptr++;
	}
	return (ret_cnt);
}

/*---------------------------------------------------- secmap() ------------*/
unsigned char secmap(sechead, ftype, head, sec)
short ftype;
unsigned char head, sec;
{
	unsigned char ret_sec;

    switch (ftype) {
        case 0:
            return(sec);
        case 1:
            ret_sec = sec + head;
            if (ret_sec >= sechead)
                ret_sec -= sechead;
            return(ret_sec);
        default:
            return(0xff);
	}
}

/*---------------------------------------------------- spare() -------------*/
spare(dest_ptr, def_ptr, sechead, fmt, sec)
struct medf *def_ptr;
struct sectid *dest_ptr;
short fmt;
char sec;
{
    dest_ptr->cyl = def_ptr->cyl & 0x7fff;  /* mask off track defect bit */
    dest_ptr->head = def_ptr->head;
    dest_ptr->sector = secmap(sechead, fmt, dest_ptr->head, sec);
}

/*-------------------------------- End of convert.c ------------------------*/
