
#	@(#)disktest.mk	1.3

include $(IROOT)/macdefs
include ../../macdefs


SGS_ROOT	=	$(SGS_68000)

NAME = disktest

OBJS =	main.o disk.o getparam.o get.o \
	filerr.o report.o format.o dump.o pdisk.o \
	disbad.o lsectop.o \
	scsimain.o scsitest.o scsiinit.o scsifunc.o scsimisc.o scsivar.o


SINC = ../../head
LIB = -L../../lib -lsc
CRT0 = ../../lib/scrt0.o
HDR = ../../lib/standhead.o
LDFILE = ../../lib/ld.util
# LDFILE = ./ld.file

CFLAG	=	-I$(SINC) -DSTANDALONE $(CFLAGS)

#option for cc --- change all .data's to .text for prom resident code
NODATA = -Wa,-r

#option for cc --- do not generate stack probe code
NSPROB = -W0,-sp


all install:	$(NAME)

clean:
	-rm -f $(OBJS)

clobber: clean
	-rm -f $(NAME).map $(NAME)

.s.o:
	$(AS) $*.s

.c.s:
	$(CC) $(CFLAG) -S $(NSPROB) $*.c

.c.o:
	$(CC) $(CFLAG) -c $(NSPROB) $*.c

$(NAME): $(OBJS) ld.file
	$(LD) -o $(NAME) -m -N $(LDFILE) $(CRT0) $(HDR) $(OBJS) $(LIB) > $(NAME).map
	nm -xev $(NAME) >> $(NAME).map
	size -x $(NAME)
	strip $(NAME)
	../sapatch/sapatch -h $(NAME)

disk.o:		disktest.h \
		$(SINC)/disksect.h \
		$(SINC)/devcmd.h

get.o:

main.o:		disktest.h \
		$(SINC)/disksect.h \
		$(SINC)/devcmd.h

getparams.o:	disktest.h \
		$(SINC)/disksect.h \
		$(SINC)/icb.h \
		$(SINC)/vreg.h

filerr.o:	disktest.h \
		$(SINC)/disksect.h

report.o:	disktest.h \
		$(SINC)/disksect.h \
		$(SINC)/devcmd.h

format.o:	disktest.h \
		$(SINC)/disksect.h \
		$(SINC)/devcmd.h \
		$(SINC)/simple_mem.h \
		$(SINC)/vreg.h

pdisk.o:	disktest.h \
		$(SINC)/disksect.h \
		$(SINC)/devcmd.h \
		$(SINC)/vreg.h

dump.o:		disktest.h \
		$(SINC)/disksect.h

disbad.o:	disktest.h \
		$(SINC)/disksect.h \
		$(SINC)/devcmd.h

chkdrive.o:	$(SINC)/icb.h \
		$(SINC)/vreg.h \
		$(SINC)/sysconf.h \
		$(SINC)/cpu.h \
		$(SINC)/icbcmd.h

lsectop.o:	disktest.h \
		$(SINC)/disksect.h \
		$(SINC)/devcmd.h \
		$(SINC)/vreg.h
