/*----------------------------------------------------------------------------
/ dsetdevq.c - making all devreq() calls to CPU PROM
/
/ Craig J. Kim -- July 1988
/ (c) Copyright 1988 ARIX Corp.  San Jose, CA.  USA
/---------------------------------------------------------------------------*/

#ifdef RO_UNIX
/* do nothing */
#else

#include "disksect.h"
#include "cpu.h"
#include "icb.h"
#include "icbcmd.h"
#include "dk.h"
#include "vreg.h"
#include "sysconf.h"

#ifndef TRUE
#define TRUE    1
#define FALSE   0
#endif

#ifndef SCSI_CMD
#define SCSI_CMD 0x25
#endif

static char aBuffer[BLKSIZE * 2];
static char *devqmem;
static char *str_notfini = "Unable to finish repeat counts at %d -- Error $%x.\n";


/*---------------------------------------------------- get_slotptr() ---------
/ a function to determine if passed controller (0..3) is a SCSI controller.
/ returns 1 if SCSI; else 0
/ 6-Apr-88  Craig J. Kim
/---------------------------------------------------------------------------*/
struct slot_info *get_slotptr(controller)
int controller;
{
        static int first_time = TRUE;   /* we want to determine only once */
        static struct slot_info *sp[NUMSLOTS];  /* large enough for sure! */

        if (controller >= NUMSLOTS || controller < 0)
            return((struct slot_info *) 0);

        if (first_time) {
            register struct slot_info *slotptr;
            register int i, bdtyp, numbd = 0;

            for (i = 0; i < NUMSLOTS; i++)
                sp[i] = (struct slot_info *) 0;
            slotptr = SYSCONF->slotinfo;
            for (i = 0; i < NUMSLOTS; i++, slotptr++) {
		if (slotptr->flags & OCCUPIED) {
                    bdtyp = slotptr->slotaddr->bdtypreg & BDTYPMSK;
                        if (bdtyp == HSDTBDTYP
                         || bdtyp == EDTBDTYP
                         || bdtyp == SCSIBDTYP) {
                    		sp[numbd] = slotptr;
                    		numbd++;
		    }
		}
            }
            first_time = FALSE;
        }

        return(sp[controller]);
}

/*---------------------------------------------------- sc_readblock() --------
/ reads 'block' 'repeat' times
/---------------------------------------------------------------------------*/
int sc_readblock(drv, block, repeat)
int drv, block, repeat;
{
        register struct slot_info *slotptr;
        register int i;
        struct devq devrq;

        devqmem = (char *) ((unsigned int) aBuffer & ~0x03);
        slotptr = get_slotptr(drv >> 4);
        for (i = 0; i < repeat; i++) {
            memset((char *) &devrq, 0, sizeof (devrq));
            devrq.q_devtype = DTDISK;
            devrq.q_devnum = drv & 0x0f;
            devrq.q_cmd = PREADPS;      /* not a scsi call */
            devrq.q_devun.block = block;
            devrq.q_mem = devqmem;
            devrq.q_count = BLKSIZE;
            devreq(slotptr, &devrq);
            if (devrq.rc1) {
                printf(str_notfini, i, devrq.rc1);
                break;
            }
        }
        return(*((unsigned short *) &devrq.rc1));
}

/*---------------------------------------------------- sc_writeblock() -------
/ writes 'block' 'repeat' times
/---------------------------------------------------------------------------*/
int sc_writeblock(drv, block, repeat)
int drv, block, repeat;
{
        register struct slot_info *slotptr;
        register int i;
        struct devq devrq;

        devqmem = (char *) ((unsigned int) aBuffer & ~0x03);
        slotptr = get_slotptr(drv >> 4);

        for (i = 0; i < repeat; i++) {
            memset((char *) &devrq, 0, sizeof (devrq));
            devrq.q_devtype = DTDISK;
            devrq.q_devnum = drv & 0x0f;
            devrq.q_cmd = PWRITPS;      /* not a scsi call */
            devrq.q_devun.block = block;
            devrq.q_mem = devqmem;
            devrq.q_count = BLKSIZE;
            devreq(slotptr, &devrq);
            if (devrq.rc1) {
                printf(str_notfini, i, devrq.rc1);
                break;
            }
        }

        return(*((unsigned short *) &devrq.rc1));
}

/*---------------------------------------------------- sc_spareblock() -------
/ reassigns 'block'
/---------------------------------------------------------------------------*/
int sc_spareblock(drv, block)
int drv, block;
{
        register struct slot_info *slotptr;
        struct devq devrq;
        struct _reassign {
            unsigned short zero;
            unsigned short listlen;
            unsigned int   block;
        } *rs;

        devqmem = (char *) ((unsigned int) aBuffer & ~0x03);
        slotptr = get_slotptr(drv >> 4);
        memset((char *) &devrq, 0, sizeof (devrq));

        rs = (struct _reassign *) devqmem;
        rs->zero = 0;                   /* this must be zero */
        rs->listlen =  4;       /* number of bytes in the defect list */
        rs->block = block;              /* block number */
        devrq.q_devtype = DTDISK;      /* hard disk */
        devrq.q_devnum = drv & 0x0f;   /* drive number */
        devrq.q_cmd = SCSI_CMD;        /* special SCSI command */
        devrq.q_mem = devqmem;         /* memory to deal with */
        devrq.q_count = sizeof (struct _reassign);
        devrq.opr = 0x07;              /* reassign block */
        devreq(slotptr, &devrq);       /* send the request */

        if (devrq.rc1)
            printf("Unable to spare block #%d -- Error $%x\n",
                    block, devrq.rc1);

        return(*((unsigned short *) &devrq.rc1));
}

#endif      /* RO_UNIX */
/*---------------------------- End of dsetdevq.c ---------------------------*/
