/* disk/tape request buffer */
struct devdq {
	struct	devdq *q_next;
	struct	devdq *q_prev;
	unsigned char	q_devtype;		/* q_devtype - DISK */
	unsigned char	q_devnum;		/* drive #: log/physical */
	unsigned char	q_cmd;			/* disk/tape command */
	unsigned char	q_priority;
	union {
		unsigned int	block;		/* block number on unit */
		unsigned int	lbuf;
		struct {
			unsigned short cyl;
			unsigned char head;
			unsigned char sector;
		} pdisk;
		struct {
			unsigned int file:8;
			unsigned int block:24;
		} ptape;
	} q_devun;
	char *	q_mem;				/* q_memory address */
	unsigned int	q_count;		/* total bytes cnt */
	unsigned int	q_key;
	struct mmu	*q_mmu;
	unsigned short	q_flag;			/* q_flag byte */

	unsigned char	rc1;			/* return code */
	unsigned char	rc2;
	unsigned char	q_extdtb;
	unsigned char	opr;

	unsigned char	scnt;			/* sector count */
	unsigned char	retry;			/* retry for disk */
	unsigned int	orgsect;		/* orginial c,h,s */
	unsigned char	totsleft;		/* total sector left */
	unsigned char	badsecn;
	unsigned char	sectleft;		/* sector left done */
	unsigned char	totsdone;		/* total sector done */
}; 


/* struct mmu is defined in vreg.h */
