#include "hsdtccpu.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevstr.h"
#include "devcmd.h"
#include "hsdtdevdq.h"
#include "hsdtdtc.h"
#include "hsdttape.h"
#include "hsdttape9.h"
#include "hsdtdata.h"
#include "hsdterror.h"
#include "hsdtptm.h"
#include "hsdtstruct.h"
#include "hsdtextrn.h"
#include "vreg.h"
#include "data_struct.h"

extern unsigned short burstid;

#define MM_MASK	 (DDC_INT + CHNDMA_INT + DTB_INT)
#define MMA_MASK (DDC_INT + CHNDMA_INT + DDADMA_INT)	
#define LOC_MEM_MASK (DDC_INT + DDCDMA_INT)
#define LOC_MEM_AMASK (DDADMA_INT + DDC_INT)
#define MME_MASK (DDC_INT + CHNDMA_INT)
#define MM1_MASK (DDC_INT + DDADMA_INT)

#define DTB_MASK (DTB_INT + CHNDMA_INT + DTBDMA_INT)

/* ************************************** */
/* icb interrupt service routine  LEVEL 1 */
/* ************************************** */

icbint() {
	/* insure it is icb interrupt from main cpu */
	if ( ICB_IBUSY == 0 )	 {
		printf ("i1");
		return;
	}

	icbdata = *ICB_IR;

	status_change |= ICB;
}


/* ************************************** */
/* tape interrupt service routine LEVEL 2 */
/* ************************************** */

tapeint() {
	register unsigned short stat;
	register struct devq *dev;

	stat = *TP_SR;
	enter_short_cr;

	if(tapeque.t_active == 0){
		dtc_ctl &= ~TAPEINT_EN;
		*DTC_CRL = dtc_ctl;
		exit_short_cr2;
		return;
	}



	if ( (stat &(TP_EXCPT | TP_READY))== 0 ) {
		exit_short_cr2;
		return;
	}

	/* READY may be true for the archive tape drive between 512 byte 
		blocks */

	if((dev = tapeque.t_first) == (struct devq *)0)
		return;

	if ( (tapdr[dev->q_devnum].tp_type & TP_ARCH) 
		&& ( stat & TP_READY ) && ((inturpt & TAPEDMA_INT)==0) ) {
		exit_short_cr2;
		return;
	}

	inturpt |= TAPE_INT;
	close_out_tape(dev);

	exit_short_cr2;
	return;
}

struct dmab { 
	unsigned char dmabit; unsigned short intbit;
} dmatable[5] =
{	DDC_EN, DDCDMA_INT,
	DDA_EN, DDADMA_INT,
	CHN_EN, CHNDMA_INT,
	DTB_EN, DTBDMA_INT,
	TP_EN,  TAPEDMA_INT,
};

/* ******************************************* */
/* dtb & dma interrupt service routine LEVEL 4 */
/* ******************************************* */

dtbdmaint() {
	register unsigned char status;
	register unsigned char value;
	register struct  dtb_que *dptr;

	enter_short_cr;
	dptr = &dtbque;
	if ( status=(*DTB_SR & (DTBRDSTAT|DTBSNDINT|DTBWRLAST|DTBRDLAST)) ) {
		*DTB_CR = (status << 8) | dtb_cr;

		inturpt |= DTB_INT;

		if((dptr->dtb_active&DISK) &&  
		    (dptr->d_first->q_flag&OPEN_DISK)){
			exit_short_cr4;
			return;
		}
		if(dptr->dtb_active)
			ckdisktape(dptr->dtb_active);
		exit_short_cr4;
		return;

	}


	/* disable dma interrupts */

	status = *DBC_SR;		/* status of DMA done */

	if((value = ((dbc_cr&CR_MASK) & status)) == 0){
#ifdef DEBUG
		if ( PRINT1 )
			printf ("i3(%x %x)", dbc_cr, status);
#endif
		exit_short_cr4;
		return;
	}

	inturpt |= (value&CR_MASK);

	dbc_cr &= ~value;
	*DBC_CR = dbc_cr;

	if((dptr->dtb_active&DISK) && 
	    (dptr->d_first->q_flag&OPEN_DISK)){
		exit_short_cr4;
		return;

	}
	if((value & 0xf0) && dptr->dtb_active)
		ckdisktape(dptr->dtb_active);
	
	exit_short_cr4;
	return;
}


/* ************************************** */
/* seek interrupt service routine LEVEL 5 */
/* ************************************** */



seekint() {

	register i;
	register struct smdrd *rd;
	register struct smdwr *wr;

	enter_short_cr;

	if(dtbque.dtb_active & DISK){
	    for(i=0,wr = (struct smdwr *)DK_BUSW; i<MAX_PDRIVE;i++,wr++,rd++){
		    if(seekque.seek_active & BIT(i))
			wr->seekend = 0;
	    }
	    exit_short_cr5;
	    return;
	}
	
	handle_seekint();
	exit_short_cr5;

}

handle_seekint()
{
	register struct dtb_que *dptr;
	register struct seek_que *sptr;
	register struct seek_per_disk *spd_ptr;
	register struct devq *dev;
	struct smdrd *rd;
	struct smdwr *wr;
	struct devq *last_ptr,*sector_ptr;
	register short cylinder;
	register i;
	unsigned int *io_count;
	struct devq *ap;
	unsigned int count;

	/* we need to determine which drive has completed seeking */

	rd = (struct smdrd *)DK_STSR;
	wr = (struct smdwr *)DK_BUSW;
	sptr = &seekque;
	for ( i=0; i<MAX_PDRIVE; i++,rd++,wr++) {
		if (sptr->seek_active & BIT(i)){ 
		 	if(rd->unitstus & SEEKEND)
				sptr->seek_active &= UNBIT(i);
			else{
				wr->seekend = ENSEEKEND;
				continue;
			}
		}
		else continue;

		spd_ptr = &sptr->s_p_d[i];
		if ( (dev= spd_ptr->s_first) == 0){
			printf("no seek request on the queue\n");
			continue;;
		}
		if(!(dev->q_mmu)){
			io_count = io_counter_array[i] ;
			*(io_count+1) += (clock_cnt - time_counter_array[i]);
		}

	/* disable 'enable seek end' interrupt bit */
		wr->seekend = 0;
	
		spd_ptr->s_time = 0;
		if ( dev->q_flag & OPEN_DISK) 
			continue;


	/* check to see if there was any error during the seek */


		if ( checkseek (dev, spd_ptr) ) {
			spd_ptr->current_cyl = -1;
		/* ************************ */
		/* check to see if we need to retry the seek */
		/* If the no retry bit is set or we have exceeded the */
		/* retry count for this request, send the request back */
		/* ************************ */
			if ( (dev->q_flag & NO_RETRY) || (++dev->retry >= RETRY) ) {
			/* ******************************* */
			/* we do not need to retry, send the request back */
			/* ******************************* */

				finreq (dev,1);		/* interrupt the master cpu 
						   for this response */
				ipque.i_p_first->rc1 = dev->rc1;
				if((spd_ptr->s_first = dev->q_next) == (struct devq *)0)
					spd_ptr->s_last = (struct devq *)0;
				else
					if(sptr->disk_seek_ptr == (struct seek_per_disk *)0) 
						sptr->disk_seek_ptr = spd_ptr;
	
			}
			else {
			/* ************************************ */
			/* retry, rezero first, then seek again */
			/* ************************************ */
				if ( dkrezero (dev->q_devnum,spd_ptr) ) {
				/* ********************************** */
				/* we have a rezero problem, cancel all*/
				/* requests                           */
				/* ********************************** */
					cancelreq (spd_ptr);
					if(ipque.i_p_first->q_key == dev->q_key)
					    ipque.i_p_first->rc1 = dev->rc1;
				}
			}
			sptr->seek_active &= ~(UPPERBIT(i));
			continue;

		}

	/* The seek is ok. Put this request, and any other request for the
	same cylinder, on the dtbque. 
	*/

		cylinder = dev->q_devun.pdisk.cyl;
		spd_ptr->current_cyl = cylinder;
		dptr = &dtbque;
	
		sector_ptr = dev;
		last_ptr = (struct devq *)0;
	
		count =0;
		while(dev && (dev->q_devun.pdisk.cyl == cylinder)){
			count++;
			last_ptr = dev;
			if(spd_ptr->sort_ptr == dev)
				spd_ptr->sort_ptr = dev->q_next;
			dev = dev->q_next;
			spd_ptr->s_first = dev;
		}

/*
		if ( count > 2 ){
			resort(&sector_ptr,&last_ptr);
		}
*/
		if(dptr->d_first)
			dptr->d_last->q_next = sector_ptr;
		else
			dptr->d_first = sector_ptr;
		dptr->d_last = last_ptr;
		dptr->d_last->q_next = (struct devq *)0;

		if(spd_ptr->s_first == (struct devq *)0)
			spd_ptr->s_last = 0;

			
		if((sptr->disk_seek_ptr == (struct seek_per_disk *)0) &&
	    	(spd_ptr->s_first))
			sptr->disk_seek_ptr = spd_ptr;


	}

}







/* ************************************* */
/* ddc interrupt service routine LEVEL 6 */
/* ************************************* */

ddcint() {

	register struct dtb_que *dptr;

	dtc_ctl &= ~DDCINT_EN;
	*DTC_CRL = dtc_ctl;

	inturpt |= DDC_INT;
	dptr = &dtbque;
	
	if((dptr->d_first->q_flag&OPEN_DISK)==0)
		ckdisktape(DISK);
	else{
		if((dptr->d_first = dptr->d_first->q_next) == (struct devq *)0)
			dptr->d_last = (struct devq *)0;
		dptr->d_tick = 0;
		dptr->dtb_active &= ~DISK;
	}
	
		
}



/* interrupts are disabled */
cancelreq (spd_ptr)
register struct seek_per_disk *spd_ptr;
{

	register struct devq *dev;

	/* we have not started seeking but the drive has a problem */
	/* send all pending requests back */
	/* interrupts are still disabled */

	while ( (dev = spd_ptr->s_first) != (struct devq *)0 ) {
		spd_ptr->s_first = dev->q_next;
		dev->rc1 = DER_SEEK;
		finreq (dev,1);
	}
}

blkyellow()
{	
	if ( (dtc_ctl & 0x03) != yellowlit )
		LIGHT (yellowlit);
	else
		LIGHT (ledoff);
}
/* ****************************************************************** */
/* Level 4 interrupt, can be DTB_INT or CHN_EN or DTB_EN or ....      */
/*								      */
/* ****************************************************************** */
 
ckdisktape(type)
register unsigned char type;
{
	register struct devq *dev;
	register struct dtb_que *dptr;
	register struct tp *taptr;
	register struct interim_processing_que *ip;

	/* ********************************************************* */
	/* if disk rw is active, check if it is done                 */
	/* completed rw: ddc interrupt, chain dma done, dtb dma done */
	/* hit alt sector: ddc interrupt,chain dma done,alt dma done */
	/* data overrun: ddc interrupt, chain dma done               */ 
	/* ********************************************************* */

	dptr = &dtbque;
	ip = &ipque;
	dev = dptr->d_first;

	if ( type == DISK){
		     if( ( (inturpt & MM_MASK) == MM_MASK ) ||

		     ( (inturpt & MMA_MASK) == MMA_MASK) ||

		     ( (inturpt & MME_MASK) == MME_MASK) || 

		     ( (inturpt & MM1_MASK) == MM1_MASK) ||

		     ((dev->q_flag & (DK_TO_LOC|LOC_TO_DK)) &&

		     ((((inturpt & LOC_MEM_MASK) == LOC_MEM_MASK)) || 

		     (((inturpt & LOC_MEM_AMASK) == LOC_MEM_AMASK)))) ){

		/* disk rw is finished with the DTB, reset the dtb interface*/
		/* also, if the next dtb request is zero or for another device
		   turn off the seek active bit for this drive */
			*DTB_CR = 0;
			if((dptr->d_first->q_next==(struct devq *)0)|| 
			    (dptr->d_first->q_devnum != 
			    dptr->d_first->q_next->q_devnum) ||
				(dptr->d_first->q_devtype != dptr->d_first->q_next->q_devtype))
				seekque.seek_active &= 
			   	    ~(UPPERBIT(dptr->d_first->q_devnum));

			finrw ();
			if((dev->q_flag & (OVR_ERROR|DK_TO_LOC)) == 
			(OVR_ERROR|DK_TO_LOC) || (dev->q_flag & (OVR_ERROR|
			MAIN_TO_LOC)) == (OVR_ERROR|MAIN_TO_LOC) ||
			((dev->q_flag & RETRY_CRC) && dev->retry<=RETRY &&
			dptr->d_first))
				/* redo CRC from dtbque, (if on queue)  */
				seekque.seek_active |=(UPPERBIT(dev->q_devnum));
			dptr->d_tick = 0;
			dptr->dtb_active &= ~DISK;

	/* First check to see if any seek requests were completed but could not
	   be handled due to the fact that a disk read/write operation was in
	   progress
	*/
		    if(seekque.seek_active & 0xf)
			handle_seekint();


		}
		else if (  (inturpt & DTB_MASK) == DTB_MASK ) {

			if(dev->q_flag & LOC_TO_MAIN){
			  if(!(dev->q_flag&OVR_ERROR))
			    return_to_free(dev,ip);
			  if(dev->q_flag&FREE_REQ)
			    ip->i_p_count += dev->q_count;
			  finreq(dev,0);
		   	  dptr->d_tick = 0;
			  dptr->dtb_active &= ~DISK;

			}
			else if(dev->q_flag & MAIN_TO_LOC){
				dev->q_flag &= ~MAIN_TO_LOC;
				dev->q_flag |= LOC_TO_DK;
				dptr->d_tick = 0;
				dptr->dtb_active &= ~DISK;
			}
		}
		return;
	}

	/* ************************************************* */
	/* if DTB active, must be tape request transfer data */
	/* check if done */
	/* ************************************************* */

	else if (  (inturpt & DTB_MASK) == DTB_MASK ) {

	    dptr->dtb_active = 0;
	    dptr->d_tick = 0;

	    if(type & TAPE){
		/* interrupts are disabled, tape req is finished sending or 
			receiving data from main memory
		if tape read, then put req on the response que, inturpt 
			master cpu, then check for any pending disk io 
		if tape write, start the tprw, if error, then put
			req on the response que, interrupt the master cpu, 
			then check for any pending disk io */


		/* *************************** */
		/* take care archive & 9 track */
		/* *************************** */

		taptr = &tapdr[dev->q_devnum];

		if ( dev->q_cmd == TPREAD ) {

		    if(dev->q_devtype == TAPE){
			return_to_free(dev,ip);
			if(dev->rc1){
				ip->i_p_block = FINISHED;
				*(short *)&ip->i_p_first->rc1= *(short *)&dev->rc1;
			}
		    }
			
		    if((!(dev->rc1)) && (ip->i_p_first->q_devtype ==
			dev->q_devtype)){
			if(dev->q_devtype == TAPE9)
				ip->i_p_block = FINISHED;
		    }
		    ip->i_p_count += dev->q_count;
		    *((short *)&ip->i_p_first->sectleft)= *((short *)taptr->tp_stat);

			finreq (dev,0);
		}	
		else {

			dev->retry = 0;
			if(dev->q_flag & TAPE_CMPLT){
			    return_to_free(dev,ip);
			    finreq(dev,0);
			    return;
			}
				
			if((dptr->d_first = dev->q_next) == (struct devq *)0)
				dptr->d_last = (struct devq *)0;
			dev->q_flag &= ~MAIN_TO_LOC;
			dev->q_flag |= LOC_TO_TAPE;
			if(tapeque.t_first)
				tapeque.t_last->q_next = dev;
			else
				tapeque.t_first = dev;
			tapeque.t_last = dev;
			dev->q_next = 0;

		}
	    }
	    else if(dev->q_devtype == DTLBUF){
		
		ipque.i_p_active |= MMUTABLE_IN;
		ipque.i_p_mmutable->length2 = -1;
		finreq(dev,0);
	    }

	}

	return;
}

#ifdef ARCH
ckarchtape(dev)
register struct devq *dev;
{
	register b0, b1;

	if ( (dev->opr == TREAD) || (dev->opr == TWRITE) ) {
		/*  assume that the tapedma is finished,followed by tapeint */
		/* check to see if the tape has any error, set the return code*/
		/* see if the tape drive timed out */
		if ( cktaperw(dev) ) {
			dev->q_count=dev->q_count-(*TP_DMAE+1- *TP_DMAS);
			if ( (dev->rc1 == TP_EOM) || (dev->rc2 == TP_EOM) )
				dev->q_count--;
			else if((dev->q_count & (TAPEBLK-1)) || ((dev->q_count == 0) && (dev->rc1 == 0)))
				dev->rc1=TP_ILLCMD;
			if ( PRINT1 )
				printf("RWEX(%x)",dev->q_count); 
		}
	}

	else {
		/* rewind, tension, erase, Q11/Q24 commands */
		/* read file mark, write file mark */

		if ( ckexcpt (dev) )
			return;		/* tape hung or power fail */

		if ( dev->opr == TRFM ) {
			b0 = TRFM_M0;
			b1 = TRFM_M1;
		}
		else if ( dev->opr == TWFM ) {
			b0 = TWFM_M0;
			b1 = TWFM_M1;
		}  
		else {
			b0 = T_M0;
			b1 = T_M1;
		}
		setrc ( dev, b0, b1 );
	}
	return;
}
#endif


close_out_tape(dev)
register struct devq *dev;
{
	register struct tp *taptr;
	register struct dtb_que *dptr;
	register struct interim_processing_que *iptr;
	struct mmutbl * mmu;
	register short mmu_value;



	dtc_ctl &= ~TAPEINT_EN;
	*DTC_CRL = dtc_ctl;

	dbc_cr &= ~TP_EN;
	*DBC_CR = dbc_cr;

	taptr = &tapdr[dev->q_devnum];
	iptr = &ipque;

	tapeque.t_active = 0;

	/* *********************** */
	/* turn off TICK for tape */
	tapeque.t_tick = 0;
	/* *********************** */
	if ( dev->q_flag & NO_WAIT) {

		/* ************************************* */
		/* ************************************* */
		/* take care of archive tape and 9 track */
		/* ************************************* */
		/* ************************************* */
#ifdef ARCH
		if ( taptr->tp_type & TP_ARCH ) {
			ckarchtape(dev);
		/* ************************************************ */
		/* return tape status in dev->sectleft          */
		/* ************************************************ */
 		    	if(dev->q_flag&FREE_REQ)
 				*((short *)&ipque.i_p_first->sectleft)= 
				   *((short *)taptr->tp_stat);
		}


#endif
#ifdef TRACK9
		if ( taptr->tp_type & TP_9TRK ) {
			if ( ck9taperw(dev, taptr) ) {
				/* **************************************** */
				/* retry for 9 track, don't send response   */
				/* to master cpu 			    */
				/* **************************************** */
				return;
			}
		}
#endif

		/* disable tape dma enable bit */
		inturpt &= ~(TAPEDMA_INT | TAPE_INT);

		/* ********************************** */
		/* we are finished with this tape operation */
		/* ********************************** */



 		if ( (dev->q_cmd == TPREAD) && ((int)dev->q_count > 0 )) {
			/* put the request on the dtb queue to be transferred
			   to the master */
			if((dev->q_count&~3) == 0){

	/* If we are reading for a non long word count, and that count
	is less than one long word in length, we must put
	the address of the final bytes in the 'q_mem' slot of the
	response so that the master can transfer them. The actual bytes are
	placed in the 'q_mmu' slot of the response
	*/
			   	iptr->i_p_first->q_mem = (char *)
				    (((iptr->i_p_mmutable->mmuslots[(short)dev->q_mmu]
					<<12) | (int)(dev->q_mem)));

				
				iptr->i_p_first->local_mem = (struct free_mem *)
					(*(int *)(((int)dev->local_mem->fm)));
				if((tapeque.t_first = dev->q_next) == 
					(struct devq *)0)
					tapeque.t_last = (struct devq *)0;
				iptr->i_p_count += dev->q_count;
				iptr->i_p_block = FINISHED;
				*((short *)&iptr->i_p_first->sectleft)= *((short *)taptr->tp_stat);
				finreq(dev,1);
				return;
			}

			dev->q_flag &= ~TAPE_TO_LOC;
			dev->q_flag |= LOC_TO_MAIN;
			dptr = &dtbque;
			if((tapeque.t_first = dev->q_next) == (struct devq *)0)
				tapeque.t_last = (struct devq *)0;
			if(dev->rc1){
			    if(dev->q_devtype == TAPE9){
				if(dev->rc1 != TP_EOM){
				    iptr->i_p_block = FINISHED;
				    *(short *)&iptr->i_p_first->rc1= *(short *)&dev->rc1;
			    	    clean_up_que(dev,0);
				}
				else
					dev->rc1=0;
			    }
			    else{
			        *(short *)&iptr->i_p_first->rc1= *(short *)&dev->rc1;
			    	clean_up_que(dev,0);
			    }
			    *((short *)&iptr->i_p_first->sectleft)= *((short *)taptr->tp_stat);
			}

			if ( dptr->d_first ) 
				dptr->d_last->q_next = dev;
			else
				dptr->d_first = dev;
			dptr->d_last = dev;
			dev->q_next = 0;

			return;
		}
 		else if((int)dev->q_count < 0)
 			dev->q_count = 0;	/* small block or blank error */

		/* *************************** */
		/* 1 tape write                */
		/* 2 tape read with no data    */
		/* 3 tape position cmd         */
		/* send request back to the master cpu */
		/* *************************** */


		/* ********************************** */
		/* free up tape for next tape request */
		/* ********************************** */

		if(burstid){
			*(unsigned short *)&iptr->i_p_first->sectleft = burstid;
			burstid = 0;
		}
		if((dev->q_cmd == TPWRITE) || (dev->q_cmd == TPREAD)){
			iptr->i_p_count += dev->q_count;
			if(dev->rc1){
				*(short *)&iptr->i_p_first->rc1= *(short *)&dev->rc1;
				if(dev->retry > T9_RETRY)
				    *((short *)&iptr->i_p_first->sectleft)= last_stat;
				else
				    *((short *)&iptr->i_p_first->sectleft)=
					*((short *)taptr->tp_stat);
				/* there are blocks of data on the dtb queue *
				*  don't send back the request until all the *
				*  data has been transferred */
				if(dev->rc1 != TP_FMD && dev->rc2 != TP_FMD)
					iptr->i_p_block = FINISHED;
				clean_up_que(dev,0);
				return;
			}
			if(dev->q_devtype == TAPE)
				return_to_free(dev,iptr);
		}
		if((tapeque.t_first = dev->q_next) == (struct devq *)0)
			tapeque.t_last = (struct devq *)0;

		finreq (dev,1);

	}

}


/* This routine is called when we either have an error or hit a file mark
when reading the tape.  Since there are usually several requests for the
tape queued up, it is necessary to remove all of the requests for this
device from the queue, put them back on the free request queue and free
up the local memory that they are using.
After all of this is done, it is also possible that some requests for this
drive completed the tape requests properly and were place on the dtb queue
but the data has not yet been transferred to main memory.  In this situation,
we will assume that the dtb transfer will complete so we must get the
byte count from these requests to pass on up with the tape request to which
they belong.
*/

extern que_cnt;
clean_up_que(dev,dtb_error)
register struct devq *dev;
register unsigned short dtb_error;
{
	register struct interim_processing_que *iptr;
	register struct devq *que_ptr,*tmp;
	register struct devq *last_que_ptr = (struct devq *)0;
	register struct tape_que *tape_ptr;
	unsigned char first_new_device = 1;
	struct devq *last,*tail,*first,*head;
	int flag=0;

	
	tape_ptr = &tapeque;

	if(dev->q_devtype & TAPE){
		que_ptr = tape_ptr->t_first;
		iptr = &ipque;

		while(que_ptr){  
	    	    	if(que_ptr->q_devnum == dev->q_devnum){
				if(iptr->i_p_dqfirst)
					iptr->i_p_dqlast->q_next = que_ptr;
				else
					iptr->i_p_dqfirst = que_ptr;
				iptr->i_p_dqlast = que_ptr;
				que_cnt++;
				if(que_ptr->q_devtype == TAPE)
					return_to_free(que_ptr,iptr);
		    	}
		    	else{ 
				if(first_new_device){
					first_new_device = 0;
					tape_ptr->t_first = que_ptr;
					last_que_ptr = que_ptr;
		        	}
				else{
					last_que_ptr->q_next = que_ptr;
					last_que_ptr = que_ptr;
				}

		    	}
		    	    que_ptr = que_ptr->q_next;
		    	    iptr->i_p_dqlast->q_next = (struct devq *)0;
		}
		if(tape_ptr->t_first->q_devnum == dev->q_devnum)
			tape_ptr->t_first = (struct devq *)0;
		tape_ptr->t_last = last_que_ptr;
		if(last_que_ptr)
			last_que_ptr->q_next = (struct devq *)0;
		if( dev->q_cmd == TPREAD)
			return; /* tapeque cleared, let the requests already *
				 * on the dtb queue clear normally */
	}

	/* Now check the dtb queue */
	
	first = dtbque.d_first; /* set head */
	tail = dtbque.d_first; 	/* set tail */
	head = dtbque.d_first; 	/* set new head */

	for((que_ptr = dtbque.d_first);que_ptr;que_ptr=tmp){
		tmp=que_ptr->q_next; /* keep place */
		if(que_ptr->q_key == dev->q_key){
			if(dtb_error)  { /* clear all with key == */
				if(que_ptr != head){
					tail->q_next = 0; /* put on end */
					finreq(que_ptr,1);
				}
				else{
					head = tmp; /* set private head */
					tail = tmp;
					finreq(que_ptr,1);
				}
			}
			else{
			        if(dev->q_cmd == TPWRITE)
					if((first == que_ptr) && 
				    	(dtbque.dtb_active )){
						que_ptr->q_flag |= TAPE_CMPLT;
						continue;
					}
				
				if(que_ptr==head) {
					head = tmp;
				      	tail = tmp;
				}
				else
					tail->q_next = tmp; /* put on end */
				finreq(que_ptr,1);
				if(que_ptr->q_devtype == TAPE)
					return_to_free(que_ptr,iptr);
			}
		}
		else
			if((tail != head)||(head!=que_ptr)){
				tail->q_next = que_ptr;
				tail = que_ptr;
			}
	}
	dtbque.d_first = head;
	dtbque.d_last = tail;
}

return_to_free(dev,ip)
register struct devq *dev;
register struct interim_processing_que *ip;
{

       if(ip->freemem_first)
		ip->freemem_last->fm_next = dev->local_mem;
       else
	    	ip->freemem_first = dev->local_mem;

       ip->freemem_last = dev->local_mem;
       dev->local_mem->fm_next = (struct free_mem *)0;

}

#ifdef S90
/*	transfer a block of data between main memory and DTC memory
	dtbptr : (DTB parameter) pointer to an 8 byte buffer containing:
			dtbptr:direction|board_id
			dtbptr+1: slot number of memory
			dtbptr+2,3: long word cnt(actually count-4)
			dtbptr+4,5,6,7: main memory address >>2(0 in this case)
	locmem:		pointer to DMA_READ_BUF array in bddesc structure
	direction:	RD_DTB: DTB -> local mem (receive data from main mem)
*/

static char flag=0;

quick_read(dev)
struct devq *dev;
{
	register unsigned char *bufptr;
	register *locmem,i;
	unsigned short timeout;

	locmem=(int *)(DMA_READ_BUF + 8); /* area to write data */
	bufptr=(unsigned char *)DMA_READ_BUF; /* parameters for DMA */

	if(flag == 0){	/* do once and save */
		if(!(dev->q_flag&DK_TO_MAIN))
			return;
		flag++;
		if ( dev->q_mem == 0){	/* program dma from ipque */
			*(bufptr+1)=(unsigned char)((((int)ipque.i_p_mmutable->
			   mmuslots[1]&0xf0000000)>>28)<<4)&0xf0; /*load slot */
		}
		else {		 /* block transfer */
		    *(bufptr+1)=(unsigned char)((((int)dev->q_mem & 	
			0xf0000000)>>28)<<4)&0xf0;/*load slot */
		}

		*bufptr= RD_DTB | bddesc.bd_dtbid;/*direction|boardid num */
		*(short *)(bufptr+2)=1;/* long word ct */
		*(int *)(bufptr+4)=0x100; /* address on memory board */
	}

		/* clear interrupt status */
	inturpt &= ~(DTB_INT | DDCDMA_INT | DDADMA_INT | CHNDMA_INT | 
  			DTBDMA_INT | DDC_INT);
		/* program CHAIN DMA start & end address with 
			8 bytes buffer containing DTB parameters */
	*(short *)((int)DDC_DMAS + CHNDMA)=(short)bufptr;
	*(short *)((int)DDC_DMAE + CHNDMA)=(short)((int)bufptr + 4);

	/* program the DTB DMA starting & ending address with 
		the DTC local data buffer address */
	*(short *)((int)DDC_DMAS + DTBDMA)=(short)locmem;
	*(short *)((int)DDC_DMAE + DTBDMA)=(short)((int)locmem);

	/*** enable CHAIN DMA, DDA dma program data path ***/

	/* receive data from main memory */
	dtb_cr=FS_RDCHN;

	/* DBC control register : DTB/DISK data path mode */
	dbc_cr=(dbc_cr & CR_MASK) | LOCMDTBX | RDDTB;
	*DBC_CR=dbc_cr;

	/* DTB control register : DTB function code */
	*DTB_CR=dtb_cr;

	/* DBC control register: enable DTB dma, CHAIN dma */
	dbc_cr=dbc_cr | DTB_EN | CHN_EN; 
	*DBC_CR=dbc_cr;

	/*** DDA and CHAIN enabled  ***/


	/* ******************** */
	/* set a timer incase the DTB gets hung up */
	/* ******************** */
	timeout=TIMEOUT;
	for (i=0; i<0x10000; i++) {
			if(*DBC_SR & DTB_DONE){
			timeout=0;
			break;
		        }
	}
	if(timeout)
	    if(PRINT1)
 		printf("timeout inturpt= 0x%x",inturpt);

	/* clear both the CHAIN DMA & DTB DMA done bit */
	dbc_cr &= ~(CHN_EN + DTB_EN);
	*DBC_CR=dbc_cr;
	inturpt &= ~(DTB_INT + DTBDMA_INT + CHNDMA_INT);

	*DTB_CR=0;

	return ;
}
#endif S90
