
#include "hsdtccpu.h"
#include "hsdtdtc.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevstr.h"
#include "devcmd.h"
#include "hsdtdevdq.h"
#include "hsdttape.h"
#include "hsdttape9.h"
#include "hsdterror.h"
#include "hsdtextrn.h"
#include "vreg.h"


struct tcmd {
	short opr; int (*io)();
};

#ifdef ARCH

extern int tprw(), tapepos(), trwfm();
int tapstatus();
struct tcmd taptbl[] = {
	0,	0,		/* 0 */
	TREAD,	tprw,		/* 1 */
	TWRITE,	tprw,		/* 2 */
	TREW,	tapepos,	/* 3 */
	TWFM,	trwfm,		/* 4 */
	TRFM,	trwfm,		/* 5 */
	TSTATUS,tapstatus,	/* 6 */
	TENS,	tapepos,	/* 7 */
	TERAS,	tapepos,	/* 8 */
	0,	0,		/* 9 */
	0,	0,		/* a */
	0,	0,		/* b */
	0,	0,		/* c */
	TQ11,	tapepos,	/* d */
	TQ24,	tapepos,	/* e */
};
#endif

#ifdef TRACK9
extern int t9rw(), t9control();
int tap9status(), t9reset();
struct tcmd tap9tbl[] = {
	0,		0,		/* 0 */
	T9READ,		t9rw,		/* 1 */
	T9WRITE,	t9rw,		/* 2 */
	T9REW,		t9control,	/* 3 rewind */	
	T9FMW,		t9control,	/* 4 write filemark */
	T9FMF,		t9control,	/* 5 read filemark */
	T9STATUS,	tap9status,	/* 6 */
	0,		0,		/* 7 tension */
	T9ERASE,	t9control,	/* 8 erase to end */
	T9ERAFIX,	t9control,	/* 9 erase fix length */
	T9RECF,		t9control,	/* a space record forword */
	T9RECR,		t9control,	/* b space record reverse */
	0,		0,		/* c position */
	0,		0,		/* d unused */
	0,		0,		/* e unused */
	T9DENHI,	t9control,	/* f density */
	T9STR_HI,	t9control,	/* 10 tapespeed, hi or low */
	T9STR_HI,	t9control,	/* 11 tapemode, stream or start/stop */
	T9FMR,		t9control,	/* 12 space filemark reverse */
	T9STATUS,	t9reset,	/* 13 reset 9 track */
};
#endif
	
taparse(dev)
register struct devq *dev;
{
	register unsigned short intfcard;
	register struct tcmd *p;
	register struct tp *taptr;
	register struct devq *dq;
	register rc;

	/* check to see if the tape is online */

	
	dev->sectleft = 0; /* make sure to zero (for return errors) */
	if ( dev->q_devnum >= MAX_TDRIVE ) {
		dev->rc1 = TP_NRDY;
		return(1);
	}
	taptr = &tapdr[dev->q_devnum];

	if ( dev->q_devtype == TAPE9 ) {
		/* better be 9 track interface card */
		if ( (*TP_SR & TP_INFC) != TP_9TRKIF ) {
			dev->rc1 = TP_INVIF;
			return(1);
		}
	}

#ifdef ARCH
	if ( (taptr->tp_type & TAPEON) == 0 ) {
		/* only check archive tape drive is it is not online */
		if ( (intfcard = *TP_SR & TP_INFC) != TP_9TRKIF ) {
			if ( setape(dev->q_devnum) ) {
				dev->rc1 = TP_NRDY;
				return(1);
			}
		}
	}
#endif

#ifdef TRACK9
	/* 9 TRACK */
	if ( taptr->tp_type & TP_9TRK ) {
		
		p = &tap9tbl[dev->q_cmd];
		if ( (p->opr == 0) || (dev->q_cmd >= TOT9CMD) ) {
			dev->rc1 = TP_ILLCMD;
			return(1);
		}

		/* put in 9 track operation code */
		dev->opr = p->opr;

		/* don't allow partial tape blk */
		if ( (dev->q_cmd == TPREAD) || (dev->q_cmd == TPWRITE) ) {
			if ((dev->q_count == 0) || (dev->q_count > T9MAXCNT) ) {
				dev->rc1 = TP_CNT;
				return(1);
			}
			if((int)dev->q_mem & 0x03){
				dev->rc1 = TP_MEM;
				return(1);
			}


			/* memory address / 4 for 16k buffer */
#ifndef S90
			dev->q_mem = (char *)((int)dev->q_mem >> 2);
#endif
		}

		if ( dev->q_cmd == DENSITY ) {
			if ( dev->q_devun.block == DENS_1600 )
				dev->opr = T9DENLOW;
			else if ( dev->q_devun.block == DENS_6250 )
				dev->opr = T9DENHI;
			else {
				dev->rc1 = TP_DENS;
				return(1);
			}
		}

		/* set the speed of 9 track */
		else if  ( dev->q_cmd == TAPESPEED ) {
			if ( dev->q_devun.block == SPEED_HI )
				dev->opr |= (taptr->tp_stat[2] & MASK_SPEED)
					 | HISPEED;
			else if ( dev->q_devun.block == SPEED_LOW )
				dev->opr |= (taptr->tp_stat[2] & MASK_SPEED) 
					| LOWSPEED;
			else {
				dev->rc1 = TP_SPEED;
				return(1);
			}
		}

		/* set the 9 track in stream mode or start_stop mode */
		else if ( dev->q_cmd == TAPEMODE ) {
			if ( dev->q_devun.block == MODE_STARTSTP )
				dev->opr |= ( taptr->tp_stat[2] & MASK_STRM ) | STARTSTP;
			else if ( dev->q_devun.block == MODE_STREAM )
				dev->opr |= (taptr->tp_stat[2] & MASK_STRM) | STREAM;
			else {
				dev->rc1 = TP_MODE;
				return(1);
			}
		}

		dev->q_flag |= NO_WAIT;

		return(0);
	}
#endif

#ifdef ARCH

	if ( taptr->tp_type & TP_ARCH ) {
		/* ******************** */
		/* archive tape command */
		/* ******************** */
	
		p =  &taptbl[dev->q_cmd];
		/* check for valid tape command */
		if ( (p->opr == 0) || (dev->q_cmd >= TOTPCMD) ) {
			dev->rc1 = TP_ILLCMD;
			return(1);
		}
	
		/* don't allow  a non long word multiple tape blk 
		   or one with a zero length or one of greater than
		   0x40000 bytes 
		*/

		if ( (dev->q_cmd == TPREAD) || (dev->q_cmd == TPWRITE) ) {
			if((dev->q_count & 3) || (dev->q_count == 0)
				|| (dev->q_count > TAPE_MAX_CNT)){
			 	dev->rc1 = TP_CNT;
				return(1);
			}


#ifndef S90
			dev->q_mem = (char *)((int)dev->q_mem >> 2);
#endif
		}

	
		/* setup archive tape cmd code */
		dev->opr = p->opr;
	
		if ( dev->rc1 == TP_HANG ) {
			printf ("p9");
			resetape();
			dev->rc1 = TP_RSET;
		}
		dev->q_flag |= NO_WAIT;
		return(0);
	}
#endif

	/* not archive, not 9 track */
	dev->rc1 = TP_NRDY;
	return(1);
}
#ifdef ARCH

tapstatus(dev)
register struct devq *dev;
{
	tstatus(dev);

	/* *********************** */
	/* get archive tape status */
	/* *********************** */
	*((short *)&dev->sectleft)= *((short *)tapdr[0].tp_stat);

	/* get type of tape in dev->q_count */
	tapetype(dev);

	return(1);
}
#endif

tapetype(dev)
register struct devq *dev;
{	register unsigned char type;
	type = tapdr[dev->q_devnum].tp_type;
	if ( type & TP_ARCH )
		dev->q_count = TP_ARCH;
	else if ( type & TP_9TRK )
		dev->q_count = TP_9TRK;
	else
		dev->q_count = 0;
}

#ifdef TRACK9
tap9status(dev)
struct devq *dev;
{
	unsigned char not_rewinding = 1;
		
	if(tp9status(dev)>0) not_rewinding = 0;

	/* get type of tape in dev->q_count */
	tapetype(dev);
	
	return(not_rewinding);
}
t9reset(dev)
struct devq *dev;
{
	resetape9();
	return(1);
}
#endif

prtbl (value, tbl)
register value; char *tbl[];
{	register i;

	for (i=0; i<8; i++) {
		if ( value & 0x80 )
			printf ("%s ", *tbl);
		tbl++;
		value = value << 1;
	}
	printlf();
}

ckbyte (dev, status, num, err)
register struct devq *dev;
register unsigned char status; register num; register char *err;
{
	register i;
	for (i=0; i<8; i++) {
		if ( status & 0x80 ) {
			if ( *(err+i) ) {
				if ( num == 0 )
					dev->rc1 = *(err+i);
				else
					dev->rc2 = *(err+i);
				num++;
			}
			if ( num == 2 )
				return (num);
		}
		status = status << 1;
	}
	return (num);
}
