#include "hsdtccpu.h"
#include "hsdtdtc.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdevstr.h"
#include "hsdtextrn.h"
#include "vreg.h"
#include "data_struct.h"


/* 12 bytes of each sector ID field */
#define SECID_LEN	12


/* ************************************************************ */
/* we can handle a maximum of 0x55 (85) sectors per track       */
/* format any number of sectors on the same track                */
/* input:	dev->q_devun.pdisk.sector = starting sector num */
/* 		dev->scnt = total number of sectors to format on the track */
/* output:	return 0 if ok
/* ************************************************************ */

wridsec (dev, dkptr)
register struct devq *dev;
struct dkinf *dkptr;
{
	register char *ptr;
	register short  num; register unsigned short i;
	register unsigned char startsec;
	struct free_mem *dq;
 
	ptr = (char *) ipque.freemem_first->fm;
	dq = ipque.freemem_first;
	dev->local_mem = dq;
	ipque.freemem_first = ipque.freemem_first->fm_next;

	num = dev->scnt;			/* # of sec */
	startsec = dev->q_devun.pdisk.sector;	/* first sector number */

	/* write sector ID from local buffer, and wait for operation */
	dev->q_flag |= (LOC_TO_DK | WAIT);

	/* create sector ID in local buffer */
	/* each sector takes up 3 long words */
	while ( num-- ) {
		*ptr++ = FMTFLAGS;
		*ptr++ = *(char *)&dev->q_devun.pdisk.cyl;	/* cyl hi */
		*ptr++ = dev->q_devun.pdisk.cyl;		/* cyl low */
		*ptr++ = dev->q_devun.pdisk.head;
		*ptr++ = dev->q_devun.pdisk.sector++;
		*ptr++ = 0;
		*ptr++ = 0;
		*ptr++ = 0;
		*(int *)ptr = FORMDATA;
		ptr += 4;
	}
	dev->opr = OPR_WRID;
	dev->q_devun.pdisk.sector = startsec;

	/* *************************** */
	/* retry on any write ID error */
	/* *************************** */

	for (i=0; i<RETRY; i++) {
		dev->q_devun.pdisk.sector = startsec;

		rwid (dev,dkptr, dev->scnt*SECID_LEN,0xff);
		if((*(short *)&dev->rc1) == 0){
			ipque.freemem_last->fm_next = dq;
			ipque.freemem_last = dq;
			dq->fm_next = (struct free_mem *)0;
			return(0);
		}

		/* force to reseek again */
		seekque.s_p_d[dev->q_devnum].current_cyl = -1;
	}
	ipque.freemem_last->fm_next = dq;
	ipque.freemem_last = dq;
	dq->fm_next = (struct free_mem *)0;
	return(-1);
}



/*	format single sector ID with alt sector num

	---------------------
	|Flag| CH | CL | H  |
	|S   | ACH| ACL| AH |
	|AS  | 0  | 0  | 0  |
	|0   | 0  | 0  | 0  |
	---------------------
 */

prgalt(dev, dkptr, sprptr)
register struct devq *dev;
register struct dkinf *dkptr;
register struct sprs *sprptr;
{
	register char *iptr;
	register struct free_mem *dq;

	iptr = (char *) ipque.freemem_first->fm;
	dq = ipque.freemem_first;
	dev->local_mem = dq;
	ipque.freemem_first = ipque.freemem_first->fm_next;

	*(int *)&dev->q_devun.pdisk.cyl = *(int *)&sprptr->cyl;

	dev->opr = OPR_WRID;
	dev->q_flag |= (WAIT | LOC_TO_DK);
	dev->scnt = 1;

	/* character buffer */
	*iptr++ = ALTFLAG;
	*iptr++ = *(char *)&sprptr->cyl;	/* cyl hi */
	*iptr++ = sprptr->cyl;			/* cyl low */
	*iptr++ = sprptr->head;
	*iptr++ = sprptr->sector;

	*iptr++ = *(char *)&sprptr->altcyl;	/* acyl hi */
	*iptr++ = sprptr->altcyl;		/* acyl low byte */
	*iptr++ = sprptr->althead;		/* ahead */
	*iptr = sprptr->altsector;		/* asector */

	rwid (dev, dkptr, ALT_LEN,0xff);

	*DDC_TRE = 0;
	ipque.freemem_last->fm_next = dq;
	ipque.freemem_last = dq;
	dq->fm_next = (struct free_mem *)0;
	return (0);
}
