#include "hsdtccpu.h"
#include "hsdtdisksect.h"
#include "hsdt.h"
#include "hsdtdevdq.h"
#include "hsdtdtc.h"
#include "hsdtdata.h"
#include "vreg.h"
#include "hsdtextrn.h"
#include "devcmd.h"
#include "data_struct.h"
#include "hsdtptm.h"

#define XFER_MASK (DTB_INT + CHNDMA_INT + DTBDMA_INT)
/*	
	dtbptr : (DTB parameter) pointer to an 8 byte buffer containing:
			dtbptr+2,3: long word cnt
			dtbptr+4,5,6,7: main memory address >>2
	locmem:		pointer to DTC local data buffer
	direction:	RD_DTB: DTB -> local mem (receive data from main mem)
			WR_DTB: local memory -> DTB (send data to main memory)

	transfer a block of data between main memory and DTC memory

	setup DTB param byte 0 :DMC control byte (direction & boardid)
	setup DTB param byte 1: zero
	program CHAIN DMA address with a pointer to the DTB parameters 
	    (an 8 byte buffer)
	program the DTB DMA address with the DTC local buffer address
	setup the data path mode for DTB <-> main memory transfer

*/
xferdata(dtbptr, locmem, direction, wait)
char *dtbptr, *locmem; int wait;
unsigned int direction;
{	register char *ptr; register struct dtb_que *dptr;
	register timeout, i;

	enter_short_cr;
	inturpt &= ~(DTB_INT | DDCDMA_INT | DDADMA_INT | CHNDMA_INT | 
		DTBDMA_INT | DDC_INT);

	ptr = dtbptr;

	/* setup DTB parameter: DMC dma msb byte count/control
		main memory -> DTB */
	*ptr++ = (char)(direction | bddesc.bd_dtbid);	/* hsdt boardid */
	*ptr++ = 0;

	/* program the DTB DMA starting & ending address with 
		the DTC local data buffer address */
	dmaddr ( locmem, ((*(unsigned short *)ptr) << 2)-4,DTBDMA); /* byte count */

	/* program the CHAIN DMA starting & ending address with 
		an 8 byte buffer containing DTB parameters */
	dmaddr ( dtbptr,  DTBP_LEN-4, CHNDMA);		/* byte count=8 */

	/* program the DTB/DISK data path mode for local memory <->DTB */
	mslmdkdtb (direction, ~DISK);

	if ( wait == DTBNOWAIT ) {
		dtbque.d_tick = TICK_1SEC;
		exit_short_cr;
		return(0);
	}

	exit_short_cr;

	/* wait for both the DTB interrupt and the DMA interrupt */

	/* ******************** */
	/* set a timer incase the DTB gets hung up */
	/* ******************** */
	timeout = TIMEOUT;
	for (i=0; i<0xf000; i++) {
		if ( (inturpt & XFER_MASK) == XFER_MASK ) {
			timeout = 0;
			break;
		}
	}

	/* clear both the CHAIN DMA & DTB DMA done bit */
	enter_short_cr;
	dbc_cr &= ~(CHN_EN + DTB_EN);
	*DBC_CR = dbc_cr;
	inturpt &= ~(DTB_INT + DTBDMA_INT + CHNDMA_INT);
	dptr = &dtbque;
	if((dptr->d_first = dptr->d_first->q_next) == (struct devq *)0)
		dptr->d_last = (struct devq *)0;
	dptr->d_tick = 0;
	dptr->dtb_active &= ~DISK;
	exit_short_cr;

	return (timeout);
}

/*
	DTB can't be busy
	setup data path for DTB <-> local memory/disk
	DTB function code
	enable DTB dma & CHN dma for local memory <-> DTB
	enable CHN dma & ALT dma for disk <-> DTB
	input: direction : RD_DTB = DTB -> local memory (receive data from
					main memory)
			   WR_DTB = local memory -> DTB (send data to 
					main memory)
		type= 	DISK ( disk <-> DTB )
			LOCM (local memory <-> DTB)
 */

mslmdkdtb (direction, type)
int direction, type;
{
	register ctrldata; 

	/* send data to main memory */
	if ( direction == WR_DTB) {
		dtb_cr = FS_WRCHN;
		/* local memory/disk -> DTB (write DTB) */
		if ( type == DISK )
			ctrldata = WRDTB;
		else
			ctrldata = LOCMDTBX | WRDTB;
	}
	else {
	/* receive data from main memory */
		dtb_cr = FS_RDCHN;
		/* DTB -> local memory/disk (read DTB) */
		if ( type == DISK )
			ctrldata = RDDTB;
		else
			ctrldata = LOCMDTBX | RDDTB;
	}


	/* DBC control register : DTB/DISK data path mode */
	dbc_cr = (dbc_cr & CR_MASK) | ctrldata;
	*DBC_CR = dbc_cr;

	/* DTB control register : DTB function code */
	*DTB_CR = dtb_cr;

	/* DBC control register:
		local memory : enable DTB dma, CHAIN dma
		disk:		enable CHN dma, DDA dma 
	*/
	if ( type == DISK )
		dbc_cr = dbc_cr | CHN_EN | DDA_EN;
	else
		dbc_cr = dbc_cr | DTB_EN | CHN_EN; 
	*DBC_CR = dbc_cr;

	return;
}

/*
	setup data path for disk <-> local memory
	enable DDC dma & DDC ALT dma
 */
msdklocm()
{	register unsigned short oldpri;

	/* disable interrupt */
	oldpri = spl6();

	/* data path with DISK <-> local memory */
	dbc_cr = (dbc_cr & CR_MASK) | LOCMEM;
	*DBC_CR = dbc_cr;

	/* DBC control register: enable DDC dma & DDC ALT dma */
	dbc_cr = dbc_cr | DDC_EN | DDA_EN;
	*DBC_CR = dbc_cr;

	/* enable interrupt */
	splx (oldpri);
}


dmaddr (ptr, bytcnt, dmatype)
int ptr; int bytcnt, dmatype;
{

	*(short *)((int)DDC_DMAS + dmatype) = (short)ptr;

	*(short *)((int)DDC_DMAE + dmatype)=(short)((int)ptr + bytcnt);
}

/* ********************************************** */
/* program dtb parameters for chaining dma        */
/* do not enable the dma yet                      */
/* buffer transfer into non-contiguous memory      */
/* return : number of bytes programmed 		   */
/* ********************************************** */

prgdtbchn(dev,direction)
register struct devq *dev;
{
	register unsigned short totcnt, bytecnt, index, offset,section;
	register unsigned char *ptr;
	register struct mmutbl *mmu;
	unsigned int tot1cnt;
	unsigned short index1,offset1;

	ptr = dtbarray;

	mmu = ipque.i_p_mmutable;
	if(dev->q_cmd == LREAD)
		totcnt = (dev->q_count & ~3);
	else
		totcnt=(dev->q_count&3) ? ((dev->q_count+4)& ~3) : dev->q_count;

	tot1cnt = totcnt;
	index = (short)dev->q_mmu;
	offset = (short)dev->q_mem;
	section = 0;

	while ( totcnt ) {
		/* determine how many bytes fit in next page */
		bytecnt = PAGESIZE - offset;

		if ( bytecnt > totcnt ){
			bytecnt = totcnt;
			offset1 = offset+bytecnt;
			index1=index;
		}

		/* program dtb buffer */
		*ptr = direction | bddesc.bd_dtbid;/* boardid num */
		*(ptr+1) = 0;
		*(short *)(ptr+2) = bytecnt >> 2;
		*(int *)(ptr+4) = ( (mmu->mmuslots[index] << 12) | offset )>>2;
		section++;
		index++;
		totcnt -= bytecnt;

		offset = 0;
		ptr +=8;

	}

	/* If we are reading for a non long word count, we must put
	the address of the final bytes in the 'q_mem' slot of the
	response so that the master can transfer them
	*/

	if((dev->q_count&3) && (dev->q_cmd == LREAD)){
		ipque.i_p_first->q_mem =(char *)(((mmu->mmuslots[index1]<<12) | 
			(offset1)));
		ipque.i_p_first->local_mem = (struct free_mem *)
			(*(int *)(((int)dev->local_mem->fm) + tot1cnt));
	}

	/* program CHAIN DMA start & end address with 
		dtbbuffer containing DTB parameters */
	if(tot1cnt)
		dmaddr ( dtbarray, (DTBP_LEN * section)-4 , CHNDMA);


	return (tot1cnt);

}
