/* 2/12/86 Added special CRC_RETRY count 
						PTL
*/

#define PRINT1		( printflag ==1 )
#define PRINT2		( printflag ==2 )
#define PRINT3		( printflag ==3 )

#define enter_short_cr \
{\
	asm("or.w	&0x0700,%sr");\
}
#define exit_short_cr \
{\
	asm("and.w	&0xf8ff,%sr");\
}
#define exit_short_cr2 \
{\
	asm("and.w	&0xfaff,%sr");\
}
#define exit_short_cr3 \
{\
	asm("and.w	&0xfbff,%sr");\
}

#define exit_short_cr4 \
{\
	asm("and.w	&0xfcff,%sr");\
}

#define exit_short_cr5 \
{\
	asm("and.w	&0xfdff,%sr");\
}

#define enter_short_cr5 \
{\
	asm("or.w	&0x0500,%sr");\
}


/* 2 different timing register set to use for reading sector 0 */
#define TIM_SET		3

/* retry for disk io */
#define RETRY		4
#define CRC_RETRY       8

/* page size in main memory */
#define PAGESIZE	0x1000

/* max bytes allowed for disk i/o into non-contiguous memory */
#define MAX_RAW_COUNT	(MAXPGNUM * 4 * 0x400)

/* max bytes allow for cmd 1/2, logical drive num, logical sector num */
/* contiguous main memory */ 
#define MAXBYTE	(255 * 0x400)


/* number of free que on hsdt board */
#define NQNUM	24

/* acknowledge data byte to master cpu for completing the request */
#define ICB_ACK		0x0

/* buffer use for formatting drive, setup sector zero */
/* used in mm<->loc memory xfer & tape r/w buffer */
#define LOCA	0x9000
#define LOCB	0xa000

#define LOC1	0x9000
#define LOC2	0x9800
#define LOC3	0xa000
#define DTBBUF  0x10000
#define ALTBUF  0x10020
#define DTBARRAY 0x10040



#define DTBNOWAIT	0
#define DTBWAIT		1

/* from diskio routine */
#define	SKERR 		1
#define RWERR		2
#define TIMEOUT		3
#define ALTERR		4

/* value in DEVICE */
#define DISK	1
#define TAPE	2		/* arch tape or 9 track */
#define TAPE9	0x82		/* must be 9 track */
#define PF_WAIT 0x1d		/*power fail wait for disk completion*/
#define CONSOLE 4
#define ICB	8
#define FINISHED -2		/* tape request has been completed*/

/* values in FLAG of devq structure */
#define NO_RETRY  0x1		/*disable retries on disk r/w */
#define NOALT	  0x2		/* no need to reprg c,h,s when
					we hit an alternate sector */ 
					
#define NO_WAIT     0x4		/*don't wait for completion of rewind/tension/
				erase on tape */
#define DUAL_DMA    0x8		/* use both tape dma channels for this request*/
#define OPEN_DISK   0x10	/*reading in system sectors */
#define WAIT	    0x10	/* wait for i/o to complete*/
#define ALT	    0x20	/* r/w on re-programmed c,h,s */
#define RETRY_CRC   0x80	/* set up for a crc retry */
#define FREE_REQ    0x100	/*this is one of the free requests; do not put
				it back on the response queue */
#define TAPE_CMPLT  0x200	/* a tape write request was completed while this
				request was on the dtbque */
#define RWID        0x400	/* this request is to be used for reading or 
				writing a sector id */
#define DK_TO_MAIN  0x800	/* data transfer from disk to main memory */
#define LOC_TO_DK   0x1000	/* data transfer from local memory to the disk*/
#define LOC_TO_TAPE 0x1000
#define DK_TO_LOC   0x2000	/* data transfer from disk to local memory */
#define TAPE_TO_LOC 0x2000
#define LOC_TO_MAIN 0x4000	/* data transfer from local to main memory */
#define MAIN_TO_LOC 0x8000	/* data transfer from main to local memory */
#define FUNCTION_MASK  0xfc00	/* mask to determine whether to do a disk read/
				   write, a read/write id or a dtb transfer */



struct alt {
	unsigned short cyl;
	unsigned char head;
	unsigned char sector;
};


/* (dev->flag) value in disk request */
#define FASTAPE		0x8		/* bit3: fast tape operation */




#define MAX_PDRIVE	4		/* max disk drive */
#define MAX_TDRIVE	4		/* max tape drive */
#define BLKSIZE		0x400
#define BLKSIZBIT	10		/* shift >> 10(same as div by 0x400) */

#define MAXCYL		0x400		/* hardware max cyl */

#define MMUTABLE_IN      2		/* mmutable loaded for raw io request*/


/* *************** 84meg drive ******************* */
/* number of bytes in regular sector = 0x0472 (including gap len) */
/* number of bytes in last sector = 0x046e */
#define BYTE84_SEC	0x0472046e

#define SEC84_HEAD	18
#define HEAD84_CYL	7
#define CYL84_DRV	589
#define LCYL84_DRV	588
#define SEC84_CYL	18*7


#define FORMDATA	0xa5
#define FMTFLAGS	0
#define DEFM_LEN	24	/* media defect list for each track */
#define ALT_LEN		16	/* 16 bytes for ID field */
#define ALTFLAG 	0x40	/* alt flag in sector ID field */

#define SEC0		0	/* system sector */
#define SPARESEC	2	/* spare sector */
#define SKTRKSEC	4	/* skip track sector */
#define MEDSEC		6	/* media defect sector */
#define BOOTSEC		8	/* boot information sector */
#define BADSCSEC	0x10	/* bad sectors found by disk test */

#define BOOTLEN		0x400	/* length in sectors of boot sw */


#define TOTLOG		64		/* 16 x 4 total log drive */
#define MAXDEV		8		/* max device num on hsdt board */
					/* tape, disk, mirror, console, boot */
#define NEXTSEC		0x12		/* next sector available for more
						spare, skip track table... */

#define MAXSKNUM	0x3f0		/* total num of skip track list 
					   for single HSDT card */

#define BIT(x) (1<<x)
#define UNBIT(x) ~(1<<x)
#define U_L_BIT(x) ((1<<x) | (1<<(x+4)))
#define UPPERBIT(x) (1<<(x+4))
#define UPPERBIT_MASK 0xf0


#define MTPR(port, val) *port = val	/* move to processor register */
#define MFPR(port) *port		/* move from processor register */
