h36214
s 00483/00000/00000
d D 1.1 91/03/26 07:53:07 root 1 0
c date and time created 91/03/26 07:53:07 by root
e
u
U
t
T
I 1

#	@(#)hsdtcode.mk	2.6

include $(IROOT)/macdefs

VERS	=	vers
VER	=	0x510
NAME	=	hsdtcode
SINC	=	../../head

#	special	rule for prom code, force .data become .text
NODATA	=	-Wa,-r 

# force no stack probe
NOSPRB	=	-W0,-sp
SHTWRD  =	-wnewfile

CFLAG	=	$(NOSPRB) $(NODATA) $(CFLAGS)

.SUFFIXES: .s .o .t .d .f .x 


COBJS	=	ckreq.o		cmd.o\
		disk.o \
		disk_rw.o	seek.o		seek_sort.o \
		dkparse1.o	dkparse2.o	disk_open.o \
		dkparse5.o	dkparse6.o 	raw_proc.o\
		dksub1.o	dksub2.o	dksub5.o \
		dtbxfer.o	finrw.o		icbparse.o	initdata.o \
		message.o	pgchar.o	printf.o



ARCH1	=	tapeio.o	tapesub.o
TRK9	=	tape9io.o

hsdtdisksect.h: hsdsksect.h
	ln hsdsksect.h hsdtdisksect.h

#------------------------------------
#download code for archive tape, disk, 9 track
#------------------------------------
DNOBJS	=	dnvectab.o	downcode.o	math.o		misc.o
DTPOBJS	=	main.o		dndownload.o	console.d
DTLDPOBJS  =	main.o		dndownload.o	console.d

DNTRK9	=	taparse.f	tapexio.f	inturpt.f	timer.f
DNLDTRK9  =	taparse.o	tapexio.o	inturpt.o	timer.o


all install: $(NAME)

clean:

clobber: clean
	rm -f *.o $(NAME) *.map *.f *.t *.d hsdtdisksect.h

.c.o:
	$(CC) -c -I. -I$(SINC)   $(CFLAG) $<

.s.o:
	$(AS) -r $(ASFLAGS) -o $@ $*.s

.x.s:
	$(CPP) -P -I. $< > $*.s

.x.o:
	$(CPP) -P -I. $< > $*.i
	$(AS) -r $(ASFLAGS)  -o $@ $*.i
	rm $*.i

# rule for bssdata.c (bss data)
.c.t:
	$(CC) -O -I$(SINC) $(NOSPRB) -c $*.c
	ln -f $*.o $*.t

.c.d:
	$(CC) -DDOWN -I$(SINC) -c $(CFLAG) $*.c
	ln -f $*.o $*.d

# ------------------------------------
# compile for archive tape & 9 track 
# ------------------------------------
.c.f:
	$(CC) -DARCH -DTRACK9 -I$(SINC) -c $(CFLAG) $*.c
	ln -f $*.o $*.f


$(NAME):	$(DNOBJS) $(DTLDPOBJS) $(COBJS) $(ARCH1) $(DNTRK9) $(TRK9) \
		initbd.o bssdata.t
	$(LD) -o  $(NAME) -N -m ld.prom \
		$(DNOBJS) $(DTLDPOBJS) $(COBJS) $(ARCH1) $(DNLDTRK9) $(TRK9) \
		initbd.o bssdata.o > $(NAME).map
	date >> $(NAME).map
	nm -xev $(NAME) >>$(NAME).map
	strip $(NAME)
	size -x $(NAME)
	@-echo running sapatch to put in header
	-../sapatch/sapatch -hv $(VER) $(NAME)


bssdata.t: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdttape.h \
		hsdttape9.h \
		data_struct.h \
		$(SINC)/vreg.h 

ckreq.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdata.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h \
		data_struct.h \
		$(SINC)/vreg.h 

console.d:	hsdtccpu.h \
		hsdtextrn.h

disk.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdtextrn.h \
		data_struct.h 

diskdfm.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdtextrn.h

dkio0.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h \
		hsdttape.h

dkio1.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h \
		hsdtptm.h \
		hsdtstruct.h

dkio2.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdata.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h \
		hsdtptm.h \
		hsdtstruct.h \
		$(SINC)/vreg.h 

dkparse1.o: \
		devcmd.h \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h \
		data_struct.h 

dkparse2.o: \
		devcmd.h \
		hsdt.h \
		hsdtdisksect.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdterror.h \
		hsdtextrn.h

disk_open.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h \
		data_struct.h 


dkparse5.o: \
		devcmd.h \
		hsdt.h \
		hsdtdisksect.h \
		hsdtdevdq.h \
		hsdtdevstr.h  \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h

dksub1.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdterror.h \
		hsdtextrn.h

dksub2.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h \
		hsdtvern.h \
		data_struct.h 

dksub4.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtdevdq.h \
		hsdtdtc.h \
		hsdtextrn.h

dksub5.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdtextrn.h

dksub6.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h \
		hsdtvern.h

dndownload.o:	hsdt.h \
		hsdtdisksect.h \
		hsdtdevdq.h \
		hsdterror.h \
		icbcmd.h

main.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdata.h \
		hsdtdtc.h \
		hsdtextrn.h \
		hsdtvern.h \
		data_struct.h  \
		$(SINC)/vreg.h

download.o: \
		hsdtccpu.h \
		hsdtdtc.h \
		hsdtextrn.h \
		icbcmd.h \
		$(SINC)/vreg.h

dtbxfer.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdata.h \
		hsdtdevdq.h \
		hsdtdtc.h \
		hsdtextrn.h \
		data_struct.h \
		$(SINC)/vreg.h

finrw.o: \
		devcmd.h \
		hsdt.h \
		hsdtdisksect.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h \
		hsdttape.h \
		data_struct.h 

icbparse.o: 	hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdata.h \
		hsdtdevdq.h \
		hsdtdevstr.h  \
		hsdtdtc.h \
		hsdtextrn.h \
		icbcmd.h \
		$(SINC)/vreg.h

initbd.o: 	hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdtextrn.h \
		hsdttape.h \
		icbcmd.h \
		data_struct.h \
		hsdtvern.h \
		$(SINC)/vreg.h

initdata.o:	hsdt.h \
		hsdtdisksect.h

inturpt.f: \
		devcmd.h \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdata.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h \
		hsdtstruct.h \
		hsdttape.h \
		hsdttape9.h \
		data_struct.h 

taparse.f: \
		devcmd.h \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h \
		hsdttape.h \
		hsdttape9.h

tape9io.o: \
		devcmd.h \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdata.h \
		hsdtdevdq.h \
		hsdtdevstr.h  \
		hsdtdtc.h \
		hsdterror.h  \
		hsdtextrn.h \
		hsdtptm.h \
		hsdttape9.h

tapeinit.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdtextrn.h

tapeio.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdata.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h \
		hsdtptm.h \
		hsdttape.h

tapesub.o: \
		hsdt.h \
		hsdtdisksect.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdterror.h \
		hsdtextrn.h \
		hsdttape.h

tapexio.f: \
		devcmd.h \
		hsdt.h \
		hsdtdisksect.h \
		hsdtdevdq.h \
		hsdtdevstr.h  \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h \
		hsdttape.h \
		hsdttape9.h

timer.f: \
		devcmd.h \
		hsdt.h \
		hsdtdisksect.h \
		hsdtccpu.h \
		hsdtdata.h \
		hsdtdevdq.h \
		hsdtdevstr.h \
		hsdtdtc.h \
		hsdterror.h \
		hsdtextrn.h \
		hsdtptm.h \
		hsdttape.h \
		data_struct.h 

seek.o: \
		hsdtccpu.h \
		hsdtdisksect.h \
		hsdt.h \
		hsdtdevstr.h \
		hsdtdevdq.h \
		hsdtstruct.h \
		hsdtdtc.h \
		hsdtptm.h \
		hsdterror.h \
		hsdtextrn.h \
		vreg.h \
		data_struct.h

seek_sort.o: \
		hsdtdtc.h \
		hsdtdisksect.h \
		hsdt.h \
		hsdtdevstr.h \
		hsdtdevdq.h \
		hsdttape.h \
		hsdterror.h \
		hsdtextrn.h \
		vreg.h \
		data_struct.h

downcode.o:	hsdtcpu.h

mprom.s:	hsdtcpu.h

vectab.s:	hsdtcpu.h

dnvectab.s:	hsdtcpu.h

prom.o: \
		hsdtcpu.h \
		vectab.a68

E 1
