#define SA_BOOTS
#include "disksect.h"
#include "dsetup.h"
#include "setjmp.h"
#include "a.out.h"
#include "icb.h"
#include "icbcmd.h"
#include "vreg.h"
#include "cpu.h"
#include "sysconf.h"
#include "mt.h"

#define BSIZE 0x400
#define DISK_INIT 'INIT'
#define OLD 0

#define devtype(s) (*(short *)s)
#define DISK 1
#define TAPE 2


#define DEFAULT_SOURCE "c0d0"
#define DEFAULT_DEST "c0d0r"
char source[] = DEFAULT_SOURCE;
char dest[] = DEFAULT_DEST;
extern type;
extern unsigned int nine_trk;

jmp_buf errorbuf;
int debugflag = 0; /* for the error module */
unsigned char archive_tape = 0;

char secbuf[BSIZE];
char buf[0x40000]; /* 256k buffer */

int maxsa; /* available room for sa programs */
char *pertype[] = {"0", "disk", "tape"};

unsigned int boot_start;

pversion(){
    printf("\nStandalone ldsa  (VER 6.00)\n\n");
}

int srcfd,dstfd;
char srcname[20],dstname[20];
char ans[10];

/*
 *	NEEDS BUG FIX
 *	to implement the disk to tape (or disk to disk)
 *	the boot image will have to be checked for the
 *	sector of 0's to terminate
 */

main() {
    int rc;
    int totalcount=0;
    int partialflag=0;
    int firstimageread=1;
    int i;
    char *cptr;
    int smode = 0;
    int tmode = 2;
    int dummy,ret;
    struct boot_list *b;

    pversion();


    cptr = source;
    *(cptr+1) = (SYSCONF->bootunit>>2)&3;
    setjmp(errorbuf);
#if OLD
    printf("Insert BOOTIMAGE tape, <CR> ");
    gets(srcname);
    strcpy(srcname, DEFAULT_SOURCE);
    srcfd = opensa(srcname,"mt");
#else 
    printf("Source device <CR> defaults to TAPE device %s: ",DEFAULT_SOURCE);
    gets(srcname);
    if(srcname[0] == '\0')
	strcpy(srcname, DEFAULT_SOURCE);

    srcfd = opensa(srcname,((srcname[4]) ? "rv" : "mt"),smode);
    if(nine_trk){
	if((ret = mtioctl(SYSCONF->bootunit,TAPESTAT,dummy)) < 0){
		printf("cannot stat tape device\n");
		exit(1);
	}
    }
#endif

    setjmp(errorbuf);
    printf("Target device <CR> defaults to DISK device %s: ",DEFAULT_DEST);
    gets(dstname);
    if(dstname[0] == '\0')
        strcpy(dstname, DEFAULT_DEST);


    dstfd = opensa(dstname,((dstname[4]) ? "rv" : "mt"),tmode);
    if(nine_trk){
	if((ret = mtioctl(SYSCONF->bootunit,TAPESTAT,dummy)) < 0){
		printf("cannot stat tape device\n");
		exit(1);
	}
    }

    /* the following cannot be fixed until large writes to disk are OK */

    printf("Copying BOOTIMAGE to %s.\n",dstname);
    if(setjmp(errorbuf)) {
	printf("ABORT, fatal io error\n");
	exit(1);
    }

    while((rc=fillbuf(srcfd,buf,sizeof(buf))) > 0) {
	if(rc != sizeof(buf)) {
	    if(partialflag) error("two partial reads?!?");
	    partialflag++;
	    /* round up disk writes */
	    rc += BSIZE - 1;
	    rc &= ~(BSIZE-1);
	}
	if(firstimageread && *(short *)buf != M68ASAMAGIC)
	    error("Not a BOOTIMAGE tape");
	firstimageread = 0;
	if(rc > maxsa) error("BOOTIMAGE too large");
	rvwriteck(dstfd, buf, rc);
	maxsa -= rc;
	totalcount += rc;
	if(partialflag) break;  /* partial read means end of image */
    }
    printf("0x%x bytes transferred\n",totalcount);
    close(srcfd);
    if(dstname[4]){
	rvlseekck(dstfd,BOOT_SECTOR*BSIZE,0);
	b = (struct boot_list *)secbuf;
	b->boot_strt = boot_start;
	b->boot_size = (totalcount/BSIZE) + 1;
	rvwriteck(dstfd,secbuf,BSIZE);
    }
    close(dstfd);
    exit( 0 );
}

opensa(icbchar,sachar,mode) /* s is ascii of the ICB nibbles for controller:device */
register char *sachar; /* mt or rv */
register char *icbchar;
int mode;
{
    int fd;
    register char *p = icbchar;
    struct boot_list *b;
    struct sector0 *pd;
    char *valchar;
    int val;


    fd = openck(icbchar,mode);
    if(sachar[0] == 'r' && sachar[1] == 'v') {
	rvreadany(fd, 0, secbuf); /* check out sector 0 */
	pd = (struct sector0 *)secbuf;
	if(*(long *)pd->id != DISK_INIT)
	    error("disk not initialized");
	if(pd->pd_ldnum == 0)
	    error("disk is not setup");
	maxsa = pd->rv_size;
	rvreadany(fd, BOOT_SECTOR, secbuf);
	b = (struct boot_list *)secbuf;
	if(b->boot_strt == 0)
	    error("disk format error: boot start not specified");
	maxsa -= b->boot_strt;
	maxsa = maxsa * BSIZE;
	boot_start = b->boot_strt;
	rvlseekck(fd, b->boot_strt * BSIZE, 0);/* point disk at bootimage loc*/
    } else if(sachar[0] == 'm' && sachar[1] == 't'){
	maxsa = 0x7fffff;  /* lots of room on the tape */
	archive_tape = 1;
    }
    else
	error("Sorry, %s ??, cannot handle this type of device",icbchar);
    return(fd);
}

openck(s,h) {
    int fd;

    if((fd=open(s,h)) < 0)
	error("open error on device %s",s);
    return(fd);
}

rvlseekck(fd,pos,how) {
    int rc;
    if((rc=lseek(fd,pos,how))<0)
	error("rv seek(0x%x,0x%x,0x%x) error 0x%x", fd, pos, how, rc);
    return(rc);
}

rvreadck(fd,p,s) {
    int rc;
    if((rc=read(fd,p,s))<0)
	error("rv read(0x%x,0x%x,0x%x) error 0x%x", fd, p, s, rc);
    return(rc);
}

rvwriteck(fd,p,s) {
    int rc;
    int totalbyte=0;
    while(s) { /* TEMP, until multi-sector read/write */
	if((rc=write(fd,p,BSIZE))<0)
	    error("rv write(0x%x,0x%x,0x%x) error 0x%x",fd,p,s,rc);
	totalbyte += rc;
	p += rc;
	s -= rc;
    }
    return(totalbyte);
}

rvreadany(fd,sector,buf)
char *buf;
{
    rvlseekck(fd,sector*BSIZE,0);
    rvreadck(fd,buf,BSIZE);
/* will add alternate checking  someday */
}


fillbuf(fd,p,size)
register char *p;
{
	register char *endp = p + size;
	register count;
	register int rc;

	rc = 1; count = 0;
	if((archive_tape) && (!(nine_trk)))
		count = read(fd,p,size);
	else{
		while(rc && p < endp) {
			if((rc=rvreadck(fd,p,BSIZE))<0) {
				return(rc);
			}
			count += rc;
			p += rc;
		}
	}
	return(count);
}
