
#	@(#)mkfs.mk	1.3

include $(IROOT)/macdefs
include ../../macdefs


NAME = mkfs
SINC = ../../head
LDF = ../../lib/ld.util
HDR = ../../lib/standhead.o
CRT0 = ../../lib/scrt0.o
LIB = -L../../lib -lsc
LIB1 = ../../lib/libsc.a

CFLAG = -I$(INCRT) -W0,-sp -DSTANDALONE $(CFLAGS)

.SUFFIXES: .c .o

.c.o:
	$(CC) -c -I$(SINC) $(CFLAG) $<

all install: $(NAME)

clean:
	-rm -f mkfs.o

clobber: clean
	-rm -f $(NAME) $(NAME).nm

$(NAME):	$(LIB1) mkfs.o
	$(LD) -o $(NAME) -N $(LDF) $(CRT0) $(HDR) mkfs.o $(LIB)
	nm -xv $(NAME) >$(NAME).nm
	strip $(NAME)
	../sapatch/sapatch -h $(NAME)

mkfs.o:		$(INCRT)/sys/types.h \
		$(INCRT)/sys/stat.h \
		$(INCRT)/sys/fs/s5param.h \
		$(INCRT)/sys/sysmacros.h \
		$(INCRT)/sys/ino.h \
		$(INCRT)/sys/inode.h \
		$(INCRT)/sys/fs/s5filsys.h \
		$(INCRT)/sys/fs/s5fblk.h \
		$(INCRT)/sys/fs/s5dir.h \
		$(SINC)/ccpu.h \
		$(SINC)/maps.h \
		$(SINC)/saio.h \
		$(SINC)/dklist.h \
		$(SINC)/dk.h \
		$(SINC)/disksect.h \
		$(SINC)/pdf.h
