#include "extern.h"
#include <ctype.h>
/* this ascii to long deals with bases
 * base  8  ,10 and 16
 * Will kick out illegal characters.
 */
long validvers(s)
register char *s;
{
	register long base = 10;

 	if(!isdigit(*s))
		fprintf(stderr,"%s: Illegal version number - %s \n",
		utilname, s),closefile('n');
	if( *s == '0' ){		/* base 8 preceded by 0 */
		if( *++s == 'x' ){
			base = 16;	/* base 16 preceded by 0x */
			*s++;
			}
		else base = 8;
		}
	if ( -1 == (result = radfix(s,base)))
		fprintf(stderr,"%s: Illegal version number - %s\n",
		utilname,s),closefile('n');
	return (result);
}

/* RADFIX--Convert a string of chars in array pointed to by txt--
 *		to the radix named by base.
 *		A check for out of range digits is made.
 * 		(-1) is returned if bad in badrad.
 */
short badrad;
long radfix(txt,base)
 char *txt;
 short base;
{
 	long retval = 0;		/* return value accumulator */
	short value;
	badrad=0;
	while ( *txt != '\0' ){		/* until end of string */
		value = *txt++;		/* get next character */
		retval *= base;
		if (value >= 'a'&& value <= 'f') /* convert hex-chars */
			value -= 'a' - 10 - '0';
		if (value >= 'A'&& value <= 'F')
			value -= 'A' - 10 - '0';
		if ( value - '0' >= base ) 	/* check for outta range */
			badrad++;
		retval += value - '0';
	}/* end while */
	if(badrad)
		return(-1);
	return(retval);
}/* end radfix */
