
#include "scsi_ccpu.h"
#include "scsi_dtc.h"
#include "command_blk.h"
#include "commands.h"
#include "mode_sns_pg.h"
#include "scsi_mem_map.h"
#include "scsi.h"
#include "message.h"
#include "scsiextrn.h"
#include "error.h"
#include "vreg.h"
#include "data_struct.h"
#include "scsi_error.h"
#include "scsi_ptm.h"

extern char *skiparg();
unsigned char getdrive();
struct devq *getptr();
struct free_mem *getmem();

char * sense_error[] = {"no sense",
			"recovered error",
			"not ready",
			"medium error",
			"hardware error",
			"illegal request",
			"unit attention",
			"invalid error",
			"invalid error",
			"invalid error",
			"invalid error",
			"aborted command",
			"invalid error",
			"volume overflow",
			"miscompare",
};

#define DMA 0x80
#define S_TIMEOUT 0xfffff

/* change memory content by byte */

setmem (mem)
register char *mem;
{
	char *ptr; char buf[10]; int value;

	value = 1;
	while (value >= 0) {
		printf ( "%6x %2x >",mem, (*mem)&0xff );
		if ( get( buf,sizeof(buf)-1 ) < 0) return(-1);

		if ( (buf[0] == 'q') || (buf[0] == 'Q') ) return(0);

		if ( buf[0] == ',' )  {
			mem--;
			value = 0;	
		}
		else if ( buf[0] == 0 ) {
			mem++;
			value = 0;
		}
		else  {
			ptr = buf;
			if (  getlong(&ptr,&value) < 0 )
				 return(-1);
			*mem++ = (char)value;
		}
	}
	return (0);
}

dismem( mem, count )
register char *mem; register count;
{
	register char *ptr;
	register i, j;

	for ( ptr=mem; count > 0; mem=ptr) {
		printf ("%6x  ",ptr);
		for (i=0,j=count; i<16; i++,ptr++) {
			if (j > 0) {
				printf ("%2x ", (*ptr)&0xff ); j--;
			}
			else
				printf ("   ");
		} 
		printf ("   ");
		ptr=mem;
		for (i=0,j=count; i<16; i++,ptr++) {
			if (j > 0) {
				printf ("%c", (*ptr >= ' ') ? *ptr : '.');
				j--;
			}
			else
				printf (" ");
		}
		printf("\n");
		count -=16;
	}
}


/*
   D	<physical addr>  <byte count>
 */

display(bufptr) 
char *bufptr;
{	char *ptr; char *mem; int count; register ret;

	ptr = bufptr;
	ptr = skiparg ( bufptr );	/* skip over command */

	/* get memory address */
	if ( getlong(&ptr, &mem) < 0 ) return (-1);

	/* get byte count */
	ret = getlong(&ptr, &count);

	if ( ret < 0 ) {
		/* no count, display one memory byte at a time */
		if ( setmem (mem) < 0 ) return (-1);
	}
	else
		dismem( mem, count );

	return(0);
}

/* M send out a mode sense command and wait until we receive
	the error recovery page
	the format control page
	the disk geometry page
	the cache control page
*/
mode_sense(bufptr)
char *bufptr;
{
	register char *cptr;
	register struct devq *dev;
	register struct scsiwr *wr;
	register int i;
	unsigned char drive;
	struct discnct_recnct *d_r_ptr;
	char ans[6];


	if ( (drive = getdrive(bufptr)) < 0 ){
		printf("invalid drive number %x\n",drive);
		return (0);
	}
	dev = getptr();
	dev->local_mem = getmem();

	/* zero out the command block */
	dev->q_devnum = drive;
	dev->q_flag |= (DK_TO_LOC|WAIT|NO_DISCONNECT);
	dev->opr = MODE_SENSE;
	dev->q_cmd = MODE_SENSE;

	printf("Do you want all of the mode sense pages?\n");
	get(ans);
	if(ans[0] == 'y' || ans[0] == 'Y'){
		dev->scsi_page = CURRENT|ALL_CACHE_PAGES;
		dev->q_count = ALL_PAGE_LENGTH;
		if(mode_snse(dev)){
			printf("cannot get a mode sense\n");
			return_ptr(dev);
			return_mem(dev->local_mem);
			return(1);
		}
	    while((dev->q_priority != DONE) && (i++ < S_TIMEOUT));

	    for(i=0,cptr=(char *)dev->local_mem->fm;i<ALL_PAGE_LENGTH;i++,cptr++)
			printf("%x ",*cptr&0xff);
		return_ptr(dev);
		return_mem(dev->local_mem);
		return(0);
	}

	printf("Current values - a,Changeable values - b,Default values - c,Saved values - d\n");
	get(ans);
	
	/* First get the error recovery page */
	switch(ans[0]){
		case 'A':
			dev->scsi_page = CURRENT|ERROR_REC_PAGE;
			break;
		case 'B':
			dev->scsi_page = CHANGEABLE|ERROR_REC_PAGE;
			break;
		case 'C':
			dev->scsi_page = DEFAULT|ERROR_REC_PAGE;
			break;
		case 'D':
			dev->scsi_page = SAVED|ERROR_REC_PAGE;
			break;
		default:
			printf("invalid selection\n");
			return_ptr(dev);
			return_mem(dev->local_mem);
			return(0);
	}
	dev->q_count = MODE_HEAD_BLK + ERROR_REC_HD_PG;
	dev->q_priority = 0;
	if(mode_snse(dev)){
		printf("cannot get a mode sense\n");
		return_ptr(dev);
		return_mem(dev->local_mem);
		return(1);
	}
	while((dev->q_priority != DONE) && (i++ < S_TIMEOUT));

	printf("error recovery page information\n");
	error_ptr = (struct error_recovery_page *)dev->local_mem->fm;
	printf("header          %x\n",error_ptr->er_ms_header);
	printf("block data      %x %x\n",error_ptr->er_block_data[0],error_ptr->er_block_data[1]);
	printf("page code       %x\n",error_ptr->e_page_code);
	printf("page length     %x\n",error_ptr->e_page_length);
	printf("parameters      %x\n",error_ptr->e_parameters);
	printf("retry count     %x\n",error_ptr->e_retry_count);
	printf("correction span %x\n",error_ptr->correction_span);
	printf("head offset cnt %x\n",error_ptr->head_offset_cnt);
	printf("data_strobe off %x\n",error_ptr->data_strobe_off_cnt);
	printf("recovery time   %x\n",error_ptr->recovery_time);

	get(ans);


/* Now get the disconnect reconnect control parameters */

	dev->q_message = 0;

	dev->scsi_page = (dev->scsi_page&0xc0) | DISC_RECON_CONTROL;
	dev->q_count = MODE_HEAD_BLK + DISC_RECON_LEN;
	dev->q_priority = 0;

	if(mode_snse(dev)){
		printf("cannot get a mode sense\n");
		return_ptr(dev);
		return_mem(dev->local_mem);
		return(1);
	}
	while((dev->q_priority != DONE) && (i++ < S_TIMEOUT));
	printf("\ndisconnect/reconnect control header\n");
	d_r_ptr = (struct discnct_recnct *)dev->local_mem->fm;
	printf("page code %x\n",d_r_ptr->dr_page_code);
	printf("page length %x\n",d_r_ptr->dr_page_length);
	printf("buffer full ratio %x\n",d_r_ptr->buf_full_ratio);
	printf("buffer emptr ratio %x\n",d_r_ptr->buf_empty_ratio);
	printf("bus inactivity time %x\n",d_r_ptr->bus_inactivity_time);
	printf("disconnect time %x\n",d_r_ptr->disconnect_time);
	printf("connect time %x\n",d_r_ptr->connect_time);

	get(ans);

/* Now get the format control header */
	
	dev->scsi_page = (dev->scsi_page&0xc0) | FORMAT_PAGE;
	dev->q_count = MODE_HEAD_BLK + FORMAT_HD_LEN;
	dev->q_priority = 0;

	if(mode_snse(dev)){
		printf("cannot get a mode sense\n");
		return_ptr(dev);
		return_mem(dev->local_mem);
		return(1);
	}
	while((dev->q_priority != DONE) && (i++ < S_TIMEOUT));
	printf("\nformat control header information\n");
	format_ptr = (struct format_param_page *)dev->local_mem->fm;
	
	printf("header          %x\n",format_ptr->f_ms_header);
	printf("block data      %x %x\n",format_ptr->f_block_data[0],format_ptr->f_block_data[1]);
	printf("page code       %x\n",format_ptr->f_page_code);
	printf("page length     %x\n",format_ptr->f_page_length);
	printf("tracks/zone     %x\n",format_ptr->tracks_per_zone);
	printf("altsecs/zone    %x\n",format_ptr->alt_sects_per_zone);
	printf("alt trks/zone   %x\n",format_ptr->alt_trks_per_zone);
	printf("alt_trks/vol    %x\n",format_ptr->alt_trks_per_vol);
	printf("sects/track     %x\n",format_ptr->sects_per_track);
	printf("bytes/sect      %x\n",format_ptr->bytes_per_sect);
	printf("interleave      %x\n",format_ptr->interleave);
	printf("track skew      %x\n",format_ptr->track_skew);
	printf("cyl skew        %x\n",format_ptr->cylinder_skew);

	get(ans);


/* Now get the disk drive geometry header */
	dev->scsi_page = (dev->scsi_page&0xc0) | DRIVE_GEOM_PAGE;
	dev->q_count = MODE_HEAD_BLK + GEOM_HD_LEN;
	dev->q_priority = 0;

	if(mode_snse(dev)){
		printf("cannot get a mode sense\n");
		return_ptr(dev);
		return_mem(dev->local_mem);
		return(1);
	}
	while((dev->q_priority != DONE) && (i++ < S_TIMEOUT));
	printf("\ndisk drive geometry information\n");
	geom_ptr = (struct disk_geometry *)dev->local_mem->fm;
	printf("header          %x\n",geom_ptr->dg_ms_header);
	printf("block data      %x %x\n",geom_ptr->dg_block_data[0],geom_ptr->dg_block_data[1]);
	printf("page code       %x\n",geom_ptr->g_page_code);
	printf("page length     %x\n",geom_ptr->g_page_length);
	printf("cylinders       %x %x %x\n",geom_ptr->cylinders_msb,geom_ptr->cylinders,geom_ptr->cylinders_lsb);
	printf("heads           %x\n",geom_ptr->heads);
	printf("wr precomp cyl  %x %x %x\n",geom_ptr->wr_precomp_st_cyl[0],geom_ptr->wr_precomp_st_cyl[1],geom_ptr->wr_precomp_st_cyl[2]);
	printf("red current cyl %x %x %x\n",geom_ptr->reduced_cur_st_cyl[0],geom_ptr->reduced_cur_st_cyl[1],geom_ptr->reduced_cur_st_cyl[2]);
	printf("step rate       %x\n",geom_ptr->step_rate);
	printf("loading zone    %x %x %x\n",geom_ptr->loading_zone_cyl[0],geom_ptr->loading_zone_cyl[1],geom_ptr->loading_zone_cyl[2]);


	get(ans);


/* Now get the cache control header */
	cache_ptr = (struct cache_control *)dev->local_mem->fm;
	
	dev->scsi_page = (dev->scsi_page&0xc0) | CACHE_CONTROL_PAGE;
	dev->q_count = MODE_HEAD_BLK + CACHE_HD_LEN;
	dev->q_priority = 0;

	if(mode_snse(dev)){
		printf("cannot get a mode sense\n");
		return_ptr(dev);
		return_mem(dev->local_mem);
		return(1);
	}
	while((dev->q_priority != DONE) && (i++ < S_TIMEOUT));
	printf("\ncache control header information\n");
	printf("page code %x\n",cache_ptr->c_page_code);
	printf("page length %x\n",cache_ptr->c_page_length);
	printf("cache control parameters %x\n",cache_ptr->c_c_parameters);
	printf("prefetch threshold %x\n",cache_ptr->prefetch_thresh);
	printf("max prefetch %x\n",cache_ptr->max_prefetch);
	printf("max prefetch mult %x\n",cache_ptr->max_prefetch_mult);
	printf("min prefetch %x\n",cache_ptr->min_prefetch);
	printf("min prefetch mult %x\n",cache_ptr->min_prefetch_mult);

	get(ans);

	return_ptr(dev);
	return_mem(dev->local_mem);
	return(0);

}
/* X - reset the scsi chip */

reset_chip(chip_number)
unsigned char chip_number;
{
	register struct scsiwr *wr;

	if(chip_number == 1)
		wr=(struct scsiwr *)SCSI_2;
	else
		wr=(struct scsiwr *)SCSI_1;

	wr->command = RESET_CHIP;

	/* now we must send a NOP command to clear the chip */
	wr->command = NOP;

	/* now we have to set up the registers again */

	wr->config=0x47;    /*bus id of 7 and disable ints on reset */
	wr->sync_period = 0;	     /* async mode */
	wr->sync_offset = 0;	
	wr->clock_conv = 5; 	     /* 25 mHz */
	wr->sel_rec_timeout=0x98;    /*250 ms timeout on sel/reselect */


	return(0);
}

/* I - inquiry command; find out the vendor specific information about the 
	drive
*/
inquiry(bufptr)
char *bufptr;
{

	register struct devq *dev;
	register i;
	register unsigned char *cptr;
	unsigned char drive;

	if ( (drive = getdrive(bufptr)) < 0 ){
		printf("invalid drive number %x\n",drive);
		return (0);
	}
	dev = getptr();
	dev->local_mem = getmem();

	dev->q_count = INQUIRY_DATA_LENGTH;
	dev->q_flag |= (DK_TO_LOC|WAIT|NO_DISCONNECT);
	dev->q_cmd = INQUIRY;
	dev->opr = INQUIRY;
	dev->q_message = 0;
	dev->q_devnum = drive;
	dev->q_priority = 0;

	inq(dev);

	i=0;
	while((dev->q_priority != DONE) && (i++ < S_TIMEOUT));
	if(i >= S_TIMEOUT){
	        dtc_ctl &= ~SCSI1_INT;
	        *DTC_CRL = dtc_ctl;
		printf("timeout\n");
		return_ptr(dev);
		return_mem(dev->local_mem);
		return(1);
	}
	if(dev->rc1 == DER_NRDY){
if(PRINT1)
		printf("drive %x not ready\n",drive);
		return_ptr(dev);
		return_mem(dev->local_mem);
		return(1);
	}
	for(i=0,cptr=(unsigned char *)dev->local_mem->fm;i<INQUIRY_DATA_LENGTH;i++,cptr++)
		printf("%c ",*cptr&0xff);
	printf("\n");

	return_ptr(dev);
	return_mem(dev->local_mem);

	return(0);
}

inq(dev)
register struct devq *dev;
{
	register struct six_byte_cdb *cdb_ptr;
	register i;
	struct six_byte_cdb ms_cdb;
	unsigned char drive;
	struct peripheral_que *pq_ptr;

	cdb_ptr = &ms_cdb;

	if(dev->q_devnum < NUMBER_OF_DEVICES){
		drive = dev->q_devnum;
		pq_ptr = &periph_que;
	}
	else{
		drive = dev->q_devnum - NUMBER_OF_DEVICES;
		pq_ptr = &periph1_que;
	}


	/* zero out the command block */
	setbuf(cdb_ptr,3,0);

	cdb_ptr->op_code = dev->opr;
	cdb_ptr->length = dev->q_count;

	dev->q_message = 0;

	pq_ptr->pt[drive].p_first = dev;
	pq_ptr->pt[drive].p_last = dev;
	pq_ptr->pt[drive].next_mem_ptr = (dev->q_flag&DK_TO_MAIN) ? dev->q_mem :
		(char *)(dev->local_mem->fm);
	pq_ptr->pt[drive].next_byte_count = dev->q_count;
	pq_ptr->bus_id = drive;
	pq_ptr->periph_active |= BIT(drive);
	
	*(short *)&dev->rc1 = 0;
	if(send_cmd(cdb_ptr,0,6,dev))
		return(1);

	return(0);
}
/* T - test unit ready */

unit_ready(bufptr)
char *bufptr;
{

	register struct six_byte_cdb *cdb_ptr;
	register struct devq *dev;
	register struct peripheral_que *pq_ptr;
	register i;
	struct six_byte_cdb ms_cdb;
	unsigned char drive,drive1;


	if ( (drive = getdrive(bufptr)) < 0 ){
		printf("invalid drive number %x\n",drive);
		return (0);
	}
	dev=getptr();
	/* zero out the command block */

	dev->q_devnum = drive;

	dev->q_cmd = UNIT_READY;
	dev->opr = UNIT_READY;
	dev->q_flag = (DK_TO_LOC|WAIT|NO_DISCONNECT);
	dev->q_message = 0;
	
	*(short *)&dev->rc1 = 0;

	i=0;

	while((dev->q_priority == 0) && (i++ < S_TIMEOUT));
	if(i >= S_TIMEOUT){
	        dtc_ctl &= ~SCSI1_INT;
	        *DTC_CRL = dtc_ctl;
		printf("timeout\n");
		return(0);
	}

	if(dev->rc1 == DER_NRDY){
if(PRINT1)
		printf("drive %x not ready\n",drive);
		return(1);
	}


	return(0);

}

send_small_cmd(dev)
register struct devq *dev;
{

	unsigned char drive;
	register struct peripheral_que *pq_ptr;

	if(dev->q_devnum < NUMBER_OF_DEVICES){
		drive = dev->q_devnum;
		pq_ptr = &periph_que;
	}
	else{
		drive = dev->q_devnum - NUMBER_OF_DEVICES;
		pq_ptr = &periph1_que;
	}


	pq_ptr->pt[drive].p_first = dev;
	pq_ptr->pt[drive].p_last = dev;

	if(diskrw(dev))
		return(1);

	return(0);

}

rezero(bufptr)
char *bufptr;
{

	register i;
	register struct six_byte_cdb *cdb_ptr;
	register struct scsiwr *wr;
	struct six_byte_cdb ms_cdb;
	unsigned char drive;
	struct devq *dev;


	if ( (drive = getdrive(bufptr)) < 0 ){
		printf("invalid drive number %x\n",drive);
		return (0);
	}
	dev = getptr();
	wr = (struct scsiwr *)SCSI_1;
	cdb_ptr = &ms_cdb;
	/* zero out the command block */
	setbuf(cdb_ptr,3,0);

	cdb_ptr->op_code = REZERO;
	cdb_ptr->length = 0;
	
	waiting = 0;
	if(send_cmd(cdb_ptr,0,6,dev))
		return(0);
	while((waiting == 0) && (i++ < S_TIMEOUT));
	if(i >= S_TIMEOUT){
	        dtc_ctl &= ~SCSI1_INT;
	        *DTC_CRL = dtc_ctl;
		printf("timeout\n");
		return(0);
	}

	printf("rezero complete\n");

	return(0);

}


format_drive(dev)
register struct devq *dev;
{
	register unsigned char drive;
	register struct peripheral_que *pq_ptr;
	register struct six_byte_cdb *cdb_ptr;
	struct six_byte_cdb fm_cdb;

	
	if(dev->q_devnum < NUMBER_OF_DEVICES){
		pq_ptr = &periph_que;
		drive = dev->q_devnum;
	}
	else{
		pq_ptr = &periph1_que;
		drive = dev->q_devnum - NUMBER_OF_DEVICES;
	}

	cdb_ptr = &fm_cdb;
	setbuf(cdb_ptr,3,0);

	cdb_ptr->op_code = dev->opr;
	dev->q_flag &= ~NO_DISCONNECT;
	pq_ptr->pt[drive].p_first = dev;
	pq_ptr->pt[drive].p_last = dev;
	pq_ptr->periph_active |= BIT(drive);
	*(short *)&dev->rc1 = 0;
	dev->q_priority = 0;
	
	if(send_cmd(cdb_ptr,0,6,dev))
		return(1);


	return(0);
}

request_sense(bufptr)
char *bufptr;
{
	register struct devq *dev;
	unsigned char drive;
	int i;

	if ( (drive = getdrive(bufptr)) < 0 ){
		printf("invalid drive number %x\n",drive);
		return (0);
	}

	dev = getptr();
	dev->local_mem = getmem();

	dev->q_cmd = REQ_SENSE;
	dev->opr = REQ_SENSE;
	dev->q_count = SENSE_DATA_LENGTH;
	dev->q_devnum = drive;
	dev->q_flag |= (DK_TO_LOC|WAIT|NO_DISCONNECT);

	req_sense(dev);

	print_rs(dev->local_mem->fm);

	return_ptr(dev);
	return_mem(dev->local_mem);

	return(0);
}
req_sense(dev)
register struct devq *dev;
{
	register struct six_byte_cdb *cdb_ptr;
	register struct periph_table *p_ptr;
	register struct peripheral_que *pq_ptr;
	register i;
	struct six_byte_cdb ms_cdb;
	unsigned char drive;
	unsigned short oldpri;

	if(dev->q_devnum < NUMBER_OF_DEVICES){
		pq_ptr = &periph_que;
		drive = dev->q_devnum;
	}
	else{
		pq_ptr = &periph1_que;
		drive = dev->q_devnum - NUMBER_OF_DEVICES;
	}
	p_ptr = &pq_ptr->pt[drive];
	cdb_ptr = &ms_cdb;
	/* zero out the command block */
	setbuf(cdb_ptr,3,0);

	cdb_ptr->op_code = REQ_SENSE;
	cdb_ptr->length = dev->q_count;
	
	oldpri = spl6();
	if(p_ptr->p_first)
		dev->q_next = p_ptr->p_first;
	else
		dev->q_next = 0;
	p_ptr->p_time = TICK_3SEC;
	p_ptr->p_first = dev;
	p_ptr->next_mem_ptr = (dev->q_flag&DK_TO_MAIN) ? dev->q_mem :
		(char *)(dev->local_mem->fm);
	p_ptr->next_byte_count = dev->q_count;
	pq_ptr->periph_active |= BIT(drive);
	*(short *)&dev->rc1 = 0;
	if(send_cmd(cdb_ptr,0,6,dev)){
		p_ptr->p_time = 0;
		pq_ptr->periph_active &= ~(BIT(drive));
		splx(oldpri);
		return(1);
	}
	pq_ptr->bus_id = drive;
	splx(oldpri);
	i=0;
	if(dev->q_flag&WAIT){
	    while((dev->q_priority != DONE) && (i++ < S_TIMEOUT));
	    if(i >= S_TIMEOUT){
	        dtc_ctl &= ~SCSI1_INT;
	        *DTC_CRL = dtc_ctl;
		printf("timeout\n");
		return(1);
	    }
	    if(dev->rc1 == DER_NRDY){
if(PRINT1)
		printf("drive %x not ready\n",dev->q_devnum);
		return(1);
	    }
	}
	return(0);
}
print_rs(mem)
char *mem;
{
	register struct request_sense *rs_ptr;

	rs_ptr = (struct request_sense *)mem;
	printf("error class         %x\n",rs_ptr->rs_err_class);
	printf("segment             %x\n",rs_ptr->rs_segment);
	printf("sense key           %x\n",rs_ptr->rs_key);
	printf("        %s\n",sense_error[rs_ptr->rs_key]);
	printf("bad block           %x\n",rs_ptr->rs_info_byte);
	printf("sense length        %x\n",rs_ptr->rs_sense_len);
	printf("error code          %x\n",rs_ptr->rs_err_code);
	printf("bit pointer         %x\n",rs_ptr->rs_bit_ptr);
	printf("field pointer       %x\n",rs_ptr->rs_field_ptr);

}

reset_bus(bus_number)
unsigned char bus_number;
{
	register struct scsiwr *wr;
	unsigned char interrupt_level;

	if(bus_number == 1){
		wr = (struct scsiwr *)SCSI_2;
		interrupt_level = SCSI1_INT;
	}
	else{
		wr = (struct scsiwr *)SCSI_1;
		interrupt_level = SCSI2_INT;
	}

	wr->command = RESET_BUS;	/*reset the scsi bus  */

    	dtc_ctl &= ~interrupt_level;
       	*DTC_CRL = dtc_ctl;

	return(0);
}

read(bufptr)
char *bufptr;
{
	register unsigned short j = 0;
	register struct devq *dev;
	int argu[5];
	unsigned char drive;



	if(*(bufptr+1) != ' '){
	    if ( (drive = getdrive(bufptr)) < 0 ){
		printf("invalid drive number %x\n",drive);
		return (1);
	    }

	    if(*(bufptr+1) == 'C'){
		read_capacity(bufptr);
		return(0);
	    }
	    else if(*(bufptr+1) == 'R'){
		printf("random reads\n");
		j = 2;
		dev = getptr();
		dev->q_cmd = READ;
		dev->opr = READ;
		dev->q_message = 0;
		dev->q_count = BLKSIZE;
		dev->q_flag = (DK_TO_LOC|WAIT|NO_DISCONNECT);
		dev->local_mem = getmem();
	    	while(con_in() != 'Q'){
			j = (((j-1)*9)+1) % 60000;
			dev->q_devun.block = j;
	    		if(read_data(dev)){
				return_mem(dev->local_mem);
				return_ptr(dev);
				return(1);
			}
	    	}
		return_mem(dev->local_mem);
		return_ptr(dev);
	    }
	}

	else{
		if ( getarg(bufptr, argu, 3)<0 ){
			printf("improper number of parameters\n");
			return (1);
		}
 		if ( argu[0] >= MAX_PDRIVE ){
			printf("invalid drive number\n");
			return (1);
		}
 		if ( argu[2] & 0x3ff){
			printf("invalid byte count\n");
			return (1);
		}

		dev = getptr();
		dev->local_mem = getmem();
		dev->q_devnum = argu[0];
		dev->q_devun.block = argu[1];

		dev->q_cmd = READ;
		dev->opr = READ;
		dev->q_message = 0;
		dev->q_count = argu[2];
		dev->q_flag = (DK_TO_LOC|WAIT|NO_DISCONNECT);
	    	while(con_in() != 'Q'){
	    		if(read_data(dev)){
				return_mem(dev->local_mem);
				return_ptr(dev);
				return(1);
			}
			if(*(bufptr+1) != 'L') break;
		}
	}
	if(*(bufptr+1) != 'L')
	    printf("local memory address is %x h\n",dev->local_mem->fm);
	return_mem(dev->local_mem);
	return_ptr(dev);
	return(0);
}

read_data(dev)
register struct devq *dev;
{
	register struct six_byte_cdb *cdb_ptr;
	register unsigned char *cptr;
	register struct peripheral_que *pq_ptr;
	register unsigned char drive;
	register i;


if(PRINT1)
	printf("drive %x sector number %x  count %x\r",dev->q_devnum,dev->q_devun.block,dev->q_count);

	if(drive < NUMBER_OF_DEVICES){
		drive = dev->q_devnum;
		pq_ptr = &periph_que;
	}
	else{
		drive = dev->q_devnum - NUMBER_OF_DEVICES;
		pq_ptr = &periph1_que;
	}

	pq_ptr->pt[drive].p_first = dev;
	pq_ptr->pt[drive].p_last = dev;

	dev->scnt = dev->q_count/BLKSIZE;
	
	if(diskrw(dev))
		return(1);
	i=0;
	
	if(dev->q_flag&WAIT){
		dev->q_priority = 0;
		while((dev->q_priority != DONE) && (i++ < S_TIMEOUT));
		if(i >= S_TIMEOUT){
        		dtc_ctl &= ~SCSI1_INT;
        		*DTC_CRL = dtc_ctl;
			printf("timeout\n");
			if(check_error(dev))
				return(1);
			else
				return(0);
		}
	}
	if(dev->rc1 == DER_NRDY){
		printf("drive %x not ready\n",drive);
		return(1);
	}

	return(0);
}

write(bufptr)
char *bufptr;
{
	register struct devq *dev;
	register unsigned int j,i;
	register unsigned int block_size;
	register char *cptr;
	int argu[5];
	char b1[5];
	unsigned char drive;


	if(*(bufptr+1) == 'L'){
	    if ( (drive = getdrive(bufptr)) < 0 ){
		printf("invalid drive number %x\n",drive);
		return (0);
	    }
	    dev = getptr();
	    dev->q_cmd = WRITE;
	    dev->opr = WRITE;
	    dev->q_message = 0;
	    dev->q_count = BLKSIZE;
	    dev->q_flag = (LOC_TO_DK|WAIT|NO_DISCONNECT);
	    dev->local_mem = getmem();
	    j = 8;
	    while(con_in() != 'Q'){
		j = (((j-1)*9)+1) % 60000;
		if(j < 8) j = 8;
		dev->q_devun.block = j;
	    	if(write_data(dev)){
			return_mem(dev->local_mem);
			return_ptr(dev);
			return(1);
		}
	    }
	    return_mem(dev->local_mem);
	    return_ptr(dev);
	}
	else{
	    if ( getarg(bufptr, argu, 3)<0 ){
		printf("Improper number of parameters\n");
		return (1);
	    }
 	    if ( argu[0] >= MAX_PDRIVE ){
		printf("invalid drive number\n");
		return (1);
	    }
 	    if ( argu[2] & 0x3ff){
		printf("invalid byte count\n");
		return (1);
	    }
 	    if ( argu[1] == 0){
		printf("writing to sector zero will corrupt system data\n");
		printf("do you want to write it anyway?");
		if ( get(b1,sizeof(b1)-1) < 0 )
			return (1);
		if(*b1 != 'Y')
			return(0);
	    }

	    dev = getptr();
	    dev->local_mem = getmem();
    
	    dev->q_devnum = argu[0];
	    dev->q_devun.block = argu[1];


	    dev->q_cmd = WRITE;
	    dev->opr = WRITE;
	    dev->q_flag = (LOC_TO_DK|WAIT|NO_DISCONNECT);
	    dev->q_count = argu[2];
	    for(i=0,cptr=(char *)(dev->local_mem->fm);i<BLKSIZE;i++,cptr++)
		*cptr = i;
	    if(write_data(dev)){
		return_mem(dev->local_mem);
		return_ptr(dev);
		return(1);
	    }
	    if(*(bufptr+1) != 'L')
	        printf("local memory address is %x h\n",dev->local_mem->fm);
	    return_mem(dev->local_mem);
	    return_ptr(dev);
	}
	return(0);
}
write_data(dev)
register struct devq *dev;
{
	register unsigned char *cptr;
	register struct peripheral_que *pq_ptr;
	register i;
	unsigned char drive;


if(PRINT1)
	printf("drive %x sector number %x  count %x\r",dev->q_devnum,dev->q_devun.block,dev->q_count);

	if(dev->q_devnum < NUMBER_OF_DEVICES){
		drive = dev->q_devnum;
		pq_ptr = &periph_que;
	}
	else{
		drive = dev->q_devnum - NUMBER_OF_DEVICES;
		pq_ptr = &periph1_que;
	}

	pq_ptr->pt[drive].p_first = dev;
	pq_ptr->pt[drive].p_last = dev;

	dev->scnt = dev->q_count/BLKSIZE;
	

	if(diskrw(dev))
		return(1);

	if(dev->q_flag&WAIT){
		i=0;
		dev->q_priority = 0;
		while((dev->q_priority != DONE) && (i++ < S_TIMEOUT));
		if(i >= S_TIMEOUT){
	        	dtc_ctl &= ~SCSI1_INT;
	        	*DTC_CRL = dtc_ctl;
			printf("timeout\n");
			return(1);
		}
	}
	if(dev->rc1 == DER_NRDY){
		printf("drive %x not ready\n",drive);
		return(1);
	}


    return(0);
}

compare(count,mem1,mem2)
register unsigned short count;
char *mem1,*mem2;
{
	register int i;
	register char *wptr,*rptr;

	for(i=0,wptr=mem1,rptr=mem2;i<BLKSIZE;i++,wptr++,rptr++)
		if(*wptr != *rptr){
			printf("\n\n");
			printf("\ncompare error byte %x values write %x read %x\n",i,*wptr,*rptr);
			return(1);
		}
	return(0);
}

download()
{
	register int (* exec)();

	exec = (int (*)())0x3fffc;
	(*exec)();
}

sync_setup(bufptr)
char *bufptr;
{
	register char *ptr;
	register unsigned char drive;
	register j;


	if ( (drive = getdrive(bufptr)) < 0 ){
		printf("invalid drive number %x\n",drive);
		return (0);
	}
	if(sync_set(drive))
		printf("drive is only asynchronous\n");

	printf("sync buf ");
	for(j=0,ptr=(char *)(setup_buf);j<4;ptr++,j++)
		printf("%x ",*ptr&0xff);
	printf("\n");
	printf("period %x offset %x\n",*(setup_buf+2),*(setup_buf+3));
	printf("synchronous transfer setup completed\n");

	return(0);
}

sync_set(drive)
register unsigned char drive;
{
	register struct scsiwr *wr;
	register struct peripheral_que *pq_ptr;
	register struct devq *dev;
	register unsigned char drive1;
	register i;
	unsigned temp;
	unsigned char sync_buf[5];

	if(drive < NUMBER_OF_DEVICES){
		drive1 = drive;
		wr = (struct scsiwr *)SCSI_1;
		pq_ptr = &periph_que;
	}
	else{
		drive1 = drive - NUMBER_OF_DEVICES;
		wr = (struct scsiwr *)SCSI_2;
		pq_ptr = &periph1_que;
	}
	dev = getptr();

	setup_buf = (unsigned char *)ipque.freemem_first->fm;
	dev->q_cmd = SET_HOST_XFER;
	dev->q_mem = (char *)setup_buf;
	dev->local_mem = ipque.freemem_first;
	dev->q_count = 4;
	dev->q_flag = (LOC_TO_DK|WAIT);
	dev->q_devnum = drive;
	dev->q_devtype = DISK;
	pq_ptr->pt[drive1].p_first = dev;
	pq_ptr->pt[drive1].p_last = dev;
	pq_ptr->pt[drive1].next_byte_count = 0;
	pq_ptr->bus_id = drive1;
	pq_ptr->periph_active |= BIT(drive1);

	sync_buf[0]=EXTENDED_MSG;
	sync_buf[1]=3;
	sync_buf[2]=SYNC_DATA_XFER;
	sync_buf[3]=50;
	sync_buf[4]=15;

	send_sync_bytes(sync_buf,drive);
	i=0;
	while((dev->q_priority == 0) && (i++ < S_TIMEOUT));

	/* if the req/ack offset returned by the drive is zero, it means
	   that the drive will only support asynchronous transfers 
	*/

	if(*(setup_buf+3) == 0){
		return_ptr(dev);
		return(1);
	}

	temp = *(setup_buf+2);
	temp = (*(setup_buf+2)*4)/40;
	wr->sync_period = temp;			/* six cycles */

	wr->sync_offset = *(setup_buf+3);	/* req/ack character offset */

	if(i >= S_TIMEOUT){
	        dtc_ctl &= (drive < NUMBER_OF_DEVICES) ? ~SCSI1_INT : ~SCSI2_INT;
	        *DTC_CRL = dtc_ctl;
		printf("timeout\n");
		return_ptr(dev);
		return(1);
	}


	return_ptr(dev);

	return(0);

}


async_setup(bufptr)
char *bufptr;
{
	register char *ptr;
	register j;
	register unsigned char drive;


	if ( (drive = getdrive(bufptr)) < 0 ){
		printf("invalid drive number %x\n",drive);
		return (0);
	}
	if(async_set(drive)){
		printf("cannot set up the drive \n");
		return(1);
	}

	printf("async buf ");
	for(j=0,ptr=(char *)(setup_buf);j<4;ptr++,j++)
		printf("%x ",*ptr&0xff);
	printf("\n");
	printf("period %x offset %x\n",*(setup_buf+2),*(setup_buf+3));
	printf("asynchronous transfer setup completed\n");

	return(0);

}

async_set(drive)
unsigned char drive;
{
	register struct scsiwr *wr;
	register struct peripheral_que *pq_ptr;
	register struct devq *dev;
	register i;
	register unsigned char drive1;
	unsigned char sync_buf[5];


	if(drive < NUMBER_OF_DEVICES){
		drive1 = drive;
		wr = (struct scsiwr *)SCSI_1;
		pq_ptr = &periph_que;
	}
	else{
		drive1 = drive - NUMBER_OF_DEVICES;
		wr = (struct scsiwr *)SCSI_2;
		pq_ptr = &periph1_que;
	}

	dev = getptr();

	setup_buf = (unsigned char *)ipque.freemem_first->fm;
	dev->q_cmd = SET_HOST_XFER;
	dev->q_mem = (char *)setup_buf;
	dev->local_mem = ipque.freemem_first;
	dev->q_count = 4;
	dev->q_flag = (LOC_TO_DK|WAIT);
	dev->q_devnum = drive;
	dev->q_devtype = DISK;
	*(short *)&dev->rc1 = 0;
	pq_ptr->pt[drive1].p_first = dev;
	pq_ptr->pt[drive1].p_last = dev;
	pq_ptr->pt[drive1].next_byte_count = 0;
	pq_ptr->bus_id = drive1;
	pq_ptr->periph_active |= BIT(drive1);

	sync_buf[0]=EXTENDED_MSG;
	sync_buf[1]=3;
	sync_buf[2]=SYNC_DATA_XFER;
	sync_buf[3]=0;
	sync_buf[4]=0;

	send_sync_bytes(sync_buf,drive);
	i=0;
	while((dev->q_priority == 0) && (i++ < S_TIMEOUT));

	wr->sync_period = 0;		/* async mode */

	wr->sync_offset = 0;		/* async mode */

	if(i >= S_TIMEOUT){
	        dtc_ctl &= (drive < NUMBER_OF_DEVICES) ? ~SCSI1_INT : ~SCSI2_INT;
	        *DTC_CRL = dtc_ctl;
		printf("timeout\n");
		return_ptr(dev);
		return(1);
	}

	return_ptr(dev);

	return(0);

}
send_sync_bytes(sync_buf,drive)
unsigned char *sync_buf;
unsigned char drive;
{

	register unsigned char *cptr,fifo_ptr;
	register struct scsiwr *wr;
	register struct scsird *rd;
	register int i;
	unsigned char drive1;
	

	/*
	  load both the indentify byte and command descriptor
	  byte into the SCSI chip fifo
	  then load the select with attention command into the command
	  register of the SCSI chip
	*/

	if(drive < NUMBER_OF_DEVICES){
		drive1 = drive;
		wr = (struct scsiwr *)SCSI_1;
		rd = (struct scsird *)SCSI_1;
		periph_que.bus_id = drive1;
		dtc_ctl |= SCSI1_INT;
	}
	else{
		drive1 = drive - NUMBER_OF_DEVICES;
		wr = (struct scsiwr *)SCSI_2;
		rd = (struct scsird *)SCSI_2;
		periph1_que.bus_id = drive1;
		dtc_ctl |= SCSI2_INT;
	}


	if((rd->status&BUS_PHASE) != DATA_OUT){
		printf("not in bus free phase\n");
		return(1);
	}
	
/* Loading the FIFO */

	wr->command = FLUSH_FIFO;

	wr->fifo = IDENTIFY;
	for(i=0,cptr=sync_buf;i<5;i++){
#ifdef DEBUG
		printf("%x ",*cptr);
#endif
		wr->fifo = *cptr++;
	}

/* Loading the command and bus id registers */

	wr->bus_id = drive1;
	wr->command = SEL_ATN_STOP;

	*DTC_CRL = dtc_ctl;		/* enable ddc done interrupt */

	return(0);
}

mode_select(bufptr)
char *bufptr;
{

	register struct devq *dev;
	register i;
	unsigned char drive;


	if ( (drive = getdrive(bufptr)) < 0 ){
		printf("invalid drive number %x\n",drive);
		return (0);
	}

	dev = getptr();
	dev->local_mem = getmem();


	dev->q_devnum = drive;
	dev->q_message = 0;
	dev->q_cmd = MODE_SELECT;
	dev->opr = MODE_SELECT;
	dev->q_flag = (DK_TO_LOC|WAIT|NO_DISCONNECT);
	dev->q_count = MODE_SELECT_HDR + BLOCK_DESCRIPTOR + FORMAT_HD_LEN;
	dev->q_priority = 0;

	if(mode_sel(dev)){
		printf("cannot send out mode select command\n");
		return_ptr(dev);
		return_mem(dev->local_mem);
		return(1);
	}

	i=0;
	while((dev->q_priority != DONE) && (i++ < S_TIMEOUT));
	if(i >= S_TIMEOUT){
	        dtc_ctl &= ~SCSI1_INT;
	        *DTC_CRL = dtc_ctl;
		printf("timeout\n");
		return_ptr(dev);
		return_mem(dev->local_mem);
		return(1);
	}
	if(dev->rc1 == DER_NRDY){
if(PRINT1)
		printf("drive %x not ready\n",drive);
		return_ptr(dev);
		return_mem(dev->local_mem);
		return(1);
	}

	return_ptr(dev);
	return_mem(dev->local_mem);

	return(0);



}

read_capacity(bufptr)
unsigned char *bufptr;
{
	register struct devq *dev;
	register i;
	unsigned long *lptr;
	unsigned long capacity,sect_size;
	unsigned char drive;

	if ( (drive = getdrive(bufptr)) < 0 ){
		printf("invalid drive number %x\n",drive);
		return (1);
	}
	dev = getptr();
	dev->local_mem = getmem();

	dev->q_cmd = READ_CAPACITY;
	dev->opr = READ_CAPACITY;
	dev->q_count = sizeof(int) << 1;
	dev->q_devnum = drive;
	dev->q_flag |= (DK_TO_LOC|WAIT|NO_DISCONNECT);


	read_cap(dev);

	i=0;
	while((dev->q_priority != DONE) && (i++ < S_TIMEOUT));
	if(i >= S_TIMEOUT){
	        dtc_ctl &= ~SCSI1_INT;
	        *DTC_CRL = dtc_ctl;
		printf("timeout\n");
		return_ptr(dev);
		return_mem(dev->local_mem);
		return(1);
	}
	if(dev->rc1 == DER_NRDY){
		printf("drive %x not ready\n",drive);
		return_ptr(dev);
		return_mem(dev->local_mem);
		return(1);
	}
	lptr = (unsigned long *)dev->local_mem->fm;
	capacity = *lptr++;
	sect_size = *lptr;
	printf("capacity %x sector size %x\n",capacity,sect_size);

	return_ptr(dev);
	return_mem(dev->local_mem);
	return(0);
}

read_cap(dev)
register struct devq *dev;
{
	register struct ten_byte_cdb *cdb_ptr;
	register unsigned char drive;
	register struct peripheral_que *pq_ptr;
	struct ten_byte_cdb ms_cdb;

	if(dev->q_devnum < NUMBER_OF_DEVICES){
		drive = dev->q_devnum;
		pq_ptr = &periph_que;
	}
	else{
		drive = dev->q_devnum - NUMBER_OF_DEVICES;
		pq_ptr = &periph1_que;
	}

	cdb_ptr = &ms_cdb;
	/* zero out the command block */
	setbuf(cdb_ptr,5,0);

	cdb_ptr->op_code = dev->opr;
	pq_ptr->pt[drive].p_first = dev;
	pq_ptr->pt[drive].next_mem_ptr = (dev->q_flag&DK_TO_MAIN) ?dev->q_mem :
		(char *)dev->local_mem->fm;
	pq_ptr->pt[drive].next_byte_count = dev->q_count;
	pq_ptr->bus_id = drive;
	pq_ptr->periph_active |= BIT(drive);
	
	*(short *)&dev->rc1 = 0;
	if(send_cmd(cdb_ptr,0,10,dev))
		return(1);


	return(0);
}


mode_snse(dev)
register struct devq *dev;
{

	register struct six_byte_cdb *cdb_ptr;
	struct six_byte_cdb cmd_blk;
	register struct peripheral_que *pq_ptr;
	register unsigned char drive;

	cdb_ptr = &cmd_blk;

	cdb_ptr->op_code =  dev->opr;
	cdb_ptr->unit_block = 0;
	cdb_ptr->block_lsb = 0;
	cdb_ptr->block_msb = dev->scsi_page;
	cdb_ptr->length = dev->q_count;
	cdb_ptr->control = 0;

	if(dev->q_devnum < NUMBER_OF_DEVICES){
		pq_ptr =  &periph_que;
		drive = dev->q_devnum;
	}
	else{
		pq_ptr = &periph1_que;
		drive = dev->q_devnum - NUMBER_OF_DEVICES;
	}
	pq_ptr->pt[drive].p_first = dev;
	pq_ptr->pt[drive].p_last = dev;
	pq_ptr->pt[drive].next_mem_ptr = (dev->q_flag&DK_TO_MAIN) ? dev->q_mem : (char *)(dev->local_mem->fm);
	pq_ptr->pt[drive].next_byte_count = dev->q_count;
	pq_ptr->bus_id = drive;
	pq_ptr->periph_active |= BIT(drive);
	*(short *)&dev->rc1 = 0;
	dev->q_message = 0;
	if(send_cmd(cdb_ptr,0,6,dev))
		return(1);

	return(0);

}


mode_sel(dev)
register struct devq *dev;
{

	register struct six_byte_cdb *cdb_ptr;
	register struct peripheral_que *pq_ptr;
	register unsigned char drive;
	struct six_byte_cdb cmd_blk;
	int i;

	cdb_ptr = &cmd_blk;

	if(dev->q_devnum < NUMBER_OF_DEVICES){
		pq_ptr =  &periph_que;
		drive = dev->q_devnum;
	}
	else{
		pq_ptr = &periph1_que;
		drive = dev->q_devnum - NUMBER_OF_DEVICES;
	}

	cdb_ptr->op_code =  dev->opr;
	cdb_ptr->unit_block = 0x10;

	*(short *)&cdb_ptr->block_msb = 0;
	cdb_ptr->control = 0;

	cdb_ptr->length = dev->q_count;

	pq_ptr->pt[drive].p_first = dev;
	pq_ptr->pt[drive].p_last = dev;
	pq_ptr->pt[drive].next_mem_ptr = (dev->q_flag&MAIN_TO_DK) ? dev->q_mem : (char *)(dev->local_mem->fm);
	pq_ptr->pt[drive].next_byte_count = dev->q_count;
	pq_ptr->bus_id = drive;
	pq_ptr->periph_active |= BIT(drive);
	*(short *)&dev->rc1 = 0;
	if(send_cmd(cdb_ptr,0,6,dev))
		return(1);

	return(0);
}

print_hdr(format_ptr)
struct format_param_page *format_ptr;
{
	printf("format control header information\n");
	
	printf("header          %x\n",format_ptr->f_ms_header);
	printf("block data      %x %x\n",format_ptr->f_block_data[0],format_ptr->f_block_data[1]);
	printf("page code       %x\n",format_ptr->f_page_code);
	printf("page length     %x\n",format_ptr->f_page_length);
	printf("tracks/zone     %x\n",format_ptr->tracks_per_zone);
	printf("altsecs/zone    %x\n",format_ptr->alt_sects_per_zone);
	printf("alt trks/zone   %x\n",format_ptr->alt_trks_per_zone);
	printf("alt_trks/vol    %x\n",format_ptr->alt_trks_per_vol);
	printf("sects/track     %x\n",format_ptr->sects_per_track);
	printf("bytes/sect      %x\n",format_ptr->bytes_per_sect);
	printf("interleave      %x\n",format_ptr->interleave);
	printf("track skew      %x\n",format_ptr->track_skew);
	printf("cyl skew        %x\n",format_ptr->cylinder_skew);



}

unsigned char
getdrive(bufptr)
char *bufptr;
{

	char *ptr;
	unsigned char drive;
	unsigned int drive1;

	ptr = skiparg ( bufptr );	/* skip over command */
	if ( getlong(&ptr, &drive1) < 0 ){
		printf("invalid drive number %x\n",drive);
		return (-1);
	}

	drive = drive1&0xff;
	return(drive);

}

clear_ptrs(cdb,dev,mem)
struct six_byte_cdb *cdb;
struct devq *dev;
int *mem;
{

	setbuf(cdb,3,0);
	setbuf(dev,sizeof(struct devq)/2,0);
	setbuf(mem,0x800,0);


}

struct devq *
getptr()
{
	struct devq *dev;
	dev = ipque.i_p_dqfirst;
	ipque.i_p_dqfirst = dev->q_next;
	setbuf(dev,sizeof(struct devq)>>1,0);
	dev->q_flag = FREE_REQ;
	return(dev);
}

struct free_mem *
getmem()
{
	struct free_mem *fm;
	fm = ipque.freemem_first;
	ipque.freemem_first = fm->fm_next;
	fm->fm_next = 0;
	return(fm);
}
return_ptr(dev)
register struct devq *dev;
{

	if(ipque.i_p_dqfirst)
		ipque.i_p_dqlast->q_next = dev;
	else
		ipque.i_p_dqfirst = dev;

	ipque.i_p_dqlast = dev;
	dev->q_next = 0;

}

return_mem(fm)
struct free_mem *fm;
{

	ipque.freemem_last->fm_next = fm;
	ipque.freemem_last = fm;
}
