	/*	HSDT/EDT DATA STRUCTURES	*/

#define NUMBER_OF_DEVICES 7  /*the number of peripeheral devices which can be
				connected to a scsi bus */
#define SCSI_BUSSES	  2  /* the number of scsi busses on each controller */

struct dtb_que{
	unsigned char dtb_active; /* the dtb is busy */
	char d_tick;     /* count for dtb timeout */
	struct devq *d_first;
	struct devq *d_last;
	struct devq *request_removed;
};

struct peripheral_que{
	unsigned short periph_active; /*The peripheral is either busy 
			transferring data or has disconnected while getting 
			ready to transfer data. No other command should be sent
			to this peripheral until this bit is reset. */
	unsigned short bus_id;

	struct periph_table *scsi_periph_ptr;  /* this pointer is used to select
			the next scsi peripheral which is available to accept a
			command. After each command has been executed the 
			pointer is moved to the next periph_table que with a 
			waiting element. */
    	struct periph_table{
		unsigned int p_time;
		struct devq *p_first;
		struct devq *p_last;
		char *next_mem_ptr;
		unsigned int next_byte_count;
		struct periph_table *next_periph_ptr;
    	}pt[NUMBER_OF_DEVICES];
};

struct interim_processing_que{
	unsigned char i_p_active;
		/*this flag will have several values:
			1 - busy processing parts of a request; do not
			    allow other read/write processing to start
			2 - mmu table loaded
		*/

	struct devq *i_p_first;
	struct devq *i_p_last;
	struct devq *i_p_dqfirst; /*pointer to the next available free request
				structure */
	struct devq *i_p_dqlast;
	struct mmutbl *i_p_mmutable; /*pointer to the local address of the 
				mmutable for the present request */
	struct free_mem *freemem_first; /*pointer to next free 1k block of 
				local memory*/
	struct free_mem *freemem_last;
	int i_p_block;  /*the block number which we are presently processing
			on the device */
	int i_p_count;	/*the number of bytes that have been transferred 
			so far */
	int i_p_proc_count; /*number of bytes that have been processed and
			placed on another queue for transfer */
};

struct tape_que{
	unsigned char t_active;
	unsigned short t_tick;
	struct devq *t_first;
	struct devq *t_last;
	unsigned char tape_status_waiting;
	struct devq * tape_wait_que[4];
	unsigned waiting_timer[4];
};


/* device type (devq.q_devtype) use defines for dd_type */
#define DTLBUF  4 /* the device is a local memory buffer */

/* q_extdtb use defines for bd_xdtbid */
#define XDDFLT  0xff  /* use the default external dtb in bd_desc (bd_xdtbid) */

#define NUMMUSLOTS 1024

struct  mmutbl {
#ifndef S90
/*
	short spacer;		spacer put in because the address of the
				mmu table in main memory is on a non long
				word boundary */
#endif	
	short mmu1index;
	short offset1;
	int   length1;
	short mmu2index;
	short offset2;
	int length2;
#ifndef S90
	short   mmuslots[NUMMUSLOTS];	/* image of mmu registers */
#else
	int mmuslots[NUMMUSLOTS];	/* image of mmu registers */
#endif
};
