
#include "scsi_ccpu.h"
#include "scsi.h"
#include "devcmd.h"
#include "scsi_dtc.h"
#include "scsi_error.h"
#include "scsi_ptm.h"
#include "vreg.h"
#include "data_struct.h"
#include "scsiextrn.h"
#include "disksect.h"
#include "disk_struct.h"
#include "scsitape.h"
#include "scsi_mem_map.h"
#include "registers.h"
#include "commands.h"
#include "message.h"
#include "command_blk.h"
#include "scsidata.h"


#define DISKIO	1

struct dkinf *getphptr();

int  diskclose(), dkcmder();

extern ldlogrw(),phyrw(),pdlogrw();
extern unit_rdy(),rezero(), read_buffer();
extern reopen(),swapdev(),scsiparse();
extern wrsysec0();
/*
extern	request_sense(), read_defects(), write_buffer();
extern	write_ext(), seek_ext(), verify();
extern	spare(), rec_diag(), send_diag(), read_capacity(), read_ext();
extern	 seek(), inquiry(), mode_select(), mode_sense(), start_unit();
*/

extern struct free_mem *getmem();

struct dcmd {
	int (*func)(); unsigned char io; unsigned char opr;
} dcmdtbl[] = {
	dkcmder,	0,	0,	/* 0 */
	ldlogrw,	DISKIO,	READ, /* 1 log dr,log sec */
	ldlogrw,	DISKIO,	WRITE,
	phyrw,		DISKIO,	READ, /* 3 physical dr,log sec */
	phyrw,		DISKIO,	WRITE,
	pdlogrw,	DISKIO,	READ, /* 5 reserved area,log sec */
	pdlogrw,	DISKIO,	WRITE,
	dkcmder,	0,	0,	/* 7 */
	dkcmder,	0,	0,	/* 8 */
	dkcmder,	0,	0,	/* 9 */
	dkcmder,	0,	0,	/* a */
	dkcmder,	0,	0,	/* b */
	dkcmder,	0,	0,	/* c */
	dkcmder,	0,	0,	/* d */
	reopen,		0,	0,	/* e (reopen) read sector 0 */
	diskclose,	0,	0,	/* f erase table for phy drive */


	dkcmder,	0,	0,	/* 10 size disk */
	dkcmder,	0,	0,	/* 11 get bad block list */
	dkcmder,	0,	0,	/* 12 next available rv sector */
	dkcmder,	0,	0,	/* 13 prg alt, set spare table */

	dkcmder,	0,	0,	/* 14 med list */
	dkcmder,	0,	0,	/* 15 total bad blk number */

	dkcmder,	0,	0,	/* 16 prg alt sector to -1 */
	dkcmder,	0,	0,	/* 17 total alt sectors number */

	dkcmder,	0,	0,	/* 18 get alt sectors list */
	swapdev,	0,	0,	/* 19 swap device */
	
	dkcmder,	0,	0,	 /* 1a,1b: pdr,chs(mult)spare lookup */
	dkcmder,	0,	0,	/* skip track */

	dkcmder,	0,	0,	/* 1c format sectors */

	dkcmder,	0,	0,	/* 1d wait for all diskio completed */

	dkcmder,	0,	0,	/* 1e unspare sector */
	dkcmder,	0,	0,	/* 1f setup timing parameters */
	wrsysec0,	0,	WRITE,	/* 20 write system sector 0 */
	dkcmder,	0,	0,	/*21 seek to the specified cyl number */
	dkcmder,	0,	0,	/* 22 read sector id */
	dkcmder,	0,	0,	/* 23 read med def list by track */
	dkcmder,	0,	0,  /*24 additional status information */
	scsiparse,	0,	0,	/* 25 scsi tool box command */

};
	
dkparse(dev)
register struct devq *dev;
{
	register unsigned char operation;
	register struct dkinf *dkptr; register struct dcmd *p;
	struct smdrd *rd;
	struct interim_processing_que *iptr;

	/* ***************************************** */
	/* check to see if there was a power failure */
	/* if so, stop all diskio 		     */
	/* ***************************************** */

	/* check for valid disk command */
	if ( dev->q_cmd >= (sizeof dcmdtbl / sizeof(struct dcmd)) ) {
		dev->rc1 = DER_ILLCMD;
		return(1);
	}

	p = &dcmdtbl[dev->q_cmd];

	if ( (dev->q_cmd == LREAD) || (dev->q_cmd == LWRITE) ) {
		/* use logical_drive to store the logical drive number*/
		dev->q_priority= dev->q_devnum & 0xf;
		dev->q_devnum = dev->q_devnum >> 4;
	}
	if((dkptr = getphptr(dev)) == (struct dkinf *)0)
		return(1);

	if(dev->q_cmd == SPECIAL_SCSI_CMD){
		if((p->func) (dev,dkptr))
			return(1);
		return(0);
	}
		

	/* only convert for read/write command */
	operation = p->opr;

	if ( (operation == OPR_READ) || (operation == OPR_WRITE) ) {
		/* can't take care of partial sectors */
		if ( (dev->q_count < BLKSIZE) || (dev->q_count & (BLKSIZE-1))
			|| (dev->q_count == 0) || (((int)dev->q_mem & 0x03) &&
			(!(dev->q_mmu)))) {
			dev->rc1 = DER_CNT;
			return(1);
		}
		if((dev->q_mmu) && (dev->q_count > MAX_RAW_COUNT)){
			dev->rc1 = DER_CNT;
			return(1);
		}
		/* convert total count to sector count, main memory shifted */
		dev->scnt = dev->q_count >> BLKSIZBIT;

	}

	*((short *)&dev->rc1) = 0;	/* zero return code */

	dev->opr = operation;		/* set operation code */


	if((p->func) (dev,dkptr))
		return(1);

	/*If it is not contiguous memory, put it on the interim_
	  processing_queue */

	dev->q_flag |= (dev->opr == READ) ? DK_TO_MAIN : MAIN_TO_DK;

	if(dev->q_mmu){
		iptr = &ipque;
		if(iptr->i_p_first)
			iptr->i_p_last->q_next = dev;
		else
			iptr->i_p_first = dev;
		iptr->i_p_last = dev;
		return(0);
	}

	send_out_the_request(dev);


	return(0);

}

dkcmder(dev)
struct devq *dev;
{
	dev->rc1 = DER_ILLCMD;
	return(1);
}


/* ***********************************************************   */
/* close a drive, we need to erase physical drive table, logical */
/* drive table, skip track list for all drives, and reopen the   */
/* other drive later don't erase timing values if they have      */
/* been sent by the master cpu    			         */
/* ***********************************************************   */
diskclose (dev)
struct devq *dev;
{
	register unsigned short stat, i;
	register struct dev_desc *devptr;
	register struct dkinf *dkptr;
	unsigned char timeval[32];


	dkptr = phydr;
	for (i=0; i<MAX_PDRIVE; i++) {
		stat = dkptr->pd_ststat & (~DK_INIT);

		setbuf ( dkptr, sizeof (struct dkinf) >> 1, 0);

		dkptr->pd_ststat = stat;

		dkptr++;
	}
	devptr = devdesc;
	if(!(devptr->dd_type & DTDISK)) devptr++;
	devptr->dd_count = 0;

}


swapdev (dev, dkptr)
register struct devq *dev; register struct dkinf *dkptr;
{
	register struct ld *ldkptr; register unsigned char i;

	/* wait for operation to be completed */

	dev->q_count = -1;
	/* if need to read sector 0, will always wait for it */
	if ( check_for_open (dev, dkptr) ) 
		return(1);


	    if(dkptr->pd_ststat&DK_INIT){
		ldkptr = dkptr->pd_ptr;		/* point to the logical drive 
						table */
	        for (i=0;  i<dkptr->pd_ldnum; i++,ldkptr++) {
		    if ( ldkptr->ld_type == LD_SWAP ) {
			dev->q_count = i;
			dev->q_mem = (char *)ldkptr->ld_size;
			return(1);
		    }
	      	}
	    }

	return(1);			/* can't find any swap device */
}

struct dkinf *
getphptr(dev)
register struct devq *dev;
{
	if ( (dev->q_devnum) >= SCSI_BUSSES*NUMBER_OF_DEVICES) {
		dev->rc1 = DER_DRLIMIT;
		printf ("D=%x invalid\n",dev->q_devnum);
		return ((struct dkinf *)0);
	}

	return ( &phydr[dev->q_devnum] ) ;
}

send_out_the_request(dev)
register struct devq *dev;
{
	register unsigned char drive;
	register struct peripheral_que *pq_ptr;
	register struct periph_table *p_ptr;
	register unsigned short oldpri;

	oldpri = spl6();
	if(dev->q_devnum < NUMBER_OF_DEVICES){
		pq_ptr =  &periph_que;
		drive = dev->q_devnum;
	}
	else{
		pq_ptr =  &periph1_que;
		drive = dev->q_devnum - NUMBER_OF_DEVICES;
	}
	p_ptr = &pq_ptr->pt[drive];
	if(p_ptr->p_first){
		p_ptr->p_last->q_next = dev;
		p_ptr->p_last = dev;
/*
		check_sort(dev,p_ptr);
*/
	}
	else {
		p_ptr->p_first = dev;
		p_ptr->p_last = dev;
		if(pq_ptr->periph_active == 0){
		       if(diskrw(dev)){
		            if(pq_ptr->scsi_periph_ptr == 0)
		                pq_ptr->scsi_periph_ptr = p_ptr;
		       }
		       splx(oldpri);
		       return(0);
		}
		if((pq_ptr->scsi_periph_ptr == 0) && 
		    (!(pq_ptr->periph_active&BIT(drive))))
		       pq_ptr->scsi_periph_ptr = p_ptr;
	}

	splx(oldpri);
}

reopen(dev,dkptr)
struct devq *dev;
struct dkinf *dkptr;
{

	dkptr->pd_ststat &= ~DK_INIT;

	dev->local_mem = getmem();

	diskopen(dev,dkptr);

	return_mem(dev->local_mem);

	return(1);
}
