#include "scsi_ccpu.h"
#include "scsi_dtc.h"
#include "scsi.h"
#include "vreg.h"
#include "scsi_error.h"
#include "scsiextrn.h"
#include "data_struct.h"
#include "scsi_mem_map.h"
#include "command_blk.h"
#include "message.h"
#include "devcmd.h"
#include "scsi_ptm.h"
#include "commands.h"
#include "scsidata.h"

#define NOCHAIN	0
#define DMA 0x80

diskrw(dev)
register struct devq *dev;
{

	register struct six_byte_cdb *cdb_ptr;
	register struct ten_byte_cdb *cdb_ptr1;
	register struct periph_table *p_ptr;
	struct peripheral_que *pq_ptr;
	register unsigned char drive;
	struct ten_byte_cdb ten_cdb;
	struct six_byte_cdb six_cdb;
	int byte_cnt;

	time_counter_array[dev->q_devnum] = clock_cnt;

/*If only one drive is connected, don't bother disconnecting */

	if(disk_pointer->dd_count == 1)
		dev->q_flag |= NO_DISCONNECT;

	if(dev->q_devnum < NUMBER_OF_DEVICES) {
		pq_ptr = &periph_que;
		drive = dev->q_devnum;
	}
	else{
		pq_ptr = &periph1_que;
		drive = dev->q_devnum-NUMBER_OF_DEVICES;
	}

	if(dev->opr & 0xe0){
		cdb_ptr1 = &ten_cdb;
		cdb_ptr1->op_code = dev->opr;
		cdb_ptr1->logical_unit=0;
		cdb_ptr1->cb_blk.block = dev->q_devun.block;
		cdb_ptr1->reserved=0;
		cdb_ptr1->length_msb =(dev->scnt>>8)&0xff;
		cdb_ptr1->length_lsb =dev->scnt&0xff;
		cdb_ptr1->control=0;
		cur_command = (unsigned int *)cdb_ptr1;
		byte_cnt = TEN_BYTE_CDB_SIZE;
	}
	else{
		cdb_ptr = &six_cdb;
		cdb_ptr->op_code = dev->opr;
		cdb_ptr->unit_block=0;
		if((dev->opr == READ) || (dev->opr == WRITE)){
		    cdb_ptr->length = dev->q_count/BLKSIZE;
		    cdb_ptr->unit_block |= (dev->q_devun.block>>16)&0xf;
		    cdb_ptr->block_msb = (dev->q_devun.block>>8)&0xff;
		    cdb_ptr->block_lsb = dev->q_devun.block&0xff;
		}
		else{
		    cdb_ptr->length = (dev->opr==REASSIGN_BLKS)?0:dev->q_count;
		    cdb_ptr->block_msb = dev->scsi_page;
		    cdb_ptr->block_lsb = 0;
		}
		cdb_ptr->control=0;
		cur_command = (unsigned int *)cdb_ptr;
		byte_cnt = SIX_BYTE_CDB_SIZE;
	}

	if(send_cmd(cur_command,0,byte_cnt,dev)){
		if(pq_ptr == &periph_que)
			last_drive = drive;
		else
			last_drive1 = drive;
		return(1);
	}
	*(short *)&dev->rc1 = 0;
	pq_ptr->periph_active |= BIT(drive);
	p_ptr = &pq_ptr->pt[drive];
	p_ptr->p_time = TICK_3SEC;
	p_ptr->next_byte_count = dev->q_count;
	p_ptr->next_mem_ptr = (dev->q_flag&(DK_TO_LOC|LOC_TO_DK)) ? (char *)dev->local_mem->fm : (char *)dev->q_mem;
	
	pq_ptr->bus_id = drive;
	if(pq_ptr == &periph_que)
		last_drive = drive;
	else
		last_drive1 = drive;

	pq_ptr->scsi_periph_ptr = 0;

	return(0);


}
set_local_dma(dev,length,direction)
struct devq *dev;
register unsigned int length;
unsigned char direction;
{
	register struct scsiwr *wr;
	register unsigned int length1;

	wr = (dev->q_devnum < NUMBER_OF_DEVICES) ? (struct scsiwr *)SCSI_1 :
		(struct scsiwr *)SCSI_2;


	/* dma counts must be for a multiple of four bytes on a read and
	a multiple of four + eight on a write */

	length1 = (direction == MEM_TO_SCSI) ? ((((length+8)/4)*4)) : (((length+3)/4)*4);
	dmaddr ( dev->q_mem, length1-4, DDCDMA);

	/* load the transfer count register */


	wr->xferlo = length&0xff;
	wr->xferhi = (length>>8)&0xff;

	/* set the direction of transfer */

	dt_control |= direction;
	*(DT_CTRL_REG) = dt_control;

	/* enable the SCSI dma and program the data path */
	msdklocm ();



}

dmaddr (ptr, bytcnt, dmatype)
int ptr; int bytcnt, dmatype;
{

	*(short *)((int)DDC_DMAS + dmatype) = (short)ptr;

	*(short *)((int)DDC_DMAE + dmatype)=(short)((int)ptr + bytcnt);
}


/*
	setup data path for disk <-> local memory
	enable DDC dma & DDC ALT dma
 */
msdklocm()
{

	unsigned short oldpri;

	/* disable interrupts */

	oldpri = spl6();
	/* data path with DISK <-> local memory */
	dbc_cr = (dbc_cr & CR_MASK) | LOCMEM;
	*DBC_CR = dbc_cr;

	/* DBC control register: enable DDC dma */
	dbc_cr = dbc_cr | DDC_EN;
	*DBC_CR = dbc_cr;

	/* enable interrupts */
	splx(oldpri);
}


cancel_dma(flag)
unsigned short flag;
{
#ifdef S90
	register struct dtb_que *dptr;
	register struct devq *dev;
#endif

	if((dtbque.dtb_active&TRANSFER_DONE) == TRANSFER_DONE){
		dtbque.d_tick = 0;
	    if ( flag & (DK_TO_LOC|LOC_TO_DK) ) 
		dbc_cr &= ~(DDC_EN);
	    else 
		dbc_cr &= ~CHN_EN;

	    *DBC_CR  = dbc_cr;
	    dt_control &= ~(MEM_TO_SCSI|READ_REMAINDER);
            *(DT_CTRL_REG) = dt_control;
	    dtbque.dtb_active = 0;
#ifdef S90
if (PRINT4) printf("<< DISK >>");
	    dptr = &dtbque;
	    dev = dptr->request_removed;
	    if ((dev->rc1 == 0) && (dev->rc2 == 0))
	      if (dev->opr == READ)
	        quickread(dev);
#endif
	    return(1);
	}
	return(0);

}

/* ******************************************************************* */ 
/* setup apropriate DMA to rw sector/rw id to main memory/local memory */
/* ******************************************************************* */ 
setupdma(dev, length,mem,direction, chaining)
register struct devq *dev; 
unsigned int length;
char *mem;
unsigned char direction;
unsigned char chaining;
{
	register unsigned char *bufptr;
	register dtb_direction;
	unsigned int length1;
	struct scsiwr *wr;


	bufptr = dtbbuf;
	wr = (dev->q_devnum < NUMBER_OF_DEVICES) ? (struct scsiwr *)SCSI_1 :
		(struct scsiwr *)SCSI_2;

	/* dma counts must be for a multiple of four bytes on a read and
	a multiple of four + eight on a write */

	length1 = (direction == MEM_TO_SCSI) ? ((((length+8)/4)*4)) : (((length+3)/4)*4);

	wr->xferlo = length&0xff;
	wr->xferhi = (length>>8)&0xff;


	if ( (dev->q_flag & (DK_TO_LOC|LOC_TO_DK)) == 0 ) {

		/* setup chain dma for disk <-> main memory */
		if ( (direction == SCSI_TO_MEM))
			dtb_direction = WR_DTB;
		else
			dtb_direction = RD_DTB;

		if ( chaining || (dev->q_mem == (char *)0))
			prgdtbchn (dev, dtb_direction,length);
		else {
			*bufptr=dtb_direction | bddesc.bd_dtbid;/*boardid num */
#ifndef S90
			*(bufptr+1) = 0;
#else
			*(bufptr+1)=(unsigned char)(((int)mem&0xf0000000)>>24);
#endif
			*(short *)(bufptr+2) = length1 >> 2;/* long word ct */
#ifndef S90
			*(int *)(bufptr+4) = (int)mem>>2;
#else
			*(int *)(bufptr+4) = (int)((((int)mem&0xfffffff))<<4);
#endif

			/* program CHAIN DMA start & end address with 
				8 byte buffer containing DTB parameters */
			dmaddr ( bufptr, DTBP_LEN-4, CHNDMA);
		}

		/* enable CHAIN DMA and program data path */
		mslmdkdtb (dtb_direction, DISK);


	}
	else {

		/* ************************* */
		/* disk <-> local memory     */
		/* does not have an MMU structure */
		/* ************************* */

		/* setup DDC dma for disk r/w into local memory */
		dmaddr ( mem, length1-4, DDCDMA);

		/* enable DDC dma, program data path */
		msdklocm ();
	/* set the direction of transfer */

		dt_control |= direction;
		*(DT_CTRL_REG) = dt_control;
	}

	dtbque.d_tick = TICK_2SEC;


}

/*
	DTB can't be busy
	setup data path for DTB <-> local memory/disk
	DTB function code
	enable DTB dma & CHN dma for local memory <-> DTB
	enable CHN dma & ALT dma for disk <-> DTB
	input: direction : RD_DTB = DTB -> local memory (receive data from
					main memory)
			   WR_DTB = local memory -> DTB (send data to 
					main memory)
		type= 	DISK ( disk <-> DTB )
			LOCM (local memory <-> DTB)
 */

mslmdkdtb (direction, type)
int direction, type;
{
	register ctrldata; 

	/* first reset the dtb fifo to clear the leftover bytes*/

	dtb_cr &= RST_FIFO;
	*DTB_CR = dtb_cr;

	/* send data to main memory */
	if ( direction == WR_DTB) {
		dtb_cr = FS_WRCHN;
		/* local memory/disk -> DTB (write DTB) */
		if ( type == DISK )
			ctrldata = WRDTB;
		else
			ctrldata = LOCMDTBX | WRDTB;
	}
	else {
	/* receive data from main memory */
		dtb_cr = FS_RDCHN;
		/* DTB -> local memory/disk (read DTB) */
		if ( type == DISK )
			ctrldata = RDDTB;
		else
			ctrldata = LOCMDTBX | RDDTB;
	}

	/* DBC control register : DTB/DISK data path mode */
	dbc_cr = (dbc_cr & CR_MASK) | ctrldata;
	*DBC_CR = dbc_cr;

	/* set the direction of transfer */

	if(type == DISK){
		dt_control |= (direction==WR_DTB) ? SCSI_TO_MEM : MEM_TO_SCSI;
		*(DT_CTRL_REG) = dt_control;
	}

	/* DTB control register : DTB function code */
	*DTB_CR = dtb_cr;


	/* DBC control register:
		local memory : enable DTB dma, CHAIN dma
		disk:		enable CHN dma 
	*/
	if ( type == DISK )
		dbc_cr = dbc_cr | CHN_EN;
	else
		dbc_cr = dbc_cr | DTB_EN | CHN_EN; 
	*DBC_CR = dbc_cr;

	return;
}

check_error(dev)
struct devq *dev;
{
	register struct scsird *rd;

	rd = (dev->q_devnum < NUMBER_OF_DEVICES) ? (struct scsird *)SCSI_1 :
		(struct scsird *)SCSI_2;

	/* check for and error that occurred because the bus or dma has 
	hung up

	read all of the registers, the fifo, and the transfer count
	check the dma count
	
	*/
	printf("dma count:start %x end %x\n",*(short *)((int)DDC_DMAS + DDCDMA),
	*(short *)((int)DDC_DMAE + DDCDMA));

	printf("status %x\n",rd->status);
	printf("sequence %x\n",rd->seq_step);
	printf("fifo_flags %x\n",rd->fifo_flag);

	printf("cmd_reg %x\n",rd->command);

	/* then read/clear the interrupt status register */

	printf("int_status %x\n",rd->interrupt);
   	printf("transfer count %x\n",(rd->xferhi<<8)|rd->xferlo);

	reset_chip(0);
	reset_bus(0);

	if(req_sense(dev->q_devnum))
		return(1);

	return(0);

}


/* ********************************************** */
/* program dtb parameters for chaining dma        */
/* do not enable the dma yet                      */
/* buffer transfer into non-contiguous memory      */
/* return : number of bytes programmed 		   */
/* ********************************************** */

prgdtbchn(dev,direction,count)
register struct devq *dev;
unsigned int direction;
unsigned int count;
{
	register unsigned short totcnt, bytecnt, index, offset,section;
	register unsigned char *ptr;
	register struct mmutbl *mmu;
	unsigned int tot1cnt;
	unsigned short index1,offset1;

	ptr = dtbarray;

	mmu = ipque.i_p_mmutable;
	if(dev->q_cmd == LREAD)
		totcnt = (count & ~3);
	else
		totcnt=(count&3) ? ((count+4)& ~3) : count;

	tot1cnt = totcnt;
	index = (short)dev->q_mmu;
	offset = (short)dev->q_mem;
	section = 0;

	while ( totcnt ) {
		/* determine how many bytes fit in next page */
		bytecnt = PAGESIZE - offset;

		if ( bytecnt > totcnt ){
			bytecnt = totcnt;
			offset1 = offset+bytecnt;
			index1=index;
		}

		/* program dtb buffer */
		*ptr = direction | bddesc.bd_dtbid;/* boardid num */
#ifndef S90
		*(ptr+1) = 0;
#else
		*(ptr+1) = (char)((mmu->mmuslots[index]&0xf0000000)>>24);
#endif
		*(short *)(ptr+2) = bytecnt >> 2;
#ifndef S90
		*(int *)(ptr+4) = ( (mmu->mmuslots[index] << 12) | offset )>>2;
#else
		*(int *)(ptr+4) = ( (mmu->mmuslots[index] << 4) | offset );

#endif
		section++;
		index++;
		totcnt -= bytecnt;

/* We have to do this because the SCSI controller requires that, on a write,
   the dtb be programmed for 8 bytes more than the actual count.  In some
   cases this can cause the count to overlap a page and this can result in
   a possibility of reading invalid memory.  Since the last 8 bytes are just
   throw aways, we will just read them from the same last page as the transfer
   before.
*/
		if(totcnt == 0){
		    if(dev->q_devtype == DISK){
		        bytecnt = (direction == RD_DTB) ? ((((bytecnt+8)/4)*4)) : (((bytecnt+3)/4)*4);
			if(bytecnt+offset <= PAGESIZE)
			    *(short *)(ptr+2) = bytecnt >> 2;
			else{
			    ptr += 8;
			    *ptr = direction | bddesc.bd_dtbid;/* boardid num */
			    *(short *)(ptr+2)=((bytecnt+offset)-PAGESIZE) >> 2;
#ifndef S90
			    *(int *)(ptr+4) = ( (mmu->mmuslots[index-1] << 12) | offset )>>2;
#else
			    *(ptr+1) = (char)((mmu->mmuslots[index-1]&0xf0000000)>>24);
			    *(int *)(ptr+4) = ( (mmu->mmuslots[index-1] << 4) | offset );
#endif
			    section++;
			}

		    }
		}
		offset = 0;
		ptr +=8;

	}

	/* If we are reading for a non long word count, we must put
	the address of the final bytes in the 'q_mem' slot of the
	response so that the master can transfer them
	*/

	if((count&3) && (dev->q_cmd == LREAD)){
		ipque.i_p_first->q_mem =(char *)(((mmu->mmuslots[index1]<<12) | 
			(offset1)));
		ipque.i_p_first->local_mem = (struct free_mem *)
			(*(int *)(((int)dev->local_mem->fm) + tot1cnt));
	}

	/* program CHAIN DMA start & end address with 
		dtbbuffer containing DTB parameters */
	if(tot1cnt)
		dmaddr ( dtbarray, (DTBP_LEN * section)-4 , CHNDMA);


	return (tot1cnt);

}

#define XFER_MASK (DTB_INT + CHNDMA_INT + DTBDMA_INT)
/*	
	dtbptr : (DTB parameter) pointer to an 8 byte buffer containing:
			dtbptr+2,3: long word cnt
			dtbptr+4,5,6,7: main memory address >>2
	locmem:		pointer to DTC local data buffer
	direction:	RD_DTB: DTB -> local mem (receive data from main mem)
			WR_DTB: local memory -> DTB (send data to main memory)

	transfer a block of data between main memory and DTC memory

	setup DTB param byte 0 :DMC control byte (direction & boardid)
	setup DTB param byte 1: zero
	program CHAIN DMA address with a pointer to the DTB parameters 
	    (an 8 byte buffer)
	program the DTB DMA address with the DTC local buffer address
	setup the data path mode for DTB <-> main memory transfer

*/
xferdata(dtbptr, locmem, direction, wait)
char *dtbptr, *locmem; int wait;
unsigned int direction;
{	register char *ptr; register struct dtb_que *dptr;
	register timeout, i;


	interrupt &= ~(DTB_INT | DDCDMA_INT | DDADMA_INT | CHNDMA_INT | 
		DTBDMA_INT | DDC_INT);

	ptr = dtbptr;

	/* setup DTB parameter: DMC dma msb byte count/control
		main memory -> DTB */
	*ptr++ = (char)(direction | bddesc.bd_dtbid);	/* hsdt boardid */

	ptr++;

	/* program the DTB DMA starting & ending address with 
		the DTC local data buffer address */
	dmaddr ( locmem, ((*(unsigned short *)ptr) << 2)-4,DTBDMA); /* byte count */

	/* program the CHAIN DMA starting & ending address with 
		an 8 byte buffer containing DTB parameters */
	dmaddr ( dtbptr,  DTBP_LEN-4, CHNDMA);		/* byte count=8 */

	/* program the DTB/DISK data path mode for local memory <->DTB */
	mslmdkdtb (direction, ~DISK);

	if ( wait == DTBNOWAIT ) {
		dtbque.d_tick = TICK_1SEC;
		return(0);
	}


	/* wait for both the DTB interrupt and the DMA interrupt */

	/* ******************** */
	/* set a timer incase the DTB gets hung up */
	/* ******************** */
	timeout = TIMEOUT;
	for (i=0; i<0xf000; i++) {
/*ADD A VARIABLE TO CHECK FOR TIMEOUT */
		if(timeout == 0)
			break;
	}

	/* clear both the CHAIN DMA & DTB DMA done bit */
	dbc_cr &= ~(CHN_EN + DTB_EN);
	*DBC_CR = dbc_cr;
	dptr = &dtbque;
	if((dptr->d_first = dptr->d_first->q_next) == (struct devq *)0)
		dptr->d_last = (struct devq *)0;
	dptr->d_tick = 0;
	dptr->dtb_active = 0;

	if ( timeout )
		printf ("t8 ");

	return (timeout);
}


adjmmu(sectdone,index,offset)
register unsigned short sectdone;
register unsigned short *index,*offset;
{
	register unsigned int offset1;


	offset1 = *offset;

	offset1 += (sectdone << BLKSIZBIT);

	if ( offset1 >= PAGESIZE ) 
		*index += (offset1 >> 12 );

	*offset = offset1 & 0x0fff;

}

canceldmc()
{	register unsigned char *bptr;
	register unsigned char status; register i, timeout;
	char *buf;;


	/* disable chain dma to prevent hardware from program next block
	   transfer which will cause race condition. This problem only happen
	   when SCSI drive disconnects the data transmission */

	dbc_cr &= ~CHN_EN;
	*DBC_CR = dbc_cr;

	buf = (char *)ipque.freemem_last->fm;

	/* *************************************************** */
	/* grab one long word from dtb dma */

	/* disable DTB */
	*DTB_CR = 0;

	/* setup DTB dma to get one long word from main memory */
	dmaddr ( buf, 0, DTBDMA);

	/* DBC control register : local <-> DTB, read from DTB */
	dbc_cr = (dbc_cr & CR_MASK) | LOCMDTBX | RDDTB;
	*DBC_CR = dbc_cr;

	dbc_cr |= DTB_EN;		/* enable DTB dma */
	*DBC_CR = dbc_cr;

	/* enable interrupt and return */
	for (i=0; i<10; i++) {
		if ( ((status= *DBC_SR) & DTB_EN) ) {
			break;
		}
	}

	/* disable dtb dma */
	dbc_cr &= ~DTB_EN;
	*DBC_CR = dbc_cr;

	/* *************************************************** */
	/* abort DMC for last transfer */
	bptr = dtbbuf;

	*bptr = DMC_ABT;
#ifndef S90
	*(bptr+1) = 0;
#endif
	*((short *)(bptr+2)) = 0;

	dmaddr ( bptr, 0, DTBDMA );

	dbc_cr = (dbc_cr & CR_MASK) | (LOCMDTBX | WRDTB);
	*DBC_CR = dbc_cr;

	*DTB_CR = 0;
	*DTB_CR = FS_SINT;

	dbc_cr = dbc_cr | DTB_EN;
	*DBC_CR = dbc_cr;

	/* *********************************************** */
	/* wait for DTBDMA to happen, interrupts are turned off */
	/* *********************************************** */

	timeout = TIMEOUT;
	for (i=0; i<0xf000; i++) {
		if ( (status = *DBC_SR) & DTB_EN ) {
			timeout = 0;
			break;
		}
	}

	dbc_cr &= ~DTB_EN;
	*DBC_CR = dbc_cr;


}

check_dtb_status()
{

	register i,timeout,j;
	register unsigned char status;
	char *buf;


	/* disable chain dma to prevent hardware from program next block
	   transfer which will cause race condition. This problem only happen
	   when SCSI drive disconnects the data transmission */

	dbc_cr &= ~CHN_EN;
	*DBC_CR = dbc_cr;

	buf = (char *)ipque.freemem_last->fm;


	/* setup DTB dma to get one long word from main memory */
	dmaddr ( buf, 4, DTBDMA);


	*DTB_CR = STATUS_FUNC;
	*DTB_CR = DTB_INTERFACE_ENAB|STATUS_FUNC;

	dbc_cr = (dbc_cr & CR_MASK) | LOCMDTBX | RDDTB;
	*DBC_CR = dbc_cr;

	dbc_cr = dbc_cr | DTB_EN;
	*DBC_CR = dbc_cr;

	/* *********************************************** */
	/* wait for DTBDMA to happen, interrupts are turned off */
	/* *********************************************** */

	timeout = TIMEOUT;
	for (i=0; i<0xf000; i++) {
		if ( (status = *DBC_SR) & DTB_EN ) {
			timeout = 0;
			break;
		}
	}

	dbc_cr &= ~DTB_EN;
	*DBC_CR = dbc_cr;

/* the dmc status is in the second long word that is transferred and its bit
   definitions are as follows:

   XXXX  XXXX  XXXX  XXXX  XXXX  XXXX  XXXX  XXXX
   |      |||  |  |  |  |  |                    |
   ------- ||  |  |  |  |  ----------------------
   unused  ||  |  |  |  |   remaining long word count
           ||  |  |  ----
           ||  |  |  edt slave board id
           ||  ----
           ||  unused
           ||-uncorrectable memory error
           |- dma channel active
*/

	if(timeout)
		printf("timeout while getting dtb status\n");

#ifndef S90
	else{
	    printf("dmc status %x\n",*(int *)(buf+4));
	    if(*(short *)(buf+6))
	        printf("remaining long word count %x(h)\n",(*(short *)(buf+2))&0xffff);

	    printf("edt slave board id %x(h)\n",*(buf+1)&0xf);
	    if(*buf&1)
		printf("uncorrectable memory error\n");
	    if(*buf&2)
		printf("dma channel active\n");
	}
#endif

/* Now flush out the dtb interface read register */



	/* grab one long word from dtb dma */

	/* disable DTB */
	*DTB_CR = 0;

	/* setup DTB dma to get one long word from main memory */
	dmaddr ( buf, 0, DTBDMA);

	/* DBC control register : local <-> DTB, read from DTB */
	dbc_cr = (dbc_cr & CR_MASK) | LOCMDTBX | RDDTB;
	*DBC_CR = dbc_cr;

	dbc_cr |= DTB_EN;		/* enable DTB dma */
	*DBC_CR = dbc_cr;

	/* enable interrupt and return */
	for (i=0; i<10; i++) {
		if ( ((status= *DBC_SR) & DTB_EN) ) {
			break;
		}
	}

	/* disable dtb dma */
	dbc_cr &= ~DTB_EN;
	*DBC_CR = dbc_cr;

	return(*(int *)(buf+4));
}
