/* 2/18/86
   Added two elements to the dkinf structure to handle system activity
   reporting (io_bcnt, io_btime)
							PTL
*/

/****************************
 *
 * Physical disk structure
 *
 **************************** */


struct dkinf{ 
	unsigned short pd_ststat;	/* status of the disk
						0x1  = standard smd timing
						0x2  = extended smd timing
						0x4  = eagle timing
						0x8  = NEC timing
						0x20 = sect0 read in
						0x40 = ready
						0x100 = timing register in
					 */
	unsigned short cyldisk;		/* number of cylinders on the disk*/
	unsigned char  headcyl;		/* number of heads on the disk*/
	unsigned char  sechead;		/* number of sectors per head*/
	unsigned short seccyl;		/* number of sectors per cyl */
	unsigned short bytesec;		/* number of bytes/sector */
	unsigned char  timing[32];	/* timing id */

	unsigned char pd_ldmaxnum;	/* maximum number of logical disks */
	unsigned char pd_ldnum;		/* actual number of logical disks on 
					   this device */

	struct devq *pd_lastdq;	/* pointer to last que */
	struct devq *pd_sortdq;	/* que pointer where to start sorting */


	unsigned short curcyl;		/* current cylinder on */
	unsigned int rv_strt;		/* starting sector address of reserved
					   area on the phys disk */
	unsigned int rv_size;  		/* number of blocks on he disk */
	struct ld *pd_ptr;		/* pointer to the logical disk table */
	unsigned short pd_xfer;		/* max dtb xfer rate */

	unsigned char  pd_opr;		/* operation being performed 
					   ie: seek, read, write,online
						0x01= read
						0x02= write
						0x04= seek
						0x08= seek done
						0x10= read ID
						0x20= write ID
					*/
	unsigned char sync_drive;	/* is this a synchronous drive */
	struct devq *next;		/* next que on the list */
	unsigned char formattype;
	unsigned char pd_tick;		/* counter to timeout disk */

	struct badtrck *skplist;	/* pointer to skip track list */
					/* for the reserved area */
	unsigned char numskiptrack;	/* total number of skip track in */
					/* the reserved area */
	unsigned int io_bcnt;		/* total block io count*/
	unsigned int io_btime;		/* time spent on block io*/
};

/* ********************************** *
 * pd_opr definition for structure pd *
 * ********************************** *
 */
#define DK_READ		0x01
#define DK_WRITE	0x02
#define DK_SEEK		0x04
#define DK_SKDONE	0x08
#define DK_RID		0x10
#define DK_WID		0x20


/* *********************************** *
 * pd_ststat definition for structure pd *
 * *********************************** *
 */

#define DK_INIT		0x20		/* sector 0 read in */
#define DK_READY	0x40

#define DK_TIMIN	0x100


/***************************
 *
 * Logical disk structure
 *
 **************************** */
struct ld{
	unsigned int   ld_strt;		/* starting address on the phys disk */
	unsigned int   ld_size;		/* number of blocks on the disk */

	unsigned char  ld_type; 	/* 1= unix file system
					   2= swap area
					   3= customer data file system 
					   4= power fail, memory dump area */
	unsigned char  ld_mirror;	/* mirrored logical drive num */
	unsigned char	mirtype;	/* 1=mir master (has mirror drive) */
					/* 2=mir slave (mirror of other drive */
		
	unsigned char  ld_bdsnum;	/* number of spared sectors or the 
					  number of bad blocks on the drive */
	struct badtrck *skplist;	/* pointer to skip track list */
	unsigned short numskiptrack;	/* total num of skip track */
};

/**************************************
 * ld_type definition in structure ld
 **************************************/
/* see disksect.h for definition */

/* ***********************
 *
 * tape drive structure
 *
 * ********************** */
struct tp{
	unsigned char  tp_opr;		/* current tape operation */
	unsigned char  tp_type;		/* type of tape that is online */
					/* 0x80 = tape drive on line */
					/* 0x01 = archive tape dr interface */
					/* 0x02 = 9 track tape dr interface*/
	unsigned short tp_filemk;	/* file mark position */
	unsigned int   tp_block;	/* current tape position */
	unsigned short tp_bsize;	/* block size */
	unsigned short tp_bufsize;	/* maximum tape buffer size */
	unsigned short tp_xfer;		/* maximum dtb transfer rate */
	unsigned short tp_tick;		/* counter to timeout tape */
	unsigned char  tp_stat[8];
	struct devq *next;
};

#define tp_flag		tp_stat[7]	/* keep track retry action */

/* ******************************
 * definition fo tp-flag
 * ****************************** 
 */
#define TP_REVFLG	0x1		/* retry mode: reversed a blk */
#define TP_ERSFLG	0x2		/* retry mode: erase fix */
#define TP_OVRNFLG	0x4		/* retry mode: tape dma overrun*/


/* *********************************
 * tp_type definition structure tp
 * *********************************
 */
#define TP_ARCH		0x01	/* archive tape drive */
#define TP_9TRK		0x02	/* 9 track tape drive */
#define	TAPEON		0x80	/* tape is online */

/***************************
 *
 * mirror disk structure
 *
 ************************** */
struct mirrdk {
	unsigned char	logdr;		/* logical drive num */
	unsigned char	phydr;		/* phy drive num where the log dr is */
	unsigned char	mirlogdr;	/* mirror log disk num */
	unsigned char	icbnum;		/* icb slot # of the mirror log disk */
	unsigned opentime;		/* log drive open time */
	unsigned closetime;		/* log drive close time */

	unsigned char	mirtype;	/* 1=mir master (has mirror drive) */
					/* 2=mir slave (mirror of other drive */
};


