
#include "scsi_ccpu.h"
#include "scsi.h"
#include "devcmd.h"
#include "scsi_dtc.h"
#include "scsi_error.h"
#include "scsi_ptm.h"
#include "vreg.h"
#include "data_struct.h"
#include "scsiextrn.h"
#include "disksect.h"
#include "disk_struct.h"
#include "scsitape.h"
#include "scsi_mem_map.h"
#include "registers.h"
#include "commands.h"
#include "message.h"
#include "command_blk.h"
#include "scsidata.h"

extern struct devq *getptr();
extern struct free_mem *getmem();

/*
	disk cmd = 1,2 (read/write) :
	logical drive, MULTIPLE logical sectors

 */
ldlogrw(dev,dkptr)
register struct devq *dev;
register struct dkinf *dkptr;
{
	register struct ld *p;


	/* if the physical drive is not open, then the drive  */
	/* must be initialized prior to trying to read a sector */

	if ( check_for_open(dev, dkptr) )
		return(1);

	/* convert logical sectors within the logical drive to
	absolute logical sectors within the physical drive 
	*/

	if ( dev->q_priority >= dkptr->pd_ldnum ) {
		dev->rc1 = DER_NLOG;
		return(1);
	}

	 /*pointer to logical drive structure */
	p = dkptr->pd_ptr + dev->q_priority;


	 /*insure that all blocks are within range */
	if ((dev->q_devun.block + (dev->q_count>>BLKSIZBIT)-1) >= p->ld_size ) {
		dev->rc1 = DER_ISEC;
		dev->q_count = 0;
		return(1);
	} 
	dev->q_devun.block += p->ld_strt;


	return(0);
}


/*
	disk cmd = 3,4 (read/write) :
	physical drive, MULTIPLE logical sectors 
		(used by disktest)


 */
phyrw ( dev,dkptr)
register struct devq *dev; 
register struct dkinf *dkptr;
{
	register struct ld *p;

	if ( check_for_open(dev, dkptr) )
		return(1);

	/* dev->rc1 will be set if there is an error */

	return(0);
}


/*
	disk cmd = 5,6 read/write:
	physical drive
	rw multiple logical sectors in the reserved area
	check for the size of the reserved area 
	this does not support non-contiguous memory
	
 */
pdlogrw ( dev,dkptr)
register struct devq *dev;
register struct dkinf *dkptr;
{
	unsigned int cyltrack; register unsigned short *ptr;
	

	/* if physical drive not opened,return an error */

	if ( check_for_open(dev, dkptr) )
			return(1);

	/* ****************************************** */
	/* only allow rw sectors within reserved area */
	/* ****************************************** 
	if ( (dev->q_devun.block + dev->scnt - 1 ) > dkptr->rv_size ) {
		dev->rc1 = DER_ISEC;
		return(1);
	}

	*/

	return(0);
}

/*	open physical drive if drive has not been opened
	output:	return 1 if we can't open the drive
 */

check_for_open(dev, dkptr)
register struct devq *dev;
struct dkinf *dkptr;
{

	register struct devq *dev1;

	/* check to see if the drive has been opened */
	if ( dkptr->pd_ststat & DK_INIT )
		return(0);

	dev1 = getptr();
	dev1->local_mem = getmem();
	dev1->q_devnum = dev->q_devnum;
	if(examine_the_drive(dev1,dkptr)){

		if(dev1->rc1)
			dev->rc1 = dev1->rc1;
		else{
		    if(dkptr->pd_ststat & DK_READY)
			dev->rc1 = DER_UNFORM;
		    else
			dev->rc1 = DER_NRDY;
		}
		return_mem(dev1->local_mem);
		return_ptr(dev1);

		return(1);
	}

	return_mem(dev1->local_mem);
	return_ptr(dev1);
	return(0);
}

scsiparse(dev,dkptr)
register struct devq *dev;
struct dkinf *dkptr;
{


	if (dev->q_count&3){
		dev->rc1 = DER_CNT;
		return(1);
	}
	if ((int)dev->q_mem & 0x03){
		dev->rc1 = DER_MEM;
		return(1);
	}

	*((short *)&dev->rc1) = 0;	/* zero return code */

	switch(dev->opr){
		case REQ_SENSE:
			if (dev->q_count==0){
				dev->rc1 = DER_CNT;
				return(1);
			}
			dev->q_flag |= (DK_TO_MAIN|NO_DISCONNECT);
			req_sense(dev);
			break;
		case FORMAT:
			dev->q_flag |= DK_TO_MAIN;
			format_drive(dev);
			break;
		case INQUIRY:
			if (dev->q_count==0){
				dev->rc1 = DER_CNT;
				return(1);
			}
			dev->q_flag |= (DK_TO_MAIN|NO_DISCONNECT);
			inq(dev);
			break;
		case MODE_SELECT:
			if (dev->q_count==0){
				dev->rc1 = DER_CNT;
				return(1);
			}
			dev->q_flag |= (MAIN_TO_DK|NO_DISCONNECT);
			mode_sel(dev);
			break;
		case MODE_SENSE:
			if (dev->q_count==0){
				dev->rc1 = DER_CNT;
				return(1);
			}
			dev->q_flag |= (DK_TO_MAIN|NO_DISCONNECT);
			mode_snse(dev);
			break;
		case READ_CAPACITY:
			if (dev->q_count==0){
				dev->rc1 = DER_CNT;
				return(1);
			}
			dev->q_flag |= (DK_TO_MAIN|NO_DISCONNECT);
			read_cap(dev);
			break;
		case READ_EXTENDED:
			if (dev->q_count==0){
				dev->rc1 = DER_CNT;
				return(1);
			}
			dev->q_flag |= (DK_TO_MAIN|NO_DISCONNECT|WAIT);
			read_data(dev);
			break;
		case WRITE_EXTENDED:
			if (dev->q_count==0){
				dev->rc1 = DER_CNT;
				return(1);
			}
			dev->q_flag |= (MAIN_TO_DK|NO_DISCONNECT|WAIT);
			write_data(dev);
			break;
		case UNIT_READY:
			if(dev->q_count){
				dev->rc1 = DER_CNT;
				return(1);
			}
			dev->q_flag |= (DK_TO_MAIN|NO_DISCONNECT);
			send_small_cmd(dev);
			break;
		case REASSIGN_BLKS:
			dev->q_flag |= (MAIN_TO_DK);
			send_small_cmd(dev);
			break;
		default:
			printf("invalid selection\n",dev->opr);
			dev->rc1 = ILL_CMD;
			return(1);

	}


	return(0);

}

/* write any sector in cyl 0, data is in main memory */
wrsysec0(dev, dkptr)
register struct devq *dev; struct dkinf *dkptr;
{
	if ( dev->q_devnum >= MAX_PDRIVE ) {
		dev->rc1 = DER_DRLIMIT;
		return(1);
	}

	return(0);

}


