
#include "scsi_ccpu.h"
#include "scsi.h"
#include "scsi_dtc.h"
#include "vreg.h"
#include "data_struct.h"
#include "scsi_ptm.h"
#include "scsiextrn.h"
#include "scsidata.h"
#include "scsi_mem_map.h"
#include "commands.h"
#include "scsiversion.h"

#define CTRL_D	4
#define NOCHAIN 0


int reset_console();
int display();
extern reset_chip(),inquiry(),unit_ready();
extern mode_sense(),request_sense();
extern rwdisk(),menu(),reset_bus(),rezero();
extern read(),write(),sync_setup(),async_setup();
extern download(),mode_select(),check_dtb_status();
int show_head(),show_ques();

char *skipsp(); char *skiparg();
struct cmd  {
	char cmdchar; int (*func)();
} cmdtbl[] = {
	'A', async_setup,
	'B', reset_bus,
	'C', check_dtb_status,
	'D', display,
	'H', show_head,
	'I', inquiry,
	'L', show_ques,
	'M', mode_sense,
	'Q', request_sense,
	'R', read,
	'S', sync_setup,
	'T', unit_ready,
	'U', reset_console,
	'W', write,
	'X', reset_chip,
	'Z', rezero,
	'?', menu,
	0, 0,
};


main() {
	char buffer[32];
	register char *bptr;
	register struct cmd *p;
	register struct dtb_que *dptr;
	register unsigned char temp;
	register int rc, i;
	unsigned char *xhead; 
	struct interim_processing_que *ip;
	unsigned short oldpri;

	/* init SCSI hardware */
	initscsi();

	printf ("\nSCSI/EDT %x.%x%x\n#", VERNUM, RELEASE,RELEASE1);

	ip = &ipque;

	for (;;) {


	/*Now check to see if there are any requests from the master cpu */

	    if ( bddesc.reqfst )
		ckreq();

	/*Are there any dma transfers to do? */

	    dptr = &dtbque;
	    oldpri = spl6();
	    if((!dptr->dtb_active) && (dptr->d_first) ){
	        if(dptr->d_first->q_devtype == DISK)
	            dptr->dtb_active = (dptr->d_first->q_devtype|((dptr->d_first->q_devnum<NUMBER_OF_DEVICES)?FIRST_QUE : SECOND_QUE));
	        else
		    dptr->dtb_active = dptr->d_first->q_devtype;
	        dtb_proc(dptr->d_first);
	    }
	    splx(oldpri);

	/* Anything on the tape queue? */

	    if(!tapeque.t_active && tapeque.t_first){
		tapeque.t_active++;
		setup_tape(tapeque.t_first);
	    }


	    if(ip->i_p_first ){
		if(!(ip->i_p_active)){
			ip->i_p_active++;
			ip->i_p_proc_count = 0;
			ip->i_p_count = 0;
			ip->i_p_block = ip->i_p_first->q_devun.block;

			load_mmu(ip);
		}
		else{

	/* Only process the raw request if the mmutable has been loaded */

			if((ip->i_p_active&MMUTABLE_IN) ||
			    ip->i_p_first->rc1)
				raw_proc(ip);
		}
	    }

	if(status_change){

		/* check for icb interrupt from main cpu or
			monitor command from keyboard */

		if ( status_change & ICB ) {
			/* get interrupt word */
			if ( icbdata & ICBI_MASK)
				icbparse();
			status_change &= ~ICB;
		}


	        if(status_change & CONSOLE){
	    	if ( consolecmd == 0 ) {
			xhead = head;
			while ( xhead != tail ) {
				temp = *xhead++;
				if ( xhead == &input_q[sizeof input_q] )
					xhead = input_q;
				if ( temp == CTRL_D ) {
					consolecmd = 1;
				}
				head = xhead;
			}
	    	}
	    	    if ( head != tail ) { 
		/* monitor command input active */
			bptr = buffer;
			for (i=0; i < sizeof(buffer); i++)
				*bptr++ = ' ';

			rc = 0;
			if ( get(buffer,sizeof(buffer)-1) < 0 )
				rc = 1;

			else if ( buffer[0] != 0 ) {
				bptr = skipsp(buffer);
				rc = 1;

			/* search for valid command */
				for(p= cmdtbl;p->cmdchar;p++) {
					if ( *bptr == p->cmdchar ) {
				     		rc=(*(p->func))(bptr);
				     		break;
					}
				}
		        }
			if ( rc )
				printf ("?\n");
			printf ("#");
	    	    }
		    status_change &= ~CONSOLE;
	        }
	    }

	}	/* end of for loop */
}

/*	get a line of output into buffer, up to a carriage return.
	if character stream is greater then buffer size, return -1
	else return num of character in buffer
	also convert all lower case to upper case letters
			--------------------------------
	input:	character buffer pointer, buffer size
*/

get(bufptr, bsize)
char *bufptr; int bsize;
{
	register char *ptr; register int charnum ;
	register char c;

	ptr = bufptr;

	charnum =0;
	while ( ((c=getchar()) != '\r') && (c !=0) && (charnum < bsize) 
			&& (c != '\n')) {
		putchar(c);
		switch (c) {
			case 0x10:
				charnum = 0;
				ptr = bufptr;
				printf ("^\r");
				break;

			case '\b':
				if ( charnum ) {
					--ptr;
					--charnum;
					putchar(' ');
					putchar('\b');
				}
				break;
	
			default:
				if ( (c >='a') && (c <='z') )
					c -= 0x20;
				*ptr++ = c;
				charnum++;
				break;
		}
	}
	if ( charnum >= bsize ) return (-1);


	*ptr = 0;
	putchar ('\r');
	putchar ('\n');
	return (charnum);
}

/*	*******************************		*/
/*	skip over argument upto a space		*/
/*	or zero or \r or \n			*/
/*	*******************************		*/
char *
skiparg(ptr)
register char *ptr;
{	register char c;
	while ( (c= *ptr) != ' ' && c != 0 && c != '\r' &&
		c != '\n' ) ptr++;
	return (ptr);
}

/*	******************	*/
/*	skip over space		*/
/*	******************	*/
char *
skipsp(ptr)
register char *ptr;
{
	while ( *ptr == ' ' )
		ptr++;
	return (ptr);	/* got char not space */
}

/*	********************************************	*/
/*	convert input ascii-char to 4 bits hex value	*/
/*	********************************************	*/

convert(c)
register char c;
{
 	if ( (c >= '0') && (c <= '9') ) {
		c -= '0';
		return (c);
	}
	else if ( (c >= 'a') && (c <= 'f') ) {
		c += 10 - 'a';
		return (c);
	}
	else if ( (c >= 'A') && (c <= 'F') ) {
		c += 10 - 'A';
		return (c);
	}
	else if ( (c == ' ') || (c == '\n') || (c == '\r') || (c == 0) )
		return (-2);
	else
		return (-1);
}


/*	*******************************************************	*/
/*	take the next argument and convert to 32 bits hex value */
/*	pptr = double pointer (contain a pointer to the buffer  */
/*	*******************************************************	*/
getlong(pptr, pvalue)
register char **pptr; register int *pvalue;
{
	register unsigned int hex32;
	register char c, *ptr;
	register temp;

	ptr = skipsp(*pptr);	/* skip over space */
	c = *ptr;		/* point to non-blank char */

	/* **************************** */
	/* check out any char out there */
	/* **************************** */

	temp = convert(c);
	c = temp;

	if ( (temp == -1) || (temp == -2) ) {
		*pptr = ptr;
		return ( -1 );	/* no hex value */
	}

	/* ****************************** */
	/* have not increment pointer yet */
	/* ****************************** */

	hex32 = 0;
	*pvalue = 0;

	while ( 1 ) {
		temp = convert(*ptr++);
		c = temp;
		if ( (temp != -1) && (temp != -2) )
			hex32 = (hex32 << 4) + c;
		else
			break;
	}
/* return  2 values */

	*pptr = --ptr;
	*pvalue = hex32;
	if ( temp == -2 )
		return ( 0 );	/* 8 digits */
	else
		return (-1);	/* illegal character */
}


/*	********************************************	*/
/*	get the next three argument (expect to be long)	*/
/*	and convert them into three 32 bits value	*/
/*	store them at array pointed by argup		*/
/*	********************************************	*/

getarg(bufptr, argup, num)
char *bufptr; register int *argup, num;
{
	char *ptr; unsigned int temp;
	/* ***************** */
	/* skip over command */
	/* ***************** */
	ptr = skiparg (bufptr);

	while ( num--)  {
		if (  getlong(&ptr, &temp) < 0 ) 
			return (-1);
		else
			*argup++ = temp;
	}
	return(0);
}

reset_console()
{	consolecmd = 0;
	return (0);
}

menu()
{

	printf("A <drive> , set up an asynchronous transfer\n");
	printf("B , reset_bus\n");
	printf("D <addr>, display memory\n");
	printf("I <drive> , get inquiry data from the disk\n");
if (PRINT6){
	printf("H<A,B,D,I,M,T,P>,struct info(dma,bddesc,dtb,intermi,mmu,tape,periph)\n");
	printf("L<D,T,I,J,P,M,F,R,A>[C] ,queue list(dtb,tape,intermi\n");
	printf("  periph,free_mem,free list,request,reponse[A];contain)\n");
	}
	printf("M <drive> , get mode_sense information\n");
	printf("Q <drive> , request sense data\n");
	printf("S <drive>, set up a synchronous transfer\n");
	printf("T <drive> , check for unit ready\n");
	printf("U , reset the console\n");
	printf("R[L] <drive> <sector> <byte count> , read a block of data from the disk [loop] \n");
	printf("RC , read capacity\n");
	printf("W[L] <drive> <sector> <byte count> , write a block of data to the disk [loop] \n");
	printf("X , reset the scsi chip\n");
	printf("Z <drive> , rezero the drive\n");
	printf("? , display the menu\n");
}


dtb_proc(dev)
register struct devq *dev;
{
	register struct peripheral_que *pq_ptr;
	register struct periph_table *p_ptr;
	register unsigned char *dtb_ptr;
	register unsigned int direction,localcount;
	unsigned char drive;
	struct scsiwr *wr;
	unsigned short oldpri;
	unsigned char chaining;
	
	interrupt &= ~(DTB_INT | DTBDMA_INT | CHNDMA_INT |DDC_INT);
	switch(dev->q_flag&FUNCTION_MASK){
		case DK_TO_MAIN:
		case MAIN_TO_DK:
		case LOC_TO_DK:
		case DK_TO_LOC:
			if(dev->q_devnum < NUMBER_OF_DEVICES){
				pq_ptr = &periph_que;
				wr = (struct scsiwr *)SCSI_1;
				drive = dev->q_devnum;
			}
			else{
				pq_ptr = &periph1_que;
				wr = (struct scsiwr *)SCSI_2;
				drive = dev->q_devnum - NUMBER_OF_DEVICES;
			}
		    	p_ptr = &pq_ptr->pt[drive];
			pq_ptr->bus_id = drive;
			p_ptr->p_time = 0;

			direction=(dev->q_flag & (DK_TO_LOC|DK_TO_MAIN)) ? SCSI_TO_MEM : MEM_TO_SCSI;
			chaining = (dev->q_mmu) ? (int)(dev->q_mmu) : NOCHAIN;
			setupdma(dev,p_ptr->next_byte_count,p_ptr->next_mem_ptr,direction,chaining);
			wr->command = NOP;
        		wr->command = XFER_INFO_D;
			break;
		case LOC_TO_MAIN:
		case MAIN_TO_LOC:
			direction=(dev->q_flag & MAIN_TO_LOC) ? RD_DTB : WR_DTB;
			if ( dev->q_mmu ) {
				oldpri = spl6();
			/* *************************************** */
			/* transfer data for non-contiguous memory */
			/* program chain dma starting & ending addr */
			/* *************************************** */

			/* number of bytes to program DTB dma */
				localcount = prgdtbchn (dev, direction,dev->q_count);
	

			/* program DTB dma with local buffer addr */
				dmaddr(dev->local_mem->fm,localcount-4,DTBDMA );

		/* program DTB/DISK data path mode for local memory <->DTB */
				mslmdkdtb (direction, ~DISK);
				dtbque.d_tick = TICK_1SEC;
				splx(oldpri);
				return;
			}
			dtb_ptr = dtbbuf;
			*(short *)(dtb_ptr+2) = dev->q_count>>2;
#ifndef S90
			*(int *)(dtb_ptr+4) = (int)(dev->q_mem) >> 2;
#else
			*(dtb_ptr+1) = (char)(((int)dev->q_mem&0xf0000000)>>24);
			*(int *)(dtb_ptr+4)=(((int)(dev->q_mem)&0xfffffff) << 4);
#endif
			xferdata(dtb_ptr,dev->local_mem->fm,direction,DTBNOWAIT);
			break;

	}
}





/* Number of bytes in each data structure field */

char dtbary[]={1,1,4,4,4};
char periphary[]={2,2,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4,4};
char interiary[]={2,4,4,4,4,4,4,4,4,4,4};
char tapeary[]={2,2,4,4,2,4,4,4,4,4,4,4,4};
char bddary[]={4,1,1,1,1,4,2,4,2,1,1,4,4,1,1,1,1,1,1,4,1,1,1,1,4,4,4,4,4,4,4};
char devary[]={4,4,1,1,1,1,4,4,4,4,4,2,1,1,1,1,1,1,4,1,1,1,1};
char memary[]={4,4};

#ifndef S90
     char mmuary[]={2,2,4,2,2,4,0}; 	/* 0 for MMU table */
#else
     char mmuary[]={2,2,4,2,2,4,0};
#endif

#define DEVTYPE 1
#define MEMTYPE 2 

show_ques(bufptr)
char *bufptr;
{
int cflag,value;
int type;
char *ptr,*pt,buf[6];
register struct devq *devpt;
	
	ptr = bufptr;
	ptr++;

	type = DEVTYPE;
	cflag = 0;
	if (*(ptr+1) == 'C')
	    cflag = 1;

	switch(*ptr){
		case 'D': devpt = dtbque.d_first;
			  printf("DTB queue : \n");
			  break;
		case 'T': devpt = tapeque.t_first;
			  printf("TAPE queue : \n");
			  break;
		case 'I': devpt = ipque.i_p_first;
			  printf("INTERI queue : \n");
			  break;
		case 'J': devpt = ipque.i_p_dqfirst;
			  printf("INTERI DIVIDED queue : \n");
			  break;
		case 'F': devpt = bddesc.freefst;
			  printf("FREE queue : \n");
			  break;
		case 'R': devpt = bddesc.reqfst;
			  printf("REQUEST queue : \n");
			  break;
		case 'A': devpt = bddesc.rsfst;
			  printf("REPONSE queue : \n");
			  break;
		case 'M': devpt = (struct devq *)(ipque.freemem_first);
			  type = MEMTYPE;
			  printf("FREE memory list: \n");
			  break;
		case 'P': 
			  printf("drive number ? (0-13) \n");
			  get(buf);
			  pt = buf;
			  if (  getlong(&pt,&value) < 0 ){
				 printf(" illegal number \n");
				 return(1);
			  }
		   	  if (value < 7){
			 	devpt = periph_que.pt[value].p_first; 	
			  	printf("PERIPHERAL queue drive %x: \n",value);
			  }
			  else{
			 	devpt = periph1_que.pt[value-7].p_first; 	
			  	printf("PERIPHERAL queue 1 drive %x: \n",value-7);
			  }
			  break;

		default : return(1);
	}
 	disp_que(devpt,cflag,type);
	return(0);
}


disp_que(pt,flag,type)
register struct devq *pt;
int flag,type;
{
int count,wd;
char ans[6];

	for (wd=0,count=0 ; pt ; wd++,count++){
	    if (wd > 7){
		wd = 0;
		printf("\n");
	    }
	    printf("%8x  ",pt);
	    if (flag){
		printf(" : %d\n",count+1);
		if (type == DEVTYPE)
		    disp_cont((unsigned char *)pt,sizeof(struct devq),devary);
		else
		    disp_cont((unsigned char *)pt,sizeof(struct free_mem),memary);
		printf("Next request block (cr) or quit(q) ?\n");
		get(ans);
		if (ans[0] == 'Q')
		    return;
	    }
	    if (type == DEVTYPE)
		pt = pt->q_next;
	    else 
		pt = (struct devq *)(((struct free_mem *)pt)->fm_next);
	}
	printf("\nNumber of request blocks on the queue = %d \n",count);
}


disp_cont(dev,size,chpt)
register unsigned char *dev;
register int size;
register char *chpt;
{
register int n,m,i,j;
char ans[4];

	for (n=0,m=0; n < size ; n += *chpt++ , m++){
	    if (m > 7) {
		m = 0;
		printf("\n");
	    }
	    switch(*chpt){
		case 1: printf("      %2x ",*dev);
			dev += 1;
		        break;
		case 2: printf("    %4x ",*(unsigned short *)dev);
			dev += 2;
		        break;
		case 4: printf("%8x ",*(unsigned int *)dev);
			dev += 4;
		        break;
		case 0: printf("\n");
			for (i = 0,j = 0,m = 0 ; i < NUMMUSLOTS ; i++,m++){
	    		    if (m > 7) {
			        m = 0;
				j++;
				printf("\n");
	    		    }
			    if (j == 19){
				j = 0;
				printf("Next screen (cr) or quit(q) ?\n");
				get(ans);
				if (ans[0] == 'Q')
		    		    return;
			        printf("MMUTBL ADDR = %8x : \n",(unsigned short *)dev);
			    } 
#ifndef S90
			printf("    %4x ",*(unsigned short *)dev);
			dev += 2;
#else
			printf("%8x ",*(unsigned int *)dev);
			dev += 4;
#endif
			}
			printf("\n");
			return;
	        default: printf("error length in disp_cont()\n");
		        return; 
	    }
	}
	printf("\n");
 
}


show_head(bufptr)
char *bufptr;
{
int cflag;
char *ptr;
register struct devq *devpt;
	
	ptr = bufptr;
	ptr++;

	switch(*ptr){
		case 'A': 
		  dma_reginfo();
		  break;
		case 'B': 
		  printf("Board desc control block %8x: \n",&bddesc);
		  disp_cont((unsigned char *)(&bddesc),sizeof(struct bd_desc),bddary);
		  break;
		case 'D': 
		  printf("DTB queue control block %8x: \n",&dtbque);
		  disp_cont((unsigned char *)(&dtbque),sizeof(struct dtb_que),dtbary);
		  break;
		case 'T':
		  printf("TAPE queue control block %8x: \n",&tapeque);
		  disp_cont((unsigned char *)(&tapeque),sizeof(struct tape_que),tapeary);
		  break;
		case 'I':
		  printf("INTERI queue control block %8x: \n",&ipque);
		  disp_cont((unsigned char *)(&ipque),sizeof(struct interim_processing_que),interiary);
		  break;
		case 'M':
		  printf("MMU table control block %8x: \n",ipque.i_p_mmutable);
		  disp_cont((unsigned char *)(ipque.i_p_mmutable),sizeof(struct mmutbl),mmuary);
		  break;
		case 'P': 
		  printf("PERIPH queue control block %8x: \n",&periph_que); 
		  disp_cont((unsigned char *)(&periph_que),sizeof(struct peripheral_que),periphary);
		  printf("PERIPH queue 1 control block %8x: \n",&periph1_que);
		  disp_cont((unsigned int *)(&periph1_que),sizeof(struct peripheral_que),periphary);
		  break;
		default : return(1);
	}
	return(0);
}


dma_reginfo()
{
unsigned int *pt;
int m;

	printf("DMA register info : \n");
	printf("DDC_DMAS : %8x DDC_DMAE : %8x \n",*DDC_DMAS,*DDC_DMAE);
	printf("DTB_DMAS : %8x DTB_DMAE : %8x \n",*DTB_DMAS,*DTB_DMAE);
	printf("TP_DMAS  : %8x TP_DMAE  : %8x \n\n",*TP_DMAS,*TP_DMAE);
	printf("CHN_DMAS : %8x CHN_DMAE : %8x \n",*CHN_DMAS,*CHN_DMAE);
	pt = (unsigned int *)(*CHN_DMAS);
	for (m = 0; (pt < (unsigned int *)(*CHN_DMAE)) ; m++){
	    if (m > 3) {
		m = 0;
		printf("\n");
	    }
	    printf("Addr %x:  %x, %x  ",pt,*pt++,*pt++);
	}
	
}
