#define MODE_HEAD_BLK		0xc
#define ERROR_REC_HD_PG 	8
#define DISC_RECON_LEN		0xc
#define CACHE_HD_LEN		0x10
#define GEOM_HD_LEN		0x14
#define FORMAT_HD_LEN		0x18
#define ALL_PAGE_LENGTH		0x5c
#define ERROR_REC_PAGE  	1
#define DISC_RECON_CONTROL 	2
#define FORMAT_PAGE     	3
#define DRIVE_GEOM_PAGE 	4
#define CACHE_CONTROL_PAGE 	0x38
#define ALL_CACHE_PAGES		0x3f
#define MODE_SELECT_HDR		4
#define BLOCK_DESCRIPTOR	8

/* ERROR RECOVERY PAGE 
	page code = 1
	mode sense header = 4 bytes
	block descriptor data = 8 bytes
	error recovery header = 2 bytes
	page length = 6 bytes
	actual length of request = 20 bytes
*/

struct error_recovery_page{
	unsigned int er_ms_header;
	unsigned int er_block_data[2];
	unsigned char e_page_code;
	unsigned char e_page_length;
	unsigned char e_parameters;	/*0xc8, AWER|ARRE|EEC*/
	unsigned char e_retry_count;	/* 0x4 */
	unsigned char correction_span;
	unsigned char head_offset_cnt;
	unsigned char data_strobe_off_cnt;
	unsigned char recovery_time;
};


/* DISCONNECT/RECONNECT CONTROL PAGE
	page code = 2 
	mode sense header = 4 bytes
	block descriptor data = 8 bytes
	disconnect/reconnect header = 2 bytes
	page length = 10 bytes
	actual length of request = 24 bytes
*/

struct discnct_recnct{
	unsigned int dr_ms_header;
	unsigned int dr_block_data[2];
	unsigned char dr_page_code;	/*2*/
	unsigned char dr_page_length;
	unsigned char buf_full_ratio;	/*8*/
	unsigned char buf_empty_ratio;  /*8*/
	unsigned short bus_inactivity_time;
	unsigned short disconnect_time;
	unsigned short connect_time;
	unsigned short reserved;
}; 

/*FORMAT PARAMETER PAGE
	page code = 3
	mode sense header = 4 bytes
	block descriptor data = 8 bytes
	format control header = 2 bytes
	page length = 22 bytes
	actual length of request = 36 bytes
*/
struct format_param_page{
	unsigned int f_ms_header;
	unsigned int f_block_data[2];
	unsigned char f_page_code;		/* 3 */
	unsigned char f_page_length;		/* 22 decimal */
	unsigned short tracks_per_zone;
	unsigned short alt_sects_per_zone;
	unsigned short alt_trks_per_zone;
	unsigned short alt_trks_per_vol;
	unsigned short sects_per_track;
	unsigned short bytes_per_sect;		/* 0x400 */
	unsigned short interleave;
	unsigned short track_skew;
	unsigned short cylinder_skew;
	unsigned char drive_type;
	unsigned char pad[3];
};

/* DISK GEOMETRY PAGE
	page code = 4
	mode sense header = 4 bytes
	block descriptor data = 8 bytes
	disk geometry header = 2 bytes
	page length = 18 bytes
	actual length of request = 32 bytes
*/


struct disk_geometry{
	unsigned int dg_ms_header;
	unsigned int dg_block_data[2];
	unsigned char g_page_code;
	unsigned char g_page_length;
	unsigned char cylinders_msb;
	unsigned char cylinders;
	unsigned char cylinders_lsb;
	unsigned char heads;
	unsigned char wr_precomp_st_cyl[3];
	unsigned char reduced_cur_st_cyl[3];
	unsigned short step_rate;
	unsigned char loading_zone_cyl[3];
	unsigned char pad[3];
};

/* CACHE CONTROL PARAMETERS
 	page code = 0x38
	mode sense header = 4 bytes
	block descriptor data = 8 bytes
	cache control parameter header = 2 bytes
	page length = 14 bytes
	actual length of request = 28 bytes
*/


struct cache_control{
	unsigned int cc_ms_header;
	unsigned int cc_block_data[2];
	unsigned char c_page_code;
	unsigned char c_page_length;
	unsigned char c_c_parameters; 	/* 0x10 - cache enable */
	unsigned char prefetch_thresh;
	unsigned char max_prefetch;
	unsigned char max_prefetch_mult;
	unsigned char min_prefetch;
	unsigned char min_prefetch_mult;
	unsigned char pad[8];
};


struct format_changes{
	unsigned char error_p;
	unsigned char c_buf_ful;
	unsigned char c_buf_empty;
	unsigned short format_sect_size;
	unsigned char cc_params;
};

