
/* The following are bit definitions for the scsi chip registers */

/*		STATUS REGISTER  	*/

/*
_________________________________________________________________
|	|	|	|	|	|	|	|	|
|   7   |   6   |   5   |   4   |   3   |   2   |   1   |   0   |
|_______|_______|_______|_______|_______|_______|_______|_______|
    |       |       |       |       |       |       |       |____ i/o
    |       |       |       |       |       |       |____________ c/d
    |       |       |       |       |       |____________________ MSG
    |       |       |       |       |____________________________ xfer complete
    |       |       |       |____________________________________ xfer cnt=0
    |       |       |____________________________________________ parity err.
    |       |____________________________________________________ gross err.
    |____________________________________________________________ reserved

*/

#define I_O		0x1
#define C_D		0x2
#define MSG		0x4
#define XFER_COMPLETE	0x8
#define COUNT_ZERO	0x10
#define PARITY		0x20
#define GROSS_ERR	0x40


/*		INTERRUPT STATUS REGISTER 	*/

/*
_________________________________________________________________
|	|	|	|	|	|	|	|	|
|   7   |   6   |   5   |   4   |   3   |   2   |   1   |   0   |
|_______|_______|_______|_______|_______|_______|_______|_______|
    |       |       |       |       |       |       |       |____ selected
    |       |       |       |       |       |       |____________ select w/ATN
    |       |       |       |       |       |____________________ reselected
    |       |       |       |       |____________________________ func. complete
    |       |       |       |____________________________________ bus service
    |       |       |____________________________________________ disconnect
    |       |____________________________________________________ illegal cmd.
    |____________________________________________________________ scsi reset 

*/

#define SELECTED		0x1
#define SELECTED_ATN		0x2
#define RESELECTED		0x4
#define FUNCTION_COMPLETE	0x8
#define BUS_SERVICE		0x10
#define DISCONNECT		0x20
#define ILL_CMD			0x40
#define SCSI_RESET		0x80
