
#include "scsi_ccpu.h"
#include "scsi_dtc.h"
#include "command_blk.h"
#include "commands.h"
#include "mode_sns_pg.h"
#include "scsi_mem_map.h"
#include "scsi.h"
#include "message.h"
#include "scsiextrn.h"
#include "error.h"
#include "vreg.h"
#include "data_struct.h"
#include "scsi_error.h"
#include "scsi_ptm.h"


send_cmd(cdb_ptr,dma,cmd_type,dev)
register int *cdb_ptr;
unsigned char dma;
register unsigned char cmd_type;
struct devq *dev;
{

	register unsigned char *cptr,fifo_ptr;
	register struct scsiwr *wr;
	register struct scsird *rd;
	register int i;
	register unsigned char drive;
	

	/*
	  load both the indentify byte and command descriptor
	  byte into the SCSI chip fifo
	  then load the select with attention command into the command
	  register of the SCSI chip
	*/

	drive = dev->q_devnum;

	if(drive < NUMBER_OF_DEVICES){
		wr = (struct scsiwr *)SCSI_1;
		rd = (struct scsird *)SCSI_1;
		dtc_ctl |= SCSI1_INT;
	}
	else{
		wr = (struct scsiwr *)SCSI_2;
		rd = (struct scsird *)SCSI_2;
		drive -= NUMBER_OF_DEVICES;
		dtc_ctl |= SCSI2_INT;
	}

	if((rd->status&BUS_PHASE) != 0)
		return(1);

	/* Loading the FIFO */

	if((dev->q_flag & NO_DISCONNECT) == 0)
		wr->fifo = IDENTIFY;
	for(i=0,cptr=(unsigned char *)cdb_ptr;i<cmd_type;i++){
#ifdef DEBUG
			printf("%x ",*cptr);
#endif
		wr->fifo = *cptr++;
	}


/* Loading the command and bus id registers */

	wr->bus_id = drive;
	if((rd->status&BUS_PHASE) != 0)
		return(1);

	if((dev->q_flag & NO_DISCONNECT) == 0)
		wr->command = SEL_ATN | dma;
	else
		wr->command = SEL_NO_ATN | dma;


	*DTC_CRL = dtc_ctl;		/* enable scsi interrupt */

	return(0);
}

