#include "scsi_ptm.h"
#include "scsi.h"
#include "scsi_ccpu.h"
#include "scsi_dtc.h"
#include "scsiextrn.h"
#include "data_struct.h"
#include "scsi_error.h"
#include "commands.h"
#include "scsi_mem_map.h"
#include "scsidata.h"
#include "devcmd.h"
#include "message.h"
#include "vreg.h"


extern struct devq *getptr();
extern struct free_mem *getmem();

prgclk()
{
	/* clock will interrupt every 10 ms */
	MTPR ( TM_MSB3, TICKHZ >> 8);
	MTPR ( TM_LSB3, TICKHZ & 0xff);
	MTPR ( TM_C2, PTM_OE | PTM_DUAL8 | PTM_ECLOCK | PTM_REG3);
	MTPR ( TM_C13, PTM_OE | PTM_IE | PTM_ECLOCK);
}

clockint()
{
	register struct tape_que *taptr;
	register struct dtb_que *dptr;
	register unsigned char drive;
	register int i;
	register unsigned short oldpri;


	oldpri = spl6();

	if( (++clock_cnt & 7) != 7 ){
		i = MFPR (TM_S2);
		i = MFPR (TM_MSB3);
		i = MFPR (TM_LSB3);
		splx(oldpri);
		return;
	}
	for ( i=0; i<NUMBER_OF_DEVICES; i++ ) {
		if ( periph_que.pt[i].p_time) {
			if ( (--(periph_que.pt[i].p_time)) == 0 ){
				timeoutdisk(periph_que.pt[i].p_first);
			}
		}
	}
	for ( i=0; i<NUMBER_OF_DEVICES; i++ ) {
		if ( periph1_que.pt[i].p_time) {
			if ( (--(periph1_que.pt[i].p_time)) == 0 ){
				timeoutdisk(periph1_que.pt[i].p_first);
			}
		}
	}
	/*  check for a timeout on DTB activity */
	dptr = &dtbque;

	if ( dptr->dtb_active && ( dptr->d_tick ) ) {
		if ( --dptr->d_tick  == 0 ){
		    if(dptr->dtb_active & SCSI_DONE)
			    timeoutdtb(dptr->request_removed);
		    else
			timeoutdtb(dptr->d_first);
		}
	}
/*
	 check for any tape activity to timeout 
*/

	taptr = &tapeque;

	 /* *************************************************** 
	 make sure the tape is actually moving              
	 when tape is using DTB
	 *************************************************** */

	if ( taptr->t_first != (struct devq *)0 ) {
		if ( taptr->t_tick ) {
			if ( (--taptr->t_tick) == 0 ) {
				timeoutape(taptr->t_first);
			}
		}
	}


	if ( ++ledtick >= TICK_1SEC ) {
		ledtick = 0;
		if ( (unsigned short)(dtc_ctl&0x03)!=(unsigned short)greenlit )
			i = greenlit;
		else
			i = ledoff;
		LIGHT (i);
	}

	splx(oldpri);

}

timeoutdisk(dev)
struct devq *dev;
{

	register struct periph_table *p_ptr;
	register struct peripheral_que *pq_ptr;
	register struct scsiwr *wr;
	unsigned char drive;

	if(dev->q_devnum<NUMBER_OF_DEVICES){
		pq_ptr = &periph_que;
		drive = dev->q_devnum;
		wr = (struct scsiwr *)SCSI_1;
	}
	else{
		pq_ptr = &periph1_que;
		drive = dev->q_devnum-NUMBER_OF_DEVICES;
		wr = (struct scsiwr *)SCSI_2;
	}
	p_ptr = &pq_ptr->pt[drive];

if(PRINT1)
	printf("timeout drive %x\n",dev->q_devnum);


	if(++dev->retry > RETRY){
		pq_ptr->periph_active &= ~(U_L_BIT(drive));
		dev->rc1 = DER_TIMEOUT;
		clear_periph_que(dev,p_ptr);
	}
	else{
		if(pq_ptr->bus_id == drive){
			wr->command = SET_ATN;
			next_message = ABORT;
		}
		else{
		    pq_ptr->periph_active &= ~(U_L_BIT(drive));
		    if(pq_ptr->periph_active == 0){
		        if(pq_ptr->scsi_periph_ptr == 0)
			    pq_ptr->scsi_periph_ptr = &pq_ptr->pt[drive];
			    check_for_completion(&dtbque,pq_ptr);
		    }
			
		}
		
	}
	
}

get_sense(dev,drive,bus_recovery)
struct devq *dev;
register unsigned char drive,bus_recovery;
{
	register struct periph_table *p_ptr;
	register struct devq *sense_dev;
	register struct peripheral_que *pq_ptr;
	unsigned short oldpri;

	if(dev->q_devnum < NUMBER_OF_DEVICES){
		pq_ptr = &periph_que;
		p_ptr =  &periph_que.pt[drive];
	}
	else{
		pq_ptr = &periph1_que;
		p_ptr = &periph1_que.pt[drive-NUMBER_OF_DEVICES];
	}
	/* zero out the command block */
	sense_dev = getptr();

	sense_dev->q_cmd = REQ_SENSE;
	sense_dev->opr = REQ_SENSE;
	sense_dev->q_message = 0;
	sense_dev->q_count = SENSE_DATA_LENGTH;
	sense_dev->q_devnum = drive;
	sense_dev->q_devtype = dev->q_devtype;
	sense_dev->q_flag = (FREE_REQ|DK_TO_LOC|NO_DISCONNECT|bus_recovery);
	sense_dev->q_key = dev->q_key;
	
	oldpri = spl6();
	if(p_ptr->p_first)
		sense_dev->q_next = p_ptr->p_first;
	else
		sense_dev->q_next = 0;
	p_ptr->p_first = sense_dev;
	sense_dev->local_mem = ipque.freemem_last;
	p_ptr->next_mem_ptr = (char *)sense_dev->local_mem->fm;
	p_ptr->next_byte_count = sense_dev->q_count;
	*(short *)&dev->rc1 = 0;
	*(short *)&sense_dev->rc1 = 0;
	if(bus_recovery){
		sense_dev->q_key = 0;
		if(pq_ptr->periph_active == 0){
		       if(diskrw(sense_dev)){
		            if(pq_ptr->scsi_periph_ptr == 0)
		                pq_ptr->scsi_periph_ptr = p_ptr;
		       }
		       splx(oldpri);
		       return(0);
		}
		if((pq_ptr->scsi_periph_ptr == 0) && 
		    (!(pq_ptr->periph_active&BIT(drive))))
		       pq_ptr->scsi_periph_ptr = p_ptr;
	}
	splx(oldpri);

	return(0);

}

timeoutdtb(dev)
register struct devq *dev;
{

	register struct periph_table *p_ptr;
	register struct scsiwr *wr;
	register struct dtb_que *dptr;
	struct peripheral_que *pq_ptr;
	unsigned char active_flag;
	unsigned char drive;


	if(dev->q_devnum<NUMBER_OF_DEVICES){
		pq_ptr = &periph_que;
		drive = dev->q_devnum;
		wr = (struct scsiwr *)SCSI_1;
	}
	else{
		pq_ptr = &periph1_que;
		drive = dev->q_devnum-NUMBER_OF_DEVICES;
		wr = (struct scsiwr *)SCSI_2;
	}

	dptr = &dtbque;

if(PRINT1)
	printf("timeoutdtb: drive %x block %x\n",dev->q_devnum,dev->q_devun.block);

	check_dtb_status();

	++dev->retry;

	canceldmc();

	p_ptr = &pq_ptr->pt[drive];
	if(dev->q_devtype == DISK){
		dt_control |= READ_REMAINDER;
        	*(DT_CTRL_REG) = dt_control;
		wr->command = FLUSH_FIFO;
		active_flag = dptr->dtb_active;
		dptr->dtb_active |= TRANSFER_DONE;
		pq_ptr->periph_active &= ~(U_L_BIT(drive));
		cancel_dma(dev->q_flag);
		pq_ptr->bus_id = NO_ONE_ON_THE_BUS;
		if(dev->retry >= RETRY){
			dev->rc1 = DER_TIMEOUT;
			dev->q_count = 0;
			if(active_flag & SCSI_DONE)
				clear_periph_que(dev,p_ptr);
			else {
			    if(p_ptr->p_first)
				clear_periph_que(dev,p_ptr);
			    send_back(dev,0);
			}
			last_ditch_recovery(dev);
		}
		else{
			if(active_flag & SCSI_DONE){
				if(pq_ptr->periph_active == 0){
		       		    if(diskrw(dev)){
		            		if(pq_ptr->scsi_periph_ptr == 0)
		                		pq_ptr->scsi_periph_ptr = p_ptr;
		       		    }
		       		    return;
				}
				if(pq_ptr->scsi_periph_ptr == 0)
		       			pq_ptr->scsi_periph_ptr = p_ptr;
			}

			else{
			    if((dptr->d_first = dev->q_next) == 0)
				dptr->d_last = 0;
			    if((dev->q_next = p_ptr->p_first) == 0)
				p_ptr->p_last = dev;
			    p_ptr->p_first = dev;
			    last_ditch_recovery(dev);
			}
	 	}
	}
	else{
		dptr->dtb_active = 0;
		if(dev->retry >= RETRY){
			clean_up_que(dev,1); /* clean up queue due to dtb
						  timeout */
   			ipque.i_p_block = FINISHED; 
			ipque.i_p_first->rc1 = DER_TIMEOUT;
		}
	}


}

clear_periph_que(dev,p_ptr)
register struct devq *dev;
struct periph_table *p_ptr;
{

	register struct devq *p_first_ptr;
	register struct devq *p_next_ptr;
	
	p_first_ptr = p_ptr->p_first;
	p_next_ptr = p_first_ptr->q_next;

	while(p_first_ptr){
		if(p_first_ptr->q_key == dev->q_key){
			p_first_ptr->q_count = 0;
			if(p_first_ptr == p_ptr->p_first)
				p_ptr->p_first = p_next_ptr;
			send_back(p_first_ptr,1);
		}
		p_first_ptr = p_next_ptr;
		p_next_ptr = p_first_ptr->q_next;
	}
	if(p_ptr->p_first == 0)
		p_ptr->p_last = 0;
	
}

timeoutape(dev)
register struct devq *dev;
{

	/* timeout on tape */

	resetape(0);

	dev->rc1 = TP_HANG;
	dev->q_count = 0;


	/* don't allow tape to interrupt, disable the tape dma bit */
	dtc_ctl &= ~TAPEINT_EN;
	*DTC_CRL = dtc_ctl;
	interrupt &= (~TAPEDMA_INT + TAPE_INT);
	dbc_cr &= ~TP_EN;
	*DBC_CR = dbc_cr;

	if ( dev->q_flag & NO_WAIT ) {
		/* send response back to master cpu */
		/*first mark the request finished so that the main
		  request will be sent back to the master later */

		if((dev->q_cmd == TPREAD) || (dev->q_cmd == TPWRITE)){
			ipque.i_p_block = FINISHED;

		/* then take the request off of the tape que */

			*(short *)&ipque.i_p_first->rc1= *(short *)&dev->rc1;
			clean_up_que(dev,0);
		}
		else{
			if((tapeque.t_first = dev->q_next) == 0)
				tapeque.t_last = 0;
			send_back(dev,1);
		}
		tapeque.t_active = 0;
	}
	else {
		/* for tape operation to be waited for completion */
		/* for fast tape rw */
		interrupt |= TAPE_INT;
	}

}

