
/* Special Peripheral Device ioctl */

#define PERIOC  ('P'<<8)
#define PERGET  (PERIOC|0) 	/* get the tape drive type */
#define PERSET  (PERIOC|1)

/*Responses from ioctl call PERGET */

#define ARCHIVE   2		/*Archive tape drive on line*/
#define TRACK9    4		/*9 track tape drive on line*/


/******************************************************************************
 *
 * Tape drive commands for structure devq (devq.q_cmd)
 *
 ******************************************************************************/
/*	read/write data between main memory and tape
	Main memory can be either contiguous and non-contiguous.
	For contiguous physical memory, the address is specified in devq.q_mem 
	and devq.q_mmu = 0; maximum can handle 0x4000 bytes in devq.q_count
	(ALL version of HSDT download code support this feature)  
	For non-contiguous memory, devq.q_mmu is the pointer to a request
	block which contains a list of page number with an offset of long
	word boundary into the first page number. (see vreg.h for structure 
	definition) and devq.q_mem = 0; maximum can handle 0x4000 bytes
	in devq.q_count.
	(HSDT download code V2.8 support this feature)
 */


	/* TAPE DRIVE COMMANDS */

#define TPREAD 	    1
#define TPWRITE     2
#define REWIND 	    3
#define WEOF 	    4			/*write end of file*/
#define REOF 	    5			/*read end of file*/
#define TAPESTAT    6			/*get tape status */
					/*tape drive type is returned in count*/
#define TENSION     7			/*not available on 9track*/
#define ERASE       8			/*for archive, open the tension on*/
					/* open device for writing. */
					/*for 9track, use ioctl call (PERSET) */
					/*putting the value of ERASE in the */
				        /*argument. */
#define ERASEFIX    9			/*fixed length erase (9track)*/
#define RECFWD      0xa			/*forward one record (9track)*/
#define RECBACK     0xb			/*back one record (9track)*/
#define POS         0xc			/*position the tape to a specific spot*/
					/* (9track) */
#define QIC11       0xd			/*change to QIC11 format (archive)*/
#define QIC24       0xe			/*change to QIC24 format (archive)*/
#define DENSITY     0xf
#define TAPESPEED   0x10		/*(9track)*/
#define TAPE_MODE   0x11		/*set 9track to start/stop or stream */
					/* mode using ioctl call (PERSET).*/
					/* OR the value SET_MODE with the */
					/* value for the desired mode and put*/
					/* it in the argument */
#define REVSFM     0x12			/*reverse to the last file mark */

	/*Other tape bit definitions */

#define TAPECMD     (4<<13)
#define ROC	      0x40		/*rewind on close*/

/*9TRACK ONLY*/
#define DENSITY_BIT   8			/*density bit in minor dev*/
#define SPEED_BIT     0x80		/*speed setting bit in minor dev*/
#define SET_MODE      0x2000		/*set the 9 track mode*/
#define START_STOP    1			/*used with SET_MODE for 9track*/
#define STREAM        2			/*used with SET_MODE for 9track*/
#define DENS_1600     1			/*set tape density to 1600bpi*/
#define DENS_6250     2			/*set tape density to 6250bpi*/
#define HI_SPEED      1			/*set tape speed to high*/
#define LOW_SPEED     2			/*set tape speed to low*/
#define MAX_TP_DRV    32		/*maximum number of 9track tape drives*/

/*ARCHIVE ONLY*/
#define TENONOP       0x80		/*tension on open */
#define DRVPERBD      4
#define FORMAT_BIT    8			/*Qic11/24 format bit in minor dev*/
#define MAXTAPE       16		/* maximum number of archive tape*/ 
					/* drives per system*/

	/* TAPE DRIVE RETURN CODES */

#define OLDBOM		0x28		/*necessary for the boot program to 
					be loaded from tape since the old
					return codes(thus the proms) started
					at 0x20 rather than 0x30 */
#define CART		0x30		/*cartridge not in place*/
#define DRVE		0x31		/*drive not ready*/
#define WRPROT		0x32		/*write protected*/
#define EOM		0x33		/*end of media*/
#define UDE		0x34		/*unrecoverable data error*/
#define FMARK		0x35		/*file mark detected*/
#define DATA		0x36		/*no data detected*/
#define RETRY		0x37		/*8 or more retries on read*/
#define BOM		0x38		/*beginning of media*/
#define HUNG 		0x39		/*tape drive hung during r/w */
#define RESET		0x3a
#define NONL		0x3b		/* drive not online*/
#define OVRUN		0x3c		/* data overrun */
#define CDATER		0x3d		/* corrected error */
#define ILLCMD		0x3e		/*illegal command*/
#define INVIF		0x3f	/* invalid io interface */
#define ABORT		0x40	/* tape request abort,due to ups */
#define NONINE		0x41    /* no nine track tape on this controller */
#define NOBRST		0x42    /* no burst id detected */
#define DENS		0x43    /* invalid density selection */
#define T_SPEED		0x44    /* invalid tape speed selection */
#define T_MODE		0x45    /* invalid tape mode selection */
#define T_BUSY		0x46	/* tape drive is in the process of performing
				   a read/write request */
#define TP_MEM		0x47	/* invalid main memory address */
#define TP_CNT		0x48	/* invalid byte count in request */

#define GEN_MSGSTRT 0xb			/*start of general error messages*/
#define TMSGSTRT    0x20		/*start of error message buffer*/
#define MSGSTRT     0x15		/*difference between general messages
					and tape error messages */

#define RAWSLP 0x80		/*sleeping on rawio*/
#define TRACK9OL  2		/*nine track tape drive online*/
#define SIZE9   0x4000

