/*
 * header file for standalone package
 */

/*
 * io block: includes an
 * inode, cells for the use of seek, etc,
 * and a buffer.
 */
#define BUFFSIZE 1024
struct	iob {
	char	i_buf[BUFFSIZE];
	struct inode i_ino;
	char	i_flgs;
	int i_unit;
	daddr_t	i_boff;
	daddr_t	i_cyloff;
	off_t	i_offset;
	daddr_t	i_bn;
	char	*i_ma;
	int	i_cc;
	int	i_error;
	ushort pad;			/* This pad was put in to insure that 
					the size of this structure will be a 
					multiple of a long word.  Please insure 
					that if any entries are made to the
					structure the entire size is a long 
					word multiple.  The reason for this 
					is that the buffer address passed
					to the DTB must be on a long word 
					boundary and, with iob being an array 
					of these structures, any structure
					after the first one in the array is 
					not guaranteed to start on a long 
					word boundary. */
};

#define F_READ	01
#define F_WRITE	02
#define F_ALLOC	04
#define F_FILE	010




/*
 * dev switch
 */
struct devsw {
	char	*dv_name;
	int	(*dv_strategy)();
	int	(*dv_open)();
	int	(*dv_close)();
};
extern struct devsw devsw[];


/*
 * request codes. Must be the same a F_XXX above
 */
#define CNTRL	0
#define	READ	1
#define	WRITE	2


#define	NBUFS	4


char	b[NBUFS][BUFFSIZE];
daddr_t	blknos[NBUFS];



#define NFILES	6
struct	iob iob[NFILES];
