
/******************************************************************************
 *
 * SYSCONF
 *
 * the ICB master builds a structure in main memory called sysconf.
 * this structure contains boot, card cage, and main memory information.
 * it is placed at the top (high address) of physical main memory and
 * mapped to location 0x3f0000 on the master cpu.
 *
 ******************************************************************************/
#define MAXBD	6			/* maximum number of boards without ICB dual port mem */

struct sysconf {
	struct slot_info slotinfo[NUMSLOTS];
	struct bd_desc bddesc[MAXBD];
	struct icbbuf icbbuf[3];
	char bootname[16];
	unsigned char bootdev;		/* DTDISK or DTTAPE */
	unsigned char bootunit;		/* msn = controller number - lsn = drive number */
	struct slot_info *bslotptr;	/* boot device slot pointer */
	unsigned char mempage[MAXMPAGE];
	unsigned short bootbaud;	/* console baud rate */
};

/* logical memory address of our sysconf structure */
#define SYSCONF		((struct sysconf *)(0x3f0000))
/* macro for determining physical memory page for the sysconf structure */
#define SYSPAGE(X)	(((unsigned)X - (64 * 1024)) >> MPAGESH)
/* number of maps to be set up for sysconf structure */
#define NUMSYSPGS	16

/* values for above mempage array */
#define MPGINV		0		/* memory page invalid */
#define MPGAVAIL	0x01	/* memory page available */
#define MPGUSED		0x02	/* memory page presently used */
#define MPGBAD		0x04	/* memory page bad */
