/*	@(#)bsearch.c	1.5	*/
/*LINTLIBRARY*/
/*
 * Binary search algorithm, generalized from Knuth (6.2.1) Algorithm B.
 *
 */
/*
 *	WARNING:
 *	modified so that main loop will not call subroutines for
 *	multiply and divide.  Maiximum table size is therfore
 *	32K bytes.
 */

typedef char *POINTER;

POINTER
bsearch(key, base, nel, width, compar)
POINTER	key;			/* Key to be located */
register POINTER	base;			/* Beginning of table */
unsigned nel;			/* Number of elements in the table */
register unsigned short width;			/* Width of an element (bytes) */
int	(*compar)();		/* Comparison function */
{
	short two_width = width + width;
	register POINTER last = base +
	    width * (unsigned short)(nel - 1); /* Last element in table */

	while (last >= base) {

		register POINTER p = base +
		    width * ((unsigned short)(last - base)/two_width);
		register int res = (*compar)(key, p);

		if (res == 0)
			return (p);	/* Key found */
		if (res < 0)
			last = p - width;
		else
			base = p + width;
	}
	return ((POINTER) 0);		/* Key not found */
}
