/* get a line of input from console: call getchar which calls xgetchar
 * routine xgetchar echoes the character, changes carriage return
 *   to line feed and echoes carriage return line feed.
 * continue getting characters and store them into buf until a line feed 
 * or carriage return is received.
 * take care character delete \b or #
 * take care line delete character  @
 * user will never get carriage return in the buf 
 */

int
gets(buf) char	*buf; {
	register char *lp;
	register c, count;

	lp = buf;
	count = 0;
	while(1) {
		c = getchar() & 0177;	/* only take 7 bits */

/* convert to lower case 
		if (c>='A' && c<='Z')
			c -= 'A' - 'a';	
*/

		/* if last character is \ and that is not first character */
		/* backup one space */

		if (lp != buf && *(lp-1) == '\\') {
			lp--;
			if (c>='a' && c<='z') {
				c += 'A' - 'a';
				goto store;
			}
			switch (c) {
			case '(':
				c = '{';
				break;
			case ')':
				c = '}';
				break;
			case '!':
				c = '|';
				break;
			case '^':
				c = '~';
				break;
			case '\'':
				c = '`';
				break;
			}
		}

	store:
		switch(c) {
		case '\n':
		case '\r':
			c = '\n';
			*lp++ = '\0';
			return( count );
		case '\b':
		case '#':
			if (lp <= buf)
				lp = buf;
			else	{
				count--;
				lp--;
			}
			continue;
		case '@':
			count = 0;
			lp = buf;
			putchar('\n');
			continue;
		case '\033':
			lp = buf;
			*lp = '\0';
			putchar('\n');
			return( -1 );
		default:
			count++;
			*lp++ = c;
		}
	}
}

