#include "cpu.h"
#include "icb.h"
#include "icbcmd.h"
#include "vreg.h"
#include "sysconf.h"

#ifndef TRUE
#define TRUE    1
#define FALSE   0
#endif

/*---------------------------------------------------- isscsi() --------------
/ a function to determine if passed controller (0..3) is a SCSI controller.
/ returns 1 if SCSI; else 0
/ 6-Apr-88  Craig J. Kim
/---------------------------------------------------------------------------*/
int isscsi(controller)
int controller;
{
        static int first_time = TRUE;   /* we want to determine only once */
        static int ctrltype[4];         /* large enough for sure! */

        if (controller < 0 || controller > 3)
            return(FALSE);

        if (first_time) {
            register struct slot_info *slotptr;
            register int i, bdtyp, numbd = 0;

            for (i = 0; i < 4; i++)
                ctrltype[i] = 0;
            slotptr = SYSCONF->slotinfo;
            for (i = 0; i < NUMSLOTS; i++, slotptr++)
		if (slotptr->flags & OCCUPIED) {
                    bdtyp = slotptr->slotaddr->bdtypreg & BDTYPMSK;
                    if (bdtyp == HSDTBDTYP
                         || bdtyp == EDTBDTYP
                         || bdtyp == SCSIBDTYP) {
                        ctrltype[numbd] = bdtyp;
                        numbd++;
                    }
                }
            first_time = FALSE;
        }

        return(ctrltype[controller] == SCSIBDTYP);
}

