
/* This raw disk device driver is intended for stand-alone use only. */


#include <sys/param.h>
#include <sys/types.h>
#include <sys/sysmacros.h>
#include "sainode.h"
#include "dk.h"
#include "saio.h"
#include "phinf.h"
#include "vreg.h"
#include "icb.h"
#include "icbcmd.h"
#include "cpu.h"
#include "sysconf.h"


#define SECTSIZE	1024
#define REQLIMIT	(255 * SECTSIZE)	/* maximum bytes per request */

#define ERRMSG 1
#define PRETTYPRINT

extern char		*dkcodes[];
extern struct devq	diskrq;
extern struct devq	*rqptr; 
extern int		intword;
extern			devreq();
extern struct slot_info	*dev_slot[4];
extern struct slot_info	*dm_slot;
extern int		debugrq;		/* pretty print disk requests */

/* always read from physical drive for rv */

rvopen(io)
register struct iob *io;
{
	register int	board;

	board = (io->i_unit >> 4) & 3;

	if((dm_slot = dev_slot[board]) == (struct slot_info *)0)
		return(-1);

	return(0);
}


rvstrategy(io,func) register struct iob *io; 
int func; 
{
	int totcnt;


	totcnt = rvstart(io,func);


	return(totcnt);
}

rvstart(io,func)
register struct iob *io;
int func;
{
	register int	board;
	register int 	i;
	char		*cptr;

/*	HSDT has a maximum limit of 255 sectors per request.		*/
/*	Currently no stand alone code asks for more, so we reject	*/
/*	any requests for more than 255 sectors				*/

	if ( io->i_cc   > REQLIMIT ) {
		printf("rvstart: too many bytes requested (%d).\n", io->i_cc);
		printf("limit is %d bytes per request.\n", REQLIMIT);
		return(-1);
	}

					/* temp kludge */
	if ( io->i_cc & 0x3ff ) {
		printf("rpstart: byte requests must be a multiple of 1024\n");
		return(-1);
	}


	board = (io->i_unit >> 4) & 3;

	dm_slot = dev_slot[board];

	for(i=0,cptr = (char *)&diskrq;i<sizeof diskrq;i++,cptr++)
		*cptr = 0;

	rqptr = &diskrq;
	rqptr->q_devtype = DISK;

			/* special case for r/w of sector 0 or 1 in rv */
	if ( io->i_bn == 0 || io->i_bn == 1 ) {
		rqptr->q_cmd = (func == READ) ? PREADPS : PWRITPS;
		rqptr->q_devun.pdisk.cyl = 0;
		rqptr->q_devun.pdisk.head = 0;
		rqptr->q_devun.pdisk.sector = io->i_bn;
	}
	else {			/* normal case */
		rqptr->q_cmd = (func == READ) ? PLREAD : PLWRITE;
		rqptr->q_devun.block =  io->i_bn;   /* starting logical block */
	}

	rqptr->q_devnum	= io->i_unit & 0xf;	/* pdrive for rv / cjk 880603 */
	rqptr->q_key = (unsigned)io;
	rqptr->q_count = io->i_cc;		/* number of bytes to read */
	rqptr->q_extdtb = XDDFLT;

			/* convert buffer address from logical to physical */
	rqptr->q_mem = (char *)conl2p(io->i_ma);

	/* hsdt can only handle requests to buffers on long word boundaries */

	if ( (int)rqptr->q_mem & 0x3 ) {
		printf("buffer must be on a long word boundary\n");
		return(-1);
	}

	if ( debugrq) 		/* pretty print disk requests */
		rqprint(rqptr);


	if(((intword = devreq(dm_slot,rqptr)) != 0) || *(short *)&(rqptr->rc1)){

		printf("disk error: iw = %x, unit = %x, bn = %x, rc = %x\n",
		  intword, io->i_unit, io->i_bn + (rqptr->q_count/1024),
		  *(short *)&(rqptr->rc1));

		if ( rqptr->rc1 )
			printf("%s\n",dkcodes[rqptr->rc1 - ERRMSG]);
		if ( rqptr->rc2 )
			printf("%s\n",dkcodes[rqptr->rc2 - ERRMSG]);

		io->i_error = *(short *)&(rqptr->rc1);
		return(-1);
	}
	return(rqptr->q_count);
}
