
	text
	global	_rtt
	global  bfile
	global  init
	global  promret
	global  cpu_type
	global	argsav%

	set	bootret%,0x150000

	set	cr%,0x0d		# carriage return
	set	lf%,0x0a		# line feed
	set	esc%,0x1b	# escape

# --------------------------------------
# come from prom code
# setup stack pointer and init bss area
# --------------------------------------
init:
	mov.l	&0x170000,%sp
	mov.l	&0x10000/4,%d1
	mov.l	&0x160000,%a1
clrstack%:
	clr.l	(%a1)+		# clear next long word
	sub.l	&1,%d1
	bne.b	clrstack%

#	mov.l	&end+0x10000,%sp	# setup stack pointer
	mov.l	&end,%d1
	mov.l	&edata,%a1	# beginning of bss
	lea.l	4(%a1),%a2	# next long addr	
#	mov.l	%sp,%d1
	sub.l	%a2,%d1		# # of bytes to clear

	asr.l	&2,%d1
	clr.l	(%a1)
flow1%:
	mov.l	(%a1)+,(%a2)+	# clear next long word
	sub.l	&1,%d1
	bne.b	flow1%

	mov.l	argsav%,%a1	# save area for boot entry sp
	add.w	&4,%a1		# pop return address
	mov.l	(%a1)+,%d0	# get arg list exists flag
	cmp.l	%d0,&0x10203040	# check it
	bne.b	flow2%		# no arglist
	mov.l	(%a1)+,%d0	# argc
	mov.l	(%a1)+,-(%sp)	# argv
	mov.l	%d0,-(%sp)	# argc
	bra.b	flow3%
flow2%:
	mov.l	&0,%d0
	mov.l	%d0,-(%sp)
flow3%:
	jsr	cpu_type
	jsr	main		# enter program
# ------------------------------------
# standalone program return to boot
# ------------------------------------

_rtt:
#	mov.l	&end+0x1800,%sp	# reset stack
	jmp	bootret%

bfile:
	rts

# xgetchar() -- get one char from console via debugger.
#		and also echo it
#	map cr into lf, echo as carriage return & line feed
#	parity bit cleared


	global	xgetch
xgetch:
	jsr	pgchar	# get one char in d0
	and.b	&0x7f,%d0	# clr parity
	mov.b	%d0,%d2
	jsr	usrabort	# is this an escape
	tst.b	%d0
	beq.b	getch1%
	mov.b	&lf%,%d0
	mov.l   %d0,-(%sp)
	jsr	putchar
	jmp	_rtt		# return to boot
getch1%:
	mov.b	%d2,%d0
	cmp.b	%d0,&cr%		# is this cr?
	bne.b	getch2%		# no
	mov.b	&lf%,%d0		# yes, turn into lf
getch2%:
	mov.l	%d0,-(%sp)
	jsr	putchar
	mov.l	(%sp),%d0
	add.l	&4,%sp
	rts

