/* LINTLIBRARY */
/*
 * @(#) Copyright 1986.  The Wollongong Group, Inc.  All Rights Reserved.
 *
 * Fixes: ID	SPR#	Description
 *
 *  	  nw2	4696	rlogin to multiple IP interfaces("Connection reset").
 *
 *        TWU1          max segment size has to be the min of mss and t_maxseg.
 *
 *        JTH 1         This change was put in to make RFS work. It undos the
 *                      TWU 1 change. It does not appear to have any side
 *                      effects. Introduced 25th November 1991, in preperation
 *                      of tcp1.2P6.
 *	  cah1  	Undo JTH 1. It did have side effects which were that
 *			gateways operations did not work.
 */

#ident "@(#)tcp_main.c (TWG)  1.10     89/09/18 "

/*
 * tcp tli multiplexor
 */

#include "sys/param.h"
#include "sys/types.h"

#ifndef XENIX
#include "sys/inline.h"
#include "sys/immu.h"
#include "sys/fs/s5dir.h"
#include "sys/region.h"
#ifdef u3b2
#include "sys/psw.h"
#include "sys/pcb.h"
#endif
#else /* XENIX */
#include "sys/seg.h"
#include "sys/page.h"
#include "sys/dir.h"
#endif
#include "sys/errno.h"
#include "sys/stream.h"
#include "sys/proc.h"
#include "sys/signal.h"
#include "sys/user.h"
#include "sys/file.h"
#include "sys/stropts.h"
#include "sys/tihdr.h"
#include "sys/strlog.h"
#include "sys/debug.h"
#ifdef XENIX
#include "sys/assert.h"
#endif
#include "sys/inet.h"
#include "sys/socket.h"
#include "sys/if.h"
#include "sys/in.h"
#include "sys/in_var.h"
#include "sys/ip.h"
#include "sys/ip_var.h"
#include "sys/tcp.h"
#include "sys/ip_icmp.h"
#include "sys/inetioctl.h"

struct qhead tcpcb;		/* All the active tcpcbs */
tcp_seq	tcp_iss = 1;		/* initial seq # */
extern struct tcpd tcpd[];
extern int tcpd_cnt;
struct tcpb tcpb;		/* should be in master.d/tcp */
struct tcpd	*tcpd_head;	/* List of active TCPDevs (for netstat)*/

long tcp_keepalive;	/* for testing  - to enable/disable keepalive */
int  tcp_ifad_ovr;	/*   " - interface address override count nw2 */

int canput_tcpisrv = 0;
int canput_tcpsend = 0;
int canput_dlsndata = 0;


extern nulldev();
extern	int	tcp_maxrcvwin;
extern mblk_t *tcp_pcbcache;


/***********************
 *  Table of Contents  *
 ***********************/

void		tcpinit();
int		tcpopen();	/* Top Read Queue Open		*/
void		tcpbclose();	/* Bottom Read Queue Close	*/
int		tcpclose();	/* Top Read Queue Close		*/
void		_tcpclose();
int		tcpiput();	/* Top Read Queue Put		*/
int		tcpisrv();	/* Top Read Queue Service	*/
int		tcpoput();	/* Top Write Queue Put		*/
int		tcp_top_put();
int		tcposrv();	/* Top Write Queue Service	*/
void		tcpmuxnotify();
int		tcpsend();
int		tcpbiput();	/* Bottom Read Queue Put	*/
void		tcpmuxack();
int		tcpbisrv();	/* Bottom Read Queue Service	*/
void		tcp_getmyaddr();
void		tcp_free_tpd();
void		tcp_ctlnotify();
void		tcp_quench();
int		in_rtchange();
void		tcp_gethisaddr();

/***** End of TOC *****/

struct module_info 	tcp_info = {	/* top QUEUE info */
TCP_ID, "tcp", 0, INFPSZ, 8192, 6144
};
static struct module_info 	tcpb_info = {	/* Bottom QUEUE info */
TCP_ID, "tcp", 0, INFPSZ, 8192, 6144
};
static struct qinit 		tcprinit = {	/* top Read QUEUE */
tcpiput, tcpisrv, tcpopen, tcpclose, NULL, &tcp_info, NULL 
};
static struct qinit 		tcpwinit = {	/* top Write QUEUE */
tcpoput, tcposrv, NULL, NULL, NULL, &tcp_info, NULL 
};
static struct qinit 		tcpbrinit = {	/* Bottom Read QUEUE */
tcpbiput, tcpbisrv, NULL, NULL, NULL, &tcpb_info, NULL 
};
static struct qinit 		tcpbwinit = {	/* Bottom Write QUEUE */
NULL, NULL, NULL, NULL, NULL, &tcpb_info, NULL 
};
struct streamtab 		tcpinfo = {	/* link to cdevsw table */
&tcprinit, &tcpwinit, &tcpbrinit, &tcpbwinit };

/*
 * tcp.c
 * This file deals with packets and interfaces associated with upstream
 * and downstream modules. It mainly consists of the the put and service
 * procedures for processing the modules. The service procedures themseleves
 * invoke functions in other files to do the work.
 */

/*
 * tcpint()
 * This function is invoked at set up time to initialize tcp.
 */

/*
 * initialization
 */
void
tcpinit()
{

	tcpcb.b_next = tcpcb.b_prev = &tcpcb;
	return;

}	/*  End of tcpinit() */

/*
 * may have to open control channel first
 * if dev==CLONEOPEN, then select any free channel to open
 */
tcpopen(q, dev, flag, sflag)
     register queue_t *q;
     register dev_t dev;
{
    register struct tcpd *tdp;
    register int mdev;
    extern void tcptimeout();
    mblk_t *bp;

    ASSERT(q);
    mdev = minor(dev);
    /* control chan needs to be opened first */
    if (tcpd[TCPCTLCHAN].td_rdq == NULL) {
	if ((sflag == CLONEOPEN) || (mdev != TCPCTLCHAN)) {
	    STRlog(TCP_ID, -1, DPRI_LO, SL_te,
		   "tcpopen: try to open chan %x before control chan\n", dev);
	    u.u_error = EPERM;
	    return OPENFAIL;
	    }
	/*
	 * When the control channel is opened, startup a timeout
	 * routine that is invoked every 200 milliseconds to trigger
	 * functionality such as retransmission and delayed acks.
	 */
	tcptimeout();
	}
    if (sflag == CLONEOPEN) {
	/*  Look for first available minor device */
	for (tdp = &tcpd[0]; tdp < &tcpd[tcpd_cnt]; tdp++)
	    if (tdp->td_rdq == (queue_t *)NULL)
		break;
	/*  Set and test validity of selected minor device */
	if ((mdev = tdp - &tcpd[0]) >= tcpd_cnt) {
	    u.u_error = ENODEV;
	    return OPENFAIL;
	    }
	/* NOT a CLONEOPEN */
	
    } else if (tdp = (struct tcpd *)q->q_ptr) {
	/* Requested minor dev already open */
	tdp->td_rdq = q;
	return mdev;
    } else {
	/*  Requested minor dev not already open */
	if (mdev < 0 || mdev >= tcpd_cnt) {
	    u.u_error = ENODEV;
	    return OPENFAIL;
	    }
	/* Allocate a minor device and continue */
	tdp = &tcpd[mdev];
	}

    /* initialize data structure */
    tdp->td_rdq = q;
    tdp->td_flags = u.u_uid ? 0 : TD_SUPERUSER;
    tdp->td_tcpcb = NULL;
    tdp->td_wcount = tdp->td_rcount = 0;

	STRlog(TCP_ID, -1, DPRI_HI, SL_te,
		 "tcp_main: wcount & rcount == 0");  /* JTH */
    
    tdp->td_dev = mdev;
    tdp->td_ipopt = NULL;	/* pointer to outgoing IP options */
    tdp->td_ipoptin = NULL;	/* pointer to incoming IP options */
    tdp->td_tstate = TS_UNBND;
    tdp->td_tos = tcp_tos;		/* default type-of-service */
    tdp->td_ttl = tcp_ttl;		/* default time-to-live */
    if (tcp_keepalive)
	tdp->td_sockflags |= SO_KEEPALIVE;
    q->q_ptr = (caddr_t)tdp;
    WR(q)->q_ptr = (caddr_t)tdp;
    noenable(WR(q));
    tdp->td_next = tcpd_head;
    tcpd_head = tdp;
    /*
     * Set the stream head lowat to 0 for our SELECT driver.
     * tn_connected and tu_connres set it back to STRLOW when
     * the state transitions to "connected" which allows our SELECT
     * driver to detect the change to "writeable" socket (in the BSD
     * sense).
     */
    if ((bp = allocb(sizeof(struct stroptions), BPRI_MED))) {
	struct stroptions *optp = (struct stroptions *)bp->b_wptr;
	bp->b_wptr += sizeof(struct stroptions);
	bp->b_datap->db_type = M_SETOPTS;
	optp->so_flags = SO_LOWAT;
	optp->so_lowat = 0;
	putnext(q, bp);
	}

    return mdev;

}	/*  End of tcpopen()  */


void
tcpbclose()
{
	if (tcpb.tb_wrq) {
		tcpb.tb_mstate = IPIF_CLOSED;
		tcpmuxnotify(); /* XXX: may be q_next (ie ip'q ) is NULL */
		tcpb.tb_wrq = NULL;
		if (tcpb.tb_iocblk) {
			/* stream head timeout, don't care iocnak */
			freeb(tcpb.tb_iocblk);
			tcpb.tb_iocblk = NULL;
		}
	}
	return;

}	/*  End of tcpbclose()  */


/*
 * if closing control channel, close all other chans and clean up mux
 */
tcpclose(q)

	queue_t *q;
{
	register struct tcpd *tdp, *p, *td;

	ASSERT(q && q->q_ptr);

	tdp = (struct tcpd *)q->q_ptr;
	if (TCPCHAN(tdp) == TCPCTLCHAN) {
		for (p = tcpd_head;  p ; p = td) {
			td = p->td_next;
			if (p != tdp && p->td_rdq) {	
				(void) putctl(p->td_rdq->q_next, M_HANGUP);
				_tcpclose(p);
			}
		}
		tcpbclose();
		tcpuntimeout();
	}
	if (tdp->td_rdq)
		_tcpclose(tdp);		/* user doesn't care anymore */

	return 0;

}	/*  End of tcpclose()  */


void
_tcpclose(tdp)

	register struct tcpd *tdp;
{
	register queue_t *q;
	register struct tcpcb *tp;
	extern void tu_cleancb();
	register int s = splnet();

	q = tdp->td_rdq;
	/*
	 * Even if there is no data left on the queue,
	 * We have to linger. When our FIN is acked or the data
	 * when acked will cause us to wakeup
	 * via setting a 2MSL timer (which will delete TCPCB). (see tcp_tw.c)
	 */
	if (tdp->td_tcpcb && !(tdp->td_flags & TD_NOLINGER)){
		tp = (struct tcpcb *)tdp->td_tcpcb->b_rptr;
		/*
		 * Go into an orderly release state.
		 */
		if (tdp->td_tstate == TS_DATA_XFER)
			tdp->td_tstate = TS_WIND_ORDREL;
		tdp->td_flags |= TD_CLOSING;
		if (tv_close(tp) < 0)
			goto zap;
		if (tdp->td_tcpcb == tcp_pcbcache)
			tcp_pcbcache = (mblk_t *)NULL;
		STRLOG(TCP_ID, TCPCHAN(tdp), DPRI_LO, SL_TRACE, 
			"lingering..");
		while (tdp->td_tcpcb && tp->t_state != TV_TIME_WAIT)
			if (sleep(tdp, (PZERO+1)|PCATCH))
				goto zap;
	}
	else {
		/*
		 * Abort Everything.
		 */
zap:
		tu_cleancb(tdp);
	}
	flushq(q, FLUSHALL);
	flushq(WR(q), FLUSHALL);

	if (tdp->td_ipopt)
		freeb(tdp->td_ipopt);

	if (tdp->td_ipoptin)
		freeb(tdp->td_ipoptin);

	tcp_free_tpd(tdp);
	tcpstat.tcps_closed++;
	splx(s);
	return;

}	/*  End of _tcpclose()  */

/*
 * no one calls me, all tli replies are sent directly to up stream
 * module from me (via qreply, see tu_bind, e.g.)
 */
tcpiput(q, bp)

	queue_t *q;
	mblk_t *bp;
{
	printf("tcpiput: Error.. called with Mtype %x\n", MTYPE(bp));
	freemsg(bp);
	return 0;

}	/*  End of tcpiput()  */


/*
 * called indirectly from tn_data()
 * if canput, just pass the data upward
 * else do nothing (mesg is left in the current q)
 *    when the upstream's q empties, this routine is called
 * instead of canput, we could use the exact count, e.g. t_rwin(tdp)
 */
tcpisrv(q)

	register queue_t *q;
{
	register struct tcpd *tdp;
	register mblk_t *bp;
	register int i;

	tdp = (struct tcpd *)q->q_ptr;
	STRlog(TCP_ID, -1, DP